/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.handler;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import net.kldp.whitebear.common.entity.QueryResult;
import net.kldp.whitebear.common.log.Log;
import net.kldp.whitebear.handler.JdbcHandler;
import net.kldp.whitebear.handler.QueryHandler;

public class QueryResultHandler
extends Thread {
    private QueryHandler queryHandler;
    private JdbcHandler jdbcHandler;
    private String query;
    private Object querySource;

    public QueryResultHandler(QueryHandler queryHandler, Object object, String string) {
        this.querySource = object;
        this.queryHandler = queryHandler;
        this.jdbcHandler = queryHandler.getMainHandler().getJdbcHandler();
        this.query = string;
    }

    public void run() {
        this.queryHandler.setRunning(true);
        QueryResult queryResult = this.makeQueryResult(this.query);
        queryResult.setQuerySource(this.querySource);
        this.queryHandler.postExecuteQuery(queryResult);
    }

    private void close(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        try {
            if (connection != null) {
                connection.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Close error(QueryHandler)", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult makeQueryResult(String string) {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        QueryResult queryResult = new QueryResult();
        queryResult.setQuery(string);
        try {
            Connection connection = this.jdbcHandler.getConnection();
            preparedStatement = connection.prepareStatement(string);
            queryResult.setStartTime(Calendar.getInstance().getTimeInMillis());
            resultSet = preparedStatement.executeQuery();
            queryResult.setEndTime(Calendar.getInstance().getTimeInMillis());
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            Log.logger.debug((Object)("rsMeta.getColumnCount() : " + n));
            queryResult.setColumnCount(n);
            int n2 = 0;
            while (resultSet.next()) {
                ++n2;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (int i = 1; i <= n; ++i) {
                    if (n2 == 1) {
                        Log.logger.debug((Object)("rsMeta.getColumnName(" + i + ") : " + resultSetMetaData.getColumnName(i)));
                        Log.logger.debug((Object)("rsMeta.getColumnTypeName(" + i + ") : " + resultSetMetaData.getColumnTypeName(i)));
                        Log.logger.debug((Object)("rsMeta.getColumnType(" + i + ") : " + resultSetMetaData.getColumnType(i)));
                        queryResult.addColumnName(resultSetMetaData.getColumnName(i));
                        queryResult.addColumnTypeName(resultSetMetaData.getColumnTypeName(i));
                        queryResult.addColumnType(resultSetMetaData.getColumnType(i));
                    }
                    Object object = resultSet.getObject(i);
                    arrayList.add(object);
                }
                queryResult.addRow(arrayList);
            }
            Log.logger.debug((Object)("rowCount : " + n2));
            queryResult.setStatus(QueryResult.STATUS_OK);
            this.close(null, preparedStatement, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                Log.logger.error((Object)"Execute query error", (Throwable)sQLException);
                queryResult.setStatus(QueryResult.STATUS_ERROR);
                queryResult.setMsg(sQLException.toString());
                this.close(null, preparedStatement, resultSet);
            }
            catch (Throwable throwable) {
                this.close(null, preparedStatement, resultSet);
                throw throwable;
            }
        }
        return queryResult;
    }
}

