/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.whitebear.handler;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.kldp.whitebear.common.entity.DbConnectInfo;
import net.kldp.whitebear.common.entity.TableRef;
import net.kldp.whitebear.common.log.Log;
import oracle.jdbc.OracleDriver;

public class JdbcHandler {
    private int maxReConnectionSize = 5;
    private Connection connection;
    private DbConnectInfo dbConnectInfo;

    public JdbcHandler(DbConnectInfo dbConnectInfo) throws SQLException {
        this.dbConnectInfo = dbConnectInfo;
        dbConnectInfo.setUrl(this.makeUrl(dbConnectInfo));
        this.connection = this.getConnection(dbConnectInfo);
        if (this.connection == null) {
            this.reConnect();
            if (this.connection == null) {
                throw new SQLException("Connection is null");
            }
        }
    }

    public Connection getConnection() {
        if (this.isConnectionAvailable()) {
            return this.connection;
        }
        this.reConnect();
        return this.connection;
    }

    private void reConnect() {
        if (!this.isConnectionAvailable()) {
            Log.logger.error((Object)"Connection reset");
            this.connection = null;
            for (int i = 0; i < this.maxReConnectionSize; ++i) {
                this.connection = this.getConnection(this.dbConnectInfo);
                if (!this.isConnectionAvailable()) continue;
                return;
            }
            Log.logger.error((Object)"Could not reset connection");
        }
    }

    private boolean isConnectionAvailable() {
        boolean bl = false;
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                Log.logger.error((Object)"Error in isConnectionAvailable", (Throwable)sQLException);
            }
        }
        return bl;
    }

    public void close() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Main control close error", (Throwable)sQLException);
        }
    }

    public Connection getConnection(DbConnectInfo dbConnectInfo) {
        Connection connection = null;
        try {
            switch (dbConnectInfo.getDbtype()) {
                case 0: {
                    DriverManager.registerDriver((Driver)new OracleDriver());
                    connection = DriverManager.getConnection(dbConnectInfo.getUrl(), dbConnectInfo.getUserName(), dbConnectInfo.getPassword());
                    break;
                }
                case 1: {
                    Class.forName("com.mysql.jdbc.Driver");
                    connection = DriverManager.getConnection(dbConnectInfo.getUrl(), dbConnectInfo.getUserName(), dbConnectInfo.getPassword());
                    break;
                }
                default: {
                    Log.logger.error((Object)"Unknown database(getConnection)");
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Get connection error(SQLException)", (Throwable)sQLException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.logger.error((Object)"Get connection error(ClassNotFoundException)", (Throwable)classNotFoundException);
            return null;
        }
        return connection;
    }

    public ArrayList getCategory(DatabaseMetaData databaseMetaData) {
        ArrayList<String> arrayList = null;
        ResultSet resultSet = null;
        String string = "";
        try {
            switch (this.dbConnectInfo.getDbtype()) {
                case 0: {
                    resultSet = databaseMetaData.getSchemas();
                    string = "TABLE_SCHEM";
                    break;
                }
                case 1: {
                    resultSet = databaseMetaData.getCatalogs();
                    string = "TABLE_CAT";
                }
            }
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                String string2 = resultSet.getString(string);
                arrayList.add(string2);
            }
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Get category error", (Throwable)sQLException);
        }
        return arrayList;
    }

    public ArrayList getTables(DatabaseMetaData databaseMetaData, String string) {
        ArrayList<TableRef> arrayList = null;
        ResultSet resultSet = null;
        try {
            switch (this.dbConnectInfo.getDbtype()) {
                case 0: {
                    resultSet = databaseMetaData.getTables(null, string, null, null);
                    break;
                }
                case 1: {
                    resultSet = databaseMetaData.getTables(string, null, null, null);
                }
            }
            while (resultSet.next()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<TableRef>();
                }
                TableRef tableRef = new TableRef();
                tableRef.setCatalog(resultSet.getString("TABLE_CAT"));
                tableRef.setSchema(resultSet.getString("TABLE_SCHEM"));
                tableRef.setName(resultSet.getString("TABLE_NAME"));
                tableRef.setType(resultSet.getString("TABLE_TYPE"));
                tableRef.setRemarks(resultSet.getString("REMARKS"));
                Log.logger.debug((Object)("TABLE_CAT : " + tableRef.getCatalog()));
                Log.logger.debug((Object)("TABLE_SCHEM : " + tableRef.getSchema()));
                Log.logger.debug((Object)("TABLE_NAME : " + tableRef.getName()));
                Log.logger.debug((Object)("TABLE_TYPE : " + tableRef.getType()));
                Log.logger.debug((Object)("REMARKS : " + tableRef.getRemarks()));
                arrayList.add(tableRef);
            }
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Get tables error", (Throwable)sQLException);
        }
        return arrayList;
    }

    public String makeUrl(DbConnectInfo dbConnectInfo) {
        String string = "";
        switch (dbConnectInfo.getDbtype()) {
            case 0: {
                string = "jdbc:oracle:thin:@" + dbConnectInfo.getHost() + ":" + dbConnectInfo.getPort() + ":" + dbConnectInfo.getDbName();
                break;
            }
            case 1: {
                string = "jdbc:mysql://" + dbConnectInfo.getHost() + ":" + dbConnectInfo.getPort() + "/" + dbConnectInfo.getDbName();
                break;
            }
            default: {
                Log.logger.error((Object)"Unknown database(makeUrl)");
            }
        }
        Log.logger.debug((Object)("URL : " + string));
        return string;
    }

    public DatabaseMetaData getDatabaseMetaData() {
        DatabaseMetaData databaseMetaData = null;
        if (!this.isConnectionAvailable()) {
            this.reConnect();
        }
        try {
            databaseMetaData = this.connection.getMetaData();
        }
        catch (SQLException sQLException) {
            Log.logger.error((Object)"Get database metadata error", (Throwable)sQLException);
        }
        return databaseMetaData;
    }
}

