//
// File: Stack.h
// Created by: Alexander Oster - tensor@ultima-iris.de
//
/*****
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*****/

#ifndef _STACK_H_
#define _STACK_H_

#ifdef WIN32
#include <windows.h>
#endif

#include "SDL/SDL.h"
#include <stdlib.h>

namespace GUI {

enum MESSAGE_TYPE {
	MESSAGE_NONE = 0,
	MESSAGE_MOUSEDOWN,
	MESSAGE_MOUSEUP,
	MESSAGE_MOUSEMOTION,
	MESSAGE_CLOSEGUMP,
	MESSAGE_SETFOCUS,
	MESSAGE_RELEASEFOCUS,
	MESSAGE_BRINGTOFRONT,
	MESSAGE_QUIT,
	MESSAGE_STARTGAME,
	MESSAGE_KEYPRESSED,
	MESSAGE_CHARDELETE,
	MESSAGE_ONDRAGITEM,
	MESSAGE_REBUILDITEMCONTAINER,
	MESSAGE_ADDCONTAINERITEM,
	MESSAGE_UPDATEPAPERDOLL,
	MESSAGE_ONCLICKITEM,
	MESSAGE_REFRESHREQUEST,
	MESSAGE_DOREFRESH,
	MESSAGE_ITEMDELETE,
	MESSAGE_CALLBACK
};

enum CALLBACK_TYPE {
	CALLBACK_ONCLICK = 0 ,
	CALLBACK_ONKEYPRESS,
	CALLBACK_ONMOUSEUP,
	CALLBACK_ONMOUSEDOWN,
	CALLBACK_ONCLOSE,
	CALLBACK_ONCHANGE
};

struct message_MouseEvent {
	int type;
	int x, y, button;
};

struct message_KeyPressed {
	int type;
	unsigned short key;
	unsigned int mod;
};

struct message_MouseMotionEvent {
	int type;
	int x, y, relx, rely, button;
};

struct message_WindowAction {
	int type;
	int controlid;
};

struct message_CharDelete {
	int type;
	unsigned int charid;
};

struct message_OnDragItem {
	int type;
	unsigned int itemid;
	unsigned short model;
};

struct message_OnRebuildItemContainer {
	int type;
	unsigned int containerid;
};

struct message_AddContainerItem {
	int type;
	unsigned int containerid;
	unsigned int id;
};

struct message_UpdatePaperdoll {
	int type;
	unsigned int id;
};

struct message_OnClickItem {
	int type;
	unsigned int itemid;
	bool doubleclick;
};

struct message_Refresh {
	int type;
	unsigned int time;
};

struct message_ItemDelete {
	int type;
	unsigned int itemid;
};

struct message_Callback {
	int type;
	int callback_type;
	unsigned int id;
	unsigned int containerid;
	int key;
};

union gui_message {
	int type;
	struct message_MouseEvent mouseevent;
	struct message_MouseMotionEvent mousemotionevent;
	struct message_WindowAction windowaction;
	struct message_KeyPressed keypressed;
	struct message_CharDelete chardelete;
	struct message_OnDragItem dragitem;
	struct message_OnRebuildItemContainer rebuilditemcontainer;
	struct message_AddContainerItem addcontaineritem;
	struct message_UpdatePaperdoll updatepaperdoll;
	struct message_OnClickItem onclickitem;
	struct message_Refresh refresh;
	struct message_ItemDelete itemdelete;
	struct message_Callback callback;
};

struct message_entry {
	gui_message msg;
	struct message_entry * next;
};

class MessageStack {
public:
	MessageStack ();
	virtual ~ MessageStack ();
	void Clear(void);
	void Push(gui_message message);
	int Pop(gui_message * message);
private:
	struct message_entry * root;
};

}

#endif
