//
// File: Checkbox.h
// Created by: Netzzwerg
//
/*****
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*****/

#ifndef _SCROLLBAR_H_
#define _SCROLLBAR_H_

#include "SDL/SDL.h"
#include "Control.h"
#include "gui/Button.h"

namespace GUI {

enum SCROLL_PART { 
	SCROLL_TRACK=0, SCROLL_THUMB, 
	SCROLL_LTUP_NORMAL, SCROLL_LTUP_HOVER, SCROLL_LTUP_PRESSED, 
	SCROLL_RTDN_NORMAL, SCROLL_RTDN_HOVER, SCROLL_RTDN_PRESSED,
	SCROLL_NUM_PART 
};

class Scrollbar : public Control
{
public:
	Scrollbar(int x=0, int y=0, int w=0, int h=0);
	virtual ~Scrollbar(void);

	void SetChangeMessage(gui_message * msg);
	void OnChange(int (*callback) (Control *sender, int pos));
	void DoOnChange(int pos);

	virtual int HandleMessage(gui_message * msg);
	virtual void Draw(GumpHandler * gumps);

	void SetGump(int type, int gump);
	int  GetGump(int type);

	void SetUseArrowButton(bool use_arrow_button) { m_use_arrow_button = use_arrow_button; }
	bool IsUseArraowButton() const { return m_use_arrow_button; }
	
	void SetVertical(bool vertical)  { m_vertical = vertical; }
	bool IsVertical() const { return m_vertical; }

	int  GetPos() const;
	void SetPos(int pos, bool fire_evnet=true);

	void SetRange(int min, int max) { m_min = min; m_max = max; }
	int  GetRange(int &min, int &max) const { min = m_min; max = m_max; }

	int  GetRangeLength() const { return m_max - m_min + 1; }

	void RecalLayout(GumpHandler * gumps);

	void SetDirectOnChange(bool direct_onchange) { m_direct_onchange = direct_onchange; }
	bool IsDirectOnChange() { return m_direct_onchange; }

	void FireOnChangeEvent();
protected:
	int m_scroll_gump[SCROLL_NUM_PART];
	bool m_use_arrow_button;
	bool m_vertical;

	int m_pos, m_prev_pos;
	int m_min, m_max;

	bool m_drag;
	int m_track_length;

	Button m_ltup, m_rtdn;

	enum RECT { LTUP, TRACK, THUMB, RTDN, NUM_RECT };
	rect m_rect[NUM_RECT];

	bool IsOverThumb(int x, int y);

	int Pt2Pos(point pt);
	point Pos2Pt(int pos);
	float PtUnit();

	bool m_direct_onchange;
	gui_message m_onchange_message;
	int (*m_callback_OnChange) (Control *sender, int pos);
};

}

#endif