/*
 * Decompiled with CFR 0.152.
 */
package tle.webcache;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.NullLogSystem;
import tle.webcache.Cache;
import tle.webcache.CacheUtil;
import tle.webcache.CreateCacheEngineException;
import tle.webcache.MakeCacheException;

public class CacheEngine {
    private static Map engineRepository = new HashMap();
    private String engineName;
    private VelocityEngine ve;
    private String cachePath;
    private String templatePath;
    private String encoding;
    private Map cacheRepository = new HashMap();
    private Object repositorySync = new Object();

    public static void createCacheEngine(String string, Properties properties) throws CreateCacheEngineException {
        CacheEngine cacheEngine = new CacheEngine(string, properties);
        engineRepository.put(string, cacheEngine);
    }

    public static CacheEngine getCacheEngine(String string) {
        CacheEngine cacheEngine = (CacheEngine)engineRepository.get(string);
        return cacheEngine;
    }

    private CacheEngine(String string, Properties properties) throws CreateCacheEngineException {
        this.engineName = string;
        String string2 = properties.getProperty("tle.webcache.template.path");
        String string3 = properties.getProperty("tle.webcache.cache.path");
        if (string2 == null) {
            throw new IllegalArgumentException("property not found:tle.webcache.template.path");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("property not found:tle.webcache.cache.path");
        }
        this.cachePath = string3;
        this.templatePath = string2;
        this.encoding = properties.getProperty("tle.webcache.template.encoding");
        this.ve = new VelocityEngine();
        this.ve.setProperty("runtime.log.logsystem", (Object)new NullLogSystem());
        this.ve.setProperty("resource.loader", (Object)"file");
        this.ve.setProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        this.ve.setProperty("file.resource.loader.path", (Object)string2);
        this.ve.setProperty("file.resource.loader.cache", (Object)"true");
        this.ve.setProperty("file.resource.loader.modificationCheckInterval", (Object)"2");
        try {
            this.ve.init();
        }
        catch (Exception exception) {
            throw new CreateCacheEngineException(exception.getMessage(), exception);
        }
    }

    public String getEngineName() {
        return this.engineName;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public Cache getCache(String string) {
        Object object;
        Cache cache = (Cache)this.cacheRepository.get(string);
        if (cache == null && ((File)(object = CacheUtil.getFile(this.cachePath, string))).exists() && ((File)object).canRead()) {
            try {
                cache = CacheUtil.readFile(this.cachePath, string, this.encoding);
                Object object2 = this.repositorySync;
                synchronized (object2) {
                    this.cacheRepository.put(cache.getCacheID(), cache);
                }
                return cache;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (cache != null && !CacheUtil.getFile(cache).exists()) {
            object = this.repositorySync;
            synchronized (object) {
                this.cacheRepository.remove(string);
            }
            cache = null;
        }
        return cache;
    }

    public void makeCache(String string, Map map) throws MakeCacheException {
        this.makeCache(string, string, map);
    }

    public void makeCache(String string, String string2, Map map) throws MakeCacheException {
        try {
            Object object;
            Template template = null;
            template = this.encoding == null ? this.ve.getTemplate(string2 + ".vm") : this.ve.getTemplate(string2 + ".vm", this.encoding);
            VelocityContext velocityContext = new VelocityContext();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                velocityContext.put((String)object, map.get(object));
            }
            object = new StringWriter();
            template.merge((Context)velocityContext, (Writer)object);
            Cache cache = new Cache(this.cachePath, string, ((StringWriter)object).toString());
            CacheUtil.writeFile(cache, this.encoding);
            Object object2 = this.repositorySync;
            synchronized (object2) {
                this.cacheRepository.put(cache.getCacheID(), cache);
            }
        }
        catch (Exception exception) {
            throw new MakeCacheException(exception.getMessage(), exception);
        }
    }

    public void removeCache(String string) {
        if (this.cacheRepository.containsKey(string)) {
            Object object = this.repositorySync;
            synchronized (object) {
                Cache cache = (Cache)this.cacheRepository.remove(string);
                CacheUtil.removeFile(cache);
            }
        }
    }

    public void removeAllCacheInMemory() {
        Object object = this.repositorySync;
        synchronized (object) {
            this.cacheRepository.clear();
        }
    }
}

