/*
 * Ʈ: TLE2Framework
 * ϸ: State.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework.util.statemachine;

import java.util.HashMap;
import java.util.Map;

/**
 * StateMachine ¸ Ÿ Ŭ.
 * 
 * @author ֹ
 * @since 2.0
 */
public class State {
	/**
	 * &lt;̺Ʈ,&gt;   Ѵ.
	 */
	private Map transferMap = new HashMap();

	/**
	 *  ̸
	 */
	private String stateName;

	/**
	 * ¿ õ 
	 */
	private Object value;

	/**
	 * State ü .
	 * <p>
	 * new State(name) new State(stateName, null) ϴ.
	 * 
	 * @param stateName  ̸
	 */
	public State(String stateName) {
		this(stateName, null);
	}
	
	/**
	 * State ü .
	 * 
	 * @param stateName  ̸
	 * @param value ¿ õ  
	 */
	public State(String stateName, Object value) {
		this.stateName = stateName;
		this.value = value;
	}
	
	/**
	 * ̺Ʈ Ÿ event   state ̵Ѵٴ  Ѵ.
	 *  
	 * @param event ̺Ʈ
	 * @param state ̵ 
	 */
	public void addEvent(String event, State state) {
		transferMap.put(event, state);
	}
	
	/**
	 *  ̸ Ѵ.
	 * 
	 * @return  ̸ 
	 */
	public String getStateName() {
		return stateName;
	}
	
	/**
	 * ° Ѵ.
	 * 
	 * @return   
	 */
	public Object getStateValue() {
		return value;
	}
	
	/**
	 * event ߻  ̵ϰ  State Ѵ.
	 * 
	 * @param event
	 * @return ̺Ʈ ߻  ̵ State
	 * @throws IllegalStateException  ¿ ̺Ʈ ó Ұ  ߻Ѵ. 
	 */
	public State transit(String event) {
		State state = (State) transferMap.get(event);
		if (state == null) {
			throw new IllegalStateException(stateName + " does not provide event:" + event);
		}
		return state;
	}
}