/*
 * Ʈ: TLE2Framework
 * ϸ: RIRequestWrapper.java
 * ۼ: 2005. 3. 21
 */
package tle.framework.http;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

import tle.framework.component.spi.ra.RequestInfo;

/**
 * RequestAnalyzer м û   ִ RequestInfoκ
 * Ķ  о HttpServletRequestWrapper.
 *  
 * @author ֹ
 * @since 2.0.5.3
 */
public class RIRequestWrapper extends HttpServletRequestWrapper {
	
	private RequestInfo ri = null;
	private Map parameterMap = null;
	
	/**
	 * RIRequestWrapper Ѵ.
	 * 
	 * @param request
	 * @param ri û м . Ķ  о  ȴ.
	 */
	public RIRequestWrapper(HttpServletRequest request, RequestInfo ri) {
		super(request);
		this.ri = ri;
	}
	
	/**
	 * Ķ  RequestInfoκ ´.
	 * @see javax.servlet.ServletRequest#getParameter(java.lang.String)
	 */
	public String getParameter(String name) {
		return ri.getParameter(name);
	}
	
	/**
	 * Ķ  Ѵ.
	 * 
	 * @see javax.servlet.ServletRequest#getParameterMap()
	 */
	public Map getParameterMap() {
		if (parameterMap == null) {
			Map tempMap = new java.util.HashMap();
			String[] names = ri.getParameterNames();
			for (int i = 0 ; i < names.length ; i++) {
				tempMap.put(names[i], ri.getParameterValues(names[i]));
			}
			parameterMap = Collections.unmodifiableMap(tempMap);
		}
		return parameterMap;
	}
	
	/**
	 * RequestInfoκ Ķ ̸  Ѵ.
	 * @see javax.servlet.ServletRequest#getParameterNames()
	 */
	public Enumeration getParameterNames() {
		return new EnemerationImpl(ri.getParameterNames());
	}
	
	/**
	 * RequestInfoκ Ķ  迭 Ѵ.
	 * @see javax.servlet.ServletRequest#getParameterValues(java.lang.String)
	 */
	public String[] getParameterValues(String name) {
		return ri.getParameterValues(name);
	}
	
	/**
	 * 迭κ  ϴ EnumerationImpl
	 */
	private static class EnemerationImpl implements Enumeration {
		private int idx = 0;
		private String[] names;
		
		EnemerationImpl(String[] names) {
			this.names = names;
		}
		
		public boolean hasMoreElements() {
			return idx < names.length;
		}
		
		public Object nextElement() {
			return names[idx++];
		}
	}
}
