/*
 * Ʈ: TLE2Framework
 * ϸ: RoleCheckTag.java
 * ۼ: 2005. 1. 18
 */
package tle.framework.customtag;

import java.util.StringTokenizer;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import tle.framework.TLEFramework;
import tle.framework.component.spi.aamanager.AAManagerException;
import tle.framework.component.spi.aamanager.AAManagerProxy;
import tle.framework.component.spi.aamanager.NullUser;
import tle.framework.component.spi.aamanager.Role;
import tle.framework.component.spi.aamanager.User;

/**
 *   ˻ϴ ±.   roles Ӽ  ؼ
 * Ư Ҹ ± ü  ش.   ID ޸ Ѵ.
 * 
 * <pre>
 *   &lt;tle:roleCheck roles="ID1,ID2,ID3">
 *   α   
 *   &lt;/tle:roleCheck>
 * </pre>
 * 
 * @author ֹ
 * @since 2.0.3
 */
public class RoleCheckTag extends TagSupport {
	private String roles;
	
	public void setRoles(String roles) {
		this.roles = roles;
	}
	
	public int doStartTag() throws JspException {
		try {
			AAManagerProxy aaManager = TLEFramework.getAAManagerProxy();
			User user = aaManager.getSessionUser((HttpServletRequest)pageContext.getRequest());
			if (user == null || user instanceof NullUser) {
				return SKIP_BODY;
			}
			StringTokenizer st = new StringTokenizer(roles, ",");
			while(st.hasMoreTokens()) {
				String roleId = st.nextToken();
				Role role = aaManager.getRole(roleId);
				if (user.isRole(role)) {
					return EVAL_BODY_INCLUDE;
				}
			}
			return SKIP_BODY;
		} catch (AAManagerException e) {
			throw new JspException(e);
		}
	}
	
	public int doEndTag() throws JspException {
		roles = null;
		return EVAL_PAGE;
	}
}
