/*
 * Ʈ: TLE2Framework
 * ϸ: UICreator.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework.component.spi.uicreator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.component.Component;
import tle.framework.component.ComponentException;
import tle.framework.component.spi.ra.RequestInfo;
import tle.framework.component.spi.rp.Result;

/**
 * UI   Ѵ.
 * <p>
 * UI ϴ Ʈ  ̽ ־ Ѵ.
 * 
 * @author ֹ
 * @since 2.0
 */
public interface UICreator extends Component {
	/**
	 *  ˸ ȭ Ѵ.
	 * 
	 * @param result 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ComponentException ȭ    ִ 쿡 ߻Ѵ.
	 */
	public void createView(Result result, HttpServletRequest request, HttpServletResponse response) throws ComponentException;
	
	/**
	 *  ʿ ϴ 񽺸 û   ȭ ̵Ѵ.
	 * 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ComponentException ȭ    ִ 쿡 ߻Ѵ.
	 */
	public void createAuthenticationForm(HttpServletRequest request, HttpServletResponse response) throws ComponentException;
	
	/**
	 *    ޽ ش.
	 * 
	 * @param ri û м 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ComponentException ȭ    ִ 쿡 ߻Ѵ.
	 */
	public void createNoAuthorizationView(RequestInfo ri, HttpServletRequest request, HttpServletResponse response) throws ComponentException;
	
	/**
	 * Result.isErrorOccured() true      Ÿ.
	 *  
	 * @param result 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ComponentException ȭ    ִ 쿡 ߻Ѵ.
	 */
	public void createErrorView(Result result, HttpServletRequest request, HttpServletResponse response) throws ComponentException;
	
	/**
	 *   ܰ ߻    ش.
	 * 
	 * @param e 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ComponentException ȭ    ִ 쿡 ߻Ѵ.
	 */
	public void createErrorView(Throwable e, HttpServletRequest request, HttpServletResponse response) throws ComponentException;
}