/*
 * Ʈ: TLE2Framework
 * ϸ: SubpageTag.java
 * ۼ: 2004. 11. 3
 */
package tle.framework.component.impl.uicreator.customtag;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import tle.framework.component.impl.uicreator.DefaultUICreator;
import tle.framework.component.impl.uicreator.config.ViewConfig;

/**
 * JSP    includeϱ ؼ Ǵ Ŀ ±.
 * <p>
 * JSP 1.2  ϴ Ŭ-Ÿ Ŀ ±̴. 
 * 
 * @author ֹ
 * @since 2.0
 */
public class SubpageTag extends TagSupport {
	private String name;
	
	public void setName(String name) {
		this.name = name;
	}
	
	/**
	 * request ̸ DefaultUICreator.VIEW_CONFIG_ATTRIBUTE_NAME  Ӽ
	 *  ViewConfig ü о ViewConfig.getSubpage()  
	 * include Ѵ. ̶ ViewConfig.getSubpage() ޼ҵ ڰ
	 * setName() ޼ҵ带 ؼ Է¹ ̴. 
	 * 
	 * @see javax.servlet.jsp.tagext.Tag#doStartTag()
	 */
	public int doStartTag() throws JspException {
		ViewConfig viewConfig = (ViewConfig)pageContext.getRequest().getAttribute(DefaultUICreator.VIEW_CONFIG_ATTRIBUTE_NAME);
		String page = viewConfig.getSubpage(name);
		try {
			if (page != null) {
				pageContext.include(page);
			}
			return SKIP_BODY;
		} catch (ServletException e) {
			throw new JspException(e);
		} catch (IOException e) {
			throw new JspException(e);
		} finally {
			name = null;
		}
	}
}
