/*
 * Ʈ: TLE2Framework
 * ϸ: RequestReceiver.java
 * ۼ: 2004. 10. 12.
 */
package tle.framework;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import tle.framework.log.Logger;

/**
 * Ŭ̾Ʈ û TLEFramework ִ .
 * <p>
 * Ŭ̾Ʈ û  RequestReceiver TLEFramework.processingRequest() ޼ҵ忡
 * û Ѵ.  û  δ web.xml   ؼ ȴ.
 *  , *.do شϴ û Ʋ ӿũ óϱ Ѵٸ
 *    web.xml Ͽ ָ߰ ȴ.
 * 
 * <pre>
 * 
 *   &lt;servlet&gt;
 *       &lt;servlet-name&gt;TLERequestReceiver&lt;/servlet-name&gt;
 *       &lt;servlet-class&gt;tle.framework.RequestReceiver&lt;/servlet-class&gt;
 *   &lt;/servlet&gt;
 *   
 *   &lt;servlet-mapping&gt;
 *       &lt;servlet-name&gt;TLERequestReceiver&lt;/servlet-name&gt;
 *       &lt;url-pattern&gt;*.do&lt;/url-pattern&gt;
 *   &lt;/servlet-mapping&gt;
 *
 * </pre> 
 * 
 * 
 * @author ֹ
 * @since 2.0
 */
public class RequestReceiver extends HttpServlet {

	/**
	 * processing() ޼ҵ ȣ
	 * 
	 * @see javax.servlet.http.HttpServlet#doGet(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		processing(request, response);
	}

	/**
	 * processing() ޼ҵ ȣ
	 * 
	 * @see javax.servlet.http.HttpServlet#doPost(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		processing(request, response);
	}
	
	/**
	 * Ŭ̾Ʈ û Ʋӿũ(TLEFramework.processingRequest() ޼ҵ) Ѵ.
	 * 
	 * @param request HTTP û
	 * @param response HTTP 
	 * @throws ServletException
	 * @throws IOException
	 * @see tle.framework.TLEFramework#processingRequest(javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse)
	 */
	private void processing(HttpServletRequest request, HttpServletResponse response)
	throws ServletException, IOException {
		try {
			TLEFramework.processingRequest(request, response);
		} catch (TLEFrameworkException e) {
			Logger.fatal("RequestReceiver.processing():"+e.getMessage(), e);
			throw new ServletException(e.getMessage(), e);
		}
	}
}