/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;
import mx4j.remote.ConnectionNotificationEmitter;
import mx4j.remote.ConnectionResolver;
import mx4j.remote.HeartBeat;
import mx4j.remote.RemoteNotificationClientHandler;
import mx4j.remote.rmi.ClientExceptionCatcher;
import mx4j.remote.rmi.ClientInvoker;
import mx4j.remote.rmi.ClientUnmarshaller;
import mx4j.remote.rmi.RMIHeartBeat;
import mx4j.remote.rmi.RMIRemoteNotificationClientHandler;

public class RMIConnector
implements JMXConnector,
Serializable {
    private static final long serialVersionUID = 817323035842634473L;
    private final JMXServiceURL jmxServiceURL;
    private RMIServer rmiServer;
    private transient RMIConnection connection;
    private transient boolean connected;
    private transient boolean closed;
    private transient ClassLoader defaultClassLoader;
    private transient String connectionId;
    private transient ConnectionNotificationEmitter emitter;
    private transient HeartBeat heartbeat;
    private transient RemoteNotificationClientHandler notificationHandler;

    public RMIConnector(JMXServiceURL url, Map environment) {
        if (url == null) {
            throw new IllegalArgumentException("JMXServiceURL cannot be null");
        }
        this.jmxServiceURL = url;
        this.rmiServer = null;
        this.initialize(environment);
    }

    public RMIConnector(RMIServer server, Map environment) {
        if (server == null) {
            throw new IllegalArgumentException("RMIServer cannot be null");
        }
        this.jmxServiceURL = null;
        this.rmiServer = server;
        this.initialize(environment);
    }

    private void initialize(Map environment) {
        this.defaultClassLoader = this.findDefaultClassLoader(environment);
        this.emitter = new ConnectionNotificationEmitter(this);
    }

    private ClassLoader findDefaultClassLoader(Map environment) {
        if (environment == null) {
            return null;
        }
        Object loader = environment.get("jmx.remote.default.class.loader");
        if (loader != null && !(loader instanceof ClassLoader)) {
            throw new IllegalArgumentException("Environment property jmx.remote.default.class.loader must be a ClassLoader");
        }
        return (ClassLoader)loader;
    }

    public void connect() throws IOException, SecurityException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map environment) throws IOException, SecurityException {
        RMIConnector rMIConnector = this;
        synchronized (rMIConnector) {
            if (this.connected) {
                return;
            }
            if (this.closed) {
                throw new IOException("This RMIConnector has already been closed");
            }
            ClassLoader loader = this.findDefaultClassLoader(environment);
            if (loader != null) {
                this.defaultClassLoader = loader;
            } else if (this.defaultClassLoader == null) {
                this.defaultClassLoader = Thread.currentThread().getContextClassLoader();
            }
            Map env = environment == null ? new HashMap() : environment;
            String protocol = this.jmxServiceURL.getProtocol();
            ConnectionResolver resolver = ConnectionResolver.newConnectionResolver(protocol, env);
            if (resolver == null) {
                throw new IOException("Unsupported protocol: " + protocol);
            }
            if (this.rmiServer == null) {
                this.rmiServer = (RMIServer)resolver.lookupClient(this.jmxServiceURL, env);
            }
            this.rmiServer = (RMIServer)resolver.bindClient(this.rmiServer, env);
            Object credentials = env.get("jmx.remote.credentials");
            this.connection = this.rmiServer.newClient(credentials);
            this.connected = true;
            this.connectionId = this.connection.getConnectionId();
            this.heartbeat = new RMIHeartBeat(this.connection, this.emitter, env);
            this.notificationHandler = new RMIRemoteNotificationClientHandler(this.connection, this.emitter, this.heartbeat, env);
            this.heartbeat.start();
            this.notificationHandler.start();
        }
        this.emitter.sendConnectionNotificationOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RMIConnector rMIConnector = this;
        synchronized (rMIConnector) {
            if (this.closed) {
                return;
            }
            this.connected = false;
            this.closed = true;
            if (this.notificationHandler != null) {
                this.notificationHandler.stop();
            }
            if (this.heartbeat != null) {
                this.heartbeat.stop();
            }
            if (this.connection != null) {
                this.connection.close();
            }
            this.connection = null;
            this.rmiServer = null;
        }
        this.emitter.sendConnectionNotificationClosed();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    public MBeanServerConnection getMBeanServerConnection(Subject delegate) throws IOException {
        if (!this.connected) {
            throw new IOException("Connection has not been established");
        }
        ClientInvoker invoker = new ClientInvoker(this.connection, this.notificationHandler, delegate);
        MBeanServerConnection unmarshaller = ClientUnmarshaller.newInstance(invoker, this.defaultClassLoader);
        MBeanServerConnection catcher = ClientExceptionCatcher.newInstance(unmarshaller);
        return catcher;
    }

    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.jmxServiceURL == null && this.rmiServer == null) {
            throw new InvalidObjectException("Nor the JMXServiceURL nor the RMIServer were specified for this RMIConnector");
        }
        this.initialize(null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.jmxServiceURL == null && this.rmiServer == null) {
            throw new InvalidObjectException("Nor the JMXServiceURL nor the RMIServer were specified for this RMIConnector");
        }
        oos.defaultWriteObject();
    }
}

