/*
 * Decompiled with CFR 0.152.
 */
package tle.framework.http;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import tle.framework.component.spi.ra.RequestInfo;

public class RIRequestWrapper
extends HttpServletRequestWrapper {
    private RequestInfo ri = null;
    private Map parameterMap = null;

    public RIRequestWrapper(HttpServletRequest request, RequestInfo ri) {
        super(request);
        this.ri = ri;
    }

    public String getParameter(String name) {
        return this.ri.getParameter(name);
    }

    public Map getParameterMap() {
        if (this.parameterMap == null) {
            HashMap<String, String[]> tempMap = new HashMap<String, String[]>();
            String[] names = this.ri.getParameterNames();
            for (int i = 0; i < names.length; ++i) {
                tempMap.put(names[i], this.ri.getParameterValues(names[i]));
            }
            this.parameterMap = Collections.unmodifiableMap(tempMap);
        }
        return this.parameterMap;
    }

    public Enumeration getParameterNames() {
        return new EnemerationImpl(this.ri.getParameterNames());
    }

    public String[] getParameterValues(String name) {
        return this.ri.getParameterValues(name);
    }

    private static class EnemerationImpl
    implements Enumeration {
        private int idx = 0;
        private String[] names;

        EnemerationImpl(String[] names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.idx < this.names.length;
        }

        public Object nextElement() {
            return this.names[this.idx++];
        }
    }
}

