#include <sys/kpi_socketfilter.h>

//work
/*sock_inject_data_in

errno_t sock_inject_data_in(
    socket_t so,
    const struct sockaddr*from, 
    mbuf_t data,
    mbuf_t control,
    sflt_data_flag_t flags);  
Parameters
so
The socket to inject the data on.
from
The address the data is from, only necessary on un-connected sockets. A copy of the address will be made, caller is responsible for freeing the address after calling this function.
data
The data and possibly control mbufs.
control
The separate control mbufs.
flags
Flags indicating the type of data.
Return Value

0 on success otherwise the errno error. If the function returns an error, the caller is responsible for freeing the mbuf. 
Discussion 

Inject data in to the receive buffer of the socket as if it had come from the network.*/
errno_t sock_inject_data_in(
    socket_t so,
    const struct sockaddr*from,
    mbuf_t data,
    mbuf_t control,
    sflt_data_flag_t flags){};

/*sock_inject_data_out

errno_t sock_inject_data_out(
    socket_t so,
    const struct sockaddr*to, 
    mbuf_t data,
    mbuf_t control,
    sflt_data_flag_t flags);  
Parameters
so
The socket to inject the data on.
to
The address the data should be sent to, only necessary on un-connected sockets. The caller is responsible for freeing the to address after sock_inject_data_out returns.
data
The data and possibly control mbufs.
control
The separate control mbufs.
flags
Flags indicating the type of data.
Return Value

0 on success otherwise the errno error. The data and control values are always freed regardless of return value. 
Discussion 

Inject data in to the send buffer of the socket as if it had come from the client.*/
 errno_t sock_inject_data_out(
    socket_t so,
    const struct sockaddr *to,
    mbuf_t data,
    mbuf_t control,
    sflt_data_flag_t flags){}; 

/*sflt_register

errno_t sflt_register(
    const struct sflt_filter *filter,
    int domain, 
    int type,
    int protocol);  
Parameters
filter
A structure describing the filter.
domain
The protocol domain these filters will be attached to.
type
The socket type these filters will be attached to.
protocol
The protocol these filters will be attached to.
Return Value

0 on success otherwise the errno error. 
Discussion 

Registers a socket filter. See 'man 2 socket' for a desciption of domain, type, and protocol.*/
errno_t sflt_register(
    const struct sflt_filter *filter,
    int domain, 
    int type,
    int protocol){};  

/*sflt_unregister

errno_t sflt_unregister(
    sflt_handle handle);  
Parameters
handle
The sf_handle of the socket filter to unregister.
Return Value

0 on success otherwise the errno error. 
Discussion 

Unregisters a socket filter. This will not detach the socket filter from all sockets it may be attached to at the time, it will just prevent the socket filter from being attached to any new sockets.*/
errno_t sflt_unregister(
    sflt_handle handle){};  
