#include <sys/attr.h>
//work


/*GETATTRLIST(2)              BSD System Calls Manual             GETATTRLIST(2)

NAME
     getattrlist -- get file system attributes

SYNOPSIS
     #include <sys/attr.h>
     #include <unistd.h>

     int
     getattrlist(const char* path, struct attrlist * attrList, void * attrBuf,
         size_t attrBufSize, unsigned long options);

DESCRIPTION
     The getattrlist() function returns attributes (that is, metadata) of file
     system objects.  You can think of getattrlist() as a seriously enhanced
     version of stat(2).  The function returns attributes about the file sys-system
     tem object specified by path in the buffer specified by attrBuf and
     attrBufSize.  The attrList parameter determines what attributes are
     returned.  The options parameter lets you control specific aspects of the
     function's behaviour.

     The getattrlist() function is only supported by certain volume format
     implementations.  For maximum compatibility, client programs should use
     high-level APIs (such as the Carbon File Manager) to access file system
     attributes.  These high-level APIs include logic to emulate file system
     attributes on volumes that don't support getattrlist().

     Not all volumes support all attributes.  See the discussion of
     ATTR_VOL_ATTRIBUTES for a discussion of how to determine whether a par-particular
     ticular volume supports a particular attribute.

     Furthermore, you should only request the attributes that you need.  Some
     attributes are expensive to calculate on some volume formats.  For exam-example,
     ple, ATTR_DIR_ENTRYCOUNT is usually expensive to calculate on non-HFS
     [Plus] volumes.  If you don't need a particular attribute, you should not
     ask for it.

     The path parameter must reference a valid file system object.  Read,
     write or execute permission of the object itself is not required, but all
     directories listed in the path name leading to the object must be search-searchable.
     able.

     The attrList parameter is a pointer to an attrlist structure, as defined
     by <sys/attr.h> (shown below).  It determines what attributes are
     returned by the function.  You are responsible for filling out all fields
     of this structure before calling the function.

     #define ATTR_BIT_MAP_COUNT 5

     The fields of the attrlist structure are defined as follows.

     bitmapcount     Number of attribute bit sets in the structure.  In cur-current
                     rent systems you must set this to ATTR_BIT_MAP_COUNT.

     reserved        Reserved.  You must set this to 0.

     commonattr      A bit set that specifies the common attributes that you
                     require.  Common attributes relate to all types of file

   The attributes are placed into the attribute buffer in the order
          that they are described below.

     If the attribute is of variable length, it is represented in the list by
     an attrreference structure, as defined by <sys/attr.h> (shown below).

     typedef struct attrreference {
         long        attr_dataoffset;
         size_t      attr_length;
     } attrreference_t;

     This structure contains a 'pointer' to the variable length attribute
     data.  The attr_length field is the length of the attribute data (in
     bytes).  The attr_dataoffset field is the offset in bytes from the
     attrreference structure to the attribute data.  This offset will always
     be a multiple of sizeof(unsigned long) bytes, so you can safely access
     common data types without fear of alignment exceptions.

     The getattrlist() function will silently truncate attribute data if
     attrBufSize is too small.  The length field at the front of the attribute
     list always represents the length of the data actually copied into the
     attribute buffer.  If the data is truncated, there is n*/

int      getattrlist(const char* path, struct attrlist * attrList, void * attrBuf,
      size_t attrBufSize, unsigned long options){};



