#include <stdio.h>
#include <dns_sd.h>


/*DNSServiceProcessResult


Gets a response from the mDNSResponder daemon and calls the appropriate callback function.
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls that take a callback parameter. 

Return Value

Returns kDNSServiceErr_NoError on success, otherwise returns an error code indicating the specific failure that occurred. 
Discussion 

Read a reply from the daemon, calling the appropriate application callback. This call will block until the daemon's response is received. Use DNSServiceRefSockFD() in conjunction with a run loop or select() to determine the presence of a response from the server before calling this function to process the reply without blocking. Call this function at any point if it is acceptable to block until the daemon's response arrives. Note that the client is responsible for ensuring that DNSServiceProcessResult() is called whenever there is a reply from the daemon - the daemon may terminate its connection with a client that does not process the daemon's responses.*/
DNSServiceErrorType DNSServiceProcessResult(
    DNSServiceRef sdRef){
printf ("DNSServiceProcessResult",sdRef);
};  

/*DNSServiceRefDeallocate


Deallocates a service discovery reference.
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Discussion 

This call is to be used only with the DNSServiceRef defined by this API. It is not compatible with dns_service_discovery_ref objects defined in the legacy Mach-based DNSServiceDiscovery.h API.*/
void DNSServiceRefDeallocate(
    DNSServiceRef sdRef){
printf ("DNSServiceRefDeallocate",sdRef);
};  


/*DNSServiceRefSockFD


Returns the socket descriptor for a service discovery reference.
int DNSServiceRefSockFD(
    DNSServiceRef sdRef);  
Parameters
sdRef
A DNSServiceRef initialized by any of the DNSService calls. 

Return Value

The DNSServiceRef's underlying socket descriptor, or -1 on error. 
Discussion 

Access underlying Unix domain socket for an initialized DNSServiceRef. The DNS Service Discovery implementation uses this socket to communicate between the client and the mDNSResponder daemon. The application MUST NOT directly read from or write to this socket. Access to the socket is provided so that it can be used as a run loop source, or in a select() loop: when data is available for reading on the socket, DNSServiceProcessResult() should be called, which will extract the daemon's reply from the socket, and pass it to the appropriate application callback. By using a run loop or select(), results from the daemon can be processed asynchronously. Without using these constructs, DNSServiceProcessResult() will block until the response from the daemon arrives. The client is responsible for ensuring that the data on the socket is processed in a timely fashion - the daemon may terminate its connection with a client that does not clear its socket buffer.*/
int DNSServiceRefSockFD(
    DNSServiceRef sdRef){
printf ("DNSServiceRefSockFD",sdRef);
};  


/*DNSServiceQueryRecord


Gets the resource data from the specified resource record.
DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context / may be NULL *
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the query operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Pass kDNSServiceFlagsLongLivedQuery to create a "long-lived" unicast query in a non-local domain. Without setting this flag, unicast queries will be one-shot - that is, only answers available at the time of the call will be returned. By setting this flag, answers (including Add and Remove events) that become available after the initial call is made will generate callbacks. This flag has no effect on link-local multicast queries. 

interfaceIndex
If non-zero, specifies the interface on which to issue the query (the index for a given interface is determined via the if_nametoindex() family of calls.) Passing 0 causes the name to be queried for on all interfaces. See "Constants for specifying an interface index" for more details. 

fullname
The full domain name of the resource record to be queried for. 

rrtype
The numerical type of the resource record to be queried for (e.g. kDNSServiceType_PTR, kDNSServiceType_SRV, etc) 

rrclass
The class of the resource record (usually kDNSServiceClass_IN). 

callBack
The function to be called when a result is found, or if the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is never invoked and the DNSServiceRef is not initialized.) 
Discussion 

This function queries the specified interfaces (if interfaceIndex is non-zero) or all interfaces (if interfaceIndex is zero) for a resource record that matches the values specified by the fullName, rrtype, and rrclass parameters. If your application needs to monitor TXT record changes, you should use this function. 

If DNSServiceQueryRecord returns kDNSServiceErr_NoError, the query was started, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceQueryRecord. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

Regardless of the value of the flags parameter, you always need to call DNSServiceRefDeallocate on sdRef to free the memory and resources associated with a query and terminate the query. 

For information about the callback function for DNSServiceQueryRecord, see DNSServiceQueryRecordReply.*/

DNSServiceErrorType DNSServiceQueryRecord ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *fullname, 
    uint16_t rrtype, 
    uint16_t rrclass, 
    DNSServiceQueryRecordReply callBack, 
    void *context /* may be NULL */
    ){
printf ("DNSServiceQueryRecord",*sdRef,flags,interfaceIndex,*fullname,rrtype,rrclass,callBack,context);
}; 


/*DNSServiceBrowse


Browse for instances of a service.
DNSServiceErrorType DNSServiceBrowse ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *regtype, 
    const char *domain, // may be NULL 
    DNSServiceBrowseReply callBack, 
    void *context // may be NULL 
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the browse operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Currently ignored, reserved for future use. 

interfaceIndex
If non-zero, specifies the interface on which to browse for services (the index for a given interface is determined via the if_nametoindex() family of calls.) Most applications will pass 0 to browse on all available interfaces. See "Constants for specifying an interface index" for more details. 

regtype
The service type being browsed for followed by the protocol, separated by a dot (e.g. "_ftp._tcp"). The transport protocol must be "_tcp" or "_udp". 

domain
If non-NULL, specifies the domain on which to browse for services. Most applications will not specify a domain, instead browsing on the default domain(s). 

callBack
The function to be called when an instance of the service being browsed for is found, or if the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is not invoked and the DNSServiceRef is not initialized.) 
Discussion 

Call this function to browse for available services of a given type in a given domain. 

If DNSServiceBrowse returns kDNSServiceErr_NoError, the search was started, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. Your callback function will be called for each service that matches the browsing criteria. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceBrowse. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

For information about the callback function for DNSServiceBrowse, see DNSServiceBrowseReply. 

To search for multiple service types, or to search multiple domains, make multiple calls to DNSServiceBrowse.*/
DNSServiceErrorType DNSServiceBrowse ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *regtype, 
    const char *domain, /* may be NULL */
    DNSServiceBrowseReply callBack, 
    void *context /* may be NULL */
    ){
printf ("DNSServiceBrowse",*sdRef,flags,interfaceIndex,*regtype,*domain,callBack,context);
};  

/*DNSServiceEnumerateDomains


Asynchronously enumerate domains available for browsing and registration.
DNSServiceErrorType DNSServiceEnumerateDomains ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    DNSServiceDomainEnumReply callBack, 
    void *context // may be NULL 
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the enumeration operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Possible values are: kDNSServiceFlagsBrowseDomains to enumerate domains recommended for browsing. kDNSServiceFlagsRegistrationDomains to enumerate domains recommended for registration. 

interfaceIndex
If non-zero, specifies the interface on which to look for domains. (the index for a given interface is determined via the if_nametoindex() family of calls.) Most applications will pass 0 to enumerate domains on all interfaces. See "Constants for specifying an interface index" for more details. 

callBack
The function to be called when a domain is found or the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is not invoked and the DNSServiceRef is not initialized.) 
Discussion 

Call this function to build a list of recommended domains in which to register your service (if flags is set to kDNSServiceFlagsRegistrationDomains) or a list of recommended domains in which to browse (if flags is set to kDNSServiceFlagsBrowseDomains). Currently, the only domain returned is local., but other domains will be returned in the future. 

If DNSServiceEnumerateDomains returns kDNSServiceErr_NoError, the enumeration was started successfully, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceEnumerateDomains. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

For information about the callback function for DNSServiceEnumerateDomains, see DNSServiceDomainEnumReply. 

If you simply want to register in or search the default domain(s), pass NULL as the domain parameter when calling DNSServiceRegister or DNSServiceBrowse, respectively, and they will use the default domain without requiring you to look it up.*/
DNSServiceErrorType DNSServiceEnumerateDomains ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    DNSServiceDomainEnumReply callBack, 
    void *context // may be NULL 
    ){
printf ("DNSServiceEnumerateDomains",*sdRef,flags,interfaceIndex,callBack,context);
};  

/*DNSServiceUpdateRecord


Update a registered resource record. The record must either be: The primary txt record of a service registered via DNSServiceRegister(). A record added to a registered service via DNSServiceAddRecord(). An individual record registered by DNSServiceRegisterRecord().
DNSServiceErrorType DNSServiceUpdateRecord ( 
    DNSServiceRef sdRef, 
    DNSRecordRef RecordRef, // may be NULL 
    DNSServiceFlags flags, 
    uint16_t rdlen, 
    const void *rdata, 
    uint32_t ttl );  
Parameters
sdRef
A DNSServiceRef that was initialized by DNSServiceRegister() or DNSServiceCreateConnection(). 

RecordRef
A DNSRecordRef initialized by DNSServiceAddRecord, or NULL to update the service's primary txt record. 

flags
Currently ignored, reserved for future use. 

rdlen
The length, in bytes, of the new rdata. 

rdata
The new rdata to be contained in the updated resource record. 

ttl
The time to live of the updated resource record, in seconds. 

Return Value

Returns kDNSServiceErr_NoError on success, otherwise returns an error code indicating the error that occurred. 
Discussion 

This function updates the resource record referenced by RecordRef for the service referenced by sdRef while the service is running. If RecordRef is NULL, this function updates the primary TXT record for the service referenced by sdRef. 

Most services rarely need to update a resource record. You might, for example, need to update a text record for a service.*/
DNSServiceErrorType DNSServiceUpdateRecord ( 
    DNSServiceRef sdRef, 
    DNSRecordRef RecordRef, // may be NULL 
    DNSServiceFlags flags, 
    uint16_t rdlen, 
    const void *rdata, 
    uint32_t ttl ){
printf ("DNSServiceUpdateRecord",sdRef,RecordRef,flags,rdlen,rdata,ttl);
}; 

/*DNSServiceResolve


Gets the port number on which the service accepts connections, the name of the host that provides the service, and the service's primary TXT record.
DNSServiceErrorType DNSServiceResolve ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *name, 
    const char *regtype, 
    const char *domain, 
    DNSServiceResolveReply callBack, 
    void *context // may be NULL 
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the resolve operation will run indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

flags
Currently ignored, reserved for future use. 

interfaceIndex
The interface on which to resolve the service. If this resolve call is as a result of a currently active DNSServiceBrowse() operation, then the interfaceIndex should be the index reported in the DNSServiceBrowseReply callback. If this resolve call is using information previously saved (e.g. in a preference file) for later use, then use interfaceIndex 0, because the desired service may now be reachable via a different physical interface. See "Constants for specifying an interface index" for more details. 

name
The name of the service instance to be resolved, as reported to the DNSServiceBrowseReply() callback. 

regtype
The type of the service instance to be resolved, as reported to the DNSServiceBrowseReply() callback. 

domain
The domain of the service instance to be resolved, as reported to the DNSServiceBrowseReply() callback. 

callBack
The function to be called when a result is found, or if the call asynchronously fails. 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is never invoked and the DNSServiceRef is not initialized.) 
Discussion 

Call this function to get the name of the host that provides a service. Before you calling this function, get the name, registration type, and domain of the service by calling DNSServiceBrowse. 

This function is appropriate for resolving services that have a single SRV record and a single TXT record (the TXT record may be empty). To resolve services that have multiple SRV or TXT records, call DNSServiceQueryRecord instead. 

If DNSServiceResolve returns kDNSServiceErr_NoError, the resolution was started successfully, and sdRef is initialized. Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. Your callback function will be called when the service's host name has been resolved or to report an error that occurred asynchronously. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceResolve. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function and pass to it the response from the mDNSResponder daemon. 

For information about the callback function for DNSServiceResolve, see DNSServiceResolveReply. 

The IP address and local host name can change dynamically, and services can be removed or unplugged at any time, so call this function immediately before connecting to any network service, and call it each time you use the service.*/
DNSServiceErrorType DNSServiceResolve ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *name, 
    const char *regtype, 
    const char *domain, 
    DNSServiceResolveReply callBack, 
    void *context // may be NULL 
    ){
printf ("DNSServiceResolve",*sdRef,flags,interfaceIndex,*name,*regtype,*domain,callBack,context);
};  


/*DNSServiceRegister


Registers a service
DNSServiceErrorType DNSServiceRegister ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *name, // may be NULL 
    const char *regtype, 
    const char *domain, // may be NULL 
    const char *host, // may be NULL 
    uint16_t port, 
    uint16_t txtLen, 
    const void *txtRecord, // may be NULL 
    DNSServiceRegisterReply callBack, // may be NULL 
    void *context // may be NULL 
    );  
Parameters
sdRef
A pointer to an uninitialized DNSServiceRef. If the call succeeds then it initializes the DNSServiceRef, returns kDNSServiceErr_NoError, and the registration will remain active indefinitely until the client terminates it by passing this DNSServiceRef to DNSServiceRefDeallocate(). 

interfaceIndex
If non-zero, specifies the interface on which to register the service (the index for a given interface is determined via the if_nametoindex() family of calls.) Most applications will pass 0 to register on all available interfaces. See "Constants for specifying an interface index" for more details. 

flags
Indicates the renaming behavior on name conflict (most applications will pass 0). See flag definitions above for details. 

name
If non-NULL, specifies the service name to be registered. Most applications will not specify a name, in which case the computer name is used (this name is communicated to the client via the callback). 

regtype
The service type followed by the protocol, separated by a dot (e.g. "_ftp._tcp"). The transport protocol must be "_tcp" or "_udp". New service types should be registered at http://www.dns-sd.org/ServiceTypes.html. 

domain
If non-NULL, specifies the domain on which to advertise the service. Most applications will not specify a domain, instead automatically registering in the default domain(s). 

host
If non-NULL, specifies the SRV target host name. Most applications will not specify a host, instead automatically using the machine's default host name(s). Note that specifying a non-NULL host does NOT create an address record for that host - the application is responsible for ensuring that the appropriate address record exists, or creating it via DNSServiceRegisterRecord(). 

port
The port, in network byte order, on which the service accepts connections. Pass 0 for a "placeholder" service (i.e. a service that will not be discovered by browsing, but will cause a name conflict if another client tries to register that same name). Most clients will not use placeholder services. 

txtLen
The length of the txtRecord, in bytes. Must be zero if the txtRecord is NULL. 

txtRecord
The txt record rdata. May be NULL. Note that a non-NULL txtRecord MUST be a properly formatted DNS TXT record, i.e. [length byte] [data] [length byte] [data] ... 

callBack
The function to be called when the registration completes or asynchronously fails. The client MAY pass NULL for the callback - The client will NOT be notified of the default values picked on its behalf, and the client will NOT be notified of any asynchronous errors (e.g. out of memory errors, etc.) that may prevent the registration of the service. The client may NOT pass the NoAutoRename flag if the callback is NULL. The client may still deregister the service at any time via DNSServiceRefDeallocate(). 

context
An application context pointer which is passed to the callback function (may be NULL). 

Return Value

Returns kDNSServiceErr_NoError on success (any subsequent, asynchronous errors are delivered to the callback), otherwise returns an error code indicating the error that occurred (the callback is never invoked and the DNSServiceRef is not initialized.) 

Discussion 

Call this function to register a service. If DNSServiceRegister returns kDNSServiceErr_NoError, the registration started successfully, and sdRef is initialized. 

Call DNSServiceRefSockFD and pass sdRef to it to get the descriptor for the underlying socket. Use the descriptor that DNSServiceRefSockFD returns to set up a run loop or a select() loop. When the loop indicates that a response is available, call DNSServiceProcessResult and pass sdRef to it. DNSServiceProcessResult will call the callback function specified by callBack and pass to it the response from the mDNSResponder daemon. 

If you don't want to set up a run or select() loop, you can call DNSServiceProcessResult immediately after calling DNSServiceRegister. In this case, DNSServiceProcessResult will block until a response from the mDNSResponder daemon becomes available. When a response becomes available, DNSServiceProcessResult will call your callback function (if one was specified) and pass to it the response from the mDNSResponder daemon. 

For information about the callback function for DNSServiceRegister, see DNSServiceRegisterReply.*/
DNSServiceErrorType DNSServiceRegister ( 
    DNSServiceRef *sdRef, 
    DNSServiceFlags flags, 
    uint32_t interfaceIndex, 
    const char *name, // may be NULL 
    const char *regtype, 
    const char *domain, // may be NULL 
    const char *host, // may be NULL 
    uint16_t port, 
    uint16_t txtLen, 
    const void *txtRecord, // may be NULL 
    DNSServiceRegisterReply callBack, // may be NULL 
    void *context // may be NULL 
    ){
printf ("DNSServiceRegister",*sdRef,flags,interfaceIndex,*name,*regtype,*domain,*host,txtLen,txtRecord,callBack,context);
};  


/*TXTRecordGetItemAtIndex


Uses an index to get a pointer to the name of a key and its value.
DNSServiceErrorType TXTRecordGetItemAtIndex ( 
    uint16_t txtLen, 
    const void *txtRecord, 
    uint16_t index, 
    uint16_t keyBufLen, 
    char *key, 
    uint8_t *valueLen, 
    const void **value );  
Parameters
txtLen
The size of the received TXT Record. 

txtRecord
Pointer to the received TXT Record bytes. 

index
An index into the TXT Record. 

keyBufLen
The size of the string buffer being supplied. 

key
A string buffer used to store the key name. On return, the buffer contains a null-terminated C string giving the key name. DNS-SD TXT keys are usually 8 characters or less. To hold the maximum possible key name, the buffer should be 256 bytes long. 

valueLen
On output, will be set to the size of the "value" data. 

value
On output, *value is set to point to location within TXT Record bytes that holds the value data. 

Return Value

Returns kDNSServiceErr_NoError on success. Returns kDNSServiceErr_NoMemory if keyBufLen is too short. Returns kDNSServiceErr_Invalid if index is greater than TXTRecordGetCount()-1. 
Discussion 

This function uses an index into TXT record data (usually received by your applications DNSServiceResolveReply callback routine) to get a pointer to the name of a key and pointer to a value that points to the key's value. You can iterate through the keys in a TXT record by calling TXTRecordGetItemAtIndex repeatedly, starting with an index of zero and incrementing it until TXTRecordGetItemAtIndex returns kDNSServiceErr_Invalid. 

You can also call this function to iterate through keys in a TXT record reference that you built yourself. 

If a key has no value, on return, value is set to null and valueLen is zero. If the key has an empty value, on return, value points to a non-null value and valueLen is zero. If the key has a non-empty value, value points to a non-null value and valueLen points to a non-zero value.*/
DNSServiceErrorType TXTRecordGetItemAtIndex ( 
    uint16_t txtLen, 
    const void *txtRecord, 
    uint16_t index, 
    uint16_t keyBufLen, 
    char *key, 
    uint8_t *valueLen, 
    const void **value ){
printf ("TXTRecordGetItemAtIndex",txtLen,txtRecord,index,keyBufLen,*key,*valueLen,value);
};  

/*TXTRecordGetCount


Gets the number of keys in TXT record data.
uint16_t TXTRecordGetCount ( 
    uint16_t txtLen, 
    const void *txtRecord );  
Parameters
txtLen
The size of the received TXT Record. 

txtRecord
Pointer to the received TXT Record bytes. 

Return Value

Returns the total number of keys in the TXT Record. 

Discussion 

This function gets the number of keys in TXT record data, which you can pass to TXTRecordGetItemAtIndex to iterate through the keys.*/
uint16_t TXTRecordGetCount ( 
    uint16_t txtLen, 
    const void *txtRecord ){
printf ("TXTRecordGetCount",txtLen,txtRecord);
};  


/*TXTRecordDeallocate


Releases resources associated with a TXT record reference.
void TXTRecordDeallocate ( 
    TXTRecordRef *txtRecord );  
Parameters
txtRecord
A TXTRecordRef initialized by calling TXTRecordCreate(). 

Discussion 

Releases any resources allocated in the course of preparing a TXT Record using TXTRecordCreate()/TXTRecordSetValue()/TXTRecordRemoveValue(). Ownership of the buffer provided in TXTRecordCreate() returns to the client.*/
void TXTRecordDeallocate ( 
    TXTRecordRef *txtRecord ){
printf ("TXTRecordDeallocate",*txtRecord);
};  

/*TXTRecordGetLength


Gets the length of the raw bytes containing key/value pairs in a TXT record reference.
uint16_t TXTRecordGetLength ( 
    const TXTRecordRef *txtRecord );  
Parameters
txtRecord
A TXTRecordRef initialized by calling TXTRecordCreate(). 

Return Value

Returns the size of the raw bytes inside a TXTRecordRef which you can pass directly to DNSServiceRegister() or to DNSServiceUpdateRecord(). Returns 0 if the TXTRecordRef is empty. 

Discussion 

This function gets the length of the raw bytes in a TXT record reference. You can pass the length directly to DNSServiceRegisterRecord to register the record or DNSServiceUpdateRecord to update the record along with a pointer to the raw bytes obtained by calling TXTRecordGetBytesPtr.*/
uint16_t TXTRecordGetLength ( 
    const TXTRecordRef *txtRecord ){
printf ("TXTRecordGetLength",*txtRecord);
};  

/*TXTRecordGetBytesPtr


Gets a pointer to the raw bytes containing key/value pairs in a TXT record reference.
const void * TXTRecordGetBytesPtr ( 
    const TXTRecordRef *txtRecord );  
Parameters
txtRecord
A TXTRecordRef initialized by calling TXTRecordCreate(). 

Return Value

Returns a pointer to the raw bytes inside the TXTRecordRef which you can pass directly to DNSServiceRegister() or to DNSServiceUpdateRecord(). 

Discussion 

This function gets a pointer to the raw bytes in a TXT record reference that you've constructed. You can pass the pointer directly to DNSServiceRegisterRecord to register the record or DNSServiceUpdateRecord to update a record that has already been registered along with the length of the raw bytes obtained by calling TXTRecordGetLength.*/
const void * TXTRecordGetBytesPtr ( 
    const TXTRecordRef *txtRecord ){
printf ("TXTRecordGetBytesPtr",*txtRecord);
};  


/*TXTRecordSetValue


Sets a key and an optional value in a TXT record reference.
DNSServiceErrorType TXTRecordSetValue ( 
    TXTRecordRef *txtRecord, 
    const char *key, 
    uint8_t valueSize, ///may be zero 
    const void *value // may be NULL /
    );  
Parameters
txtRecord
A TXTRecordRef initialized by calling TXTRecordCreate(). 

key
A null-terminated string which only contains printable ASCII values (0x20-0x7E), excluding '=' (0x3D). Keys should be 8 characters or less (not counting the terminating null). 

valueSize
The size of the value. 

value
Any binary value. For values that represent textual data, UTF-8 is STRONGLY recommended. For values that represent textual data, valueSize should NOT include the terminating null (if any) at the end of the string. If NULL, then "key" will be added with no value. If non-NULL but valueSize is zero, then "key=" will be added with empty value. 

Return Value

Returns kDNSServiceErr_NoError on success. Returns kDNSServiceErr_Invalid if the "key" string contains illegal characters. Returns kDNSServiceErr_NoMemory if adding this key would exceed the available storage. 
Discussion 

Adds a key (optionally with value) to a TXTRecordRef. If the "key" already exists in the TXTRecordRef, then the current value will be replaced with the new value. 

Keys may exist in four states with respect to a given TXT record:
Absent (key does not appear at all) 
Present with no value ("key" appears alone) 
Present with empty value ("key=" appears in TXT record) 
Present with non-empty value ("key=value" appears in TXT record)


For more details refer to Data Syntax for DNS-SD TXT Records at http://files.dns-sd.org/draft-cheshire-dnsext-dns-sd.txt*/
DNSServiceErrorType TXTRecordSetValue ( 
    TXTRecordRef *txtRecord, 
    const char *key, 
    uint8_t valueSize, //may be zero 
    const void *value // may be NULL /
    ){
printf ("TXTRecordSetValue",*txtRecord,*key,valueSize,value);
};  

/*TXTRecordCreate


Creates a new empty TXTRecordRef referencing the specified storage.
void TXTRecordCreate ( 
    TXTRecordRef *txtRecord, 
    uint16_t bufferLen, 
    void *buffer );  
Parameters
txtRecord
A pointer to an uninitialized TXTRecordRef. 

bufferLen
The size of the storage provided in the "buffer" parameter. 

buffer
The storage used to hold the TXTRecord data. This storage must remain valid for as long as the TXTRecordRef.
Discussion 

If the buffer parameter is NULL, or the specified storage size is not large enough to hold a key subsequently added using TXTRecordSetValue(), then additional memory will be added as needed using malloc(). 

On some platforms, when memory is low, malloc() may fail. In this case, TXTRecordSetValue() will return kDNSServiceErr_NoMemory, and this error condition will need to be handled as appropriate by the caller. 

You can avoid the need to handle this error condition if you ensure that the storage you initially provide is large enough to hold all the key/value pairs that are to be added to the record. The caller can precompute the exact length required for all of the key/value pairs to be added, or simply provide a fixed-sized buffer known in advance to be large enough. 
A no-value (key-only) key requires (1 + key length) bytes. 
A key with empty value requires (1 + key length + 1) bytes. 
A key with non-empty value requires (1 + key length + 1 + value length).
For most applications, DNS-SD TXT records are generally less than 100 bytes, so in most cases a simple fixed-sized 256-byte buffer will be more than sufficient. Recommended size limits for DNS-SD TXT Records are discussed in http://files.dns-sd.org/draft-cheshire-dnsext-dns-sd.txt 

Note: When passing parameters to and from these TXT record APIs, the key name does not include the '=' character. The '=' character is the separator between the key and value in the on-the-wire packet format; it is not part of either the key or the value.*/
void TXTRecordCreate ( 
    TXTRecordRef *txtRecord, 
    uint16_t bufferLen, 
    void *buffer ){
printf ("TXTRecordCreate",*txtRecord,bufferLen,buffer);
};  
