#include <SystemConfiguration/SystemConfiguration.h>

//work


/*SCDynamicStoreCreate

SCDynamicStoreRef SCDynamicStoreCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    SCDynamicStoreCallBack callout, 
    SCDynamicStoreContext *context );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for the local dynamic store object. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
name
A string that describes the name of the calling process or plug-in of the caller.
callout
The function to be called when a watched value in the dynamic store is changed. A NULL value can be specified if no callouts are desired.
context
The SCDynamicStoreContext associated with the callout.
Return Value

Returns a reference to the new SCDynamicStore session. You must release the returned value. 
Discussion 

Creates a new session used to interact with the dynamic store maintained by the System Configuration server.*/
SCDynamicStoreRef SCDynamicStoreCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    SCDynamicStoreCallBack callout, 
    SCDynamicStoreContext *context ){};  

/*SCDynamicStoreSetNotificationKeys

Boolean SCDynamicStoreSetNotificationKeys ( 
    SCDynamicStoreRef store, 
    CFArrayRef keys, 
    CFArrayRef patterns );  
Parameters
store
The dynamic store session being watched.
keys
An array of keys to be monitored; NULL if no specific keys are to be monitored.
patterns
An array of regex(3) pattern strings used to match keys to be monitored; NULL if no key patterns are to be monitored.
Return Value

Returns TRUE if the set of notification keys and patterns was successfully updated; FALSE if an error was encountered. 
Discussion 

Specifies a set of specific keys and key patterns that should be monitored for changes.*/
Boolean SCDynamicStoreSetNotificationKeys ( 
    SCDynamicStoreRef store, 
    CFArrayRef keys, 
    CFArrayRef patterns ){};  

/*SCDynamicStoreCreateRunLoopSource

CFRunLoopSourceRef SCDynamicStoreCreateRunLoopSource ( 
    CFAllocatorRef allocator, 
    SCDynamicStoreRef store, 
    CFIndex order );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this run loop source. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
store
A reference to the dynamic store session.
order
On platforms which support it, for source versions which support it, this parameter determines the order in which the sources which are ready to be processed are handled. A lower order number causes processing before higher order number sources. It is inadvisable to depend on the order number for any architectural or design aspect of code. In the absence of any reason to do otherwise, zero should be used.
Return Value

A reference to the new CFRunLoopSource. You must release the returned value. 

Discussion 

Creates a CFRunLoopSource object that can be added to the application's run loop. All dynamic store notifications are delivered using this run loop source.*/

CFRunLoopSourceRef SCDynamicStoreCreateRunLoopSource ( 
    CFAllocatorRef allocator, 
    SCDynamicStoreRef store, 
    CFIndex order ){};  


/*SCDynamicStoreCopyKeyList

CFArrayRef SCDynamicStoreCopyKeyList ( 
    SCDynamicStoreRef store, 
    CFStringRef pattern );  
Parameters
store
The dynamic store session.
pattern
A regex(3) regular expression pattern used to match the dynamic store keys.
Return Value

Returns the list of matching keys; NULL if an error was encountered. You must release the returned value. 
Discussion 

ReturnSCDynamicStoreCopyKeyList

CFArrayRef SCDynamicStoreCopyKeyList ( 
    SCDynamicStoreRef store, 
    CFStringRef pattern );  
Parameters
store
The dynamic store session.
pattern
A regex(3) regular expression pattern used to match the dynamic store keys.
Return Value

Returns the list of matching keys; NULL if an error was encountered. You must release the returned value. 
Discussion 

Returns an array of CFString keys representing the current dynamic store entries that match a specified pattern.s an array of CFString keys representing the current dynamic store entries that match a specified pattern.*/
CFArrayRef SCDynamicStoreCopyKeyList ( 
    SCDynamicStoreRef store, 
    CFStringRef pattern ){};

  
/*SCDynamicStoreCopyValue

CFPropertyListRef SCDynamicStoreCopyValue ( 
    SCDynamicStoreRef store, 
    CFStringRef key );  
Parameters
store
The dynamic store session.
key
The key associated with the value you want to get.
Return Value

Returns the value from the dynamic store that is associated with the given key; NULL if no value was located or an error was encountered. You must release the returned value. 
Discussion 

Gets the value of the specified key from the dynamic store.*/
CFPropertyListRef SCDynamicStoreCopyValue ( 
    SCDynamicStoreRef store, 
    CFStringRef key ){};

  

