#include <SearchKit/SearchKit.h>

//work

/*SKDocumentCreate

Creates a document URL object based on a scheme, parent, and name.

SKDocumentRef SKDocumentCreate (
CFStringRef     inScheme,
SKDocumentRef   inParent,
CFStringRef     inName
);
Parameters
inScheme

The scheme to use—analogous to the scheme of a URL. Only documents referenced with the “file” scheme can be read by the SKIndexAddDocument function. The scheme can be anything you like if you use the SKIndexAddDocumentWithText function. The scheme can be NULL, in which case it will be set to be the same scheme as the document URL object’s (SKDocumentRef’s) parent. For more information on schemes, see http://www.iana.org/assignments/uri-schemes.html.
inParent

The document URL object one step up in the document hierarchy. Can be NULL.
inName

The name of the document that you’re creating a document URL object for. For the “file” scheme, it is the name of the file or the container, not its path. The path can be constructed by following parent links. The maximum length for a document name is 256 bytes.
Return Value

The new document URL object, or NULL on failure.
Discussion

The new document URL object’s (SKDocumentRef’s) parent can be NULL, but you must specify either a scheme or a parent. When your application no longer needs the document URL object, dispose of it by calling CFRelease.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKDocument.h*/
SKDocumentRef SKDocumentCreate (
CFStringRef     inScheme,
SKDocumentRef   inParent,
CFStringRef     inName
){};
