#include <QuickTime/QuickTime.h>


/*TuneQueue

Places a sequence of music events into a queue to be played.

ComponentResult TuneQueue (
   TunePlayer         tp,
   unsigned long      *tune,
   Fixed              tuneRate,
   unsigned long      tuneStartPosition,
   unsigned long      tuneStopPosition,
   unsigned long      queueFlags,
   TuneCallBackUPP    callBackProc,
   long               refCon );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
tune

A pointer to an array of events, terminated by a marker event of subtype kMarkerEventEnd. See QTMA Events.
tuneRate

Speed at which to play the sequence. "Normal" speed is 0x00010000.
tuneStartPosition

Sequence starting time.
tuneStopPosition

Sequence stopping time. The tuneStartPosition and tuneStopPosition parameters specify, in time units numbered from 0 for the beginning of the sequence, which part of the queued sequence to play. To play all of it, pass 0 and 0xFFFFFFFF, respectively.
queueFlags

Flags (see below) with details about how to play the queued tunes. See these constants: 
kTuneStartNow
kTuneDontClipNotes
kTuneExcludeEdgeNotes
kTuneQuickStart
kTuneLoopUntil
kTuneStartNewMaster
callBackProc

A pointer to a TuneCallBackProc callback.
refCon

A reference constant to be passed to your TuneCallBackProc callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult TuneQueue (
   TunePlayer         tp,
   unsigned long      *tune,
   Fixed              tuneRate,
   unsigned long      tuneStartPosition,
   unsigned long      tuneStopPosition,
   unsigned long      queueFlags,
   TuneCallBackUPP    callBackProc,
   long               refCon ){
printf ("TuneQueue",tp,*tune,tuneRate,tuneStartPosition,tuneStopPosition,queueFlags,callBackProc,refCon);
};


/*NASetNoteChannelVolume

Sets the volume on the specified note channel.

ComponentResult NASetNoteChannelVolume (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   Fixed            volume );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
noteChannel

The note channel to reset. You obtain the note channel identifier from the NANewNoteChannel or the NANewNoteChannelFromAtomicInstrument function.
volume

A fixed 16.16 number. NASetNoteChannelVolume sets the volume for the note channel, which is different from a kControllerVolume setting. Both volume settings allow fractional values of 0.0 to 1.0. Each value modifies the other. For example, a kControllerVolume value of 0.5 and a NASetNoteChannelVolume value of 0.5 result in a 0.25 volume level.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult NASetNoteChannelVolume (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   Fixed            volume ){
printf ("NASetNoteChannelVolume ",na,noteChannel,volume);
};

//work


/*NANewNoteChannel

Requests a new note channel with the qualities described in a NoteRequest structure.

ComponentResult NANewNoteChannel (
   NoteAllocator    na,
   NoteRequest      *noteRequest,
   NoteChannel      *outCh
annel );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
noteRequest

A pointer to a NoteRequest structure.
outChannel

On return, a pointer to an identifier for a new note channel or NIL if the function fails to create a note channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function searches all available music components for the instrument that best matches the specifications in the ToneDescription structure that is contained within the noteRequest parameter. If an error occurs, the new note channel is initialized to NIL. The caller can request an instrument that is not currently allocated to a part. In that case, this function may return a value in outChannel, even though the request cannot initially be satisfied. The note channel may become valid at a later time, as other note channels are released or other music components are registered.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NANewNoteChannel (
   NoteAllocator    na,
   NoteRequest      *noteRequest,
   NoteChannel      *outChannel ){};


/*NADisposeNoteChannel

Deletes a specified note channel.

ComponentResult NADisposeNoteChannel (
   NoteAllocator    na,
   NoteChannel      noteChannel );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
noteChannel

Note channel to be disposed. You obtain the note channel identifier from NANewNoteChannel or NANewNoteChannelFromAtomicInstrument.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NADisposeNoteChannel (
   NoteAllocator    na,
   NoteChannel      noteChannel ){};


/*NAPickInstrument

Presents a user interface for picking an instrument.

ComponentResult NAPickInstrument (
   NoteAllocator      na,
   ModalFilterUPP     filterProc,
   StringPtr          prompt,
   ToneDescription    *sd,
   unsigned long      flags,
   long               refCon,
   long               reserved1,
   long               reserved2 );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
filterProc

Pointer to a ModalFilterProc callback.
prompt

A pointer to the dialog box prompt "New Instrument".
sd

On entry, the tone description of the instrument that appears in the picker dialog box. On return, a tone description of the instrument the user selected.
flags

Flags (see below) that determine whether to display the picker dialog box and what instruments appear for selection. If the kPickDontMix flag is set, the dialog box does not display a mix of synthesizer part types. For example, if the current instrument is a drum, only available drums appear in the dialog box. The kPickSameSynth flag allows selections only within the current synthesizer. The kPickUserInsts flag allows user modifiable instruments to appear. The kPickEditAllowPick flag is used only with NAPickEditInstrument. See these constants: 
kPickDontMix
kPickSameSynth
kPickUserInsts
refCon

A reference constant value. The Movie Toolbox passes this reference constant to your ModalFilterProc callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
reserved1

Must contain 0.
reserved2

Must contain 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAPickInstrument (
   NoteAllocator      na,
   ModalFilterUPP     filterProc,
   StringPtr          prompt,
   ToneDescription    *sd,
   unsigned long      flags,
   long               refCon,
   long               reserved1,
   long               reserved2 ){};

/*TuneGetStatus

Returns an initialized structure describing the state of the tune player instance.

ComponentResult TuneGetStatus (
   TunePlayer    tp,
   TuneStatus    *status );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
status

A pointer to an initialized TuneStatus structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult TuneGetStatus (
   TunePlayer    tp,
   TuneStatus    *status ){};

/*NANewNoteChannelFromAtomicInstrument

Requests a new note channel for an atomic instrument.

ComponentResult NANewNoteChannelFromAtomicInstrument (
   NoteAllocator          na,
   AtomicInstrumentPtr    instrument,
   long                   flags,
   NoteChannel            *outChannel );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
instrument

A pointer to the atomic instrument. This may be a dereferenced locked QT atom container.
flags

Flags (see below) that specify details of initializing a part with an atomic instrument. See these constants: 
kSetAtomicInstKeepOriginalInstrument
kSetAtomicInstShareAcrossParts
kSetAtomicInstCallerTosses
kSetAtomicInstDontPreprocess
outChannel

On return, a pointer to an identifier for a new note channel or NIL if the function fails to create a note channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function takes a note allocator identifier in the na parameter and a pointer to the atomic instrument you are requesting a new channel for in the instrument parameter. Among other things, you can specify how to handle the expanded sample with the flags parameter. The function returns the note channel allocated for the instrument in the outChannel parameter, or NIL if an error occurs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NANewNoteChannelFromAtomicInstrument (
   NoteAllocator          na,
   AtomicInstrumentPtr    instrument,
   long                   flags,
   NoteChannel            *outChannel ){};


/*NAStuffToneDescription

Initializes a tone description structure with the details of a General MIDI note channel.

ComponentResult NAStuffToneDescription (
   NoteAllocator      na,
   long               gmNumber,
   ToneDescription    *td );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
gmNumber

A General MIDI instrument number.
td

On return, an initialized tone description. The instrument name field will be filled in with the string name for the instrument.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAStuffToneDescription (
   NoteAllocator      na,
   long               gmNumber,
   ToneDescription    *td ){};


/*NAPlayNote

Plays a note with a specified pitch and velocity on the specified note channel.

ComponentResult NAPlayNote (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             pitch,
   long             velocity );
Parameters
na

You obtain the note allocator identifier from OpenComponent.
noteChannel

The note channel to play the note. You obtain the note channel identifier from the NANewNoteChannel or the NANewNoteChannelFromAtomicInstrument function.
pitch

The pitch at which to play the note. You can specify values as integer pitch values (0-127 where 60 is middle C) or fractional pitch values (256 (0x1.00) through 32767 (0x7F.FF)). If the pitch is a number from 0 to 127, then it is the MIDI pitch, where 60 is middle C. If the pitch is a positive number above 65535, then the value is a fixed-point pitch value. Thus, microtonal values can be specified. Negative values are not defined and should not be used.
velocity

The velocity with which the key is struck. Typically, this translates directly to volume, but on many synthesizers this also subtly alters the timbre of the tone. A value of 0 is silence; a value of 127 is maximum force.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAPlayNote (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             pitch,
   long             velocity ){};


/*TuneSetHeader

Prepares the tune player to accept subsequent music event sequences by defining one or more parts to be used by sequence Note events.

ComponentResult TuneSetHeader (
   TunePlayer       tp,
   unsigned long    *header );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
header

A pointer to a list of instruments that will be used in subsequent calls to the TuneQueue function. The list can include events with subtypes of kGeneralEventNoteRequest, kGeneralEventPartKey, kGeneralEventAtomicInstrument, kGeneralEventMIDIChannel, and kGeneralEventUsedNotes. It can also include atomic instruments. The list is terminated by a marker event of subtype kMarkerEventEnd. See QTMA Events.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is the first QuickTime music architecture call to play a music sequence. The header parameter points to one or more initialized General events and atomic instruments. Only one call to this function is required. Each call to this function resets the tune player.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult TuneSetHeader (
   TunePlayer       tp,
   unsigned long    *header ){};


/*NASetController

Changes the controller setting on a note channel to a specified value.

ComponentResult NASetController (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             controllerNumber,
   long             controllerValue );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
noteChannel

Note channel on which to change controller. You obtain the note channel identifier from NANewNoteChannel or NANewNoteChannelFromAtomicInstrument.
controllerNumber

The controller to set; see Music Controllers.
controllerValue

Value for controller setting; typically 0 (0x00.00) to 32767 (0x7F.FF).
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NASetController (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             controllerNumber,
   long             controllerValue ){};






