#include <QuartzComposer/QuartzComposer.h>
//work
/*Connstants

You can pass the following constants in the optional argument dictionary when you call the renderAtTime:arguments: method.
Constant	
Description
QCRendererEventKey	
The associated value is an NSEvent object.

Available in Mac OS X v10.4 and later.
QCRendererMouseLocationKey	
The associated value is a mouse location, specified as an NSPoint object stored in an NSValue object.

Available in Mac OS X v10.4 and later.*/
NSString* const QCRendererEventKey;
NSString* const QCRendererMouseLocationKey	;

//work
@implementation  QCRenderer

/*renderAtTime:arguments:

Renders a frame at the specified time. 

- (BOOL) renderAtTime:(NSTimeInterval)time arguments:(NSDictionary*)arguments
Parameters
time

The time, in seconds, at which to render a composition frame. The time must be a positive value or zero. 
arguments

An optional dictionary that can contain any of the following key-value pairs as entries:
QCRendererEventKey and the current NSEvent, if any
QCRendererMouseLocationKey and the current mouse location (an NSPoint object stored in an NSValue object) in normalized coordinates relative to the OpenGL context viewport ([0,1]x[0,1] with the origin (0,0) at the lower-left corner).
Discussion

The rendertAtTime:arguments: method does not swap the front and back buffers of the OpenGL context. You must perform the swap yourself by calling the OpenGL command flushBuffer on the context associated with the renderer. This allows you to combine Quartz Composer with custom OpenGL code. All OpenGL states that are modified by the renderer are saved or restored except the following:
States defined by GL_CURRENT_BIT
Textures on each unit and the environment mode
Matrix mode
Availability
Available in Mac OS X v10.4 and later.*/
- (BOOL) renderAtTime:(NSTimeInterval)time arguments:(NSDictionary*)arguments{}


/*initWithOpenGLContext:pixelFormat:file:

Returns a QCRenderer object initialized with a Quartz Composer composition.

- (id) initWithOpenGLContext:(NSOpenGLContext*)context pixelFormat:(NSOpenGLPixelFormat*)format file:(NSString*)path
Parameters
context

An NSOpenGLContext object. The object that you supply must have both a color and a depth buffer.
format

An NSOpenGLPixelFormat object.
path

A string that specifies the location of a Quartz Composer composition file.
Return Value

The initialized QCRenderer object or nil if initialization is not successful.
Availability
Available in Mac OS X v10.4 and later.*/
- (id) initWithOpenGLContext:(NSOpenGLContext*)context pixelFormat:(NSOpenGLPixelFormat*)format{}

/*initWithOpenGLContext:pixelFormat:file:

Returns a QCRenderer object initialized with a Quartz Composer composition.

- (id) initWithOpenGLContext:(NSOpenGLContext*)context pixelFormat:(NSOpenGLPixelFormat*)format file:(NSString*)path
Parameters
context

An NSOpenGLContext object. The object that you supply must have both a color and a depth buffer.
format

An NSOpenGLPixelFormat object.
path

A string that specifies the location of a Quartz Composer composition file.
Return Value

The initialized QCRenderer object or nil if initialization is not successful.
Availability
Available in Mac OS X v10.4 and later.*/
- (id) initWithOpenGLContext:(NSOpenGLContext*)context pixelFormat:(NSOpenGLPixelFormat*)format file:(NSString*)pathParameters{}

/*setValue:forInputKey:

Sets the value for an input port of a composition.

- (BOOL) setValue:(id)value forInputKey:(NSString*)key
Parameters
value

The value to set for the input port. The input port must be at the root patch of the composition. The data type of the value argument must match the input port. See QCPortAttributeTypeKey for the data types accepted by a particular port type.
key

The key associated with the input port of the composition. This method throws an exception if key is invalid.
Return Value

Returns NO if it cannot set the value.
Availability
Available in Mac OS X v10.4 and later.
See Also
– valueForInputKey:
– valueForOutputKey:*/
- (BOOL) setValue:(id)value forInputKey:(NSString*)key{}



@end
