#include <QD/QD.h>

//work

/*ATSUGetFontIDs

Obtains a list of all the ATSUI-compatible fonts installed on the user’s system. 

OSStatus ATSUGetFontIDs (
   ATSUFontID *oFontIDs,
   ItemCount iArraySize,
   ItemCount *oFontCount
);
Parameters
oFontIDs

A pointer to memory you have allocated for an array of ATSUFontID values. On return, the array contains unique identifiers for each of the ATSUI-compatible fonts installed on the user’s system. You should allocate enough memory to contain an array the size of the count produced by the function ATSUFontCount. 
iArraySize

An ItemCount value specifying the maximum number of fonts to obtain. Typically, this is equivalent to the number of ATSUFontID values for which you have allocated memory in the oFontIDs parameter.
oFontCount

A pointer to an ItemCount value. On return, the value specifies the actual number of ATSUI-compatible fonts installed on the user’s system. This may be greater than the value you specified in the iArraySize parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetFontIDs function obtains the IDs of all the fonts on the user’s system except for the last-resort font. It is important to note that the set of installed ATSUI-compatible fonts may change while your application is running. In Mac OS X, the set of installed fonts may change at any time. Although in Mac OS 9, fonts cannot be removed from the Fonts folder while an application other than the Finder is running, they can be removed from other locations, and it is possible for fonts to be added.

To ensure an accurate representation of the set of installed ATSUI-compatible fonts, you should call ATSUGetFontIDs to rebuild your font menu each time your application is brought to the foreground.

Finally, note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change across system restarts.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontIDs (
   ATSUFontID *oFontIDs,
   ItemCount iArraySize,
   ItemCount *oFontCount
){};


/*ATSUFontCount

Obtains the number of ATSUI-compatible fonts installed on a user’s system.

OSStatus ATSUFontCount (
   ItemCount *oFontCount
);
Parameters
oFontCount

A pointer to an ItemCount value. On return, the value specifies the current number of ATSUI-compatible fonts installed on the user’s system.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUFontCount function obtains the number of fonts on a user’s system that are compatible with ATSUI. Incompatible fonts include those that cannot be used to represent Unicode, the missing-character glyph font, and fonts whose names begin with a period or a percent sign. You can use the count produced in the oFontCount parameter to determine the amount of memory to allocate for the oFontIDs array in the function ATSUGetFontIDs.

It is important to note that the set of installed ATSUI-compatible fonts may change while your application is running. In Mac OS X, the set of installed fonts may change at any time. Although in Mac OS 9, fonts cannot be removed from the Fonts folder while an application other than the Finder is running, they can be removed from other locations, and it is possible for fonts to be added.

Additionally, just because the number of fonts stays the same between two successive calls to ATSUFontCount, this does not mean that the font lists are the same. It is possible for a font to be added and another removed between two successive calls to ATSUFontCount, leaving the total number unchanged.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUFontCount (
   ItemCount *oFontCount
){};

/*ATSUGetIndFontVariation

Obtains a variation axis and its value range for a font.

OSStatus ATSUGetIndFontVariation (
   ATSUFontID iFont,
   ItemCount iVariationIndex,
   ATSUFontVariationAxis *oATSUFontVariationAxis,
   ATSUFontVariationValue *oMinimumValue,
   ATSUFontVariationValue *oMaximumValue,
   ATSUFontVariationValue *oDefaultValue
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iVariationIndex

An ItemCount value specifying an index into the array of variation axes for the font. This index identifies the font variation axis to examine. Because this index is zero-based, you must pass a value between 0 and one less than the value produced in the oVariationCount parameter of the function ATSUCountFontVariations.
oATSUFontVariationAxis

A pointer to an ATSUFontVariationAxis value. On return, the value provides a four-character code identifying the font variation axis corresponding to the specified index. 
oMinimumValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis minimum. 
oMaximumValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis maximum. 
oDefaultValue

A pointer to an ATSUFontVariationValue value. On return, the value identifies the variation axis default. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

By calling the function ATSUGetIndFontVariation, you can obtain a variation axis and its maximum, minimum, and default values for a font.

If you supply font variation axes and values to the function ATSUSetVariations, you can change the appearance of a style object’s font accordingly.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetIndFontVariation (
   ATSUFontID iFont,
   ItemCount iVariationIndex,
   ATSUFontVariationAxis *oATSUFontVariationAxis,
   ATSUFontVariationValue *oMinimumValue,
   ATSUFontVariationValue *oMaximumValue,
   ATSUFontVariationValue *oDefaultValue
){};


/*ATSUSetVariations

Sets font variation axes and values in a style object.

OSStatus ATSUSetVariations (
   ATSUStyle iStyle,
   ItemCount iVariationCount,
   const ATSUFontVariationAxis *iAxes,
   const ATSUFontVariationValue *iValue
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set font variation values. 
iVariationCount

An ItemCount value specifying the number of font variation values to set. This value should correspond to the number of elements in the iAxes and iValue arrays.
iAxes

A pointer to the initial ATSUFontVariationAxis value in an array of font variation axes. Each element in the array must represent a valid variation axis tag that corresponds to a variation value in the iValue array. To obtain a valid variation axis tag for a font, you can call the functions ATSUGetIndFontVariation or ATSUGetFontInstance. 
iValue

A pointer to the initial ATSUFontVariationValue value in an array of font variation values. Each element in the array must contain a value that is valid for the corresponding variation axis in the iAxes parameter. You can obtain a font’s maximum, minimum, and default values for a given variation axis by calling the function ATSUGetIndFontVariation. You can obtain the font variation axis values for a font instance by calling ATSUGetFontInstance. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

If you supply font variation axes and values to the ATSUSetVariations function, you can change the appearance of a style object’s font accordingly. You may specify any number of variation axes and values in a style object. Any of the font’s variations that you do not set retain their font-defined default values.

You can also use the ATSUSetVariations function to supply your own value within any variation axes defined for the font. However, if the font does not support the variation axis you specify, your custom variation has no visual effect.

By calling the function ATSUGetIndFontVariation, you can obtain a variation axis and its maximum, minimum, and default values for a font.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUSetVariations (
   ATSUStyle iStyle,
   ItemCount iVariationCount,
   const ATSUFontVariationAxis *iAxes,
   const ATSUFontVariationValue *iValue
){};

/*ATSUCountFontFeatureTypes

Obtains the number of available feature types in a font.

OSStatus ATSUCountFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount *oTypeCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
oTypeCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature types defined for the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontFeatureTypes function obtains the total number of feature types defined for a font. You can use the count produced by ATSUCountFontFeatureTypes to determine how much memory to allocate for the oTypes array in the function ATSUGetFontFeatureTypes. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUCountFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount *oTypeCount
){};


/*ATSUCountFontVariations

Obtains the number of defined variation axes in a font.

OSStatus ATSUCountFontVariations (
   ATSUFontID iFont,
   ItemCount *oVariationCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
oVariationCount

A pointer to an ItemCount value. On return, the value specifies the number of variation axes defined for the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontVariations function obtains the total number of variation axes defined for a font. You can use the count produced by ATSUCountFontVariations to get information about a specific font variation axis from the function ATSUGetIndFontVariation.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUCountFontVariations (
   ATSUFontID iFont,
   ItemCount *oVariationCount
){};



/*ATSUGetFontFeatureTypes

Obtains the available feature types of a font.

OSStatus ATSUGetFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount iMaximumTypes,
   ATSUFontFeatureType *oTypes,
   ItemCount *oActualTypeCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iMaximumTypes

An ItemCount value specifying the maximum number of feature types to obtain for the font. Typically, this is equivalent to the number of elements in the oTypes array.
oTypes

A pointer to memory you have allocated for an array of ATSUFontFeatureType values. You can call the function ATSUCountFontFeatureTypes to obtain the number of available feature types for a given font and thus determine the amount of memory to allocate. On return, the array contains constants identifying each type of feature that is defined for the font. The constants that represent font feature types are defined in the header file SFNTLayoutTypes.h and are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. 
oActualTypeCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature types defined in the font. This may be greater than the value you specify in the iMaximumTypes parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

A given font may not support all possible feature types and selectors. If you select features that are not available in a font, you won’t see a change in the glyph’s appearance. To determine the available features of a font, you can call the functions ATSUGetFontFeatureTypes and ATSUGetFontFeatureSelectors.

The ATSUGetFontFeatureTypes function reads the font data table for the specified font and obtains its supported feature types. You can then use this information both to present the user a list of font features from which to select and to call such functions as ATSUSetFontFeatures with more accuracy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontFeatureTypes (
   ATSUFontID iFont,
   ItemCount iMaximumTypes,
   ATSUFontFeatureType *oTypes,
   ItemCount *oActualTypeCount
){};


/*ATSUCountFontFeatureSelectors

Obtains the number of available feature selectors for a given feature type in a font.

OSStatus ATSUCountFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount *oSelectorCount
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iType

An ATSUFontFeatureType value specifying one of the font’s supported feature types. To obtain the available feature types for a font, call the function ATSUGetFontFeatureTypes. 
oSelectorCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature selectors defined for the feature type by the font.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUCountFontFeatureSelectors function obtains the total number of feature selectors defined for a given feature type in the font. You can use the count produced by ATSUCountFontFeatureSelectors to determine how much memory to allocate for the oSelectors array in the function ATSUGetFontFeatureSelectors.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUCountFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount *oSelectorCount
){};

/*ATSUGetFontFeatureSelectors

Obtains the available feature selectors for a given feature type in a font.

OSStatus ATSUGetFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount iMaximumSelectors,
   ATSUFontFeatureSelector *oSelectors,
   Boolean *oSelectorIsOnByDefault,
   ItemCount *oActualSelectorCount,
   Boolean *oIsMutuallyExclusive
);
Parameters
iFont

An ATSUFontID value identifying the font to examine. 
iType

An ATSUFontFeatureType value specifying one of the font’s supported feature types. To obtain the available feature types for a font, call the function ATSUGetFontFeatureTypes. 
iMaximumSelectors

An ItemCount value specifying the maximum number of feature selectors to obtain for the font’s specified feature type. Typically, this is equivalent to the number of elements in the oSelectors array.
oSelectors

A pointer to memory you have allocated for an array of ATSUFontFeatureSelector values. You can call the function ATSUCountFontFeatureSelectors to obtain the number of available feature selectors for a given font feature type and thus determine the amount of memory to allocate. On return, the array contains constants identifying each available feature selector for the given feature type. The constants that represent font feature selectors are defined in the header file SFNTLayoutTypes.h and are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. 
oSelectorIsOnByDefault

A pointer to memory you have allocated for an array of Boolean values. The number of elements in this array should correspond to the number of elements in the oSelectors array. On return, the array contains Boolean values indicating whether the corresponding feature selector in the oSelectors array is on or off. If true, the feature selector is on by default; if false, off. 
oActualSelectorCount

A pointer to an ItemCount value. On return, the value specifies the actual number of feature selectors defined for the given feature type. This value may be greater than the value you specify in the iMaximumSelectors parameter. 
oIsMutuallyExclusive

A pointer to a Boolean value. On return, the value indicates whether the feature selectors for the given feature type are exclusive or nonexclusive. If a feature type is exclusive you can choose only one of its available feature selectors at a time, such as whether to display numbers as proportional or fixed-width. If a feature type is nonexclusive, you can enable any number of feature selectors at once. If true, the feature type is exclusive and only one selector can be used at a time.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

A given font may not support all possible feature types and selectors. If you select features that are not available in a font, you won’t see a change in the glyph’s appearance. To determine the available features of a font, you can call the functions ATSUGetFontFeatureTypes and ATSUGetFontFeatureSelectors.

The ATSUGetFontFeatureSelectors function reads the font data table for the specified font and obtains its supported feature selectors for the given feature types. You can then use this information both to present the user a list of font features from which to select and to call such functions as ATSUSetFontFeatures with more accuracy.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontFeatureSelectors (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ItemCount iMaximumSelectors,
   ATSUFontFeatureSelector *oSelectors,
   Boolean *oSelectorIsOnByDefault,
   ItemCount *oActualSelectorCount,
   Boolean *oIsMutuallyExclusive
){};

/*ATSUSetFontFeatures

Sets font features in a style object.

OSStatus ATSUSetFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to set font features. 
iFeatureCount

An ItemCount value specifying the number of font features to set. This value should correspond to the number of elements in the iType and iSelector arrays.
iType

A pointer to the initial ATSUFontFeatureType value in an array of feature types. Each element in the array must contain a valid feature type that corresponds to a feature selector in the iSelector array. To obtain the valid feature types for a font, call the function ATSUGetFontFeatureTypes. 
iSelector

A pointer to the initial ATSUFontFeatureSelector value in an array of feature selectors. Each element in the array must contain a valid feature selector that corresponds to a feature type in the iType array. To obtain the valid feature selectors for a font, call the function ATSUGetFontFeatureSelectors. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUSetFontFeatures function enables you to set multiple font features for a style object. Any unset font features retain their font-defined default values. To set style attributes and font variations for a style object, call the functions ATSUSetAttributes and ATSUSetVariations, respectively.

The constants that represent font feature types are defined in the header file SFNTLayoutTypes.h. When you use ATSUI to access and set font features, you must use the constants defined in this header file, which are described in Inside Mac OS X: Rendering Unicode Text With ATSUI. As feature types can be added at any time, you should check Apple’s font feature registry website for the most up-to-date list of font feature types and selectors: http://developer.apple.com/fonts/Registry/index.html.
Version Notes

Prior to ATSUI 1.2, ATSUSetFontFeatures does not remove contradictory font features. You are responsible for maintaining your own list and removing contradictory settings when they occur. Beginning with ATSUI 1.2, ATSUSetFontFeatures removes contradictory font features if they are set. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUSetFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
){};


/*ATSUFONDtoFontID

Finds the ATSUI font ID that corresponds to a font family number, if one exists. (Deprecated. There is no replacement because FONDs are a QuickDraw concept and QuickDraw is deprecated.)

Not recommended.

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
);
Parameters
iFONDNumber

The font family number of the ATSUI-compatible font for which to obtain an ATSUI font ID.
iFONDStyle

The font family style of the font, if any. Style identifiers exist only for fonts that split a font family into subgroups.
oFontID

A pointer to a ATSUFontID value. On return, the value provides a unique identifier for the specified font family number and style. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The function ATSUFONDtoFontID is not recommended for use. Instead, use the Font Manager functions that translate font family numbers to FMFont values, which are equivalent to ATSUFontID values. Font family numbers were used by QuickDraw to represent fonts to the Font Manager. Some of these fonts, even if compatible with ATSUI, may not have font IDs.

Note that Apple Type Services assigns ATSUFontID values systemwide at runtime. As a result, these font IDs can change when the system is restarted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/

OSStatus ATSUFONDtoFontID (
   SInt16 iFONDNumber,
   Style iFONDStyle,
   ATSUFontID *oFontID
){};


/*ATSUFindFontFromName

Obtains an ATSUI font ID for the first entry in a name table that matches the specified name string, name code, platform, script, and/or language. 

OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
);
Parameters
iName

A string that specifies the font name whose ATSUI font ID you want to obtain. The string that you pass must be appropriate for the value you pass in the iFontNameCode parameter. For example, if the iFontNameCode parameter is kFontPostscriptName, then you would supply a string that specifies the PostScript name of the font.
iNameLength

A ByteCount value specifying the length of the font name string provided in the iName parameter.
iFontNameCode

The FontNameCode value of the font name for which to obtain an ATSUI font ID. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file. You can supply any of the following constants, kFontCopyrightName, kFontFamilyName, kFontStyleName, kFontUniqueName, kFontFullName, kFontVersionName, kFontPostscriptName, kFontTrademarkName, kFontManufacturerName, kFontDesignerName, kFontDescriptionName, kFontVendorURLName, kFontDesignerURLName, kFontLicenseDescriptionName,or kFontLicenseInfoURLName.
iFontNamePlatform

A FontPlatformCode value specifying the encoding of the font name, for example, kFontUnicodePlatform (for UTF-16), kFontMacintoshPlatform, kFontReservedPlatform, kFontMicrosoftPlatform, or kFontCustomPlatform. If you pass the kFontNoPlatformCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontPlatformCode type and a list of possible values. 
iFontNameScript

A FontScriptCode value specifying the script code of the font name, for example, kFontRomanScript. Pass kFontNoScriptCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoScriptCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontScriptCode type and a list of possible values. 
iFontNameLanguage

A FontLanguageCode value specifying the language of the font name, for example, kFontNorwegianLanguage. Pass kFontNoLanguageCode if you supplied the kFontUnicodePlatform constant for the iFontNamePlatform parameter. If you pass the kFontNoLanguageCode constant, ATSUFindFontFromName produces the first font in the name table matching the other specified parameters. See the SFNTTypes.h header file for a definition of the FontLanguageCode type and a list of possible values.
oFontID

On return, points to the unique identifier for the specified font that matches the specified name string, name code, platform, script, and/or language. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
Return Value

A result code. If no installed font matches the specified parameters, ATSUFindFontFromName produces the constant kATSUInvalidFontID and returns the result code kATSUInvalidFontErr. See “ATSUI Result Codes”.
Discussion

The ATSUFindFontFromName function obtains an ATSUI font ID for the first font that matches the specified name string, name code, platform, script, and/or language. Because ATSUI cannot guarantee the uniqueness of names among installed fonts, ATSUFindFontFromName does not necessarily find the only font ID that matches these parameters. As a result, you may want to create a more sophisticated name-matching algorithm or guarantee the uniqueness of names among installed fonts.

To find a name string and index value for the first font in a name table that matches an ATSUI font ID and the specified font parameters, call the function ATSUFindFontName.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUFindFontFromName (
   const void *iName,
   ByteCount iNameLength,
   FontNameCode iFontNameCode,
   FontPlatformCode iFontNamePlatform,
   FontScriptCode iFontNameScript,
   FontLanguageCode iFontNameLanguage,
   ATSUFontID *oFontID
){};

/*ATSUGetFontVariationNameCode

Obtains the name code for the font variation that matches an ASTUI font ID and font variation axis.

OSStatus ATSUGetFontVariationNameCode (
   ATSUFontID iFont,
   ATSUFontVariationAxis iAxis,
   FontNameCode *oNameCode
);
Parameters
iFont

The ATSUFontID value of the font for which to obtain a font variation name code. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
iAxis

An ATSUFontVariationAxis value representing a valid variation axis tag. To obtain a valid variation axis tag for a font, you can call the functionsATSUGetIndFontVariation or ATSUGetFontInstance. 
oNameCode

A pointer to a FontNameCode value. On return, the value contains the name code for the font variation. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetFontVariationNameCode function obtains the name code for the font variation that matches an ASTUI font ID and font variation axis tag. You can use the function ATSUFindFontName to obtain the localized name string for the name code produced by ATSUGetFontVariationNameCode.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontVariationNameCode (
   ATSUFontID iFont,
   ATSUFontVariationAxis iAxis,
   FontNameCode *oNameCode
){
printf ("ATSUGetFontVariationNameCode",iFont,iAxis,*oNameCode);
};

/*ATSUGetFontVariationValue

Obtains the current value for a font variation axis in a style object.

OSStatus ATSUGetFontVariationValue (
   ATSUStyle iStyle,
   ATSUFontVariationAxis iFontVariationAxis,
   ATSUFontVariationValue *oFontVariationValue
);
Parameters
iStyle

An ATSUStyle value specifying the style object to examine. 
iFontVariationAxis

An ATSUFontVariationAxis tag specifying the style object’s variation axis to examine. You can obtain variation axis tags for a style object from the function ATSUGetAllFontVariations. 
oFontVariationValue

A pointer to memory you have allocated for an ATSUFontVariationValue value. On return, ATSUGetFontVariationValue produces the currently set value for the style object’s specified variation axis. If this value has not been set, ATSUGetFontVariationValue produces the font-defined default value. 
Return Value

A result code. Note that if no value has been set for the specified variation axis, ATSUGetFontVariationValue produces the font-defined default value and returns the result code kATSUNotSetErr. See “ATSUI Result Codes”.
Discussion

The ATSUGetFontVariationValue function obtains the setting for a specified font variation axis in a style object. You might typically call ATSUGetFontVariationValue if you need to obtain one previously set variation axis value after another within your program’s processing loop. To obtain all nondefault font variation axis values for a given style object, you can call the function ATSUGetAllFontVariations.

Before calling ATSUGetFontVariationValue, call the function ATSUGetAllFontVariations to obtain the font variation axes that are set for the style object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontVariationValue (
   ATSUStyle iStyle,
   ATSUFontVariationAxis iFontVariationAxis,
   ATSUFontVariationValue *oFontVariationValue
){
printf ("ATSUGetFontVariationValue",iStyle,iFontVariationAxis,*oFontVariationValue);
};

/*ATSUClearFontFeatures

Restores default settings to the specified font features of a style object.

OSStatus ATSUClearFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
);
Parameters
iStyle

An ATSUStyle value specifying the style object for which to restore default font feature settings. 
iFeatureCount

An ItemCount value specifying the number of font features to restore to default settings. This value should correspond to the number of elements in the iType and iSelector arrays. To restore default settings to all the font features in the specified style object, pass the constant kATSUClearAll in this parameter. In this case, the values in the iType and iSelector parameters are ignored.
iType

A pointer to the initial ATSUFontFeatureType value in an array of feature types. Each value should identify a font feature to restore to its default setting. To obtain all previously set font features for a given style object, you can call the function ATSUGetAllFontFeatures. 
iSelector

A pointer to the initial ATSUFontFeatureSelector value in an array of feature selectors. Each element in the array must contain a valid feature selector corresponding to a font feature you provide in the iType parameter. To obtain all previously set feature selectors for a given style object, you can call the function ATSUGetAllFontFeatures. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUClearFontFeatures function removes those font features that are identified by the feature selector and type constants in the iSelector and iType arrays and replaces them with their font-defined default values. Note that if you pass ATSUClearFontFeatures a font feature and selector that are already at default settings, the function does not return an error.

To restore default font variations to a style object, call the function ATSUClearFontVariations. To restore default style attributes to a style object, call ATSUClearAttributes. To restore all default settings to a style object (for font features, variations, and style attributes), call the function ATSUClearStyle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUClearFontFeatures (
   ATSUStyle iStyle,
   ItemCount iFeatureCount,
   const ATSUFontFeatureType *iType,
   const ATSUFontFeatureSelector *iSelector
){
printf ("ATSUClearFontFeatures",iStyle,iFeatureCount,*iType,*iSelector);
};


/*ATSUGetFontFeatureNameCode

Obtains the name code for a font’s feature type or selector that matches an ASTUI font ID, feature type, and feature selector.

OSStatus ATSUGetFontFeatureNameCode (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ATSUFontFeatureSelector iSelector,
   FontNameCode *oNameCode
);
Parameters
iFont

The ATSUFontID value of the font for which to obtain the name code for a feature type or selector. Note that because Apple Type Services assigns ATSUFontID values systemwide at runtime, font IDs can change across system restarts. 
iType

An ATSUFontFeatureType constant identifying a valid feature type. To obtain the valid feature types for a font, call the function ATSUGetFontFeatureTypes. 
iSelector

An ATSUFontFeatureSelector constant identifying a valid feature selector that corresponds to the feature type passed in the iType parameter. If you pass the constant kATSUNoSelector, the name code produced by ATSUGetFontFeatureNameCode is that of the feature type, not the feature selector. To obtain the valid feature selectors for a font, call the functionATSUGetFontFeatureSelectors. 
oNameCode

A pointer to a FontNameCode value. On return, the value contains the name code for the font feature selector or type. The FontNameCode is a UInt32 data type, and it is defined in the SFNTTypes.h header file.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetFontFeatureNameCode function obtains the name code for a font’s feature type or selector that matches an ASTUI font ID, feature type and feature selector values. By default, ATSUGetFontFeatureNameCode function obtains the name code of a feature selector. To determine the name code of a feature type, pass the constant kATSUNoSelector in the iSelector parameter.

You can use the function ATSUFindFontName to obtain the localized name string for the name code produced by ATSUGetFontFeatureNameCode.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeFonts.h*/
OSStatus ATSUGetFontFeatureNameCode (
   ATSUFontID iFont,
   ATSUFontFeatureType iType,
   ATSUFontFeatureSelector iSelector,
   FontNameCode *oNameCode
){
printf ("ATSUGetFontFeatureNameCode",iFont,iType,iSelector,*oNameCode);
};

