#include <stdio.h>
#include <QD/QD.h>

OSStatus 
ATSUMeasureText(
  ATSUTextLayout         iTextLayout,
  UniCharArrayOffset     iLineStart,
  UniCharCount           iLineLength,
  ATSUTextMeasurement *  oTextBefore,
  ATSUTextMeasurement *  oTextAfter,
  ATSUTextMeasurement *  oAscent,
  ATSUTextMeasurement *  oDescent){
printf ("ATSUMeasureText",iTextLayout,iLineStart,iLineLength,oTextBefore,oTextAfter,oAscent,*oDescent);
};

//work

/*ATSUMeasureTextImage

Obtains the image bounding rectangle for a line of text after final layout.

OSStatus ATSUMeasureTextImage (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   Rect *oTextImageRect
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the line to examine. To indicate that the specified line starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the text range. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd. However, the image bounds is restricted to the line in which iLineOffset resides.
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the line’s origin in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the dimensions of the bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounding rectangle relative to one another, not their actual onscreen position. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the line’s origin in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the dimensions of the bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounding rectangle relative to one another, not their actual onscreen position. 
oTextImageRect

A pointer to a Rect structure. On return, the structure contains the dimensions of the image bounding rectangle for the text, offset by the values specified in the iLocationX and iLocationY parameters. If the line is rotated, the sides of the rectangle are parallel to the coordinate axis.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUMeasureTextImage function obtains the image bounds of a laid-out line of text. These bounds are described by the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs.

In measuring the line, the ATSUMeasureTextImage function takes into account line rotation, alignment, and justification, as well as other characteristics that affect layout, such as hanging punctuation. (If the line is rotated, the sides of the rectangle are parallel to the coordinate axes and encompass the rotated line.) If no attributes are set for the line, ATSUMeasureTextImage uses the global attributes set for the text layout object.

Because the height of the image bounding rectangle is determined by the actual device metrics, ATSUMeasureTextImage ignores any previously set line ascent and descent values for the line it is measuring.

Before calculating the image bounds for the text range, the ATSUMeasureTextImage function examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUMeasureTextImage assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, the ATSUMeasureTextImage function assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUMeasureTextImage assigns the remaining characters to the last style run it finds.

To obtain the final typographic bounds of a line, call the function ATSUGetGlyphBounds. To calculate the unjustified typographic bounds of a line, call the function ATSUGetUnjustifiedBounds.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUMeasureTextImage (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   Rect *oTextImageRect
){};


/*ATSUGetGlyphBounds

Obtains the typographic bounds of a line of glyphs after final layout. 

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iTextBasePointX

An ATSUTextMeasurement value specifying the x-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iTextBasePointY

An ATSUTextMeasurement value specifying the y-coordinate of the origin of the line containing the glyphs in the current graphics port or Quartz graphics context. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to obtain the glyph bounds relative to the current pen location in the current graphics port or graphics context. You can pass 0 to obtain only the dimensions of the bounds relative to one another, not their actual onscreen position. 
iBoundsCharStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the character corresponding to the first glyph to measure. To indicate that the text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. 
iBoundsCharLength

A UniCharCount value specifying the length of the text range to measure. If you want the range to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iTypeOfBounds

A glyph bounds constant indicating whether the width of the resulting typographic glyph bounds is determined using the caret origin (midway between two characters), the glyph origin in device space, or the glyph origin in fractional absolute positions (uncorrected for device display). See “Glyph Origin Selectors” for a description of possible values.
iMaxNumberOfBounds

An ItemCount value specifying the maximum number of bounding trapezoids to obtain. Typically, this is equivalent to the number of bounds in the oGlyphBounds array. To determine this value, see the Discussion. 
oGlyphBounds

A pointer to memory you have allocated for an array of ATSTrapezoid values. On return, the array contains a trapezoid representing the typographic bounds for glyphs in the text range. If the specified range of text encloses nested bidirectional text, ATSUGetGlyphBounds produces multiple trapezoids defining these regions.In ATSUI 1.1, the maximum number of enclosing trapezoids that can be returned is 31; in ATSUI 1.2, the maximum number is 127. If you pass a range that covers an entire line, ATSUGetGlyphBounds returns 1 trapezoid. If you are uncertain of how much memory to allocate for this array, see the Discussion. 
oActualNumberOfBounds

A pointer to an ItemCount value. On return, the value specifies the actual number of enclosing trapezoids bounding the specified characters. This may be greater than the value you provide in the iMaxNumberOfBounds parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

There are two kinds of bounds that your application may typically want to obtain for a block of text: typographic bounds and image bounds. The image bounds define the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs. Because of the potential differences in glyph height in a text block, your application may instead need to determine the typographic bounds. The typographic bounding rectangle contains the extra space above and below the image bounding rectangle where characters with ascenders or descenders would be drawn (even if none currently are).

The ATSUGetGlyphBounds function produces the enclosing trapezoid(s) that represent the typographic bounds for glyphs in a final, laid-out range of text. You typically call this function when you need to obtain an enclosing trapezoid for a line, taking rotation and all other layout attributes into account.

ATSUI determines the height of each trapezoid by examining any line ascent and descent attribute values you may have set for the line. If you have not set these attributes for the line, the ATSUGetGlyphBounds function uses any line ascent and descent values you may have set for the text layout object containing the line. If these are not set, ATSUGetGlyphBounds uses the font’s natural line ascent and descent values for the line. If these are previously set, ATSUGetGlyphBounds uses the ATSUStyle ascent and or descent/leading values.

Depending on the value you pass in the iTypeOfBounds parameter, the width of the resulting trapezoid(s) is determined using one of the following values:
the caret origin, located halfway between two characters, which should be used when performing your own highlighting
the glyph origin in device space, which is useful for obtaining bounds adjusted for specific rendering and device constraints
the glyph origin in fractional (or “ideal”) absolute positions, uncorrected for device display

Note that the coordinates produced for the trapezoid(s) are offset by the amount specified in the iTextBasePointX and iTextBasePointY parameters. If your goal in calling the ATSUGetGlyphBounds function is to obtain metrics for drawing the typographic bounds on the screen, pass the position of the origin of the line in the current graphics port or graphics context in these parameters. This enables ATSUGetGlyphBounds to match the trapezoids to their onscreen image. 

Before calculating the typographic glyph bounds for the given text range, the ATSUGetGlyphBounds function examines the text layout object to make sure that the style runs cover the entire range of text. If there are gaps between style runs, ATSUGetGlyphBounds assigns the characters in the gap to the style run following the gap. If there is no style run at the beginning of the range of text, ATSUGetGlyphBounds assigns these characters to the first style run it can find. If there is no style run at the end of the range of text, ATSUGetGlyphBounds assigns the remaining characters to the last style run it can find.

Typically you use the ATSUGetGlyphBounds function by calling it twice, as follows:
Pass NULL for the oGlyphBounds parameter, 0 for the iMaxNumberOfBounds parameter, and valid values for the other parameters. The ATSUGetGlyphBounds function returns the actual number of trapezoids needed to enclose the glyphs in the oActualNumberOfBounds parameter.
Allocate enough space for a buffer of the returned size, then call the function again, passing a valid pointer to the buffer in the oGlyphBounds parameter. On return, the buffer contains the trapezoids for the glyphs’ typographic bounds. 

To obtain the typographic bounds of a line of text prior to line layout, call the function ATSUGetUnjustifiedBounds. To calculate the image bounding rectangle for a final laid-out line, call the function ATSUMeasureTextImage. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUGetGlyphBounds (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iBoundsCharStart,
   UniCharCount iBoundsCharLength,
   UInt16 iTypeOfBounds,
   ItemCount iMaxNumberOfBounds,
   ATSTrapezoid *oGlyphBounds,
   ItemCount *oActualNumberOfBounds
){};

/*ATSUDrawText

Renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context.

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object for which to render text. 
iLineOffset

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to render. The function ATSUDrawText renders text to the first soft line break it encounters. If the range of text spans multiple lines, you should call ATSUDrawText for each line, passing the offset corresponding to the beginning of the new line to draw with each call. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the text range to render. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd. Keep in mind that the function ATSUDrawText renders text one line at a time. If the range of text spans multiple lines, you must call ATSUDrawText for each line.
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the origin (in either the current QuickDraw graphics port or in a Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the origin (in either the current graphics port or Quartz graphics context) of the line containing the text range to render. Note that the ATSUTextMeasurement type is defined as a Fixed value, so you must ensure that your coordinates are converted to Fixed values before passing them to this function. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUDrawText function renders a range of text at a specified location in a QuickDraw graphics port or Quartz graphics context. This function renders text to the first soft line break it encounters. If you draw into a QuickDraw graphics port you get the best performance by using a bit depth of 16 bits. If you use bit depths of 1, 4, or 8, your application incurs a performance penalty.

You typically call the ATSUDrawText function every time you need to draw or redraw unhighlighted text. To draw highlighted text, call the function ATSUHighlightText.

ATSUDrawText uses the transfer mode and resolution that are set in the graphics port or graphics context. If you explicitly set in the style object, then text color is taken from the style object, and the value in the graphics port/context is ignored. If the text color was not explicitly set in the style object, ATSUDrawText uses the graphics port/context setting.

ATSUDrawText examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUI assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUI assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUI assigns the remaining characters to the last style run it finds.

If you want to draw a range of text that spans multiple lines, you should call ATSUDrawText for each line of text to draw, even if all the lines are in the same text layout object. You should adjust the iLineOffset parameter to reflect the beginning of each line to be drawn.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/

OSStatus ATSUDrawText (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineOffset,
   UniCharCount iLineLength,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY
){};


/*ATSUClearSoftLineBreaks

Removes soft line breaks from a range of text. 

OSStatus ATSUClearSoftLineBreaks (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iRangeStart,
   UniCharCount iRangeLength
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to remove line breaks. 
iRangeStart

A UniCharArrayOffset value specifying the offset from the beginning of the text layout object’s text buffer to the first character of the text range. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iRangeLength parameter. 
iRangeLength

A UniCharCount value specifying the length of the text range. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUClearSoftLineBreaks function clears all previously set soft line breaks for the specified text range and clears any associated layout caches as well.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUClearSoftLineBreaks (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iRangeStart,
   UniCharCount iRangeLength
){
printf ("ATSUClearSoftLineBreaks",iTextLayout,iRangeStart,iRangeLength);
};


/*ATSUHighlightText

Renders a highlighted range of text at a specified location in a QuickDraw graphics port or Quartz graphics context.

OSStatus ATSUHighlightText (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iHighlightStart,
   UniCharCount iHighlightLength
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object for which to render highlighted text. 
iTextBasePointX

An ATSUTextMeasurement value specifying the x-coordinate of the origin (in either the current graphics port or in a Quartz graphics context) of the line containing the text range to highlight. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
iTextBasePointY

An ATSUTextMeasurement value specifying the y-coordinate of the origin (in either the current graphics port or graphics context) of the line containing the text range to highlight. Pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, to draw relative to the current pen location in the current graphics port. 
iHighlightStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the range to highlight. If the range of text spans multiple lines, you should call ATSUHighlightText for each line, passing the offset corresponding to the beginning of the new line to draw with each call. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iHighlightLength parameter. 
iHighlightLength

A UniCharCount value specifying the length of the text range to highlight. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When the user selects a series of glyphs, the characters in memory corresponding to the glyphs make up the selection range and should be highlighted to indicate where the next editing operation is to occur. The characters in a selection range are always contiguous in memory, but their corresponding glyphs are not necessarily so onscreen. If the selection range crosses a direction boundary, it is appropriate to display discontinuous highlighting.

The ATSUHighlightText function renders a highlighted range of text at a specified location in a QuickDraw graphics port or Quartz graphics context, using the highlight information in the graphics port or context. ATSUHighlightText automatically produces discontinuous highlighting, if needed. You typically call the ATSUHighlightText function every time you need to draw or redraw highlighted text.

If you pass your own CGContextRef (created by calling the function QDBeginCGContext) to an ATSUTextLayout, highlighting by calling the function ATSUHighlightText will not work unless you first call the function ATSUSetHighlightingMethod with the iMethod parameter set to kRedrawHighlighting and a pointer to an ATSUUnhighlightData structure as the iUnhighlightData parameter. 

Before drawing the highlighted text, ATSUHighlightText examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUI assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUI assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUI assigns the remaining characters to the last style run it finds.

ATSUHighlightText uses the previously set line ascent and descent values to calculate the height of the highlighted region. If these values have not been set for the line, ATSUHighlightText uses the line ascent and descent values set for the text layout object containing the line. If these are not set, it uses the default values.

To draw a highlighted text range that spans multiple lines, you should call ATSUHighlightText for each line of the text range, even if all the lines are in the same text layout object. You should adjust the iHighlightStart parameter to reflect the beginning of each line to be drawn.

After calling ATSUHighlightText, to properly redraw the unhighlighted text and background, you should always call the function ATSUUnhighlightText.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUHighlightText (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iTextBasePointX,
   ATSUTextMeasurement iTextBasePointY,
   UniCharArrayOffset iHighlightStart,
   UniCharCount iHighlightLength
){
printf ("ATSUHighlightText",iTextLayout,iTextBasePointX, iTextBasePointY,iHighlightStart,iHighlightLength);
};

/*ATSUPositionToOffset

Obtains the memory offset for the glyph edge nearest a mouse-down event.

OSStatus ATSUPositionToOffset (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   UniCharArrayOffset *ioPrimaryOffset,
   Boolean *oIsLeading,
   UniCharArrayOffset *oSecondaryOffset
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object in which the mouse-down event occurred. 
iLocationX

An ATSUTextMeasurement value specifying the x-coordinate of the event, in local coordinates, relative to the origin of the line where the event occurred. That is, to specify the x-coordinate value, you should subtract the x-coordinate of the line origin from the x-coordinate of the hit point (in local coordinates). You can pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the location of the mouse-down event relative to the current pen location in the current graphics port. 
iLocationY

An ATSUTextMeasurement value specifying the y-coordinate of the event, in local coordinates, relative to the origin of the line where the event occurred. That is, to specify the y-coordinate value, you should subtract the y-coordinate of the line origin from the y-coordinate of the hit point (in local coordinates). You can pass the constant kATSUUseGrafPortPenLoc, described in “Convenience Constants”, for the location of the mouse-down event relative to the current pen location in the current graphics port. 
ioPrimaryOffset

A pointer to a UniCharArrayOffset value specifying the offset corresponding to the beginning of the line where the event occurred. On return, the value specifies the offset corresponding to the glyph edge that is visually closest to the event. To determine whether this offset indicates the leading or trailing edge of the glyph, you can examine the value produced in the oIsLeading parameter. 
oIsLeading

A pointer to a Boolean value. On return, the value indicates whether the offset produced in the ioPrimaryOffset parameter is leading or trailing. The function ATSUPositionToOffset produces a value of true if the offset is leading (that is, more closely associated with the subsequent character in memory). It produces a value of false if the offset is trailing (that is, more closely associated with the preceding character in memory).
oSecondaryOffset

A pointer to a UniCharArrayOffset value. On return, the value typically specifies the same offset as that produced in the ioPrimaryOffset parameter, unless the event occurred within a glyph cluster or at a line direction boundary. If so, the value specifies a secondary offset. The secondary offset is associated with the glyph that has a different direction from the primary line direction. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The process of hit-testing text obtains the location of a mouse-down event relative both to the position of onscreen glyphs and to the corresponding offset between character codes in memory. You can then use the location information obtained by hit-testing to set the insertion point (that is, the caret) or selection range (for highlighting).

Hit-testing text is complicated by the fact that a given line of text may be bidirectional. Therefore, the onscreen order of glyphs may not readily correspond to the storage order of the corresponding character codes. And the concept of which glyph comes “first” in a line of text cannot always be limited to the visual terms “left” and “right.” Because of these complexities, it is more accurate to speak in terms of “leading” and “trailing” edges to glyphs. A “leading edge” is defined as the edge of a glyph that you first encounter when you read the text that includes that glyph. For example, when reading Roman text, you first encounter the left edge of a Roman glyph. Similarly, the “trailing edge” is defined as the edge of the glyph encountered last.

ATSUI can translate the location of a mouse click into an onscreen position, as well as to a memory offset. When you use ATSUI for hit-testing, ATSUI takes into account the glyph edge (whether leading or trailing) nearest to where the click occurred, thus providing positional information in complex situations, such as at line direction boundaries or within glyph clusters.

The first step in obtaining the caret position(s) for a mouse-down event is to pass the location (in local coordinates, relative to the line origin) of the event to the function ATSUPositionToOffset. For example, if you have a mouse-down event whose position in local coordinates is (75,50), you would subtract this value from the position of the origin of the line in the current graphics port. If the position of the origin of the line in the current graphics port is (50,50), then the relative position of the event that you would pass in the iLocationX and iLocationY parameters is (25,0).

The ATSUPositionToOffset function produces the memory offset corresponding to the glyph edge nearest the event. If the mouse-down event occurs at a line direction boundary or within a glyph cluster, ATSUPositionToOffset produces two offsets. You can then provide the offset(s) to the ATSUOffsetToPosition function, to obtain the actual caret position(s) for the event.

When you call the ATSUPositionToOffset function, ATSUI examines the Unicode directionality of the character corresponding to the event location. The ATSUPositionToOffset function produces a value of true in the oIsLeading parameter if the offset is leading (that is, more closely associated with the subsequent character in memory and therefore indicative of a left-to-right line direction). It produces a value of false if the offset is trailing (that is, more closely associated with the preceding character in memory and indicative of a right-to-left line direction).

Finally, note that when the event occurs beyond the leftmost or rightmost caret positions of the line (not taking into account line rotation), such that no glyph corresponds to the location of the hit, the ATSUPositionToOffset function produces the primary offset of the closest edge of the line to the input location. The oIsLeading flag depends on the directionality of the closest glyph and the side of the line to which the input location is closest. In this case, the secondary offset is equal to the primary offset, since no glyph was hit.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUPositionToOffset (
   ATSUTextLayout iTextLayout,
   ATSUTextMeasurement iLocationX,
   ATSUTextMeasurement iLocationY,
   UniCharArrayOffset *ioPrimaryOffset,
   Boolean *oIsLeading,
   UniCharArrayOffset *oSecondaryOffset
){
printf ("ATSUPositionToOffset",iTextLayout,iLocationX,iLocationY,*ioPrimaryOffset,*oIsLeading,*oSecondaryOffset);
};

/*ATSUSetHighlightingMethod

Sets the method ATSUI uses to highlight and unhighlight text for a text layout object.

OSStatus ATSUSetHighlightingMethod (
   ATSUTextLayout iTextLayout,
   ATSUHighlightMethod iMethod,
   const ATSUUnhighlightData *iUnhighlightData
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object for which to set the highlighting method. 
iMethod

An ATSUHighlightMethod value specifying the type of highlighting for ATSUI to use (kInvertHighlighting or kRedrawHighlighting). The default highlighting method, if you do not call ATSUSetHighlightingMethod, is inversion. See “Highlight Methods” for a description of available values.
iUnhighlightData

A pointer to an ATSUUnhighlightData structure if you are setting the iMethod parameter to kRedrawHighlighting or NULL if setting iMethod to kInvertHighlighting. Before calling ATSUSetHighlightingMethod, you should set the ATSUUnhighlightData structure to contain the data needed (either a color or a UPP for a background drawing callback) to redraw the background. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

In Mac OS 9 and by default in Mac OS X (except with Cocoa applications—see below), ATSUI highlights text by “inverting” the region containing the text, that is, its background color. Although inversion provides satisfactory highlighting in most cases, it does not always provide the best result for grayscale text. (Mac OS X sets a lower threshold for antialiasing, while in Mac OS 9 grayscale text can be turned off by the user.)

In Mac OS X, when using a Quartz graphics context, you can instruct ATSUI to use the redraw method of highlighting, rather than simple inversion. (Note that Cocoa applications always use the redraw method of highlighting.) The redraw method allows for accurate highlighting of more complex backgrounds, such as those containing multiple colors, patterns, or pictures. To set redrawing on, call the ATSUSetHighlightingMethod function and specify that the redraw method be used (by passing kRedrawHighlighting in the iMethod parameter).

If you specify the redraw method of highlighting when you call ATSUSetHighlightingMethod, then you must also specify how the background is to be redrawn when the function ATSUUnhighlightText is called. ATSUI can restore the desired background in one of two ways, depending on the background’s complexity:
When the background is a single color (such as white), ATSUI can readily unhighlight the background. In such a case, you specify the background color that ATSUI uses by calling ATSUSetHighlightingMethod and setting iUnhighlightData.dataType to kATSUBackgroundColor and providing the background color in iUnhighlightData.unhighlightData. With these settings defined, when you call ATSUUnhighlightText, ATSUI simply calculates the previously highlighted area, repaints it with the specified background color, and then redraws the text.
When the background is more complex (containing, for example, multiple colors, patterns, or pictures), you must provide a redraw background callback function when you call ATSUSetHighlightingMethod. You do this by setting iUnhighlightData.dataType to kATSUBackgroundCallback and providing a RedrawBackgroundUPP in iUnhighlightData.unhighlightData. Then when you call ATSUUnhighlightText and ATSUI calls your callback, you are responsible for redrawing the background of the unhighlighted area. If you choose to also redraw the text, then your callback should return false as a function result. If your callback returns true ATSUI redraws any text that needs to be redrawn. See RedrawBackgroundProcPtr for additional information.
Version Notes

Mac OS 9 applications cannot use the redraw method of highlighting and must use the inversion method, instead.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUSetHighlightingMethod (
   ATSUTextLayout iTextLayout,
   ATSUHighlightMethod iMethod,
   const ATSUUnhighlightData *iUnhighlightData
){
printf ("ATSUSetHighlightingMethod",iTextLayout,iMethod,*iUnhighlightData);
};
/*ATSUBreakLine

Calculates and, optionally, sets a soft line break in a range of text.

OSStatus ATSUBreakLine (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   ATSUTextMeasurement iLineWidth,
   Boolean iUseAsSoftLineBreak,
   UniCharArrayOffset *oLineBreak
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineStart

A UniCharArrayOffset value specifying the offset from the beginning of the text layout object’s text buffer to the first character of the text range to examine. To specify the beginning of the text buffer, pass the constant kATSUFromTextBeginning. When calling ATSUBreakLine repeatedly to obtain all the soft line breaks for a given text range, in each subsequent call pass the value produced in the oLineBreak parameter by the immediately prior call to ATSUBreakLine. 
iLineWidth

An ATSUTextMeasurement value specifying the line width for the text, as measured from the offset provided in the iLineStart parameter. You must pass a nonzero value. You can pass kATSUUseLineControlWidth to indicate that ATSUBreakLine should use the previously set line width attribute for the current line to determine how many characters can fit on the line. If no line width has been set for the line, ATSUBreakLine uses the line width set for the text layout object; if this value is not set, ATSUBreakLine returns paramErr. 

Note that the value you pass for the iLineWidth parameter is used only for the line-breaking operation. For justification, flushness, and other operations to work properly you must also use this value as the line width for the text layout object. You can set the line width for the text layout object by calling the function ATSUSetLineControls or ATSUSetLayoutControls with the kATSULineWidthTag and the line width value.
iUseAsSoftLineBreak

A Boolean value indicating whether ATSUBreakLine should automatically set the line break produced in the oLineBreak parameter. If true, ATSUBreakLine sets the line break and clears any previously-set soft line breaks that precede the new break in the line but lie after the offset specified by iLineStart.
oLineBreak

A pointer to a UniCharArrayOffset value. On return, the value specifies the offset from the beginning of the text layout object’s text buffer to the location of the calculated soft line break. If the value produced is the same value as specified in iLineStart, you have made an input parameter error. In this case, check to make sure that the line width specified in iLineWidth is big enough for ATSUBreakLine to perform line breaking. ATSUBreakLine does not return an error in this case. ATSUI usually calculates a soft line break to be at the beginning of the first word that does not fit on the line. But if ATSUBreakLine calculates the most optimal line break to be in the middle of a word, it returns the result code kATSULineBreakInWord. Note that ATSUI produces a line break in the middle of a word only as a last resort. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

When the user inserts or deletes text or changes text layout attributes that affect how glyphs are laid out, you must determine whether the affected range of text still fits in the set line width, that is, whether the text needs to be rewrapped. You can use the ATSUBreakLine function to calculate a soft line break, based on the line width and text range you specify. If you pass true for iUseAsSoftLineBreak, ATSUBreakLine sets the soft line break it calculates and performs line layout on the characters.

If you need to calculate and set soft line breaks for a range of text and you want to use the same width for all lines in this range, you should call the function ATSUBatchBreakLines. Calling ATSUBatchBreakLines is equivalent to repeatedly calling the ATSUBreakLine function with the parameter iUseAsSoftLineBreak set to true. However, the ATSUBatchBreakLines function performs more efficiently than repeated calls to the ATSUBreakLine function.

If you do choose to call the ATSUBreakLine function repeatedly to obtain all possible line breaks for a range of text it will produce the previously set soft line break(s) if there are no additional line breaks to be found, or if the user has altered the text range or its attributes in a way that does not affect glyph layout.

The ATSUBreakLine function suggests a soft line break each time it encounters a hard line break character such as a carriage return, line feed, form feed, line separator, or paragraph separator. If ATSUBreakLine does not encounter a hard line break, it uses the line width you specify to determine how many characters fit on a line and suggests soft line breaks accordingly.

If you pass true for iUseAsSoftLineBreak, ATSUBreakLine uses the soft line break it calculates to perform line layout on the characters. ATSUBreakLine then determines whether the characters still fit within the line, which is necessary due to end-of-line effects such as swashes. When ATSUBreakLine sets a soft line break, it clears any previously-set soft line breaks that precede the new break in the line but lie after the offset specified by iLineStart.

Before calculating soft line breaks, ATSUBreakLine turns off any previously set line justification, rotation, width, alignment, descent, and ascent values and treats the text as a single line. Additionally, ATSUBreakLine examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUBreakLine assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUBreakLine assigns these characters to the first style run it finds. If there no style run at the end of the text range, ATSUBreakLine assigns the remaining characters to the last style run it finds.

For optimal performance, you should use ATSUBreakLine or ATSUBatchBreakLines to both calculate and set soft line breaks in your text. You should typically only call the function ATSUSetSoftLineBreak to set soft line breaks when you are using your own line-breaking algorithm to calculate soft line breaks.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUBreakLine (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   ATSUTextMeasurement iLineWidth,
   Boolean iUseAsSoftLineBreak,
   UniCharArrayOffset *oLineBreak
){
printf ("ATSUBreakLine",iTextLayout,iLineStart,iLineWidth,iUseAsSoftLineBreak,*oLineBreak);
};

/*ATSUNextCursorPosition

Obtains the memory offset for the insertion point that follows the current insertion point in storage order, as determined by a move of the specified length.

OSStatus ATSUNextCursorPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOldOffset,
   ATSUCursorMovementType iMovementType,
   UniCharArrayOffset *oNewOffset
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object to examine. 
iOldOffset

A UniCharArrayOffset value specifying the memory offset corresponding to the current caret position. To specify the beginning of the text buffer, pass the constant kATSUFromTextBeginning. 
iMovementType

An ATSUCursorMovementType constant identifying the unit of movement. See “Caret Movement Types” for a description of possible values (which range from a single Unicode character to a Unicode word in length). Note that ATSUI may not be able to move the caret by a single Unicode character in some cases, since doing so might place the insertion point in the middle of a surrogate pair.
oNewOffset

A pointer to a UniCharArrayOffset value. On return, the value provides the memory offset corresponding to the following insertion point. This offset may be outside the initial text buffer. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUNextCursorPosition function obtains the memory offset for the insertion point that follows the current insertion point in storage order, as determined by a move of the specified length.

You should use the ATSUNextCursorPosition function or the function ATSUPreviousCursorPosition to determine caret position when the initial memory offset is not at a line direction boundary. If the initial offset is at a line direction boundary, you should instead use the functions ATSURightwardCursorPosition or ATSULeftwardCursorPosition.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUNextCursorPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOldOffset,
   ATSUCursorMovementType iMovementType,
   UniCharArrayOffset *oNewOffset
){
printf ("ATSUNextCursorPosition",iTextLayout,iOldOffset,iMovementType,*oNewOffset);
};



/*ATSUPreviousCursorPosition

Obtains the memory offset for the insertion point that precedes the current insertion point in storage order, as determined by a move of the specified length.

OSStatus ATSUPreviousCursorPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOldOffset,
   ATSUCursorMovementType iMovementType,
   UniCharArrayOffset *oNewOffset
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object to examine. 
iOldOffset

A UniCharArrayOffset value specifying the memory offset corresponding to the current caret position. To specify the beginning of the text buffer, pass the constant kATSUFromTextBeginning, 
iMovementType

An ATSUCursorMovementType constant identifying the unit of movement. See “Caret Movement Types” for a description of possible values (which range from a single Unicode character to a Unicode word in length). Note that ATSUI may not be able to move the caret by a single Unicode character in some cases, since doing so might place the insertion point in the middle of a surrogate pair.
oNewOffset

A pointer to a UniCharArrayOffset value. On return, the value provides the memory offset corresponding to the preceding insertion point. This offset may be outside the initial text buffer. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUPreviousCursorPosition function obtains the memory offset for the insertion point that precedes the current insertion point in storage order, as determined by a move of the specified length.

You should use the ATSUPreviousCursorPosition function or the function ATSUNextCursorPosition to determine caret position when the initial offset is not at a line direction boundary. If the initial offset is at a line direction boundary, you should instead use the functions ATSURightwardCursorPosition or ATSULeftwardCursorPosition.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUPreviousCursorPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOldOffset,
   ATSUCursorMovementType iMovementType,
   UniCharArrayOffset *oNewOffset
){
printf ("ATSUPreviousCursorPosition",iTextLayout,iOldOffset,iMovementType,*oNewOffset);
};

/*ATSUGetUnjustifiedBounds

Obtains the typographic bounding rectangle for a line of text prior to final layout. 

OSStatus ATSUGetUnjustifiedBounds (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ATSUTextMeasurement *oTextBefore,
   ATSUTextMeasurement *oTextAfter,
   ATSUTextMeasurement *oAscent,
   ATSUTextMeasurement *oDescent
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the line. To indicate that the line starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the line. If you want the line to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
oTextBefore

A pointer to an ATSUTextMeasurement value. On return, the value specifies the starting point of the typographic bounds for the line, relative to the origin (0,0) of the line and taking into account cross-stream shifting. Note that the ATSUMeasureText function might produce negative values for the typographic starting point of the line if, for example, the initial character of the line is allowed to hang into the margin. For horizontal text, this value corresponds to the left side of the bounding rectangle. 
oTextAfter

A pointer to an ATSUTextMeasurement value. On return, the value specifies the end point of the typographic bounds for the line, relative to the origin (0,0) of the line and taking into account cross-stream shifting. For horizontal text, this value corresponds to the right side of the bounding rectangle. 
oAscent

A pointer to an ATSUTextMeasurement value. On return, the value specifies the ascent of the typographic bounds for the line, relative to the origin (0,0) of the line and taking into account cross-stream shifting. For horizontal text, this value corresponds to the top side of the bounding rectangle. 
oDescent

A pointer to an ATSUTextMeasurement value. On return, the value specifies the descent of the typographic bounds for the line, relative to the origin (0,0) of the line and taking into account cross-stream shifting. For horizontal text, this value corresponds to the bottom side of the bounding rectangle. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

There are two kinds of bounds that your application may typically want to obtain for a block of text: typographic bounds and image bounds. The image bounds define the smallest rectangle that completely encloses the filled or framed parts of a block of text—that is, the text’s “inked” glyphs. Because of the potential differences in glyph height in a text block, your application may instead need to determine the typographic bounds. The typographic bounding rectangle contains the extra space above and below the image bounding rectangle where characters with ascenders or descenders would be drawn (even if none currently are).

The ATSUGetUnjustifiedBounds function calculates the typographic bounds (in coordinates independent of the rendering device) for a line of text. Note that ATSUGetUnjustifiedBounds calculates these bounds prior to the text’s final layout, and therefore, the calculated bounds might not reflect those of the final laid-out line. To obtain the typographic bounds of a line after it is laid out, you can call the function ATSUGetGlyphBounds.

The ATSUGetUnjustifiedBounds function ignores any previously set line attributes such as line rotation, flushness, justification, ascent, and descent in its calculations. You typically only call ATSUGetUnjustifiedBounds when you need to find out what the width of a line is without these attributes, such as for determining your own line breaks or the leading and line spacing to impose on a line. 

The ATSUGetUnjustifiedBounds function treats the specified text range as a single line. That is, if the range of text you specify is less than a line, it nevertheless treats the initial character in the range as the start of a line, for measuring purposes. If the range of text extends beyond a line, ATSUGetUnjustifiedBounds ignores soft line breaks, again, treating the text as a single line.

Before calculating the typographic bounds for the text range, the ATSUGetUnjustifiedBounds function examines the text layout object to ensure that each of the characters in the range is assigned to a style run. If there are gaps between style runs, ATSUGetUnjustifiedBounds assigns the characters in the gap to the style run that precedes (in storage order) the gap. If there is no style run at the beginning of the text range, ATSUGetUnjustifiedBounds assigns these characters to the first style run it finds. If there is no style run at the end of the text range, ATSUGetUnjustifiedBounds assigns the remaining characters to the last style run it finds.

To obtain the image bounding rectangle of a laid-out line, call the function ATSUMeasureTextImage.
Version Notes

As of ASTUI version 2.4, this function replaces the ATSUMeasureText function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUGetUnjustifiedBounds (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ATSUTextMeasurement *oTextBefore,
   ATSUTextMeasurement *oTextAfter,
   ATSUTextMeasurement *oAscent,
   ATSUTextMeasurement *oDescent
){
printf ("ATSUGetUnjustifiedBounds",iTextLayout,iLineStart,iLineLength,*oTextBefore,*oTextAfter,*oAscent,*oDescent);
};


/*ATSUGetSoftLineBreaks

Obtains soft line breaks in a range of text. 

OSStatus ATSUGetSoftLineBreaks (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iRangeStart,
   UniCharCount iRangeLength,
   ItemCount iMaximumBreaks,
   UniCharArrayOffset *oBreaks,
   ItemCount *oBreakCount
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iRangeStart

A UniCharArrayOffset value specifying the offset from the beginning of the text layout object’s text buffer to the first character of the text range to examine. To indicate that the specified text range starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning, To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iRangeLength parameter. 
iRangeLength

A UniCharCount value specifying the length of the text range. If you want the range of text to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
iMaximumBreaks

An ItemCount value specifying the maximum number of soft line breaks to obtain. Typically, this is equivalent to the number of UniCharArrayOffset values for which you have allocated memory in the oBreaks array. To determine this value, see the Discussion.
oBreaks

A pointer to memory you have allocated for an array of UniCharArrayOffset values. On return, the array contains offsets from the beginning of the text buffer to each of the soft line breaks in the text range. If you are uncertain of how much memory to allocate for this array, see the Discussion. 
oBreakCount

A pointer to an ItemCount value. On return, the value specifies the actual number of soft line breaks in the range of text. This may be greater than the value you specified in the iMaximumBreaks parameter.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetSoftLineBreaks function obtains the soft line breaks that are currently set in a given text range.

Typically you use the function ATSUGetSoftLineBreaks by calling it twice, as follows:
Pass valid values for the iTextLayout, iRangeStart, iRangeLength, and oBreakCount parameters. Pass NULL for the oBreaks parameter and 0 for the iMaximumBreaks parameter. On return, the value of the oBreakCount parameter specifies the number of items in the offset array. 
Allocate enough space for an array of the appropriate size (number of items in the array multiplied by 4 bytes per item), then call the function again, passing a valid pointer in the oBreaks parameter. On return, the pointer refers to an array containing the text range’s soft line breaks.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUGetSoftLineBreaks (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iRangeStart,
   UniCharCount iRangeLength,
   ItemCount iMaximumBreaks,
   UniCharArrayOffset *oBreaks,
   ItemCount *oBreakCount
){
printf ("ATSUGetSoftLineBreaks",iTextLayout,iRangeStart,iRangeLength,iMaximumBreaks,*oBreaks,*oBreakCount);
};
/*ATSUOffsetToPosition

Obtains the caret position(s) corresponding to a memory offset.

OSStatus ATSUOffsetToPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOffset,
   Boolean iIsLeading,
   ATSUCaret *oMainCaret,
   ATSUCaret *oSecondCaret,
   Boolean *oCaretIsSplit
);
Parameters
iTextLayout

An ATSUTextLayout value identifying the text layout object to examine. 
iOffset

A UniCharArrayOffset value specifying the memory offset for which to obtain the corresponding caret position. To respond to a mouse-down event, pass the offset produced in the ioPrimaryOffset parameter of the function ATSUPositionToOffset—that is, the offset corresponding to the glyph edge closest to the event. 
iIsLeading

A Boolean value indicating whether the offset corresponds to the leading or trailing edge of the glyph. You can obtain this information from the function ATSUPositionToOffset. This value is relevant if the offset occurs at a line direction boundary or within a glyph cluster.
oMainCaret

A pointer to an ATSUCaret structure. On return, the structure contains the starting and ending pen locations of the high caret if the value produced in oCaretIsSplit is true. If the value is false, the structure contains the starting and ending pen locations of the main caret. 
oSecondCaret

A pointer to an ATSUCaret structure. On return, the structure contains the starting and ending pen locations of the low caret if the value passed back in the oCaretIsSplit parameter is true. If the value is false, the structure contains the starting and ending pen locations of the main caret (that is, the same values as the oMainCaret parameter). 
oCaretIsSplit

A pointer to a Boolean value. On return, the value indicates whether the offset specified in the iOffset parameter occurs at a line direction boundary. If true, the offset occurs at a line direction boundary; otherwise, false.
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The process of hit-testing text obtains the location of a mouse-down event relative both to the position of onscreen glyphs and to the corresponding offset between character codes in memory. You can then use the location information obtained by hit-testing to set the insertion point (that is, the caret) or selection range (for highlighting).

Hit-testing text is complicated by the fact that a given line of text may be bidirectional. Therefore, the onscreen order of glyphs may not readily correspond to the storage order of the corresponding character codes. And the concept of which glyph comes “first” in a line of text cannot always be limited to the visual terms “left” and “right.” Because of these complexities, it is more accurate to speak in terms of “leading” and “trailing” edges to glyphs. A “leading edge” is defined as the edge of a glyph that you first encounter when you read the text that includes that glyph. For example, when reading Roman text, you first encounter the left edge of a Roman glyph. Similarly, the “trailing edge” is defined as the edge of the glyph encountered last.

ATSUI can translate the location of a mouse click into an onscreen position, as well as to a memory offset. When you use ATSUI for hit-testing, ATSUI takes into account the glyph edge (whether leading or trailing) nearest to where the click occurred, thus providing positional information in complex situations, such as at line direction boundaries or within glyph clusters.

Line direction boundaries can occur on the trailing edges of two glyphs, the leading edges of two glyphs, or at the beginning or end of a text segment. At direction boundaries, a single insertion point in memory can require two caret positions onscreen, one for text entry in each direction. The two separate carets (known as a split caret or a dual caret) consist of a high caret and a low caret. The high (primary) caret is displayed at the caret position for inserting text whose direction corresponds to the line direction (the dominant direction for the overall line of text). The low (secondary) caret is displayed at the caret position for inserting text whose direction is counter to the overall line direction.

The first step in obtaining the caret position(s) for a mouse-down event is to pass the location (in local coordinates, relative to the line origin) of the event to the function ATSUPositionToOffset. The ATSUPositionToOffset function produces the memory offset corresponding to the glyph edge nearest the event. If the mouse-down event occurs at a line direction boundary or within a glyph cluster, the ATSUPositionToOffset function produces two offsets. You can then provide the offset(s) to the ATSUOffsetToPosition function, to obtain the actual caret position(s) for the event.

The ATSUOffsetToPosition function produces two structures of type ATSUCaret. These structures contain the pen positioning information needed to draw the caret(s) for the event, specified relative to the origin of the line in the current graphics port or graphics context. Specifically, the ATSUCaret structures contain x-y coordinates for both the caret’s starting and ending pen positions (the latter taking into account line rotation, caret slanting, and split-caret appearances).

If the memory offset you pass to ATSUOffsetToPosition is at a line boundary, the structure produced in the oMainCaret parameter contains the starting and ending pen locations for the high caret, while the oSecondCaret parameter contains the corresponding values for the low caret. If the offset is not at a line boundary, both parameters contain the starting and ending pen locations of the main caret.

Because you provide the ATSUOffsetToPosition function an offset relative to the origin of the line where the hit occurred, ATSUOffsetToPosition produces positioning information that is also relative. Therefore, you must transform the positions produced by the ATSUOffsetToPosition function before drawing the caret(s). To transform the caret location(s), add the starting and ending caret coordinates to the coordinates of the origin of the line in which the hit occurred. For example, if ATSUOffsetToPosition produces starting and ending pen locations of (25,0), (25,25) in the oMainCaret parameter (and the oSecondCaret parameter contains the same coordinates, meaning that the caret was not split), you would add these to the position of the origin of the line in the graphics port or context. If the position of the line origin was at (50,50), then the starting and ending pen locations of the caret would be (75,50), (75,75).
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUOffsetToPosition (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iOffset,
   Boolean iIsLeading,
   ATSUCaret *oMainCaret,
   ATSUCaret *oSecondCaret,
   Boolean *oCaretIsSplit
){
printf ("ATSUOffsetToPosition",iTextLayout,iOffset,iIsLeading,*oMainCaret,*oSecondCaret,*oCaretIsSplit);
};

/*ATSUSetSoftLineBreak

Sets a soft line break that you specify.

OSStatus ATSUSetSoftLineBreak (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineBreak
);
Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object for which to set a line break. 
iLineBreak

A UniCharArrayOffset value specifying the offset from the beginning of the text layout object’s text buffer to the line break to set. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUSetSoftLineBreak function enables you to set a soft line break in a text range. You should typically only call ATSUSetSoftLineBreak to set line breaks when you are using your own line-breaking algorithm to calculate these breaks. For optimal performance, you should use ATSUBatchBreakLines to both calculate and set soft line breaks in your text.

After calling ATSUSetSoftLineBreak, you should call the function ATSUGetUnjustifiedBounds to determine whether the characters still fit within the line, which is necessary due to end-of-line effects such as swashes.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeDrawing.h*/
OSStatus ATSUSetSoftLineBreak (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineBreak
){};



