#import <PDFKit/PDFAnnotation.h>
//work
@implementation PDFAnnotation

/*type

Gets the type of the annotation.

- (NSString *)type
Discussion

Types include Line, Link, Text, and so on, referring to the PDFAnnotation subclasses. In the Adobe PDF Specification, this attribute is called Subtype, and the common “type” for all annotations in the PDF Specification is Annot.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSString *)type{}


/*bounds

Gets the bounding box for the annotation in page space.

- (NSRect)bounds
Discussion

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setBounds:*/
- (NSRect)bounds{}


/*page

Gets the page that the annotation is associated with.

- (PDFPage *)page
Discussion

The addAnnotation: method in the PDFPage class lets you associate an annotation with a page.
Availability
Available in Mac OS X v10.4 and later.*/
- (PDFPage *)page{}

/*initWithBounds:

Initializer for use by subclasses of PDFAnnotation.

- (id)initWithBounds:(NSRect)bounds
Discussion

Provide bounds in page space. Invoking initWithBounds directly on a PDFAnnotation object creates an illegal NULL type.

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.*/

- (id)initWithBounds:(NSRect)bounds{}


/*setBounds:

Specifies the bounding box for the annotation.

- (void)setBounds:(NSRect)bounds
Discussion

Use page space for bounds. The bounds attribute is required for all annotations.

Page space is a 72 dpi coordinate system with the origin at the lower-left corner of the current page.
Availability
Available in Mac OS X v10.4 and later.
See Also
– bounds*/
- (void)setBounds:(NSRect)bounds{}

@end

