#include <Metadata/Metadata.h>


/*kMDQueryDidUpdateNotification

Indicates that a query’s results list has change during the live-update phase of a query.

const CFStringRef kMDQueryDidUpdateNotification;
Constants
kMDQueryDidUpdateNotification

Notification posted to indicate that a change has occured to the query’s resuls list during the live-update phase of a query’s execution.

Available in Mac OS X v10.4 and later.
Discussion

The info dictionary of the notification can contain kMDQueryUpdateAddedItems, kMDQueryUpdateChangedItems, and kMDQueryUpdateRemovedItems keys. 

This notification is only sent to the application’s notification center.*/
const CFStringRef kMDQueryDidUpdateNotification;



/*Query Search Scope Keys

Specify the scope of a query’s search.

const CFStringRef kMDQueryScopeHome;
const CFStringRef kMDQueryScopeComputer;
const CFStringRef kMDQueryScopeNetwork;
Constants
kMDQueryScopeHome

Specifies that the query should be restricted to the volume and directory that contains the current user’s home directory.

Available in Mac OS X v10.4 and later.
kMDQueryScopeComputer

Specifies that the query should be restricted to all locally mounted volumes, plus the user’s home directory (which may be on a remote volume).

Available in Mac OS X v10.4 and later.
kMDQueryScopeNetwork

Specifies that the query should include all user mounted remote volumes.

Available in Mac OS X v10.4 and later.
Discussion

These constants can be passed in the scopeDirectories array to the function MDQuerySetSearchScope.*/
const CFStringRef kMDQueryScopeHome;
const CFStringRef kMDQueryScopeComputer;
const CFStringRef kMDQueryScopeNetwork;

/*kMDQueryProgressNotification

Indicates that a query’s results list has change during the initial result-gathering phase of a query.

const CFStringRef kMDQueryProgressNotification;
Constants
kMDQueryProgressNotification

Notification posted to indicate that a change has occurred to the query’s results list during the initial result-gathering phase of execution.

Available in Mac OS X v10.4 and later.
Discussion

New items are typically added during this phase, however it is possible for items to be removed or updated, if the original file is changed. The info dictionary of the notification can contain kMDQueryUpdateChangedItems and kMDQueryUpdateRemovedItems keys.

For performance reasons added results are not indicated in progress notifications, to avoid the cost of creating the result objects.

This notification is only sent to the application’s notification center.*/
const CFStringRef kMDQueryProgressNotification;

/*kMDQueryDidFinishNotification

Indicates that a query has finished with the initial result-gathering phase.

const CFStringRef kMDQueryDidFinishNotification;
Constants
kMDQueryDidFinishNotification

Posted to indicate that the query has finished the initial result-gathering phase. 

Available in Mac OS X v10.4 and later.
Discussion

The query results list is not updated as a result of this notification.

This notification is only sent to the application’s notification center.*/
const CFStringRef kMDQueryDidFinishNotification;


//work

/*MDQueryCreate

Creates a new query instance.

MDQueryRef MDQueryCreate (
CFAllocatorRef allocator,
CFStringRef queryString,
CFArrayRef valueListAttrs,
CFArrayRef sortingAttrs
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
queryString

The query expression string for this query.
valueListAttrs

An optional array of attribute names. The query will collect the values of these attributes into uniqued lists that can be used to summarize the results of the query and allow the user to further qualify the search. This parameter may be NULL if no value lists are required. Value list collection increases CPU usage and significantly increases the memory usage of an MDQuery. The attribute names are CFStrings.
sortingAttrs

A n array of attribute names used to sort the results, or NULL if no sorting is required. The first name in the array is used as the primary sort key, the second as the secondary key, and so on. The comparison of like-typed values is a simple, literal comparison. Sorting increases memory usage and significantly increases the CPU usage of an MDQuery. It is usually more efficent to allow the MDQuery to sort the results than retrieiving the values and sorting the results yourself. The attribute names are CFStrings.
Return Value

An MDQueryRef, or NULL on failure. If the query string is empty or malformed the function returns NULL.
Availability
Available in Mac OS X v10.4 and later.*/
MDQueryRef MDQueryCreate (
CFAllocatorRef allocator,
CFStringRef queryString,
CFArrayRef valueListAttrs,
CFArrayRef sortingAttrs
){};

/*MDQueryGetResultAtIndex

Returns the current result at the given index.

const void *MDQueryGetResultAtIndex (
MDQueryRef query,
CFIndex idx
)
Parameters
query

The query.
idx

The index into the query's result list. If the index is negative, or is equal to or larger than the current number of results in the query, the behavior is undefined.
Return Value

Returns the MDItemRef currently at the given index, or if a result-creation function has been set, returns the result returned by that function.
Discussion

This function causes the result object to be created if it hasn't been created already. For performance reasons you should only request objects that you require. If possible, call this function to fetch only the results you need to display or otherwise process. 

Note that the index of a particular result can change over time if the query is configured to allow live-updates.
Availability
Available in Mac OS X v10.4 and later.*/
const void *MDQueryGetResultAtIndex (
MDQueryRef query,
CFIndex idx
){};

/*MDQueryGetResultCount

Returns the number of results currently collected by the query. 

CFIndex MDQueryGetResultCount (
MDQueryRef query
)
Parameters
query

The query.
Return Value

The number of results in the query.
Discussion

Note that the number of results in a query will change over time as the query's result list is updated.
Availability
Available in Mac OS X v10.4 and later.*/
CFIndex MDQueryGetResultCount (
MDQueryRef query
){};

/*MDQueryExecute

Run the query, and populate the query with the results. 

Boolean MDQueryExecute (
MDQueryRef query,
CFOptionFlags optionFlags
);
Parameters
query

The query to execute.
optionFlags

A bitwise OR of the MDQueryOptionFlags to be used by the query.
Return Value

Returns TRUE if the query was started, FALSE otherwise. Queries cannot be executed more than once.
Discussion

Queries only gather results or process updates while the current thread's run loop is running.

Queries have two phases: the initial gathering phase that collects all currently matching results and a second live-update phase. Updates occur during the live-update phase if a change in a file occurs such that it no longer matches the query or if it begins to match the query. Files which begin to match the query are added to the result list, and files which no longer match the query expression are removed from the result list.

Query notifications are posted within the context of the same thread which executes the query.
Availability
Available in Mac OS X v10.4 and later.*/
Boolean MDQueryExecute (
MDQueryRef query,
CFOptionFlags optionFlags
){};

/*MDQuerySetSearchScope

Sets the search scope for a query instance.

void MDQuerySetSearchScope (
MDQueryRef query,
CFArrayRef scopeDirectories,
OptionBits scopeOptions
);
Parameters
query

The query object to modify.
scopeDirectories

A CFArray of CFStringRef or CFURLRef objects which specify where to search. For convenience the kMDQueryScopeHome, kMDQueryScopeComputer and kMDQueryScopeNetwork constants may also be included in the array.
scopeOptions

Additional options for modifying the search. Currently you must pass 0.
Discussion

Availability
Available in Mac OS X v10.4 and later.*/
void MDQuerySetSearchScope (
MDQueryRef query,
CFArrayRef scopeDirectories,
OptionBits scopeOptions
){};




