#include <Ink/Ink.h>

/*InkSetPhraseTerminationMode

Sets the conditions that define a phrase termination.

void     InkSetPhraseTerminationMode(
   InkSourceType iSource,
   InkTerminationType iAllowedTerminationTypes
);
Parameters
iSource

An “Ink Source Types” constant that specifies the source of the Ink data stream. You can use one of these constants to get independent control over termination of data originating with the user versus data that is passed from your application to Ink Services. To manage phrase termination for user input, pass the constant kInkSourceUser. To manage phrase termination for application input (that is recognized using the function InkAddStrokeToCurrentPhrase, pass the constant kInkSourceApplication.
iAllowedTerminationTypes

A constant that specifies the conditions which define a phrase termination. To turn off automatic phrase termination, pass kInkTerminationNone. You can restore the default phrase termination behavior by passing the constant kInkTerminationDefault. See “Phrase Termination Modes” for more information on the constants you can supply.
Discussion

The default behavior is for Ink Services to terminate a phrase when one of the following events occur: 
The user removes the stylus from the proximity of the tablet
A specified period of time elapses in which the stylus is not pressed to the tablet (The user can control the period of time in the Ink preferences pane.)
The user writes sufficiently far away from the previous Ink—either horizontally, or on a new line

You can use the function InkSetPhraseTerminationMode if your application does not want the default behavior or wants complete control over when Ink phrases are terminated. If you turn off automatic phrase termination, you must make sure you manage phrase termination appropriately for your application.

For example, if you want to force Ink drawn in a specific input window to be treated as a single phrase until the user presses a “finished-writing” button, you would call InkSetPhraseTerminationMode with the parameter kInkTerminationNone to turn off automatic phrase termination. Then you would need to install a Carbon event handler for the event kEventInkPoint. Your handler would examine the kEventInkPoint events, notice when a pen-down event occurs on the “finished-writing” button, and then terminate the phrase by calling the function InkTerminateCurrentPhrase. See Using Ink Services in Your Application for details on writing code to handle phrase termination.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkSetPhraseTerminationMode(
   InkSourceType iSource,
   InkTerminationType iAllowedTerminationTypes
){};

/*InkTextCreateCFString

Obtains the string associated with a text interpretation of an Ink phrase.

CFStringRef         InkTextCreateCFString(
   InkTextRef iTextRef,
   InkAlternateCount iIndex
);
Parameters
iTextRef

On input, a reference to the Ink text object that specifies the Ink word for which you want to create a string. You must obtain an Ink text object reference (InkTextRef) through your application’s Ink event handler. Your handler must take care of the Carbon event class kEventClassInk and the event kind kEventInkText. The event parameter kEventParamInkTextRef that you obtain from this event kind is a reference to an Ink text object.
iIndex

The index that specfies the text interpretation for which you want to obtain a CFString. Text interpretations are stored in an array in ranked order, with the most-likely interpretation at index zero.
Return Value

A CFStringRef that specifies an interpretation for the given Ink text phrase. Returns NULL if the index you provide is invalid. Your application is responsible for releasing the returned CFStringRef.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
CFStringRef         InkTextCreateCFString(
   InkTextRef iTextRef,
   InkAlternateCount iIndex
){};

/*InkTerminateCurrentPhrase

Terminates the current phrase.

void     InkTerminateCurrentPhrase (
   InkSourceType iSource
);
Parameters
iSource

An “Ink Source Types” constant that specifies the source of the Ink data stream.To terminate a phrase that originates from application input (that is recognized using the function InkAddStrokeToCurrentPhrase), pass the constant kInkSourceApplication.

If you are managing phrase termination that originates from direct user input, you can pass the constant kInkSourceUser. Note that this function is normally not used in this fashion, as most applications can let Ink Services terminate such phrases automatically.
Discussion

You do not need to call this function unless you have turned off automatic phrase termination (by calling the function InkSetPhraseTerminationMode) and have set up your application to manage phrase termination. When you call the function InkTerminateCurrentPhrase, any Ink drawn by Ink Services is erased. If your application handles phrase termination, it can still take advantage of the recognition service provided by Ink Services.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkTerminateCurrentPhrase (
   InkSourceType iSource
){};



/*InkTextInsertAlternatesInMenu

Inserts a list of alternate text interpretations into a menu.

ItemCount        InkTextInsertAlternatesInMenu(
   InkTextRef iTextRef,
   MenuRef iMenuRef,
   MenuItemIndex iAfterItem
);
Parameters
iTextRef

On input, a reference to an Ink text object that specifies the Ink word for which you want to provide a list of alternate text interpretations. You must obtain an Ink text object reference (InkTextRef) through your application’s Ink event handler. Your handler must take care of the Carbon event class kEventClassInk and the event kind kEventInkText. The event parameter kEventParamInkTextRef that you obtain from this event kind is a reference to an Ink text object.
iMenuRef

A reference to the menu into which you want to insert the list of alternate text interpretations. Ink Services attaches menu event handlers to this menu, so you should use this MenuRef directly, rather than copy items from the menu reference to another menu.
iAfterItem

A value that specifies the menu item after which you want to insert the list of alternate text interpretations. If the specified menu item is 0, the text alternates are inserted at the head of the menu. If the specified menu item is greater than or equal to the existing number of menu items, the text alternates are appended to the end of the menu. Remember that the first item in a menu item array is numbered 1, not 0.
Return Value

Returns the number of menu items added to the menu. Returns 0 if the operation is not successful.
Discussion

The function InkTextInsertAlternatesInMenu allows your application to insert a list of text interpretations for a given Ink text phrase into an existing contextual menu. You should handle a list of alternate text interpretations as a standard contextual menu using the Menu Manager function ContextualMenuSelect. 

When a user selects an item from the list of alternates, the list of alternates maintained by Ink Services are reordered automatically. This means that if you call the function InkTextCreateCFString with the parameter iIndex set to 0, you obtain the newly selected item.

Thus the user’s choice persists in internal system data structures without requiring your application to call additional functions. However your application must update its own internal data structures appropriately. 

You must rebuild the menu to reflect the user’s choice. After the user makes a choice and then reopens the menu, you must make sure the newly-selected item shows up as the first item in the menu. The items in the menu should mirror the list of alternates maintained by Ink Services.

Upon return from the function ContextualMenuSelect, your application can determine if the user has made a selection by checking the value of the parameter outUserSelectionType. The value indicates the item that the user selected from the contextual menu. If there is a selection, your application can examine the outMenuID and outMenuItem parameters of the function ContextualMenuSelect, and use these values to obtain the alternate text interpretation by calling the Menu Manager function CopyMenuItemTextAsCFString. 

Menu items for a set of alternates whose first letter is an alphabetical character always include an alternate whose first letter is the opposite lettercase. Menu items for a set of alternates whose first letter is a non-alphabetical character do not include a lettercase alternate. 

When the menu items are reordered automatically, the text that was first in the list moves to the second or the third position, depending upon whether the first letter is alphabetical or non-alphabetical. For example, the following list of menu items:

crash, Crash, crush, crust, wrash

If the user chooses crush, the menu items are reordered as follows:

crush, Crush, crash, crust, wrash

Notice that the list of alternates is kept to a length of five. A lettercase alternate for crush is added to the menu while the uppercase alternate Crash is dropped.

For a non-alphabetic first character, however, such as a number, the original moves to the second position. So for the following menu:

1239, 1234, 1289, 1284

If the user chooses 1234, the menu becomes:

1234, 1239, 1289, 1284

If it is important for your application to maintain the original order of alternates, then it must use its own internal data structures to keep track of the original list.

See Using Ink Services in Your Application for details on writing code that uses the function InkTextInsertAlternatesInMenu to implement a correction model.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
ItemCount        InkTextInsertAlternatesInMenu(
   InkTextRef iTextRef,
   MenuRef iMenuRef,
   MenuItemIndex iAfterItem
){};

/*InkAddStrokeToCurrentPhrase

Adds a stroke to the current Ink phrase.

void     InkAddStrokeToCurrentPhrase(
   unsigned long iPointCount,
   InkPoint *iPointArray
);
Parameters
iPointCount

The number of elements in the iPointArray array.
iPointArray

A pointer to an array of InkPoint structures that specify the path of the stylus, starting with the point that defines the first stylus-down location and ending with the point that defines the last stylus-down location.
Discussion

This function operates on the Ink source from the application, and not on that from direct user input. So there is no need to specify the Ink source as kInkSourceApplication. See “Ink Source Types” for more information on sources.

You do not need to call this function unless you have raw data to process or you have turned off automatic recognition (by calling the function InkSetApplicationWritingMode) and have set up your application to handle Ink input events itself. For example, you might need to handle Ink input if your application needs to acquire pen data in a device-specific manner.

If your application handles Ink input events, it can still take advantage of the recognition service provided by Ink Services. To do so, your application should call the function InkAddStrokeToCurrentPhase to add one stroke at a time to the current phrase. You then terminate the phrase at the appropriate time by calling the function InkTerminateCurrentPhrase. Note that calling InkAddStrokeToCurrentPhase adds a stroke to the current phrase, but does not draw the stroke. See Using Ink Services in Your Application for details on writing code that uses the function InkAddStrokeToCurrentPhase to implement deferred recognition.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkAddStrokeToCurrentPhrase(
   unsigned long iPointCount,
   InkPoint *iPointArray
){};

/*InkSetDrawingMode

Controls what is drawn when the user writes. 

void InkSetDrawingMode(
InkDrawingModeType iDrawingMode
);
Parameters
iDrawingMode

A “Drawing Modes” constant that specifies the drawing mode to use for your application. The default (kInkDrawInkAndWritingGuides) is for Ink Services to draw both the Ink writing guides and the Ink. Pass kInkDrawInkOnly if you want Ink Services to draw only the Ink. Pass kInkDrawNothing to turn off drawing of both the Ink writing guides and the Ink.
Discussion

Normally Ink Services draws writing guides, similar in look to the alternating solid and broken lines used on many paper writing tablets. The Ink itself is drawn anti-aliased and grayscale. Your application can call the function InkSetDrawingMode to request that Ink Services not draw the writing guides or not draw either Ink or the writing guides. If Ink drawing is disabled, your application must receive the points (by installing a handler for kEventInkPoint events) and draw the Ink. 

You do not need to call the function InkSetDrawingMode to inhibit drawing if you called the function InkSetApplicationWritingMode, passing the value kInkWriteNowhereInApp. Also, Ink Services will not draw any point for which a kEventInkPoint Carbon event handler returns noErr.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void InkSetDrawingMode(
InkDrawingModeType iDrawingMode
){};

/*InkDrawingModeType iDrawingMode
);

InkSetApplicationWritingMode

Controls where the user is allowed to write in the current application.

void InkSetApplicationWritingMode (
   InkApplicationWritingModeType iWriteWhere
   );
Parameters
iWriteWhere

An “Application Modes” constant that specifies the Ink writing mode to use for your application. Pass kInkWriteAnywhereInApp if you want your application to allow Ink input and recognition and to receive Ink events when the user writing mode is set to kInkWriteInkAwareOnly. When you call this function with the iWriteWhere parameter set to kInkWriteAnywhereInApp, your application can receive Ink events whose screen locations lie outside the application windows. Pass kInkWriteNowhereInApp to disable Ink input temporarily, such as when the user is using a paint tool. 
Discussion

You can call the function InkSetApplicationWritingMode to control when Ink input and recognition are allowed in your application. Using this function, you can turn Ink Services on or off for your application. Note that Ink input is available for your application only when your application is frontmost and when the user has turned on recognition in the Ink preferences pane.

If your application calls the function InkSetApplicationWritingMode with the parameter kInkWriteNowhereInApp to disable Ink Services management of pen events because you want to accumulate Ink data yourself, be aware that you may need to manage mouse event coalescing yourself. You can use the Carbon Event Manger function SetMouseCoalescingEnabled for this purpose. See Using Ink Services in Your Application for a discussion of mouse coalescing.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void InkSetApplicationWritingMode (
   InkApplicationWritingModeType iWriteWhere
   ){};

/*InkSetApplicationRecognitionMode

Specifies whether Ink input should be interpreted as text, gestures, both, or neither.

void     InkSetApplicationRecognitionMode(
   InkRecognitionType iRecognitionType
);
Parameters
iRecognitionType

The recognition mode you want Ink Services to use. Pass kInkRecognitionGesture to specify gesture recognition, kInkRecognitionText to specify text recognition, kInkRecognitionNone to turn off recognition, or kInkRecognitionDefault (which is kInkRecognitionGesture | kInkRecognitionText) to specify both gesture and text recognition. See “Recognition Modes” for more information on the constants you can supply. 
Discussion

This function only affects recognition of Ink that originates from the user. It does not affect recognition of Ink that originates from your application, and is recognized using the function InkAddStrokeToCurrentPhrase. Note that only text recognition (not gesture recognition) is performed on an Ink data stream that originates from your application.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkSetApplicationRecognitionMode(
   InkRecognitionType iRecognitionType
){};








