#include <HIToolbox/HIToolbox.h>

/*LClick

Processes a mouse-down event in a list.

Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
);
Parameters
pt

The location in local coordinates of the mouse-down event. Your application can simply call GlobalToLocal(myEvent.where) and then pass myEvent.where in this parameter.

If the pt parameter specifies a portion of the list’s visible rectangle, then cells are selected with an algorithm that depends on the list’s selection flags and on the modifiers parameter. If the user drags the cursor above or below the list’s visible rectangle and vertical autoscrolling is enabled, then the List Manager vertically autoscrolls the list. If the user drags the cursor to the right or the left of the list’s visible rectangle and horizontal autoscrolling is enabled, then the List Manager horizontally autoscrolls the list.

If the pt parameter specifies a point within the list’s scroll bar, then the List Manager calls the scroll bar’s control definition function to track the cursor and it scrolls the list appropriately.
modifiers

An integer value corresponding to the modifiers field of the event record. 
lHandle

The list in which the mouse-down event occurred. 
Return Value

TRUE if the click was a double-click, or FALSE otherwise. 
Discussion

The LClick function handles all user interaction until the user releases the mouse button. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LClick (
   Point pt,
   EventModifiers modifiers,
   ListHandle lHandle
){
printf ("LClick",pt,modifiers,lHandle);
};


/*GetListViewBounds


Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
);
Parameters
list
view
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

Rect * GetListViewBounds (
   ListHandle list,
   Rect * view
){
printf ("GetListViewBounds",list,*view);
};

/*LActivate

Activates or deactivates a list.

void LActivate (
   Boolean act,
   ListHandle lHandle
);
Parameters
act

Indicates whether the list should be activated. Specify TRUE to activate the list. Specify FALSE to deactivate the list. 
lHandle

The list to be activated or deactivated. 
Discussion

If a list is being deactivated, this function removes highlighting from selected cells and hides the scroll bars. If a list is being activated, the function highlights selected cells and shows the scroll bars.

This function has no effect on a list’s size box, if one exists. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LActivate (
   Boolean act,
   ListHandle lHandle
){
printf ("LActivate",act,lHandle);
};

/*LGetSelect

Gets information about which cells are selected.

Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
);
Parameters
next

Indicates whether the function should check only the cell specified by the parameter theCell, or whether it should try to find the next selected cell. If next is TRUE, then the function searches the list for the first selected cell beginning at the cell specified by theCell. (In particular, it first checks cells in row theCell.v, and then cells in the next row, and so on.) 

If next is FALSE, then the function checks only the cell specified by the parameter theCell.
theCell

On input, a pointer to the first cell whose selection status should be checked. If next is TRUE, then, on return this parameter is a pointer to the next selected cell greater than or equal to the cell specified on input. Otherwise, this parameter remains unchanged. 
lHandle

The list in which the selection is being checked. 
Return Value

TRUE if next is TRUE and the function finds a selected cell, or if next is FALSE and the cell specified by theCell is selected. If this function does not find a selected cell, FALSE. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
Boolean LGetSelect (
   Boolean next,
   Cell * theCell,
   ListHandle lHandle
){
printf ("LGetSelect",next,*theCell,lHandle);
};




/*LDelRow

Deletes one or more rows from a list.

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to delete, or 0 to delete all rows. 
rowNum

The row number of the first row to delete.
lHandle

The list from which to delete the rows. 
Discussion

This function deletes rows starting at the row specified by the rowNum parameter. If the row specified by rowNum is invalid, then nothing is done.

Your application can quickly delete all rows from a list (and thus delete all cell data) simply by setting the count parameter to 0. The number of columns is left unchanged. Your application can achieve the same effect by setting the rowNum parameter to (**lHandle).dataBounds.top and setting the count parameter to a value greater than (**lHandle).dataBounds.bottom – (**lHandle).dataBounds.top.

Rows whose row numbers are initially greater than rowNum have their row numbers decreased by count.

If the automatic drawing mode is enabled and one or more of the rows deleted by the function are visible, then the list (including its scroll bars) is updated. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

void LDelRow (
   short count,
   short rowNum,
   ListHandle lHandle
){
printf ("LDelRow",count,rowNum,lHandle);
};


/*LGetCell

Copies a cell’s data.

void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the location to which to copy the cell’s data. 
dataLen

On input, a pointer to the maximum number of bytes to copy. On return, a pointer to the number of bytes actually copied. 
theCell

The cell whose data is to be copied. 
lHandle

The list containing the cell specified by the parameter theCell. 
Discussion

If the cell data is longer than dataLen, only dataLen bytes are copied and the dataLen parameter is unchanged. If the cell data is shorter than dataLen, then the function sets dataLen to the length in bytes of the cell’s data. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LGetCell (
   void * dataPtr,
   short * dataLen,
   Cell theCell,
   ListHandle lHandle
){
printf ("LGetCell",dataPtr,*dataLen,theCell,lHandle);
};


/*NewListClickLoopUPP

Creates a new universal procedure pointer (UPP) to a list click loop callback function.

ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListClickLoopUPP data type.
Discussion

See the ListClickLoopProcPtr callback for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListClickLoopUPP NewListClickLoopUPP (
   ListClickLoopProcPtr userRoutine
){
printf ("NewListClickLoopUPP",userRoutine);
};


/*NewListDefUPP

Creates a new universal procedure pointer (UPP) to a list definition callback function.

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the ListDefUPP data type.
Discussion

See the ListDefProcPtr callback for more information. 
Special Considerations
Version Notes
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

ListDefUPP NewListDefUPP (
   ListDefProcPtr userRoutine
){
printf ("NewListDefUPP",userRoutine);
};

/*CreateCustomList


OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
);
Parameters
rView
dataBounds
cellSize
theSpec
theWindow
drawIt
hasGrow
scrollHoriz
scrollVert
outList
Return Value

A result code.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

OSStatus CreateCustomList (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cellSize,
   const ListDefSpec * theSpec,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert,
   ListHandle * outList
){
printf ("CreateCustomList",*rView,*dataBounds,cellSize,*theSpec,theWindow,drawIt,hasGrow,scrollHoriz,scrollVert,*outList);
};

//work
/*LDispose

Disposes of the memory associated with a list.

void LDispose (
   ListHandle lHandle
);
Parameters
lHandle

The list to be disposed of. 
Discussion

This function releases all memory allocated by the List Manager in creating a list. First, it issues a close request to the list definition function and calls the Control Manager function DisposeControl for the list’s scroll bars (if any). The function then uses the Memory Manager to free the memory referenced by the cells field, then disposes of the list record itself.

Because it disposes of data associated with cells in your list, there is no need to clear the data from list cells or to delete individual rows and columns before calling this function.

This function does not dispose of any memory associated with a list that the List Manager has not allocated. In particular, it does not dispose of any memory referenced by the userHandle field of the list record. Your application is responsible for deallocating any memory it has allocated through the userHandle field before calling this function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Version Notes
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes
Declared In
Lists.h*/

void LDispose (
   ListHandle lHandle
){};


/*LUpdate

Responds to an update event.

void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
);
Parameters
theRgn

The visible region of the list’s port after a call to the Window Manager’s BeginUpdate function. 
lHandle

The list to be updated. 
Discussion

This function redraws all visible cells in the list specified by the lHandle parameter that intersect the region specified by the parameter theRgn. It also redraws the scroll bars if they intersect the region.

You should bracket calls to LUpdate by calls to the Window Manager functions BeginUpdate and EndUpdate. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LUpdate (
   RgnHandle theRgn,
   ListHandle lHandle
){};

/*LSize

Changes the size of a list.

void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
);
Parameters
listWidth

The new width (in pixels) of the list’s visible rectangle. 
listHeight

The new height (in pixels) of the list’s visible rectangle.
lHandle

The list whose size is being changed. 
Discussion

This function adjusts the lower-right side of the list so that the list’s visible rectangle is the width and height specified by the listWidth and listHeight parameters. 

Because the list’s visible rectangle does not include room for the scroll bars, your application should make listWidth 15 pixels less than the desired width of the list if it contains a vertical scroll bar, and it should make listHeight 15 pixels less than the desired height of the list if it contains a horizontal scroll bar.

The contents of the list and the scroll bars are adjusted and redrawn as necessary. However, this function does not draw a border around the list’s rectangle. Also, it does not erase any portions of the old list that may still be visible. This approach should not be a problem if your application only calls LSize after the user resizes a window containing a list in its lower-right corner.

Usually, you need to call this function only after calling the Window Manager function SizeWindow. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSize (
   short listWidth,
   short listHeight,
   ListHandle lHandle
){};




/*LNew

Creates a new list in a window.

ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
);
Parameters
rView

A pointer to the rectangle in which to display the list, in local coordinates of the window specified by the theWindow parameter. This rectangle does not include the area to be taken up by the list’s scroll bars. 
dataBounds

A pointer to the initial data bounds for the list. By setting the left and top fields of this rectangle to (0,0) and the right and bottom fields to (kMyInitialColumns, kMyInitialRows), your application can create a list that has kMyInitialColumns columns and kMyInitialRows rows. 
cSize

The size of each cell in the list. If your application specifies (0,0) and is using the default list definition function, the List Manager sets the v coordinate of this parameter to the sum of the ascent, descent, and leading of the current font, and it sets the h coordinate using the following formula:

cSize.h = (rView.right - rView.left) / (dataBounds.right – dataBounds.left).
theProc

The resource ID of the list definition function to use for the list. To use the default list definition function, which supports the display of unstyled text, specify a resource ID of 0. 
theWindow

A pointer to the window in which to install the list. 
drawIt

Indicates whether the List Manager should initially enable the automatic drawing mode. When the automatic drawing mode is enabled, the List Manager automatically redraws the list whenever a change is made to it. You can later change this setting using the LSetDrawingMode function. Your application should leave the automatic drawing mode disabled only for short periods of time when making changes to a list (by, for example, adding rows and columns). 
hasGrow

Indicates whether the List Manager should leave room for a size box. The List Manager does not actually draw the grow icon. Usually, your application can draw it with the Window Manager’s DrawGrowIcon function.
scrollHoriz

Indicates whether the list should contain a horizontal scroll bar. Specify TRUE if your list requires a horizontal scroll bar; specify FALSE otherwise.
scrollVert

Indicates whether the list should contain a vertical scroll bar. Specify TRUE if your list requires a vertical scroll bar; specify FALSE otherwise.
Return Value

A handle to the newly created list, or if the function cannot allocate the list, NULL. This might happen if there is not enough memory available or if the function cannot load the resource specified by the theProc parameter. If it returns successfully, then all of the fields of the list record referenced by the returned handle are correctly set. See the description of the ListHandle data type.
Discussion

If the list contains a horizontal or vertical scroll bar and the window specified by the parameter theWindow is visible, this function draws the scroll bar for the new list in the window just outside the list’s visible rectangle specified by the rView parameter. This function does not, however, draw a 1-pixel border around the list’s visible rectangle. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
ListHandle LNew (
   const Rect * rView,
   const ListBounds * dataBounds,
   Point cSize,
   short theProc,
   WindowRef theWindow,
   Boolean drawIt,
   Boolean hasGrow,
   Boolean scrollHoriz,
   Boolean scrollVert
){};


/*LSetDrawingMode

Changes the automatic drawing mode specified when creating a list. 

void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
);
Parameters
drawIt

Indicates whether the List Manager should enable the automatic drawing mode. Specify TRUE to enable the automatic drawing mode. Specify FALSE to disable the automatic drawing mode. 
lHandle

The list whose drawing mode is being changed. 
Discussion

Your application can use the LSetDrawingMode function to enable or disable automatic drawing of lists. If your application uses LSetDrawingMode to temporarily disable list drawing, then it must call the LDraw function to draw a cell when its appearance changes, or when new rows or columns are added to the list. .

While the automatic drawing mode is turned off, all cell drawing and highlighting are disabled, and the scroll bar does not function properly. Thus, your application should disable the automatic drawing mode only for short periods of time. After enabling it, your application should ensure that the list is redrawn.

This function is also available as the LDoDraw function. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetDrawingMode (
   Boolean drawIt,
   ListHandle lHandle
){};

/*LSetSelect

Selects or deselects a cell.

void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
);
Parameters
setIt

Indicates whether the function should select or deselect the specified cell. Specify TRUE to select the cell. If the cell is already selected, the function does nothing. Specify FALSE to deselect the cell. If the cell is already deselected, the function does nothing. 
theCell

The cell to be selected or deselected. 
lHandle

The list containing the cell to be selected or deselected. 
Discussion

If a cell’s selection status is changed and the cell is visible, LSetSelect redraws the cell. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetSelect (
   Boolean setIt,
   Cell theCell,
   ListHandle lHandle
){};


/*LScroll

Scrolls a list a specified number of rows and columns.

void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
);
Parameters
dCols

The number of columns to scroll. Specify a positive number to scroll down (that is, each cell moves up), and a negative number to scroll up. 
dRows

The number of rows to scroll. Specify a positive number to scroll right (that is, each cell moves left), and a negative number to scroll left.
lHandle

The list to be scrolled. 
Discussion

The List Manager will not scroll beyond the data bounds of the list. If the automatic drawing mode is enabled, this function does all necessary updating of the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LScroll (
   short dCols,
   short dRows,
   ListHandle lHandle
){};

/*LSetCell

Changes the data contained in a cell.

void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
);
Parameters
dataPtr

A pointer to the new data for a cell. 
dataLen

The length in bytes of the new data. 
theCell

The coordinates of the cell to hold the new data. 
lHandle

The list containing the cell given in the theCell parameter. 
Discussion

Any previous cell data in theCell is replaced. If there is insufficient memory in the heap, the function may fail to set the cell’s data. If the cell coordinates specified by the theCell parameter are invalid, the function does nothing.

If the data of a visible cell is changed and the automatic drawing mode is enabled, the function updates the list. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/
void LSetCell (
   const void * dataPtr,
   short dataLen,
   Cell theCell,
   ListHandle lHandle
){};

/*LAddRow

Adds one or more rows to a list.

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
);
Parameters
count

The number of rows to add. 
rowNum

The row number of the first row to add.
lHandle

The list to add the rows to. 
Return Value

The row number of the first row added, which is equal to the value specified by the rowNum parameter if that value is a valid row number. If the row number specified by rowNum is not already in the list, then new last rows are added. The value returned by this function thus has significance only in this case. 
Discussion

This function inserts rows starting at the row specified by the rowNum parameter. If there is insufficient memory in the heap to add the new rows, the function may fail to add the new rows although it returns a positive function result. Be sure there is enough memory in the heap to allocate the new rows before calling this function.

Rows whose row numbers are initially greater than rowNum have their row numbers increased by count. 

If the automatic drawing mode is enabled and the rows added by this function are visible, then the list (including its scroll bars) is updated. New cells created by a call to this function are initially empty.

You may add rows to a list that does not yet have columns. The dataBounds field of the list record reflects that the list has rows, but you can only access cells when both rows and columns have been added. 
Special Considerations

This function is contained in a resource of resource type 'PACK'. Calling it could result in the loading of the package resource and the allocation of memory. Thus, your application should not call this function from within an interrupt, such as in a completion function or VBL task.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
Lists.h*/

short LAddRow (
   short count,
   short rowNum,
   ListHandle lHandle
){};