#include <HIToolbox/HIToolbox.h>


/*HIViewFindByID

Obtains a view by its ID. 

OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
);
Parameters
inStartView

The view to start searching at. 
inID

The ID of the view you are looking for. 
outControl

Receives the control if found. 
Return Value

An operating system result code.
Discussion

Allows you to find a particular view by its ID. The HIViewID type used by this function is identical to the ControlID type used by the Control Manager.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewFindByID (
   HIViewRef inStartView,
   HIViewID inID,
   HIViewRef * outControl
){
printf ("HIViewFindByID",inStartView,inID,*outControl);
};

/*HIViewGetRoot

Obtains the root view for a window. 

HIViewRef HIViewGetRoot (
   WindowRef inWindow
);
Parameters
inWindow

The window to get the root for.
Return Value

The root view for the window, or NULL if an invalid window is passed.
Discussion

Note that the root view is not the same as the Control Manager root control.
Availability
Available in Mac OS X v10.2 and later.*/

HIViewRef HIViewGetRoot (
   WindowRef inWindow
){
printf ("HIViewGetRoot",inWindow);
};

/*HIViewGetBounds

Obtains the local bounds of a view. 

OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose local bounds are to be obtained.
outRect

The local bounds of the view.
Return Value

An operating system result code.
Discussion

The local bounds are the coordinate system that is completely view-relative. A view’s top left coordinate starts out at 0, 0. Most operations use local coordinates. Note, however, that the frame is used to move a view, not local coordinates.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetBounds (
   HIViewRef inView,
   HIRect* outRect
){
printf ("HIViewGetBoundst",inView,*outRect);
};

/*HIViewSetNeedsDisplay

Marks a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
);
Parameters
inView

The view to mark as dirty (needing to be redrawn) or clean (not needing to be redrawn).
inNeedsDisplay

A Boolean whose value is true to mark the view as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetNeedsDisplay (
   HIViewRef inView,
   Boolean inNeedsDisplay
){
printf ("HIViewSetNeedsDisplay",inView,inNeedsDisplay);
};

/*HIViewAddSubview

Adds a subview to the given parent view.

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
);
Parameters
inParent

The view that will receive the new subview.
inNewChild

The subview being added.
Return Value

An operating system result code. The result code errNeedsCompositedWindow is returned if you try to embed into the content view in a non-compositing window; you can only embed into the content view in a compositing window.
Discussion

The new subview is added to the front of the list of subviews (that is, it is made topmost). The subview being added is not retained by the new parent view. Do not release the view after adding it, or it will cease to exist. All views in a window are released automatically when the window is destroyed.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewAddSubview (
   HIViewRef inParent,
   HIViewRef inNewChild
){
printf ("HIViewAddSubview",inParent,inNewChild);
};

/*HIViewSetLayoutInfo

Sets the layout information of an HIView. 

OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
);
Parameters
inView

The view whose layout information is to be set.
inLayoutInfo

A pointer to an HILayoutInfo structure containing the layout values that are to be set.
Return Value

An operating system result code.
Discussion

Layouts are used to automatically change the size and positioning of a view when another view changes size or position. Layout changes only take effect in two cases:
When HIViewApplyLayout is called after the view’s layout has been set by calling HIViewSetLayoutInfo. The HIViewApplyLayout function is most useful when first applying a scaling or positioning layout to a view in order to set up the view’s initial position and size relative to the view referenced in the layout.
When the related view changes its size or position.

A layout allows a view’s size or position to be modified in three ways: side binding, axial scaling, and axial positioning. In the following examples, View A initially has a left side of 100 and a right side of 150, and is placed inside a parent view that has a width of 275.
Bindings — Setting up a binding relationship between two views specifies that one edge of a view is to change by an amount equal to the change in an edge of another view. If View A has a right-side binding to its parent’s maximum (or right) side, when the parent’s right side changes, View A’s right side changes by the same amount. If the parent view resizes to be 325 units wide (50 units wider than before), View A is resized so that its left side changes to 150 units and its right side changes to 200, which is 50 units more to the right than before. You can think of bindings as a way to maintain distance. An edge bound to another view’s edge always maintains its offset from that related edge. In other view systems, this concept is often referred to as “springs and rods.” Note that a binding does not cause one side of the view to exactly align with the side of another view; a binding merely causes one side of the view to change by the same amount as another view changes. To align one edge of a view to another view’s edge, use positioning. Bindings depend on changes in size or position of the related view. As a result, calling HIViewApplyLayout does not activate side bindings, as no changes have occurred. Bindings are implemented using the HIBinding structure and one HISideBinding structure per view edge.
Scaling — Setting up a scaling relationship between two views specifies that the axial size (that is, the width or height) of a view is to be a specified ratio of the size of another view when that other view moves or resizes. If View A has an x-axis scaling for its parent view with a ratio of 0.8, when the parent view’s width changes, View A’s width changes to be the parent’s width multiplied by 0.8. If the parent view resizes to be 325 units wide, View A resizes so that its left side stays at 100 and its right side changes to 360 (100 + 325 * 0.8). Note that when a scaling layout is first set up on a view with HIViewSetLayoutInfo, no scaling is applied to the view because scaling only occurs when the related view resizes. If scaling is required at initial setup, call HIViewSetLayoutInfo and then HIViewApplyLayout. Scaling is implemented using the HIScaling structure and one HIAxisScale structure per view axis.
Positioning — Setting up a positioning relationship between two views specifies that the axial position (i.e., vertical or horizontal) of a view is to change so that the view aligns with the minimum, maximum, or center of another view when that other view resizes. If View A has an x-axis position with its parent view with center positioning specified, when the parent view changes size, View A moves so that it is centered horizontally relative to its parent. If the parent view resizes to be 300 units wide, View A repositions so that its left side is at 125 and its right side is at 175, centered in the parent view. Positioning is implemented using the HIPositioning structure and one HIAxisPosition per view axis.

The HIView layout engine applies transformations to a view sequentially. First, bindings are applied. Then scaling is applied, which could override some of the previously applied bindings. Then positioning is applied, which could also override some of the previously applied bindings. The bindings are applied recursively to a container’s subviews, which requires care on your part to avoid infinite recursion, especially when applying inter-relational bindings. For example, if View A’s x axis is scaled relative to View B and View B’s x-axis is scaled to View A, your application could hang when the layouts are applied because View A would affect View B, which would affect View A, and so on.

For more information on using the layout engine, see HIView Programming Guide.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewSetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * inLayoutInfo
){
printf ("HIViewSetLayoutInfo",inView,*inLayoutInfo);
};

/*HIViewSetVisible

Hides or shows a view. 

OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
);
Parameters
inView

The view to hide or show.
inVisible

A Boolean value that indicates whether you want to hide the view (false) or show the view (true).
Return Value

An operating system result code.
Discussion

Marks the area the view will occupy or previously occupied as needing to be redrawn later. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetVisible (
   HIViewRef inView,
   Boolean inVisible
){
printf ("HIViewSetVisible",inView,inVisible);
};

/*HIViewGetLastSubview

Returns the last subview in a parent view.

HIViewRef HIViewGetLastSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the last subview of a container. The last subview is the bottommost subview in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetLastSubview (
   HIViewRef inView
){
printf ("HIViewGetLastSubview",inView);
};
 
/*HIViewGetPreviousView

Returns the view above the specified view.

HIViewRef HIViewGetPreviousView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view in front of it or is invalid.
Discussion

Returns the view before the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetPreviousView (
   HIViewRef inView
){
printf ("HIViewGetPreviousView",inView);
};

/*HIViewSetText

Sets the text of a view to the specified string.

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
);
Parameters
inView

The view whose text is to be set.
inText

The text that is to be set.
Return Value

An operating system result code.
Discussion

This function attempts to set the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag SetControlData tag. If this function can’t set that text, it sets the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetText (
HIViewRef inView,
CFStringRef inText
){
printf ("HIViewSetText",inView,inText);
};

/*HIViewSetID

Sets the HIViewID of a view.

OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
);
Parameters
inView

The view whose HIViewID is to be set.
inID

The HIViewID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetID (
HIViewRef inView,
HIViewID inID
){
printf ("HIViewSetIDt",inView,inID);
};



/*HIViewGetValue

Obtains the value of a view.

SInt32 HIViewGetValue (
HIViewRef inView
);
Parameters
inView

The view whose value is to be obtained.
Return Value

The view’s value.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetValue (
HIViewRef inView
){
printf ("HIViewGetValue",inView);
};

/*HIViewSetHilite

Sets highlighting on a view.

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
);
Parameters
inView

The view for which highlighting is to be set.
inHilitePart

The part of the view whose highlighting is to be set. For possible values, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetHilite (
HIViewRef inView,
HIViewPartCode inHilitePart
){
printf ("HIViewSetHilite",inView,inHilitePart);
};

/*HIViewSetValue

Sets the value of a view.

OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
);
Parameters
inView

The view whose value is to be set.
inValue

The value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetValue (
HIViewRef inView,
SInt32 inValue
){
printf ("HIViewSetValuel",inView,inValue);
};

/*HIViewSetMaximum

Sets a view’s maximum value.

OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
);
Parameters
inView

The view whose maximum value is to be set.
inView

The maximum value to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetMaximum (
HIViewRef inView,
SInt32 inMaximum
){
printf ("HIViewSetMaximum",inView,inMaximum);
};

/*HIViewSetViewSize

Sets the view size of a view.

OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
);
Parameters
inView

The view whose view size is to be set.
inViewSize

The view size that is to be set.
Return Value

An operating system result code.
Discussion

The view size is the size of the content to which a view’s display is proportioned. The view size is commonly used to set the proportional size of a scroll bar’s thumb indicator.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetViewSize (
HIViewRef inView,
SInt32 inViewSize
){
printf ("HIViewSetViewSize",inView,inViewSize);
};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewSetMinimum (
HIViewRef inView
){
printf ("HIViewSetMinimum",inView);
};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewSetMinimum (
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/

SInt32 HIViewGetMinimum (
HIViewRef inView
){
printf ("HIViewGetMinimum",inView);
};

/*HIViewGetMaximum

Obtains a view’s maximum value.

SInt32 HIViewGet Maximum(
HIViewRef inView
);
Parameters
inView

The view whose maximum value is to be obtained.
Return Value

The maximum value of the specified view.
Availability
Available in Mac OS X v10.4 and later.*/
SInt32 HIViewGetMaximum (
HIViewRef inView
){
printf ("HIViewGetMaximum",inView);
};

/*HIViewGetSuperview

Returns a view’s parent view.

HIViewRef HIViewGetSuperview (
   HIViewRef inView
);
Parameters
inView

The view whose parent you are interested in getting.
Return Value

An HIView reference, or NULL if this view has no parent or is invalid.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetSuperview (
   HIViewRef inView
){
printf ("HIViewGetSuperview",inView);
};

/*HIViewConvertRect

Converts a rectangle from one view to another. 

OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioRect

The rectangle to convert. 
inSourceView

The view whose coordinate system ioRect is starting out in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
inDestView

The view whose coordinate system ioRect should end up in. You can pass NULL to indicate that ioRect is a window-relative rectangle.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewConvertRect (
   HIRect* ioRect,
   HIViewRef inSourceView,
   HIViewRef inDestView
){
printf ("HIViewConvertRect",*ioRect,inSourceView,inDestView);
};

/*HIViewDrawCGImage

Draws a Core Graphics image appropriately for a view.

OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
);
Parameters
inContext

The context to draw in.
inBounds

The bounds to draw the image into.
inImage

The image to draw.
Return Value

An operating system status code.
Discussion

This function is similar to CGContextDrawImage, but it flips the context so that the image is drawn correctly. The origin of a view is at the top left corner, so you are really drawing upside-down. This call insulates you from that fact.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewDrawCGImage (
   CGContextRef inContext,
   const HIRect* inBounds,
   CGImageRef inImage
){
printf ("HIViewDrawCGImage",inContext,*inBounds,inImage);
};

/*HIImageViewSetImage

Sets the image to display in an image view.

OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
);
Parameters
inView

The image view to affect.
inImage

The image to set.
Return Value

An operating system status code.
Discussion

The image passed in is retained by the view, so you may release the image after calling this function if you no longer need to reference it.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetImage (
   HIViewRef inView,
   CGImageRef inImage
){
printf ("HIImageViewSetImage",inView,inImage);
};

/*HIImageViewSetOpaque

Sets the opacity of an image view.

OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
);
Parameters
inView

The image view to set.
inOpaque

A Boolean whose value is true to make the image view opaque or false to disable the opacity setting.
Return Value

An operating system result code.
Discussion

When opacity is enabled, the image view can make certain optimizations for compositing and scrolling. The alpha-related image view APIs are rendered useless when opacity is enabled. An image view, when created, is opaque by default. You must pass false to this function in order to change the alpha, etc. or if your image does not fill the full bounds of the view.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetOpaque (
   HIViewRef inView,
   Boolean inOpaque
){
printf ("HIImageViewSetOpaque",inView,inOpaque);
};

/*HIViewNewTrackingArea

Creates a new tracking area for a view.

OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
);
Parameters
inView

The view for which a new tracking area is to be created.
inShape

The shape to use. Pass NULL to use the entire structure region of the view.
inID

An identifier for the new tracking area. You can specify any value you want, or zero if you don’t want associate an identifier with the new tracking area.
outRef

On return, a pointer to the reference to the new tracking area. A count is not maintained for this reference.
Return Value

An operating system result code.
Discussion

All tracking areas attached to a view are automatically disposed of when the view is disposed of, so you don’t need to dispose of a tracking area explicitly unless you want to remove it from a view before the view is disposed of.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewNewTrackingArea (
HIViewRef inView,
HIShapeRef inShape,
HIViewTrackingAreaID inID,
HIViewTrackingAreaRef * outRef
){
printf ("HIViewNewTrackingArea",inView,inShape,inID,*outRef);
};

/*HIImageViewSetAlpha

Sets the alpha value for an image view.

OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
);
Parameters
inView

The image view to affect.
inAlpha

The new alpha value. 
Return Value

An operating system result code.
Discussion

Allows you to set the alpha for an image, making it more or less transparent. An alpha of 1.0 is fully opaque, and an alpha of 0.0 is fully transparent. The default alpha for an image is 1.0. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetAlpha (
   HIViewRef inView,
   float inAlpha
){
printf ("HIImageViewSetAlpha",inView,inAlpha);
};

/*HIImageViewSetScaleToFit

Specifies whether an image should scale or clip to the view’s bounds.

OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
);
Parameters
inView

The image view.
inScaleToFit

A Boolean whose value is true to indicate that the image should be scaled to fit the view bounds or false to indicate that the image should clip to the view’s bounds.
Return Value

An operating system status code.
Discussion

Normally, an image view clips to the view’s bounds. Use this function to tell the image view to size the image to fit into the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewSetScaleToFit (
   HIViewRef inView,
   Boolean inScaleToFit
){
printf ("HIImageViewSetScaleToFit",inView,inScaleToFit);
};


/*HIViewConvertPoint

Converts a point’s coordinates from one view to another.

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
);
Parameters
ioPoint

The point to convert. 
inSourceView

The view whose coordinate system ioPoint is starting out in. You can pass NULL to indicate that ioPoint is a window-relative point.
inDestView

The view whose coordinate system ioPoint should end up in. You can pass NULL to indicate that ioPoint is a window-relative point.
Return Value

An operating system result code.
Discussion

Both views must have a common ancestor, that is, they must both be in the same window.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewConvertPoint (
   HIPoint* ioPoint,
   HIViewRef inSourceView,
   HIViewRef inDestView
){
printf ("HIViewConvertPoint",*ioPoint,inSourceView,inDestView);
};

/*HIViewSetFrame

Sets the frame of a view. 

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
);
Parameters
inView

The view whose frame is to be set.
inRect

The new frame to set.
Return Value

An operating system result code.
Discussion

This function effectively moves the view within its parent. It also marks the view (and anything that was exposed behind it) to be redrawn. 
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewSetFrame (
   HIViewRef inView,
   const HIRect* inRect
){
printf ("HIViewSetFrame",inView,*inRect);
};


/*HiewMoveBy

Move a view by the specified distance relative to its current location. 

OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
);
Parameters
inView

The view you want to move.
inDX

The horizontal distance to move the view. Negative values move the view to the left, positive values to the right.
inDY

The vertical distance to move the view. Negative values move the view up, positive values down.
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewMoveBy (
   HIViewRef inView,
   float inDX,
   float inDY
){
printf ("HIViewMoveBy",inView,inDX,inDY);
};

/*HIViewGetFirstSubview

Returns the first subview of a parent view. 

HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
);
Parameters
inView

The view whose subview you are fetching.
Return Value

An HIView reference, or NULL if this view has no subviews or is invalid.
Discussion

Returns the first subview of a container. The first subview is the topmost subview in z-order. 
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetFirstSubview (
   HIViewRef inView
){
printf ("HIViewGetFirstSubview",inView);
};

/*HIViewGetNextView

Returns the view behind the specified view.

HIViewRef HIViewGetNextView (
   HIViewRef inView
);
Parameters
inView

The view to use as reference.
Return Value

An HIView reference, or NULL if this view has no view behind it or is invalid.
Discussion

Returns the view after the specified view, in z-order.
Availability
Available in Mac OS X v10.2 and later.*/
HIViewRef HIViewGetNextView (
   HIViewRef inView
){
printf ("HIViewGetNextView",inView);
};

/*HIScrollViewCreate

Creates a scroll view. 

OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
);
Parameters
inOptions

Options for our scroll view. You must specify either a horizontal or a vertical scroll bar. If neither is passed, an error is returned. For possible values, see “Scroll View Constants”.
outView

The new scroll view. 
Return Value

An operating system result code.
Discussion

This view has three parts. It can have a horizontal scroll bar, a vertical scroll bar, and a view to be scrolled that must be added by calling HIViewAddSubview. The added scroll view integrates itself automatically and appropriately.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIScrollViewCreate (
   OptionBits inOptions,
   HIViewRef* outView
){
printf ("HIScrollViewCreate",inOptions,*outView);
};


/*HIViewGetFrame

Obtains the frame bounds of a view. 

OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
);
Parameters
inView

The view whose frame you want to obtain.
outRect

The frame of the view.
Return Value

An operating system result code.
Discussion

The frame bounds is the bounds of a view relative to its parent’s local coordinate system. 
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetFrame (
   HIViewRef inView,
   HIRect* outRect
){
printf ("HIViewGetFrame",inView,*outRect);
};

/*HIViewGetLayoutInfo

Obtains the layout information of an view. 

OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
);
Parameters
inOptions

The view whose layout information is to be obtained.
outLayoutInfo

A pointer to an HILayoutInfo into which to copy the view’s layout information. If the version field of this structure is not valid, the call will fail.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewGetLayoutInfo (
   HIViewRef inView,
   HILayoutInfo * outLayoutInfo
){
printf ("HIViewGetLayoutInfo",inView,*outLayoutInfo);
};

/*HIViewPlaceInSuperviewAt

Places a view at an absolute location within its parent. 

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view you want to position.
inX

The absolute horizontal coordinate at which to position the view. 
inY

The absolute vertical coordinate at which to position the view. 
Return Value

An operating system result code.
Discussion

This function affects the view’s frame but does not affect the view’s bounds.
Availability
Available in Mac OS X v10.2 and later.*/

OSStatus HIViewPlaceInSuperviewAt (
   HIViewRef inView,
   float inX,
   float inY
){
printf ("HIViewPlaceInSuperviewAt",inView,inX,inY);
};

/*HIViewSetNeedsDisplayInShape

Uses a shape to mark a portion of a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
);
Parameters
inView

The view having a shape that is to be marked as dirty (needs to be redrawn) or clean (valid and not needing to be redrawn).
inArea

The area, in view-relative coordinates, that is to be marked.
inNeedsDisplay

A Boolean whose value is true to mark the area described by inArea as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken. The area specified by inArea is intersected with the view’s visible region.
Availability
Available in Mac OS X v10.4 and later.*/

OSStatus HIViewSetNeedsDisplayInShape (
HIViewRef inView,
HIShapeRef inArea,
Boolean inNeedsDisplay
){
printf ("HIViewSetNeedsDisplayInShape",inView,inArea,inNeedsDisplay);
};

/*HIViewCopyText

Copies the text of a view.

CFStringRef HIViewCopyText (
HIViewRef inView
);
Parameters
inView

The view whose text is to be copied.
Return Value

A CFString containing a copy of the view’s text. The caller is responsible for releasing the CFString.
Discussion

This function attempts to copy the text that is displayed when drawing the view and is generally successful on views that handle the kControlEditTextCFStringTag GetControlData tag. If this function can’t copy that text, it copies the text in the view’s title instead.
Availability
Available in Mac OS X v10.4 and later.*/

CFStringRef HIViewCopyText (
HIViewRef inView
){
printf ("HIViewCopyText",inView);
};

/*HIViewSetBoundsOrigin

Sets the origin of the view.

OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
);
Parameters
inView

The view whose origin you wish to adjust. 
inX

The X coordinate. 
inY

The Y coordinate. 
Return Value

An operating system result code.
Discussion

This effectively also moves all subcontrols of a view as well. This call will not invalidate the view, in case you might want to move the contents with HIViewScrollRect instead of redrawing the complete content.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetBoundsOrigin (
   HIViewRef inView,
   float inX,
   float inY
){
printf ("HIViewSetBoundsOrigin",inView,inX,inY);
};

/*HIViewGetWindow

Obtains a reference to the window to which the specified view is bound.

WindowRef HIViewGetWindow (
   HIViewRef inView
);
Parameters
inView

The view to query.
Return Value

An operating system result code, or NULL if the view reference specified by inView is invalid or if the view is not bound to any window.
Availability
Available in Mac OS X v10.3 and later.*/
WindowRef HIViewGetWindow (
   HIViewRef inView
){
printf ("HIViewGetWindow",inView);
};

/*HIViewRender

Renders the invalid portions of a view.

OSStatus HIViewRender (
HIViewRef inView
);
Parameters
inView

The view that is to be rendered.
Return Value

An operating system result code.
Discussion

Normally, areas are redrawn at event loop time, but there might be times when an immediate redraw is needed. You should call this function sparingly because it does a fully composited redraw for the area of the view. That is, all other views that intersect the area of the specified view are also redrawn. Calling this function for several views at a particular level of a hierarchy would be costly, so you should only pass the root view of a window to this function.

The behavior of this function when passed a non-root view changed in Mac OS X v10.4. In Mac OS X v10.3, when called on a non-root view, this function validated all of the views in the window that intersect the specified view, including portions that did not intersect the specified view. Consequently, all of the views were not actually redrawn. In Mac OS X v10.4, when called on a non-root view, this function only validates those portions of each view that intersect the specified view.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewRender (
HIViewRef inView
){
printf ("HIViewRender",inView);
};

/*HIViewGetEventTarget

Returns the EventTargetRef for the specified view.

EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
);
Parameters
inImage

The view for which the EventTargetRef should be returned.
Return Value

The EventTargetRef.
Discussion

Once you obtain this reference, you can install an event handler and send events to the target.
Availability
Available in Mac OS X v10.4 and later.*/
EventTargetRef HIViewGetEventTarget (
   HIViewRef inView
){
printf ("HIViewGetEventTarget",inView);
};

/*HIViewRemoveFromSuperview

Removes a view from its parent.

OSStatus HIViewRemoveFromSuperview (
   HIViewRef inView
);
Parameters
inView

The view to remove.
Return Value

An operating system result code.
Discussion

The subview that is removed from the parent is not released and still exists.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewRemoveFromSuperview (
   HIViewRef inView
){
printf ("HIViewRemoveFromSuperview",inView);
};

/*HIViewChangeFeatures

Changes the features of a view.

OSStatus HIViewChangeFeatures (
   HIViewRef inView,
   HIViewFeatures * inFeaturesToSet,
   HIViewFeatures inFeaturesToClear
);
Parameters
inView

The view whose features are to be changed.
inFeaturesToSet

The features that are to be set. For details, see “HIView Feature Constants”.
inFeaturesToClear

The features that are to be cleared. For details, see “HIView Feature Constants”.
Return Value

An operating system result code.
Discussion

The view itself typically controls its features. For example, the view might decide that under some situations it is opaque and in others it is transparent. In general entities outside of the view itself should not call this function. The only exception might be user-interface building tools that want to make sure a view always responds to clicks, for example, so it could override mouse tracking to drag items.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HIViewChangeFeatures (
   HIViewRef inView,
   HIViewFeatures * inFeaturesToSet,
   HIViewFeatures inFeaturesToClear
){
printf ("HIViewChangeFeatures",inView,*inFeaturesToSet,inFeaturesToClear);
};

/*HIViewSetZOrder

Changes the front-to-back ordering of sibling views.

OSStatus HIViewSetZOrder (
   HIViewRef inView,
   HIViewZOrderOp inOp,
   HIViewRef inOther
);
Parameters
inView

The view whose Z-order you want to change.
inOp

Causes inView to be ordered above or below inOther. For possible values, see “HIView Z-Ordering Constants”.
inOther

Another optional view to use as a reference. Pass NULL to indicate an absolute position.
Return Value

An operating system result code.
Discussion

For example, passing kHIViewZOrderAbove as the value on inOp and NULL as the value of inOther moves a view to the front of all of its siblings. Passing kHIViewZOrderBelow as the value of inOp and NULL as the value of inOther moves a view to the back of all its siblings.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetZOrder (
   HIViewRef inView,
   HIViewZOrderOp inOp,
   HIViewRef inOther
){
printf ("HIViewSetZOrder",inView,inOp,inOther);
};

/*HIViewSetCommandID

Sets the command ID of a view.

OSStatus HIViewSetCommandID (
HIViewRef inView,
UInt32 inCommandID
);
Parameters
inView

The view whose command ID is to be set.
inID

The command ID to set.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetCommandID (
HIViewRef inView,
UInt32 inCommandID
){
printf ("HIViewSetCommandID",inView,inCommandID);
};

/*HIComboBoxCreate

Creates a combo box control.

OSStatus HIComboBoxCreate (
   const HIRect* boundsRect,
   CFStringRef text,
   const ControlFontStyleRec* style,
   CFArrayRef list,
   OptionBits inAttributes,
   HIViewRef* outComboBox
);
Parameters
boundsRect

The bounding box of the control.
text

The default text in the editable portion of the control. Can be NULL.
style

The font style of the both editable text and the text in the disclosure list. Can be NULL.
list

The default values available in the disclosure list. Can be NULL.
inAttributes

The default attributes of the combo box. For possible values, see “Combo Box Attributes”.
outComboBox

On exit, a pointer to a reference for the new control.
Discussion

The combo box can be used in compositing mode, as well as traditional Control Manager mode. When created, this view is invisible. To see the view, you must show the view by calling HIViewSetVisible.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIComboBoxCreate (
   const HIRect* boundsRect,
   CFStringRef text,
   const ControlFontStyleRec* style,
   CFArrayRef list,
   OptionBits inAttributes,
   HIViewRef* outComboBox
){
printf ("HIComboBoxCreate",*boundsRect,text,*style,list,inAttributes,*outComboBox);
};

/*HISearchFieldCreate

Creates a Search field control.

OSStatus HISearchFieldCreate (
   const HIRect * inBounds,
   OptionBits inAttributes,
   MenuRef inSearchMenu,
   CFStringRef inDescriptiveText,
   HIViewRef * outRef
);
Parameters
inBounds

The initial bounds of the view, or NULL. If this parameter is NULL, the view is created with empty bounds ( 0, 0, 0, 0 ).
inAttributes

The initial attributes of the search field. Indicates whether the field should contain the Cancel icon. For possible values, see “Search Field Attribute Constants”.
inSearchMenu

The menu to be associated with this search field, or NULL. If inSearchMenu is non-NULL, the menu will be retained by the search field and the Search icon will be enabled in the left side of the text field. If this parameter is NULL, the view will not display the Search icon in the left portion of the text field. You are expected to install handlers on this menu to handle the visual appearance of the menu (for example, to draw check marks or enable items when the menu receives the kEventMenuEnableItems Carbon event), and to keep track of what action should be performed by associating HICommands with each menu item and installing a handler for the kEventClassCommand /kEventCommandProcess Carbon event.
inDescriptiveText

The text to be displayed in the text field when the field does not have focus and contains no user-entered text, or NULL. This text should indicate the search criteria. For example, you may want to identify to the user that the search will cover the “Subject” or “Contents” of a selected range of items. If inDescriptiveText is non-NULL, the text will be retained by the search field.
outRef

On return, a reference for the new view.
Return Value

An operating system result code.
Discussion

This view is designed to be used by applications that provide searching functionality. Visually, it is a standard text field optionally adorned with a Search icon on the left and a Cancel image on the right. The new control is initially invisible.

When the user accepts the text by pressing the Return or Enter key, a Carbon event of kEventClassTextField / kEventTextAccepted is sent to the control to indicate that the search should begin. This control also responds to all of the standard control tags used by the EditUnicodeText control.
Availability
Available in Mac OS X v10.3 and later.*/
OSStatus HISearchFieldCreate (
   const HIRect * inBounds,
   OptionBits inAttributes,
   MenuRef inSearchMenu,
   CFStringRef inDescriptiveText,
   HIViewRef * outRef
){
printf ("HISearchFieldCreate",*inBounds,inAttributes,inSearchMenu,inDescriptiveText,*outRef);
};

/*HIViewScrollRect

Scrolls a view’s contents, or a portion thereof. 

OSStatus HIViewScrollRect (
   HIViewRef inView,
   const HIRect* inRect,
   float inDX,
   float inDY
);
Parameters
inView

The view to scroll. 
inRect

The rect to scroll. Pass NULL to mean the entire view. The rect passed cannot be bigger than the view's bounds. It must be in the local coordinate system of the view. 
inDX

The horizontal distance to scroll. Positive values shift to the right, negative values shift to the left. 
inDY

The vertical distance to scroll. Positive values shift downward, negative values shift upward. 
Return Value

An operating system result code.
Discussion

This function blits the contents of the view as appropriate to scroll and then invalidates those portions that need to be redrawn. Be warned that this is a raw bit scroll. Anything that overlaps the target view will be scrolled as well.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewScrollRect (
   HIViewRef inView,
   const HIRect* inRect,
   float inDX,
   float inDY
){
printf ("HIViewScrollRect",inView,*inRect,inDX,inDY);
};

/*HIViewSetNeedsDisplayInRect

Uses an HIRect to mark a portion of a view as needing or not needing to be redrawn.

OSStatus HIViewSetNeedsDisplayInRect (
HIViewRef inView,
const HIRect * inRect,
Boolean inNeedsDisplay
);
Parameters
inView

The view having a region that is to be marked as dirty (needs to be redrawn) or clean (valid and not needing to be redrawn).
inRect

The area, in view-relative coordinates, that is to be marked.
inNeedsDisplay

A Boolean whose value is true to mark the area described by inRect as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken. The area specified by inRect is intersected with the view’s visible region.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewSetNeedsDisplayInRect (
HIViewRef inView,
const HIRect * inRect,
Boolean inNeedsDisplay
){
printf ("HIViewSetNeedsDisplayInRect",inView,*inRect,inNeedsDisplay);
};

/*HIViewDisposeTrackingArea

Disposes of an existing tracking area.

OSStatus HIViewDisposeTrackingArea (
HIViewTrackingAreaRef inArea
);
Parameters
inArea

The tracking area that is to be disposed of.
Return Value

An operating system result code.
Discussion

All tracking areas attached to a view are automatically disposed of when the view is disposed of, so you don’t need to dispose of a tracking area explicitly unless you want to remove it from a view before the view is disposed of.

After you call this function, the reference is invalid.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HIViewDisposeTrackingArea (HIViewTrackingAreaRef inArea){
printf ("HIViewDisposeTrackingArea",inArea);
};

/*HICreateTransformedCGImage

Creates a new Core Graphics image with the standard selected or disabled appearance.

OSStatus HICreateTransformedCGImage (
   CGImageRef inImage,
   OptionBits inTransform,
   CGImageRef * outImage
);
Parameters
inImage

The original image.
inTransform

The transformation to apply to the image. For possible values, see “Transformation Constants”.
outImage

A pointer to a value of type CGImageRef that, on return, contains the new image. You are responsible for releasing the image.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.4 and later.*/
OSStatus HICreateTransformedCGImage (
   CGImageRef inImage,
   OptionBits inTransform,
   CGImageRef * outImage
){
printf ("HICreateTransformedCGImage",inImage,inTransform,*outImage);
};

/*HIViewSimulateClick

Simulates a mouse click on a given view.

OSStatus HIViewSimulateClick (
   HIViewRef inView,
   HIViewPartCode inPartToClick,
   UInt32 inModifiers,
   ControlPartCode* outPartClicked
);
Parameters
inView

The view to test the part hit.
inPartToClick

The part the view should consider to be clicked. 
inModifiers

The modifiers the view can consider for its click action. 
outPartClicked

The part that was hit; can be kHIViewNoPart if no action occurred. For possible values, see “HIViewPartCode Constants”. Pass NULL if you don’t need the part code returned.
Return Value

An operating system result code.
Discussion

This function is used to simulate a mouse click on a given view. It sends a kEventControlSimulateHit event to the specified view and also sends kEventControlHit and (if the Hit event is not handled) kEventCommandProcess events.

Note that not all windows respond to the events that this API sends. A fully Carbon-event-based window most likely responds exactly as if the user had really clicked in the view. A window that uses Classic event record-based APIs (WaitNextEvent or ModalDialog) typically does not respond at all. To simulate a click in such a window, you may need to post a mouse-down/mouse-up pair or use a Dialog Manager event filter proc to simulate a hit in a dialog item.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSimulateClick (
   HIViewRef inView,
   HIViewPartCode inPartToClick,
   UInt32 inModifiers,
   ControlPartCode* outPartClicked
){
printf ("HIViewSimulateClick",inView,inPartToClick,inModifiers,*outPartClicked);
};

/*HIViewSetNeedsDisplayInRegion

Uses a region to mark a portion of a view as needing or not needing to be redrawn. 

OSStatus HIViewSetNeedsDisplayInRegion (
HIViewRef inView,
RgnHandle inRgn,
Boolean inNeedsDisplay
);
Parameters
inView

The view having a region that is to be marked as dirty (needs to be redrawn) or clean (valid and not needing to be redrawn).
inRgn

The region, in view-relative coordinates, to mark as dirty or clean.
inNeedsDisplay

A Boolean whose value is true to mark the region described by inRgn as dirty or false to mark it as clean.
Return Value

An operating system result code.
Discussion

If the view is not visible or is obscured completely by other views, no action is taken. The specified region is effectively intersected with the view’s visible region.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewSetNeedsDisplayInRegion (
HIViewRef inView,
RgnHandle inRgn,
Boolean inNeedsDisplay
){
printf ("HIViewSetNeedsDisplayInRegion",inView,inRgn,inNeedsDisplay);
};



/*Standard View Constants

Specify IDs of views that are commonly used. 

   
const HIViewID kHIViewWindowContentID;
const HIViewID kHIViewWindowGrowBoxID;
const HIViewID kHIViewMenuContentID;
Constants
kHIViewWindowContentID

The standard view ID for the content view of a window.

Available in Mac OS X v10.2 and later.
kHIViewWindowGrowBoxID

The standard view ID for the grow box view of a window. Not all windows have grow boxes, so you might not find this view if you look for it.

Available in Mac OS X v10.2 and later.
kHIViewMenuContentID

The standard view ID for the content view of a menu. The Menu Manager assigns this view ID to all menu content views.

Available in Mac OS X v10.3 and later.*/
 const HIViewID kHIViewWindowContentID;
 const HIViewID kHIViewWindowGrowBoxID;
 const HIViewID kHIViewMenuContentID;

/*HIViewGetIndexedSubview

Obtains the subview of a view by index.

CFIndex HIViewGetIndexedSubview (
   HIViewRef inView,
   CFIndex inSubviewIndex,
   HIViewRef * outSubview
);
Parameters
inView

The view whose indexed subview is being requested.
inSubviewIndex

The index of the requested subview.
outSubview

A pointer to an HIViewRef that, on return, represents the indexed subview.
Return Value

The number of subviews for the specified view.
Discussion

Instead of calling HIViewGetIndexedSubview repeatedly, it may be more efficient to iterate through the subviews of a view with calls to HIViewGetFirstSubview and HIViewGetNextView.
Availability
Available in Mac OS X v10.4 and later.*/
CFIndex HIViewGetIndexedSubview (
   HIViewRef inView,
   CFIndex inSubviewIndex,
   HIViewRef * outSubview
){
printf ("HIViewGetIndexedSubview",inView,inSubviewIndex,*outSubview);
};

/*HIViewGetFocusPart

Obtains the part in the specified view that currently has focus. 

OSStatus HIViewGetFocusPart (
   HIViewRef inView,
   HIViewPartCode * outFocusPart
);
Parameters
inView

The view to inquire about. 
outFocusPart

The part that currently has focus. For more information, see “HIViewPartCode Constants”.
Return Value

An operating system result code.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIViewGetFocusPart (
   HIViewRef inView,
   HIViewPartCode * outFocusPart
){
printf ("HIViewGetFocusPart",inView,*outFocusPart);
};

/*HIImageViewCreate

Creates an image view.

OSStatus HIImageViewCreate (
   CGImageRef inImage,
   ControlRef * outControl
);
Parameters
inImage

An initial image, or NULL. You can use SetControlData to set the image later.
outControl

The new image view. 
Return Value

An operating system result code.
Discussion

The view responds to the scrollable interface and can be used in a scrolling view. You can pass an image initially, or set one later.
Availability
Available in Mac OS X v10.2 and later.*/
OSStatus HIImageViewCreate (
   CGImageRef inImage,
   ControlRef * outControl
){
printf ("HIImageViewCreate",inImage,*outControl);
};

