#include <HIToolbox/HIToolbox.h>

/*RunApplicationEventLoop

Runs the application event loop.

void RunApplicationEventLoop ();
Discussion

This function is used as the main event loop for a Carbon Event-based application. Once entered, this function waits for events to arrive and dispatches them to your event handlers automatically. 

Note that calling RunApplicationEventLoop also installs the standard application handler, which provides standard handler responses for menu and application events. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void RunApplicationEventLoop (){
printf ("RunApplicationEventLoop");
};

/*GetControlEventTarget

Obtains the event target reference for the specified control.

EventTargetRef GetControlEventTarget (
   ControlRef inControl
);
Parameters
inControl

The control to return the target for. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetControlEventTarget (
   ControlRef inControl){
printf ("GetControlEventTarget",inControl);
};


/*CreateTypeStringWithOSType

Converts an OSType string to a Core Foundation string. 

CFStringRef CreateTypeStringWithOSType (
   OSType inType
);
Return Value

The Core Foundation string version of the OSType string. A return value of NULL indicates that an error occurred. See the Base Services documentation for a description of the CFStringRef data type.
Discussion

You can use this function to create CFString versions of OSType data types to pass to the Services Manager. As this is a creation function, you must call CFRelease on your Core Foundation string when you no longer need it. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEvents.h*/

CFStringRef CreateTypeStringWithOSType (
   OSType inType
){
printf ("CreateTypeStringWithOSType",inType);
};

/*TrackMouseLocationWithOptions

Tracks the mouse with additional options. 

OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
);
Parameters
inPort

The graphics port (GrafPort) to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in global coordinates. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
inOptions

The only option supported by this function at present is the option to have the toolbox leave mouse up events in the queue, rather than pulling them (which is the default). See “Mouse Tracking Option Constant” for more information. 
inTimeout

The amount of time to wait for an event. If no events arrive within this time, kMouseTrackingTimedOut is returned in outResult. 
outPt

On return, a pointer to the mouse location from the last mouse event that caused this function to exit. If a timeout or key modifiers changed event caused this function to exit, the current mouse position at the time is returned.
outModifiers

On return, a pointer to the most recent state of the keyboard modifiers.
outResult

On return, a pointer to a value indicating the kind of event that caused the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”. 
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocationWithOptions (
   GrafPtr inPort,
   OptionBits inOptions,
   EventTimeout inTimeout,
   Point * outPt,
   UInt32 * outModifiers,
   MouseTrackingResult * outResult
){
printf ("TrackMouseLocationWithOptions",inPort,inOptions,inTimeout,*outPt,*outModifiers,*outResult);
};

/*ReleaseMouseTrackingRegion

Releases a mouse tracking region. (Deprecated in Mac OS X v10.4. Use HIViewDisposeTrackingArea instead.)

OSStatus ReleaseMouseTrackingRegion (
   MouseTrackingRef inMouseRef
);
Parameters
inMouseRef

The mouse tracking region to release. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

ReleaseMouseTrackingRegion decreases the reference count for the region. If the reference count drops to zero, the mouse tracking region is disposed. 
Special Considerations

Tracking areas are HIView-based rather than window-based. HIViews support compositing and Quartz, and provide a much easier way to handle user elements in windows. For more details about tracking areas, see the mouse tracking region section in Carbon Event Manager Programming Guide. For details about HIViews, see HIView Programming Guide.
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.
Declared In
CarbonEvents.h*/
OSStatus ReleaseMouseTrackingRegion (
   MouseTrackingRef inMouseRef
){
printf ("ReleaseMouseTrackingRegion",inMouseRef);
};


/*UnregisterEventHotKey

Unregisters a global hot key. 

OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey
);
Parameters
inHotKey

The event hot key reference of the hot key you want to unregister. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Unregisters a global hot key that was previously registered with the function RegisterEventHotKey. You do not need to unregister a hot key when your application terminates; the system takes care of that for you. You can use this function if the user changes a hot key for something in your application—you would unregister the previous key and register your new key. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus UnregisterEventHotKey (
   EventHotKeyRef inHotKey){
printf ("UnregisterEventHotKey",inHotKey);
};


/*GetWindowEventTarget

Obtains the event target reference for a specified window. 

EventTargetRef GetWindowEventTarget (
   WindowRef inWindow
);
Parameters
inWindow

The window to return the event target for. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install an event handler on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetWindowEventTarget (
   WindowRef inWindow){
printf ("GetWindowEventTarget",inWindow);
};


/*RegisterEventHotKey

Registers a global hot key.

OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef
);
Parameters
inHotKeyCode

The virtual key code of the hot key you want to register. 
inHotKeyModifiers

The keyboard modifiers to look for. In Mac OS X v10.2 and earlier, if you do not specify a modifier key, this function returns paramErr. In Mac OS X v10.3 and later, passing 0 does not cause an error.
inHotKeyID

The application-specified hot key ID. You will receive this ID in the kEventHotKeyPressed event as the direct object parameter. 
inTarget

The target to notify when the hot key is pressed. 
inOptions

Currently unused. You must pass 0.
outRef

On return, a reference to the new hot key. You need this reference if you later wish to unregister it. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function registers a global hot key based on the virtual key code and modifiers you pass in. When the user enters the hot-key combination, a kEventHotKeyPressed event is sent to the target you specified. Only one such combination can exist for the current application (that is, multiple entities in the same application cannot register for the same hot key combination). The same hot key can, however, be registered by multiple applications. This means that multiple applications can potentially be notified when a particular hot key is requested. This might not necessarily be desirable, but it is how it works at present. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RegisterEventHotKey (
   UInt32 inHotKeyCode,
   UInt32 inHotKeyModifiers,
   EventHotKeyID inHotKeyID,
   EventTargetRef inTarget,
   OptionBits inOptions,
   EventHotKeyRef * outRef){
printf ("RegisterEventHotKey",inHotKeyCode,inHotKeyModifiers,inHotKeyID,inOptions,*outRef);
};


/*ConvertEventRefToEventRecord

Converts an event reference into an event record.

Boolean ConvertEventRefToEventRecord (
   EventRef inEvent,
   EventRecord * outEvent
);
Parameters
inEvent

The event reference to convert. 
outEvent

The event record to fill out. See the Event Manager documentation for a description of the EventRecord data type.
Return Value

A Boolean value indicating whether the conversion was successful (true) or not (false). 
Discussion

This function helps you when you need an EventRecord structure and all you have is a Carbon event reference. If the event can be converted, outEvent is filled in and the function returns true. If not, the function returns false and outEvent contains nullEvent.

This function can convert the following events:
kEventMouseDown, kEventMouseUp, kEventMouseMoved, and kEventMouseDragged (kEventClassMouse)
kEventRawKeyDown, kEventRawKeyUp, and kEventRawKeyRepeat (kEventClassKeyboard)
kEventWindowUpdate, kEventWindowActivate, kEventWindowDeactivate, and kEventWindowCursorChange (kEventClassWindow)
kEventAppActivated and kEventAppDeactivate (kEventClassApplication)
kEventAppleEvent (kEventClassAppleEvents)
kEventControlTrack (kEventClassControl) is converted to a mouse down event in Mac OS X v10.4 and later
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
Boolean ConvertEventRefToEventRecord (
   EventRef inEvent,
   EventRecord * outEvent
){
printf ("ConvertEventRefToEventRecord",inEvent,*outEvent);
};

/*IsMouseCoalescingEnabled

Indicates whether mouse coalescing is enabled. 

Boolean IsMouseCoalescingEnabled ();
Return Value

A Boolean whose value is TRUE if mouse coalescing is on; otherwise, FALSE. 
Discussion

If mouse coalescing is enabled, intermediate mouse movement events are merged into the most recent event, so that only one mouse moved or mouse dragged event is in the event queue at any time. For example, when the user moves the mouse across the screen, more mouse moved events are generated than most applications care about. Rather than place all these events in the queue (which would probably slow down the application), the Carbon Event Manager first checks to see if a mouse moved event already exists. If a mouse moved event already exists, that event is updated with the position and delta information from the more recently-generated event. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEvents.h*/
Boolean IsMouseCoalescingEnabled (){
printf ("IsMouseCoalescingEnabled");
};

/*SetMouseCoalescingEnabled

Turns mouse coalescing on or off.

OSStatus SetMouseCoalescingEnabled (
   Boolean inNewState,
   Boolean * outOldState
);
Parameters
inNewState

Pass true to turn mouse coalescing on, false otherwise. 
outOldState

A Boolean value indicating the previous mouse coalescing state (that is, before you called this function to set it). You can use this value if you want to save the previous state for later restoration. If you don’t need this state information, pass NULL. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

See IsMouseCoalescingEnabled for a definition of mouse coalescing. 
Availability
Available in Mac OS X v10.1 and later.
Declared In
CarbonEvents.h*/

OSStatus SetMouseCoalescingEnabled (
   Boolean inNewState,
   Boolean * outOldState
){
printf ("SetMouseCoalescingEnabled",inNewState,*outOldState);
};

/*SetWindowDefaultButton

Specifies a default button for a window.

OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl
);
Parameters
inWindow

The window whose default button you want to set. See the Window Manager documentation for a description of the WindowRef data type.
inControl

The control to designate as the default. See the Control Manager documentation for a description of the ControlRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to specify a control (normally a button) to be the default for a given window. This button would be considered to have been clicked if the user instead presses the Return or Enter keys on the keyboard. 

The standard window event handler looks for keystrokes that correspond to the default button and generates events of type kEventControlHit when it detects the correct key being pressed. This is similar to the way the Dialog Manager responds to default buttons, except that instead of returning an item index for which button is pressed, the Carbon Event Manager generates a control hit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetWindowDefaultButton (
   WindowRef inWindow,
   ControlRef inControl){
printf ("SetWindowDefaultButton",inWindow,inControl);
};

/*GetApplicationEventTarget

Obtains the event target reference for the application.

EventTargetRef GetApplicationEventTarget ();
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetApplicationEventTarget (){
printf ("GetApplicationEventTarget");
};



/*HICopyAccessibilityRoleDescription

Returns the system-defined role description string for a standard role or role-subrole pair.

extern CFStringRef HICopyAccessibilityRoleDescription(
   CFStringRef inRole,
   CFStringRef inSubrole);
Parameters
inRole

The role for which you want the system-defined description. See “Roles” for the role strings you can use.
inSubrole

The subrole for which you want the system-defined description. See “Subroles” for the subrole strings you can use. Pass NULL if your accessible object does not have a subrole.
Return Value

The system-defined description for the role or role-subrole pair. When you are finished with the CFString containing the description, you must use CFRelease to release it. If there is no system-defined role description associated with the role or role-subrole pair you pass in, this function returns NULL. If you pass in an unknown role or an unknown subrole, this function returns NULL.
Discussion

The HICopyAccessibilityRoleDescription function is a convenience function you can use if you have to provide the role description for an accessibility object you create. Instead of hard-coding a role description for an accessibility object, you should use this function to get the current, system-defined role description. This allows you to take advantage of any changes or enhancements Apple might make.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
: CarbonEvents.h*/
CFStringRef HICopyAccessibilityRoleDescription(
   CFStringRef inRole,
   CFStringRef inSubrole){
printf ("HICopyAccessibilityRoleDescription",inRole,inSubrole);
};


/*GetEventMonitorTarget

Obtains an event monitor target.

EventTargetRef GetEventMonitorTarget (
   void
);
Return Value

An event monitor target. 
Discussion

The event monitor target is a special event target used to monitor user input events across all processes. When an event handler is installed on the event monitor target, the Carbon Event Manager examines the EventTypeSpec for user input event types, such as mouse-down, mouse-up, and key-down. It then requests that the WindowServer make copies of any of these events that are sent to any process, and delivers them to the current process. These events are queued into the main thread’s event queue and are sent directly to the event handlers installed on the event monitor target during normal event dispatching. Monitored events are not sent through the normal event dispatching path for the current process. Instead, they pass through the event dispatcher target and are sent directly to the event monitor target.Handlers installed on the event monitor target receive events only when the current application is inactive. When the current application is active, all events flow through the event dispatcher target, and no events are sent to the event monitor target.Currently, the event monitor supports the following event kinds: kEventRawKeyDown, kEventRawKeyUp, kEventRawKeyRepeat, kEventRawKeyModifiersChange, kEventMouseDown, kEventMouseUp, kEventMouseMoved, kEventMouseDragged, kEventMouseWheelMoved, kEventTabletPoint, and kEventTabletProximity.To prevent keyboard events from being passed to other applications, Carbon and Cocoa password-edit-text controls enable a secure input mode while the focus is on the control. Their password-edit-text controls prevent the monitoring event target from being used to capture password keystrokes.For added security, GetEventMonitorTarget requires that “Enable access for assistive devices” be checked in the Universal Access preference pane in order to monitor kEventRawKeyDown, kEventRawKeyUp, and kEventRawKeyRepeat events. If this control is not checked, you can still install handlers for these events on the event monitor target, but no events of these types will be sent to your handler. Administrator privileges are required to enable this feature. You can determine whether this control is checked using the AXAPIEnabled function in AXUIElement.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventMonitorTarget (void){
printf ("GetEventMonitorTarget");
};


/*TrackMouseLocation

Tracks the mouse, blocking your application when there is no activity.

OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
);
Parameters
inPort

The grafport to consider for mouse coordinates. You can pass NULL for this parameter to indicate the current port. The mouse location is returned in terms of local coordinates of this port. See the QuickDraw Manager documentation for a description of the GrafPtr data type.
outPt

On exit, a pointer to the mouse location from the last mouse event that caused this function to exit. 
outResult

On exit, a pointer to a value representing what kind of event was received that cause the function to exit, such as kMouseTrackingMouseReleased. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

Once entered, this function waits for certain mouse events (move, mouse down, mouse up). When one of these events occurs, the function returns and tells the caller what happened and where the mouse is currently located. While there is no activity, the current event loop is run, effectively blocking the current thread (save for any timers that fire). This helps to minimize CPU usage when there is nothing going on. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus TrackMouseLocation (
   GrafPtr inPort,
   Point * outPt,
   MouseTrackingResult * outResult
){
printf ("TrackMouseLocationWithOptions",inPort,*outPt,*outResult);
};


/*QuitApplicationEventLoop

Terminates the application event loop.

void QuitApplicationEventLoop ();
Discussion

This function is used to quit the RunApplicationEventLoop function. Typically, your application doesn’t need to call this. If your application has the Quit menu item tagged with the kHICommandQuit menu command ID, the toolbox will automatically call this for your application, automatically terminating your event loop. If your application wants to do pre-processing before the event loop exits, it should intercept either the kHICommandQuit menu command, or the kEventAppQuit event. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
void QuitApplicationEventLoop (){
printf ("QuitApplicationEventLoop");
};

/*RunAppModalLoopForWindow

Puts the window in an application-modal state. 

OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window you wish to behave modally. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used as a replacement for the Dialog Manager function ModalDialog to drive a Carbon Event-based modal dialog. Once called, this function will not exit until QuitAppModalLoopForWindow is called. 

While in the modal state, the standard toolbox dispatcher processes events only for the modal window and any that are above it (that is, closer to the front). This feature allows you to create stacked modal dialogs, if desired. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus RunAppModalLoopForWindow (
   WindowRef inWindow
){
printf ("RunAppModalLoopForWindow",inWindow);
};




/*QuitAppModalLoopForWindow

Quits the application-modal state for a window. 

OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
);
Parameters
inWindow

The window that is leaving the modal state. See the Window Manager documentation for a description of the WindowRef data type.
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

This function is used to quit a currently running call to RunAppModalLoopForWindow (that is, it terminates a modal loop). Typically you call this from a handler you have installed on the modal window in question when the user clicks the appropriate button (Ok, Cancel, and so on). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus QuitAppModalLoopForWindow (
   WindowRef inWindow
){
printf ("QuitAppModalLoopForWindow",inWindow);
};

/*GetMenuEventTarget

Obtains an event target reference for the specified menu. 

EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
);
Parameters
inMenu

The menu to return the target for. See the Menu Manager documentation for a description of the MenuRef data type.
Return Value

An event target reference. 
Discussion

Once you obtain this reference, you can send events to the target and install event handlers on it. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetMenuEventTarget (
   MenuRef inMenu
){
printf ("GetMenuEventTarget",inMenu);
};


/*GetUserFocusWindow

Returns the current user focus window.

WindowRef GetUserFocusWindow ();
Return Value

A reference to the window receiving user focus. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Discussion

This function returns a reference to the current user focus window. This window receives menu commands and keyboard input as part of the standard event dispatching. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
WindowRef GetUserFocusWindow (){
printf ("GetUserFocusWindow");
};

/*ProcessHICommand

Sends a command to the command chain.

OSStatus ProcessHICommand (
   const HICommand * inCommand
);
Return Value

A result code. See “Carbon Event Manager Result Codes”
Discussion

ProcessHICommand is a convenience function for sending a “process command” event through the command chain (for example, from menu to user focus to application). The command event is sent initially to either a menu (if the command represents a menu command) or the current user focus. If the function returns eventNotHandledErr, the command was not handled by any element in the chain. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/

OSStatus ProcessHICommand (
   const HICommand * inCommand
){
printf ("ProcessHICommand",*inCommand);
};



/*GetEventDispatcherTarget

Obtains the event target reference for the standard toolbox dispatcher.

EventTargetRef GetEventDispatcherTarget ();
Return Value

An event target reference. 
Discussion

The standard toolbox dispatcher is the default mechanism for dispatching events to the appropriate event targets. You typically don’t need to call this, but some applications may need to pick events off the event queue and call the dispatcher themselves. This allows you to do just that instead of calling RunApplicationEventLoop to handle it all.

If desired, you can attach event handlers to the event dispatcher target. Doing so allows you to intercept any events before they can be sent to the appropriate event targets. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
EventTargetRef GetEventDispatcherTarget (){
printf ("GetEventDispatcherTarget");
};


/*AXUIElementGetIdentifier

Gets the unique identifier associated with an accessibility object. 

void AXUIElementGetIdentifier (
   AXUIElementRef inHIAccObj,
   UInt64 *outIdentifier);
Parameters
inHIAccObj

The accessibility object whose identifier you want to get. 
outIdentifier

A pointer to a 64-bit integer. On return, outIdentifier contains the accessibility object’s identifier. If inHIAccObj is not a valid accessibility object, this function returns 0. Note that 0 is a valid identifier value, so you should not assume that inHIAccObj is invalid if you receive a 0 result. 
Discussion

If you create your own accessibility objects to represent custom user interface elements or subviews, you can use the identifier this function returns to identify which accessibility object is being referenced.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CarbonEvents.h*/
void AXUIElementGetIdentifier (
   AXUIElementRef inHIAccObj,
   UInt64 *outIdentifier){
printf ("AXUIElementGetIdentifier",inHIAccObj,*outIdentifier);
};


/*AXUIElementCreateWithHIObjectAndIdentifier

Creates an accessibility object that represents a user interface element.

AXUIElementRef AXUIElementCreateWithHIObjectAndIdentifier(
   HIObjectRef inHIObject,
   UInt64 inIdentifier);
Parameters
inHIObject

A reference to the user interface element this accessibility object represents. You must pass one of the following reference types: WindowRef, ControlRef, MenuRef, or an HIObjectRef.
inIdentifier

A 64-bit identifier to uniquely identify the accessibility object within the user interface element. Pass 0 to indicate the base object identified by the inHIObject parameter. 
Return Value

The newly created accessibility object. 
Discussion

If the accessibility object represents part of the substructure of a user interface element, then you must assign it a unique, nonzero identifier value. If the accessibility object represents a complex user interface object as a whole, you must give it the identifier value 0. For example, a segmented view containing five buttons can have six accessibility objects associated with it: 
The segmented view as a whole, identified by its control reference (ControlRef) and identifier value 0. 
The five button elements, identified by the segmented view reference and identifiers 1 through 5, respectively. 

The accessibility object is a CFTypeRef object. You can use CFEqual to compare two accessibility objects. You must call CFRelease on the accessibility object when you no longer need it. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CarbonEvents.h*/

AXUIElementRef AXUIElementCreateWithHIObjectAndIdentifier(
   HIObjectRef inHIObject,
   UInt64 inIdentifier){
printf ("AXUIElementCreateWithHIObjectAndIdentifier",inHIObject,inIdentifier);
};


//work


/*CreateMouseTrackingRegion

Creates a mouse tracking region. (Deprecated in Mac OS X v10.4. Use the HIView function HIViewNewTrackingArea instead.)

   OSStatus CreateMouseTrackingRegion(
   WindowRef inWindow,
   RgnHandle inRegion,
   RgnHandle inClip,
   MouseTrackingOptions inOptions,
   MouseTrackingRegionID inID,
   void * inRefCon,
   EventTargetRef inTargetToNotify,
   MouseTrackingRef * outTrackingRef
);
Parameters
inWindow

The window to contain the tracking region.
inRegion

The region for which you want to receive mouse entered/exited events. 
inClip

The clip region for the inRegion region (can be NULL). 
inOptions

Tracking options that define whether the inRegion region is in local or global coordinates. 
inID

A signature and ID to uniquely define this tracking region. See MouseTrackingRegionID for information about the structure of this ID. 
inRefCon

A pointer to an application-defined value. You can obtain this value by calling GetMouseTrackingRegionRefCon.
inTargetToNotify

The event target to send the mouse tracking event. If you pass NULL, the event target is the owning window specified in inWindow. 
outTrackingRef

On return, a pointer to the new mouse tracking region. 
Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

CreateMouseTrackingRegion allows you to define regions in your window, and the specified event target is notified (using kEventMouseEntered or kEventMouseExited events) when the mouse cursor interacts with the region. Your application can define any number of regions as long as each has a unique ID. This function is especially useful for creating rollover effects without having to constantly poll the mouse. 

If you need to keep track of the state of the mouse (down or up) in a region, you should use TrackMouseRegion, either instead of, or in conjunction with, mouse tracking regions. 
Special Considerations

Tracking areas are HIView-based rather than window-based. HIViews support compositing and Quartz, and provide a much easier way to handle user elements in windows. For more details about tracking areas, see the mouse tracking region section in Carbon Event Manager Programming Guide. For details about HIViews, see HIView Programming Guide.
Availability
Available in Mac OS X v10.2 and later.
Deprecated in Mac OS X v10.4.*/
   OSStatus CreateMouseTrackingRegion(
   WindowRef inWindow,
   RgnHandle inRegion,
   RgnHandle inClip,
   MouseTrackingOptions inOptions,
   MouseTrackingRegionID inID,
   void * inRefCon,
   EventTargetRef inTargetToNotify,
   MouseTrackingRef * outTrackingRef
){};


/*SetUserFocusWindow

Designates a window to receive user focus.

OSStatus SetUserFocusWindow (
   WindowRef inWindow
);

Return Value

A result code. See “Carbon Event Manager Result Codes”.
Discussion

You can use this function to assign user focus to a specified window. This tells the Carbon Event Manager to route events that should go to the user focus (for example, commands and keyboard events) to the specified window. This can be used, for example, to route keyboard events to a floating palette, since floating palettes do not normally receive user focus.

Setting focus automatically defocuses whatever element formerly had user focus. 

If you pass kUserFocusAuto in the inWindow parameter, the system picks the best candidate for user focus. If you temporarily change the focus to a special window, you should use this option to restore the focus rather than setting the focus to an explicit window. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CarbonEvents.h*/
OSStatus SetUserFocusWindow (
   WindowRef inWindow
){};



