#import <Foundation/NSDateFormatter.h>
#import <ADD/Foundation/NSDateFormatter.h>
//work
 @implementation NSDateFormatter(ADD)
/*setDefaultFormatterBehavior:

Sets the default formatting behavior for instances of the class.

+ (void)setDefaultFormatterBehavior:(NSDateFormatterBehavior)behavior
Parameters
behavior

The default formatting behavior for instances of the class. For possible values, see NSDateFormatterBehavior.
Availability
Available in Mac OS X v10.4 and later.
See Also
+ defaultFormatterBehavior
– formatterBehavior
– setFormatterBehavior:*/
+ (void)setDefaultFormatterBehavior:(NSDateFormatterBehavior)behavior{}

/*setTimeStyle:

Sets the time style of the receiver.

- (void)setTimeStyle:(NSDateFormatterStyle)style
Parameters
style

The time style for the receiver. For possible values, see NSDateFormatterStyle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– timeStyle*/
- (void)setTimeStyle:(NSDateFormatterStyle)style{}


/*setDateStyle:

Sets the date style of the receiver.

- (void)setDateStyle:(NSDateFormatterStyle)style
Parameters
style

The date style of the receiver. For possible values, see NSDateFormatterStyle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateStyle.*/
- (void)setDateStyle:(NSDateFormatterStyle)style{}

/*stringFromDate:

Returns a string representation of a given date formatted using the receiver’s current settings.

- (NSString *)stringFromDate:(NSDate *)date
Parameters
date

The date to format.
Return Value

A string representation of date formatted using the receiver’s current settings.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateFromString:*/

- (NSString *)stringFromDate:(NSDate *)date{}


/*getObjectValue:forString:range:error:

Returns by reference a date representation of a given string and the range of the string used, and returns a Boolean value that indicates whether the string could be parsed.

- (BOOL)getObjectValue:(id *)objforString:(NSString *) stringrange:(inout NSRange *)rangep error:(NSError **)error
Parameters
obj

If the receiver is able to parse string, upon return contains a date representation of string.
string

The string to parse.
rangep

If the receiver is able to parse string, upon return contains the range of string used to create the date.
error

If the receiver is unable to create a date by parsing string, upon return contains an NSError object that describes the problem.
Return Value

YES if the receiver can create a date by parsing string, otherwise NO.
Availability
Available in Mac OS X v10.4 and later.
See Also
– dateFromString:
– stringForObjectValue:*/
- (BOOL)getObjectValue:(id *)obj forString:(NSString *) string range:(inout NSRange *)rangep           error:(NSError **)error{}



@end
