#include <CoreGraphics/CoreGraphics.h>

//work

/*CGPathApply

For each element in a Quartz path, calls a custom applier function.

void CGPathApply (
   CGPathRef path,
   void *info,
   CGPathApplierFunction function
);
Parameters
path

The path to which the function will be applied.
info

A pointer to the user data that Quartz will pass to the function being applied, or NULL.
function

A pointer to the function to apply. See CGPathApplierFunction for more information.
Discussion

For each element in the specified path, Quartz calls the applier function, which can examine (but not modify) the element.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/
void CGPathApply (
   CGPathRef path,
   void *info,
   CGPathApplierFunction function
){};

/*CGPathRelease

Decrements the retain count of a Quartz path.

void CGPathRelease (
   CGPathRef path
);
Parameters
path

The Quartz path to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the path parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/
void CGPathRelease (
   CGPathRef path
){};

/*CGPathAddLineToPoint

Appends a line segment to a mutable Quartz path.

void CGPathAddLineToPoint (
   CGMutablePathRef path,
   const CGAffineTransform *m,
   float x,
   float y
);
Parameters
path

The mutable path to change. The path must not be empty.
m

A pointer to an affine transformation matrix, or NULL if no transformation is needed. If specified, Quartz applies the transformation to the line before it is added to the path.
x

The x-coordinate of the end point of the line.
y

The y-coordinate of the end point of the line.
Discussion

Before returning, this function updates the current point to the specified location (x,y).
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/
void CGPathAddLineToPoint (
   CGMutablePathRef path,
   const CGAffineTransform *m,
   float x,
   float y
){};

/*CGPathMoveToPoint

Starts a new subpath at a specified location in a mutable Quartz path.

void CGPathMoveToPoint (
   CGMutablePathRef path,
   const CGAffineTransform *m,
   float x,
   float y
);
Parameters
path

The mutable path to change.
m

A pointer to an affine transformation matrix, or NULL if no transformation is needed. If specified, Quartz applies the transformation to the point before changing the path.
x

The x-coordinate of the new location.
y

The y-coordinate of the new location.
Discussion

This function initializes the starting point and the current point to the specified location (x,y) after an optional transformation.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/

void CGPathMoveToPoint (
   CGMutablePathRef path,
   const CGAffineTransform *m,
   float x,
   float y
){};

/*CGPathCreateMutable

Creates a mutable Quartz graphics path.

CGMutablePathRef CGPathCreateMutable (void);
Return Value

A new mutable path. You are responsible for releasing this object.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/
CGMutablePathRef CGPathCreateMutable (void){};

/*CGPathCloseSubpath

Closes and completes a subpath in a mutable Quartz path.

void CGPathCloseSubpath (
   CGMutablePathRef path
);
Parameters
path

The path to change.
Discussion

Appends a line from the current point in a path to the starting point of the current subpath and ends the subpath. On return, the current point is now the previous starting point.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGPath.h*/
void CGPathCloseSubpath (
   CGMutablePathRef path
){};

