#include <CoreGraphics/CoreGraphics.h>


/*CGRectInfinite

Represents a rectangle that has infinite extent.

const CGRect CGRectInfinite;
Constants
CGRectInfinite

Defines a rectangle that has infinite extent.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X v10.4 and later.*/
const CGRect CGRectInfinite;


/*Geometric Zeroes

Define the zero point, zero rectangle, or zero size.

const CGPoint CGPointZero;
const CGRect CGRectZero;
const CGSize CGSizeZero;
Constants
CGPointZero

Defines a point constant with location (0, 0). The zero point is equivalent to CGPointMake(0,0).

Available in Mac OS X v10.0 and later.
CGRectZero

Defines a rectangle constant with location (0,0), and width and height of 0. The zero rectangle is equivalent to CGRectMake(0,0,0,0).

Available in Mac OS X v10.0 and later.
CGSizeZero

Defines a size constant with width and height of 0.The zero size is equivalent to CGSizeMake(0,0).

Available in Mac OS X v10.0 and later.*/
const CGPoint CGPointZero;
const CGRect CGRectZero;
const CGSize CGSizeZero;

//work

/*CGRectIsInfinite

Checks whether a rectangle is infinite.

bool CGRectIsInfinite (
   CGRect rect
);
Parameters
rect

The rectangle to examine.
Return Value

Returns true if the specified rectangle is infinite, false otherwise.
Discussion

An infinite rectangle is one that has no defined bounds. Infinite rectangles can be created as output from a tiling filter. For example, the Core Image framework perspective tile filter creates an image whose extent is described by an infinite rectangle.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGGeometry.h*/
bool CGRectIsInfinite (
   CGRect rect
){};

/*CGRectIntegral

Returns a rectangle with integer values for its origin and size.

CGRect CGRectIntegral (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

The rectangle with smallest integer values for its origin and size that contains the source rectangle. That is, given a rectangle with fractional origin or size values, CGRectIntegral rounds the rectangle’s origin downward and its size upward to the nearest whole integers, such that the result contains the original rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectIntegral (
   CGRect rect
){};

/*CGRectIntersection

Returns the intersection of two rectangles.

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first source rectangle.
rect2

The second source rectangle.
Return Value

A rectangle that is the intersection of the two specified rectangles. If the two rectangles do not intersect, returns the null rectangle. To check for this condition, use CGRectIsNull. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectIntersection (
   CGRect rect1,
   CGRect rect2
){};

/*CGRectInset

Returns a rectangle that is smaller or larger than the source rectangle, with the same center point.

CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to adjust the x-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
dy

The value by which to adjust the y-coordinates of the source rectangle. To create an inset rectangle, specify a positive value. To create a larger, encompassing rectangle, specify a negative value.
Return Value

A rectangle with its origin offset in the x-axis by the distance specified by the dx parameter and in the y-axis by the distance specified by the dy parameter, and its size adjusted by (2*dx,2*dy), relative to the source rectangle. If dx and dy are positive values, then the rectangle’s size is decreased. If dx and dy are negative values, the rectangle’s size is increased.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectInset (
   CGRect rect,
   float dx,
   float dy
){};

/*CGRectGetHeight

Returns the height of a rectangle.

float CGRectGetHeight (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The height of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetHeight (
   CGRect rect
){};

/*CGRectGetWidth

Returns the width of a rectangle.

float CGRectGetWidth (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The width of the specified rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetWidth (
   CGRect rect
){};

/*CGRectMake

Returns a rectangle structure constructed from coordinate and dimension values you provide.

CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
);
Parameters
x

The x-coordinate of the rectangle’s origin point.
y

The y-coordinate of the rectangle’s origin point.
width

The width of the rectangle.
height

The height of the rectangle.
Return Value

Returns a rectangle with the specified location and dimensions. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectMake (
   float x,
   float y,
   float width,
   float height
){};


/*CGRectGetMinY

Returns the y-axis coordinate that establishes the bottom edge of a rectangle.

float CGRectGetMinY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinY (
   CGRect rect
){};

/*CGRectGetMaxY

Returns the y-axis coordinate that establishes the top edge of a rectangle.

float CGRectGetMaxY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the top-right corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMaxY (
   CGRect rect
){};

/*CGRectGetMidY

Returns the y-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidY (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The y-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMidY (
   CGRect rect
){};

/*CGRectUnion

Returns the smallest rectangle that contains two other specified rectangles.

CGRect CGRectUnion (
   CGRect r1,
   CGRect r2
);
Parameters
r1

The first source rectangle. 
r2

The second source rectangle.
Return Value

The smallest rectangle that completely contains both of the source rectangles. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectUnion (
   CGRect r1,
   CGRect r2
){};

/*CGPointMake

Returns a point structure constructed from coordinate values you provide.

CGPoint CGPointMake (
   float x,
   float y
);
Parameters
x

The x-coordinate of the point to construct.
y

The y-coordinate of the point to construct.
Return Value

Returns a CGPoint structure, representing a single (x,y) coordinate pair. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGPoint CGPointMake (
   float x,
   float y
){};

/*CGRectGetMidX

Returns the x-axis coordinate that establishes the center of a rectangle.

float CGRectGetMidX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the center of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

float CGRectGetMidX (
   CGRect rect
){};

/*CGRectGetMinX

Returns the x-axis coordinate that establishes the left edge of a rectangle.

float CGRectGetMinX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the bottom-left corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
float CGRectGetMinX (
   CGRect rect
){};

/*CGRectContainsPoint

Indicates whether a rectangle contains a specified point.

int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
);
Parameters
rect

The rectangle to examine. 
point

The point to examine. 
Return Value

Returns 1 if the specified point is located within the specified rectangle; otherwise, 0. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
int CGRectContainsPoint (
   CGRect rect,
   CGPoint point
){};

/*CGRectIntersectsRect

Indicates whether two rectangles intersect.

int CGRectIntersectsRect (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The first rectangle to examine. 
rect2

The second rectangle to examine.
Return Value

Returns 1 if the two specified rectangles intersect; otherwise, 0. The first rectangle intersects the second if the intersection of the rectangles is not equal to the null rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
int CGRectIntersectsRect (
   CGRect rect1,
   CGRect rect2
){};

/*CGRectOffset

Returns a rectangle with an origin offset from that of the source rectangle.

CGRect CGRectOffset (
   CGRect rect,
   float dx,
   float dy
);
Parameters
rect

The source rectangle. 
dx

The value by which to move the x-coordinate of the source rectangle’s origin.
dy

The value by which to move the y-coordinate of the source rectangle’s origin.
Return Value

A rectangle with the same size as the source, but with its origin offset by dx units along the x-axis and dy units along the y-axis with respect to the source.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGRect CGRectOffset (
   CGRect rect,
   float dx,
   float dy
){};

/*CGRectGetMaxX

Returns the x-axis coordinate that establishes the right edge of a rectangle.

float CGRectGetMaxX (
   CGRect rect
);
Parameters
rect

The rectangle to examine. 
Return Value

The x-coordinate of the top-right corner of the specified rectangle.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/


float CGRectGetMaxX (
   CGRect rect
){};

/*CGRectContainsRect

Indicates whether the first rectangle contains the second rectangle.

int CGRectContainsRect (
   CGRect rect1,
   CGRect rect2
);
Parameters
rect1

The rectangle to examine for containment of the rectangle passed in rect2. 
rect2

The rectangle to examine for being contained in the rectangle passed in rect1.
Return Value

Returns 1 if the rectangle specified by rect2 is contained in the rectangle passed in rect1; otherwise, 0. The first rectangle contains the second if the union of the two rectangles is equal to the first rectangle. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

int CGRectContainsRect (
   CGRect rect1,
   CGRect rect2
){};

/*CGRectStandardize

Returns a rectangle with a positive width and height.

CGRect CGRectStandardize (
   CGRect rect
);
Parameters
rect

The source rectangle. 
Return Value

Returns a rectangle, equivalent to the source rectangle, with a positive width and height. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/
CGRect CGRectStandardize (
   CGRect rect
){};

/*CGSizeMake

Returns a size structure constructed from dimension values you provide.

CGSize CGSizeMake (
   float width,
   float height
);
Parameters
width

A width value.
height

A height value.
Return Value

Returns a CGSize structure with the specified width and height. 
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGGeometry.h*/

CGSize CGSizeMake (
   float width,
   float height
){};

