#include <CoreGraphics/CoreGraphics.h>

//work

/*CGFunctionCreate

Creates a Quartz function.

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
);
Parameters
info

A pointer to user-defined storage for data that you want to pass to your callbacks. You need to make sure that the data persists for as long as it’s needed, which can be beyond the scope in which the Quartz function is used. 
domainDimension

The number of inputs.
domain

An array of (2*domainDimension) floats used to specify the valid intervals of input values. For each k from 0 to (domainDimension - 1), domain[2*k] must be less than or equal to domain[2*k+1], and the kth input value will be clipped to lie in the interval domain[2*k] ≤ input[k] ≤ domain[2*k+1]. If this parameter is NULL, then the input values are not clipped.
rangeDimension

The number of outputs.
range

An array of (2*rangeDimension) floats that specifies the valid intervals of output values. For each k from 0 to (rangeDimension - 1), range[2*k] must be less than or equal to range[2*k+1], and the kth output value will be clipped to lie in the interval range[2*k] ≤ output[k] ≤ range[2*k+1]. If this parameter is NULL, then the output values are not clipped.
callbacks

A pointer to a callback function table. This table should contain pointers to the callbacks you provide to implement the semantics of this Quartz function. Quartz makes a copy of your table, so, for example, you could safely pass in a pointer to a structure on the stack.
Return Value

The new Quartz function. You are responsible for releasing this object using CGFunctionRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
){};

/*CGFunctionRelease

Decrements the retain count of a Quartz function.

void CGFunctionRelease (
   CGFunctionRef function
);
Parameters
function

The Quartz function to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the function parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/
void CGFunctionRelease (
   CGFunctionRef function
){};

