#include <CoreFoundation/CoreFoundation.h>

//work
/*CFUserNotificationDisplayNotice

Displays a user notification dialog that does not need a user response.

SInt32 CFUserNotificationDisplayNotice (
   CFTimeInterval timeout,
   CFOptionFlags flags,
   CFURLRef iconURL,
   CFURLRef soundURL,
   CFURLRef localizationURL,
   CFStringRef alertHeader,
   CFStringRef alertMessage,
   CFStringRef defaultButtonTitle
);
Parameters
timeout

The amount of time to wait for the user to dismiss the notification dialog before the dialog dismisses itself. Pass 0 to have the dialog never time out.
flags

A set of flags describing the type of notification dialog to display. The value is normally just the alert level from Alert Levels. If you don’t want a default button displayed, perform a bitwise-OR operation with the alert level and the constant kCFUserNotificationNoDefaultButtonFlag.
iconURL

A file URL pointing to the icon to display in the dialog. If NULL, a default icon is used based on the notification’s alert level specified in flags.
soundURL

Not used.
localizationURL

A file URL pointing to a bundle that contains localized versions of the strings displayed in the dialog. Can be NULL.
alertHeader

The title of the notification dialog. Cannot be NULL.
alertMessage

The message string to display in the dialog. Can be NULL.
defaultButtonTitle

The title of the default button. If NULL, the string OK is used.
Return Value

0 if the cancel was successful; a non-0 value otherwise.
Discussion

This function returns immediately. It does not wait for a user response after displaying the dialog.
Availability
Available in Mac OS X v10.0 and later.*/
SInt32 CFUserNotificationDisplayNotice (
   CFTimeInterval timeout,
   CFOptionFlags flags,
   CFURLRef iconURL,
   CFURLRef soundURL,
   CFURLRef localizationURL,
   CFStringRef alertHeader,
   CFStringRef alertMessage,
   CFStringRef defaultButtonTitle
){};

