#include <ColorSync/ColorSync.h>

//work

/*CMGetDefaultDevice

Gets the default device.

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
);
Parameters
deviceClass

The device class whose default device you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

On return, points to the device ID for the default device.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

For each class of device, a device management layer may establish which of the registered devices is the default. This helps keep color management choices to a minimum and allows for some automatic features to be enabled, such as the "Default printer" as an output profile selection. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMGetDefaultDevice (
   CMDeviceClass deviceClass,
   CMDeviceID * deviceID
){};

/*CMIterateDeviceProfiles

Iterates through the device profiles available on the system and returns information about profiles of the devices to a callback you supply.

CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain profile information for each device. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
flags

A value that specifies which set of profiles you want to iterate through. It can have the following values: cmIterateFactoryDeviceProfiles, cmIterateCustomDeviceProfiles, cmIterateCurrentDeviceProfiles, cmIterateAllDeviceProfiles or 0. Supplying 0 is the same as supplying cmIterateCurrentDeviceProfiles.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMIterateDeviceProfiles (
   CMIterateDeviceProfileProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   UInt32 flags,
   void * refCon
){};

/*CMGetDeviceProfile

Gets a profile used by a given device. 

CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
);
Parameters
deviceClass

The device class for the device whose profile you want to get. See “Device Classes” for a list of the constants you can supply.
deviceID

The device ID for the device whose profile you want to get.
defaultID

The ID of the default profile for this device.
deviceProfLoc

On return, the location of the profile.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/
CMError CMGetDeviceProfile (
   CMDeviceClass deviceClass,
   CMDeviceID deviceID,
   CMDeviceProfileID profileID,
   CMProfileLocation * deviceProfLoc
){};

/*CMIterateColorDevices

Iterates through the color devices available on the system, returning device information to a callback you supply.

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
);
Parameters
proc

A pointer to a function that iterates through device information available on the system. This is optional, but allows you to obtain device information. If provided, your callback is invoked once for each registered device.
seed

A pointer to a seed value. This is optional. If you pass a pointer to a seed value that is the same as the current seed value, then the callback function specified by the proc parameter is not invoked.
count

On output, the number of color devices available on the system.
refCon

An optional value that passed to your callback.
Return Value

A CMError value. See “ColorSync Manager Result Codes”.
Discussion

This routine gets device information about all registered color devices. If provided, the supplied callback functions is called once for each registered device, passing in the device info and the supplied refcon. 
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
CMDeviceIntegration.h*/

CMError CMIterateColorDevices (
   CMIterateDeviceInfoProcPtr proc,
   UInt32 * seed,
   UInt32 * count,
   void * refCon
){};

