#include <CarbonSound/CarbonSound.h>


/*Saving and Restoring Sound Component Preferences
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings);
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings);*/
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings){
printf ("SetSoundPreference",type,name,settings);
};
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings){
printf ("GetSoundPreference",type,name,settings);
};

/*SoundComponentGetSourceData
A utility component must implement the SoundComponentGetSourceData function. A sound output device component calls this function on its source component when it needs more data.

pascal ComponentResult SoundComponentGetSourceData 
                           (ComponentInstance ti, 
                              SoundComponentDataPtr *sourceData);
ti 
A component instance that identifies your sound component. 
sourceData 
On output, a pointer to a sound component data record that specifies the type and location of the data your component has processed. 
DESCRIPTION
Your SoundComponentGetSourceData function is called when the sound component immediately following your sound component in the sound component chain needs more data. Your function should generate a new block of audio data, fill out a sound component data record describing the format and location of that data, and then return the address of that record in the sourceData parameter.

Your SoundComponentGetSourceData function might itself need to get more data from its source component. To do this, call through to the source component's SoundComponentGetSourceData function. If your component cannot generate any more data, it should set the sampleCount field of the sound component data record to 0 and return noErr.

IMPORTANT 
Sound output device components do not need to implement this function, but all utility components must implement it.  
RESULT CODES
Your SoundComponentGetSourceData function should return noErr if successful or an appropriate result code otherwise.*/
pascal ComponentResult SoundComponentGetSourceData 
                           (ComponentInstance ti, 
                              SoundComponentDataPtr *sourceData){
printf ("SoundComponentGetSourceData",ti,*sourceData);
};


/*SoundConverterBeginConversion
pascal OSErr SoundConverterBeginConversion(SoundConverter sc);

SoundConverterBeginConversion starts a conversion. All state information is reset to default values in preparation for a new input buffer.

This routine can be called at interrupt time.*/
pascal OSErr SoundConverterBeginConversion(SoundConverter sc){
printf ("SoundConverterBeginConversion",sc);
};

/*SoundConverterGetBufferSizes 
pascal OSErr SoundConverterGetBufferSizes(
                     SoundConverter sc,
                                         unsigned long targetBytes, 
                     unsigned long *inputFrames,
                                         unsigned long *inputBytes, 
                     unsigned long *outputBytes);

SoundConverterGetBufferSizes is used to determine the input and output buffer sizes for a given target size. This is so you can make sure your buffers will fit the conversion parameters established with SoundConverterOpen .

The targetBytes parameter is the approximate number of bytes you would like both your input and output buffers to be. The inputFrames and inputBytes parameters return the actual size you should make your input buffer, in frames and bytes, respectively. The outputBytes parameter returns the size in bytes for your output buffer.

The returned input and output buffer sizes can be larger than your target size settings. This is because they are rounded up depending on the format, but they will be very close to the target settings. Also note that the input and output sizes may be very different, depending on the input and output formats given in SoundConverterOpen . The sizes are calculated assuming you will convert all data in the input buffer to the output buffer.*/
pascal OSErr SoundConverterGetBufferSizes(
                     SoundConverter sc,
                                         unsigned long targetBytes, 
                     unsigned long *inputFrames,
                                         unsigned long *inputBytes, 
                     unsigned long *outputBytes){
printf ("SoundConverterGetBufferSizes",sc,targetBytes,*inputFrames,*inputBytes,*outputBytes);
};


/*SoundConverterEndConversion
pascal OSErr SoundConverterEndConversion(
                     SoundConverter sc, 
                     void *outputPtr, 
                     unsigned long *outputFrames, 
                     unsigned long *outputBytes);

SoundConverterEndConversion ends a conversion. Any data remaining in the converters is flushed out and returned here.

This routine can be called at interrupt time.*/
pascal OSErr SoundConverterEndConversion(
                     SoundConverter sc, 
                     void *outputPtr, 
                     unsigned long *outputFrames, 
                     unsigned long *outputBytes){
printf ("SoundConverterEndConversion",sc,outputPtr,*outputFrames,*outputBytes);
};



/*Opening and Closing the Apple Mixer Component
pascal OSErr OpenMixerSoundComponent
		(SoundComponentDataPtr outputDescription, 
		long outputFlags, 
		ComponentInstance *mixerComponent);
pascal OSErr CloseMixerSoundComponent
		(ComponentInstance ci);
Saving and Restoring Sound Component Preferences
pascal OSErr SetSoundPreference
		(OSType type, Str255 name, Handle settings);
pascal OSErr GetSoundPreference
		(OSType type, Str255 name, Handle settings);
Sound Component-Defined Routines
Managing Sound Components
pascal ComponentResult SoundComponentInitOutputDevice
		(ComponentInstance ti, long actions);
pascal ComponentResult SoundComponentSetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance source);
pascal ComponentResult SoundComponentGetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance *source);
pascal ComponentResult SoundComponentGetSourceData
		(ComponentInstance ti, 
		SoundComponentDataPtr *sourceData);
pascal ComponentResult SoundComponentSetOutput
		(ComponentInstance ti, 
		SoundComponentDataPtr requested, SoundComponentDataPtr *actual);
Creating and Removing Audio Sources
pascal ComponentResult SoundComponentAddSource
		(ComponentInstance ti, SoundSource *sourceID);
pascal ComponentResult SoundComponentRemoveSource
		(ComponentInstance ti, SoundSource sourceID);
Getting and Setting Sound Component Information
pascal ComponentResult SoundComponentGetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);
pascal ComponentResult SoundComponentSetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr);
Managing Source Data
pascal ComponentResult SoundComponentStartSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentStopSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPauseSource
		(ComponentInstance ti, short count, 
		SoundSource *sources);
pascal ComponentResult SoundComponentPlaySourceBuffer
		(ComponentInstance ti, SoundSource sourceID, SoundParamBlockPtr pb, long actions);*/
pascal OSErr OpenMixerSoundComponent
		(SoundComponentDataPtr outputDescription, 
		long outputFlags, 
		ComponentInstance *mixerComponent){
printf ("OpenMixerSoundComponent",outputDescription,outputFlags,*mixerComponent);
};
pascal OSErr CloseMixerSoundComponent
		(ComponentInstance ci){
printf ("CloseMixerSoundComponent",ci);
};
//work

pascal ComponentResult SoundComponentInitOutputDevice
		(ComponentInstance ti, long actions){
printf ("SoundComponentInitOutputDevicet",ti,actions);
};
pascal ComponentResult SoundComponentSetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance source){
printf ("SoundComponentSetSource",ti,sourceID,source);
};
pascal ComponentResult SoundComponentGetSource
		(ComponentInstance ti, SoundSource sourceID,
		ComponentInstance *source){
printf ("SoundComponentGetSource",ti,sourceID,*source);
};

pascal ComponentResult SoundComponentSetOutput
		(ComponentInstance ti, 
		SoundComponentDataPtr requested, SoundComponentDataPtr *actual){
printf ("SoundComponentSetOutput",ti,requested,*actual);
};

pascal ComponentResult SoundComponentAddSource
		(ComponentInstance ti, SoundSource *sourceID){
printf ("SoundComponentAddSource",ti,*sourceID);
};
pascal ComponentResult SoundComponentRemoveSource
		(ComponentInstance ti, SoundSource sourceID){
printf ("SoundComponentRemoveSource",ti,sourceID);
};

pascal ComponentResult SoundComponentGetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr){
printf ("SoundComponentGetInfo",ti,sourceID,selector,infoPtr);
};
pascal ComponentResult SoundComponentSetInfo
		(ComponentInstance ti, SoundSource sourceID,
		OSType selector, void *infoPtr){
printf ("SoundComponentSetInfo",ti,sourceID,selector,infoPtr);
};

pascal ComponentResult SoundComponentStartSource
		(ComponentInstance ti, short count, 
		SoundSource *sources){
printf ("SoundComponentStartSource",ti,count,*sources);
};
pascal ComponentResult SoundComponentStopSource
		(ComponentInstance ti, short count, 
		SoundSource *sources){
printf ("SoundComponentStopSource",ti,count,*sources);
};
pascal ComponentResult SoundComponentPauseSource
		(ComponentInstance ti, short count, 
		SoundSource *sources){
printf ("SoundComponentPauseSource",ti,count,*sources);
};
pascal ComponentResult SoundComponentPlaySourceBuffer
		(ComponentInstance ti, SoundSource sourceID, SoundParamBlockPtr pb, long actions){
printf ("SoundComponentPlaySourceBuffer",ti,sourceID,pb,actions);
};

/*New Sound Manager APIs 

In addition to two new SoundManagerGetInfo and SoundManagerSetInfo calls, there is a new Sound Converter API in QuickTime 4.1, which is discussed in the next section. Note that this new API is now the recommended way to use the Sound Converter.
SoundManagerGetInfo
pascal OSErr
SoundManagerGetInfo(OSType selector, void* infoPtr); 

This routine retrieves global information about the Sound Manaager.

Defined selectors:
siSupportedExtendedFlags

Retrieves which flags are supported in Extended sound data structures in an unsigned long.

SoundManagerSetInfo
pascal OSErr
SoundManagerSetInfo(OSType selector, void* infoPtr); 

This routine sets global information about the Sound Manager.

Defined selectors: none
SoundConverterFillBuffer

Provides an alternative method for converting data using the Sound Converter, which is both more predictable and more flexible than the SoundConverterConvertBuffer mechanism. The SoundConverterFillBuffer function can return any Sound Manager error.
pascal OSErr    SoundConverterFillBuffer( SoundConverter sc,
                     SoundConverterFillBufferDataUPP  fillBufferDataUPP,
                     void* fillBufferDataRefCon,
                     void* outputBuffer,
                     unsigned long outputBufferByteSize,
                     unsigned long* bytesWritten,
                     unsigned long* framesWritten,
                     unsigned long* outputFlags
                     ) 
sc 
The Sound Converter context to work with (created with SoundConverterOpen).

fillBufferDataUPP

A UPP that points to a routine that can provide data to the Sound Converter.

fillBufferDataRefCon

This value is passed to the SoundConverterFillBufferDataUPP. It can be used for any purpose the client wishes.

outputBuffer

The buffer to write the data into.

outputBufferByteSize

The size of outputBuffer in bytes. No more than this amount will ever be written during a single call to SoundConverterFillBuffer.

bytesWritten

Upon completion, the number of bytes that were written into outBuffer.

framesWritten

Upon completion, the number of sample frames written into outBuffer.

outputFlags 
 

Upon completion, a set of bit flags that indicate the state of the conversion. These are the currently defined flags:

kSoundConverterDidntFillBuffer

Set if the converter didn't completely fill the output buffer.

kSoundConverterHasLeftOverData

Set if the converter still has more data to deliver. This indicates that more calls to SoundConvertFillBuffer should be made to complete the conversion. A caveat: If this flag is not set, it doesn't indicate there is necessarily more data in the pipeline. These are advisor flags only: they don't guarantee any internal data. You need to keep track of your data. 

Working with SoundConverterFillBuffer
Writing the SoundConverterFillBufferData Routine*/
pascal OSErr
SoundManagerGetInfo(OSType selector, void* infoPtr){
printf ("SoundManagerGetInfo",selector,infoPtr);
}; 

pascal OSErr
SoundManagerSetInfo(OSType selector, void* infoPtr){
printf ("SoundManagerSetInfo",selector,infoPtr);
};

pascal OSErr    SoundConverterFillBuffer( SoundConverter sc,
                     SoundConverterFillBufferDataUPP  fillBufferDataUPP,
                     void* fillBufferDataRefCon,
                     void* outputBuffer,
                     unsigned long outputBufferByteSize,
                     unsigned long* bytesWritten,
                     unsigned long* framesWritten,
                     unsigned long* outputFlags
                     ){
printf ("SoundConverterFillBuffer",sc,fillBufferDataUPP,fillBufferDataRefCon,outputBuffer,outputBufferByteSize,*bytesWritten,*framesWritten,*outputFlags);
};

/*Allocating and Releasing Sound Channels
pascal OSErr SndNewChannel  (SndChannelPtr *chan, short synth, long init,
                             SndCallBackProcPtr userRoutine);
pascal OSErr SndDisposeChannel
                            (SndChannelPtr chan, Boolean quietNow);*/
pascal OSErr SndNewChannel  (SndChannelPtr *chan, short synth, long init,
                             SndCallBackProcPtr userRoutine){
printf ("SndNewChannel",*chan,synth,init,userRoutine);
};
pascal OSErr SndDisposeChannel
                            (SndChannelPtr chan, Boolean quietNow){
printf ("SndDisposeChannel",chan,quietNow);
};

/*Controlling Volume Levels
pascal OSErr GetSysBeepVolume
                    (long *level);
pascal OSErr SetSysBeepVolume
                    (long level);
pascal OSErr GetDefaultOutputVolume
                    (long *level);
pascal OSErr SetDefaultOutputVolume
                    (long level);*/
pascal OSErr SetDefaultOutputVolume
                    (long level){
printf ("SetDefaultOutputVolumel",level);
};
pascal OSErr GetDefaultOutputVolume
                    (long *level){};

/*ParseSndHeader
pascal OSErr ParseSndHeader(
                     SndListHandle sndHandle,
                                         SoundComponentData *sndInfo, 
                     unsigned long *numFrames,
                                         unsigned long *dataOffset);

The ParseSndHeader routine returns information describing the audio data in the given 'snd ' resource handle. The sndHandle parameter specifies the sound handle to use. The sndInfo parameter is a SoundComponentData structure that returns the following information about the format of the sound in the handle:

flags 
Always returns 0


format 
The sound format (i.e., 'raw', 'twos', 'MAC3', etc.)


numChannels 
The number of channels (i.e., 1 = mono, 2 = stereo)


sampleSize 
The sample size (i.e., 8 = 8-bit, 16 = 16-bit)


sampleRate 
The sampling rate (in samples/second)


sampleCount 
The number of audio samples in the file


buffer 
Always returns 0


reserved 
Always returns 0


The numFrames parameter returns the number of frames of audio data in the handle, and the dataOffset parameter returns the byte offset of the first audio sample in the handle.*/
pascal OSErr ParseSndHeader(
                     SndListHandle sndHandle,
                                         SoundComponentData *sndInfo, 
                     unsigned long *numFrames,
                                         unsigned long *dataOffset){
printf ("ParseSndHeader",sndHandle,*sndInfo,*numFrames,*dataOffset);
};

/*Obtaining Information
pascal NumVersion SndSoundManagerVersion
                            (void);
pascal NumVersion MACEVersion
                            (void);
pascal OSErr SndControl     (short id, SndCommand *cmd);
pascal OSErr SndChannelStatus
                            (SndChannelPtr chan, short theLength,
                             SCStatusPtr theStatus);
pascal OSErr SndManagerStatus
                            (short theLength, SMStatusPtr theStatus);
pascal void SndGetSysBeepState
                            (short *sysBeepState);
pascal OSErr SndSetSysBeepState
                            (short sysBeepState);
pascal OSErr GetSoundHeaderOffset
                            (Handle sndHandle, long *offset);*/
pascal OSErr GetSoundHeaderOffset
                            (Handle sndHandle, long *offset){
printf ("GetSoundHeaderOffset",sndHandle,*offset);
};

/*SndGetInfo and SndSetInfo
extern pascal OSErr SndGetInfo(
                     SndChannelPtr chan, OSType selector, 
                     void *infoPtr);
extern pascal OSErr SndSetInfo(
                     SndChannelPtr chan, OSType selector, 
                     const void *infoPtr);

The two new routines SndGetInfo and SndSetInfo are used to get and set information about the sound environment. Both routines use a selector based interface similar to the SPBGetDeviceInfo and SPBSetDeviceInfo routines found in the Sound Input Manager, and in fact they use the same sound information selectors.

SndGetInfo and SndSetInfo operate on an open Sound Manager channel, and can be used to retrieve and change information about the channel, including hardware settings. These routines should be used instead of attempting to communicate directly with sound components.

These new calls are only available with Sound Manager version 3.1 or later. Check for this by calling SndSoundManagerVersion for the installed version. Note that you can always open a sound channel for the hardware device that you desire by passing kUseOptionalOutputDevice as the synth parameter and the component reference as the init parameter.
OSErr OpenChannel(OSType myType)
{
    ComponentDescription   searching;
    Component              outputDevice;
    OSErr                  err;

    // search for a sound output device component
    searching.componentType = kSoundOutputDeviceType;
    searching.componentSubType = myType;
    searching.componentManufacturer = kAnyComponentManufacturer;
    searching.componentFlags = 0;
    searching.componentFlagsMask = kAnyComponentFlagsMask;
    outputDevice = nil;
    outputDevice = FindNextComponent(outputDevice, &searching);

    if (outputDevice == nil)
        err = cantFindHandler; /component not found*
    else
    {
        gChan = nil;
        err = SndNewChannel(&gChan, kUseOptionalOutputDevice,
                            (long)outputDevice, nil);
    }
    return (err);
}

For example, to determine the current hardware sampling rate of the given sound channel you may use this code:
UnsignedFixed sampleRate;
err = SndGetInfo(gChan, siSampleRate, &sampleRate);
GetSoundOutputInfo() and SetSoundOutputInfo()
pascal OSErr GetSoundOutputInfo(Component outputDevice, OSType selector,
                                void *infoPtr);
pascal OSErr SetSoundOutputInfo(Component outputDevice, OSType selector,
                                const void *infoPtr);

These two routines get and set information about the sound environment: GetSoundOutputInfo and SetSoundOutputInfo . Both routines use a selector based interface similar to the SPBGetDeviceInfo and SPBSetDeviceInfo routines found in the Sound Input Manager, and in fact they use the same sound info selectors.

GetSoundOutputInfo and SetSoundOutputInfo operate directly on a sound output device, and can be used to retrieve and change information about the hardware settings. These routines should be used instead of attempting to communicate directly with sound output components. Setting the output device parameter to nil causes the default output device to be used. These calls are similar to GetSndInfo and SetSndInfo but do not require an opened sound channel. For example, to determine the sampling rate of the sound hardware on the default output device, you could use this code:
OSErr GetCurrentSampleRate(UnsignedFixed *sampleRate)
    {   
OSErr err;
    err = GetSoundOutputInfo(nil, siSampleRate, sampleRate);
return (err);
}*/
pascal OSErr SndGetInfo(
                     SndChannelPtr chan, OSType selector, 
                     void *infoPtr){
printf ("SndGetInfo",chan,selector,infoPtr);
};

/*SoundConverterConvertBuffer
pascal OSErr SoundConverterConvertBuffer(
                     SoundConverter sc,
                                         const void *inputPtr, unsigned long inputFrames,
                                         void *outputPtr, unsigned long *outputFrames,
                                         unsigned long *outputBytes);

SoundConverterConvertBuffer converts a buffer of data from the input format to the output format. The inputPtr parameter points to the input data, and inputFrames gives the number of frames in that buffer. The outputPtr parameter specifies where the output data should be placed. The outputFrames and outputBytes parameters return the number of frames and bytes placed in the output buffer respectively.

This routine will consume all the data in the input buffer. Depending on the complexity of the conversion, however, not all the converted data may be put in the output buffer right away. The SoundConverterEndConversion routine is used to flush out all this remaining data before a conversion session is closed.

If you are using this routine in conjunction with SoundConverterGetBufferSizes , it is very important that you do not pass in a value in inputFrames larger than the frames value returned by SoundConverterGetBufferSizes , or you will overflow your output buffer. The SoundConverterConvertBuffer calls converts ALL the input data! This routine can be called at interrupt time.*/
pascal OSErr SoundConverterConvertBuffer(
                     SoundConverter sc,
                                         const void *inputPtr, unsigned long inputFrames,
                                         void *outputPtr, unsigned long *outputFrames,
                                         unsigned long *outputBytes){
printf ("SoundConverterConvertBuffer",sc,inputPtr,inputFrames,outputPtr,*outputFrames,*outputBytes);
};

/*Sending Commands to a Sound Channel
pascal OSErr SndDoCommand   (SndChannelPtr chan, const SndCommand *cmd,
                             Boolean noWait);
pascal OSErr SndDoImmediate
                            (SndChannelPtr chan, const SndCommand *cmd);*/
pascal OSErr SndDoImmediate
                            (SndChannelPtr chan, const SndCommand *cmd){
printf ("SndDoImmediate",chan,*cmd);
};

pascal OSErr SndDoCommand   (SndChannelPtr chan, const SndCommand *cmd,
                             Boolean noWait){
printf ("SndDoCommand",chan,*cmd,noWait);
};

/*ParseAIFFHeader
pascal OSErr ParseAIFFHeader(
                     short fRefNum, SoundComponentData *sndInfo,
                                         unsigned long *numFrames, 
                     unsigned long *dataOffset);

The ParseAIFFHeader routine returns information describing the audio data in the given AIFF file. The fRefNum parameter specifies the open AIFF file to use. The sndInfo parameter is a SoundComponentData structure that returns the following information about the format of the sound in the AIFF file:

flags 
Always returns 0


format 
The sound format (i.e., 'raw', 'twos', 'MAC3', etc.)


numChannels 
The number of channels (i.e., 1 = mono, 2 = stereo)


sampleSize 
The sample size (i.e., 8 = 8-bit, 16 = 16-bit)


sampleRate 
The sampling rate (in samples/second)


sampleCount 
The number of audio samples in the file


buffer 
Always returns 0


reserved 
Always returns 0


The numFrames parameter returns the number of frames of audio data in the file, and the dataOffset parameter returns the byte offset of the first audio sample in the file.*/
pascal OSErr ParseAIFFHeader(
                     short fRefNum, SoundComponentData *sndInfo,
                                         unsigned long *numFrames, 
                     unsigned long *dataOffset){
printf ("ParseAIFFHeader",fRefNum,*sndInfo,*numFrames,*dataOffset);
};

/*GetCompressionInfo
pascal OSErr GetCompressionInfo(
                     short compressionID, OSType format,
                                         short numChannels, short sampleSize, CompressionInfoPtr cp);

For a given AIFF file or snd resource, the information contained within it might be used to determine basic characteristics of the sound such as its duration.
duration = numSampleFrames / sampleRate

Note that this is a valid calculation for an uncompressed sound. But this calculation returns an incorrect result for a compressed sound. The problem here is that each sample frame in a compressed sound is composed of one or more packets rather than sample points (see "Sampled-Sound Data" ), and each packet in that compressed sound can itself represent several sample points. We therefore need a way to determine the number of samples in a packet in order to get an accurate calculation.

The compressionID parameter defines the compression algorithm used on the sample. The AIFF-C Extended Common Chunk does not contain a compressionID field. In this case (and when using snd resources where the OSType describing the compression format is known) you should always pass the constant fixedCompression in this parameter and the OSType in the format parameter. The format field will then contain the OSType representing the compression format. If you set the compressionID field in a compressed sound header to any value other than fixedCompression , then the format field is set to zero. The format parameter is the OSType describing the format of the compressed sound data. If you pass the constant fixedCompression in the compressionID parameter you will need to pass a valid compression type here. Some of the valid format types are:
NONE - sound is not compressed
MAC3 - compression format is MACE 3:1
MAC6 - compression format is MACE 6:1
ima4 - compression format is IMA 4:1

There are some snd resources that do not store an OSType in the format field of the compressed sound header describing the compression format. You can still use GetCompressionInfo in this case by passing in the compressionID and passing 0 in the format parameter. The correct OSType will be returned in the format field of the CompressionInfo structure. Using the appropriate fields from an AIFF-C Extended Common Chunk or our snd resource compressed sound header, we can make the call to GetCompressionInfo :*/
pascal OSErr GetCompressionInfo(
                     short compressionID, OSType format,
                                         short numChannels, short sampleSize, CompressionInfoPtr cp){
printf ("GetCompressionInfo",compressionID,format,numChannels,sampleSize,cp);
};

/*Opening and Closing Sound Input Devices
pascal  OSErr SPBOpenDevice (ConstStr255Param deviceName, short permission,
                             long *inRefNum);
pascal OSErr SPBCloseDevice
                            (long inRefNum);*/
pascal  OSErr SPBOpenDevice (ConstStr255Param deviceName, short permission,
                             long *inRefNum){
printf ("SPBOpenDevice",deviceName,permission,*inRefNum);
};
pascal OSErr SPBCloseDevice
                            (long inRefNum){
printf ("SPBCloseDevice",inRefNum);
};

/*Manipulating Device Settings
pascal  OSErr SPBGetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);
pascal  OSErr SPBSetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData);*/
pascal  OSErr SPBGetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData){
printf ("SPBGetDeviceInfo",inRefNum,infoType,*infoData);
};
pascal  OSErr SPBSetDeviceInfo
                         (long inRefNum, OSType infoType, 
                          char *infoData){
printf ("SPBSetDeviceInfo",inRefNum,infoType,*infoData);
};

/*SndSetInfo
You can use the SndSetInfo function to set information for a sound channel.

pascal OSStatus SndSetInfo (
SndChannelPtr chan,
OSType selector,
void *infoPtr);
chan 
A pointer to a sound channel. 
selector 
A sound channel information selector specifying the kind of information you want to set for the sound channel. See "Sound Channel Information Selectors" (page 1-23) for a description of the selectors defined by SoundSprocket. 
infoPtr 
A pointer to a buffer containing the information you want to set. This buffer must be large enough for the type of information specified by the selector parameter. 
function result 
A result code. 
DESCRIPTION
The SndSetInfo function sets information for the sound channel specified by the chan parameter. The type of information you want to set is specified by the selector parameter. If additional data is required, it is passed in the buffer pointed to by the infoPtr parameter.*/
pascal OSStatus SndSetInfo (
SndChannelPtr chan,
OSType selector,
void *infoPtr){
printf ("SndSetInfo",chan,selector,infoPtr);
};

/*Playing Sounds
pascal	void		SysBeep(short duration);
pascal	OSErr		SndPlay(SndChannelPtr chan, Handle sndHdl, 
			Boolean async);
pascal	OSErr		SndStartFilePlay
			(SndChannelPtr chan, short fRefNum,
			short resNum, long bufferSize, void *theBuffer,
			AudioSelectionPtr theSelection,
			FilePlayCompletionProcPtr theCompletion, Boolean async);*/
pascal	void		SysBeep(short duration){
printf ("SysBeep",duration);
};

pascal	OSErr		SndPlay(SndChannelPtr chan, Handle sndHdl, 
			Boolean async){
printf ("SndPlay",chan,sndHdl,async);
};

 void
DisposeSndCallBackUPP(SndCallBackUPP userUPP){
printf ("DisposeSndCallBackUPP",userUPP);
};


 SndCallBackUPP
NewSndCallBackUPP(SndCallBackProcPtr userRoutine){
printf ("NewSndCallBackUPP",userRoutine);
};

/*For example, to determine the current hardware sampling rate of the given sound channel you may use this code:
UnsignedFixed sampleRate;
err = SndGetInfo(gChan, siSampleRate, &sampleRate);
GetSoundOutputInfo() and SetSoundOutputInfo()
pascal OSErr GetSoundOutputInfo(Component outputDevice, OSType selector,
                                void *infoPtr);
pascal OSErr SetSoundOutputInfo(Component outputDevice, OSType selector,
                                const void *infoPtr);*/
pascal OSErr GetSoundOutputInfo(Component outputDevice, OSType selector,
                                void *infoPtr){
printf ("GetSoundOutputInfo",outputDevice,selector,infoPtr);
};

pascal OSErr SetSoundOutputInfo(Component outputDevice, OSType selector,
                                const void *infoPtr){
printf ("SetSoundOutputInfo",outputDevice,selector,infoPtr);
};

 NumVersion 
SndSoundManagerVersion(void){
printf ("SndSoundManagerVersion");
};


OSErr 
SetupAIFFHeader(
  short           fRefNum,
  short           numChannels,
  UnsignedFixed   sampleRate,
  short           sampleSize,
  OSType          compressionType,
  unsigned long   numBytes,
  unsigned long   numFrames){
printf ("SetupAIFFHeader",fRefNum,numChannels,sampleRate,sampleSize,compressionType,numBytes,numFrames);
};

 OSErr 
SoundConverterOpen(
  const SoundComponentData *  inputFormat,
  const SoundComponentData *  outputFormat,
  SoundConverter *            sc){};

OSErr 
SoundConverterSetInfo(
  SoundConverter   sc,
  OSType           selector,
  void *           infoPtr){};

SoundConverterFillBufferDataUPP
NewSoundConverterFillBufferDataUPP(SoundConverterFillBufferDataProcPtr userRoutine){} ;

 OSErr 
SoundConverterClose(SoundConverter sc){};

void
DisposeSoundConverterFillBufferDataUPP(SoundConverterFillBufferDataUPP userUPP){};

OSErr 
SoundConverterGetInfo(
  SoundConverter   sc,
  OSType           selector,
  void *           infoPtr){};


/*GetCompressionName
pascal OSErr GetCompressionName(
                     OSType compressionType, 
                     Str255 compressionName);

The GetCompressionName routine returns a string describing the given compression format in a string that can be displayed to the user. The compressionType parameter specifies the compression format, and the name is returned in compressionName .

This string can be used in pop-up menus and other user interface elements to allow the user to select a compression format.*/
pascal OSErr GetCompressionName(
                     OSType compressionType, 
                     Str255 compressionName){};







