#include <CarbonCore/CarbonCore.h>

//work


/*FSFindFolder

Obtains location information for system-related directories.

OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType)on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Passing kCreateFolder will not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundRef

A pointer to a file system reference. On return, the FSRef refers to the directory specified by the vRefNum and folderType parameters.
Return Value

A result code. See "Folder Manager Result Codes".
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FSFindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   FSRef * foundRef
){};

/*FindFolder

Obtains location information for system-related directories.

OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
);
Parameters
vRefNum

Pass the volume reference number of the volume on which you want to locate a directory, or a constant specifying a disk or domain. The constants which you can use in this parameter are described in Disk and Domain Constants.

Note that, on Mac OS X, passing a volume reference number in this parameter does not make sense for most of the folder type selectors which you can specify in the folderType parameter. On Mac OS X, folders are "domain-oriented"; because there may be more than one domain on any given physical volume, asking for these folders on a per-volume basis yields undefined results. For example, if you were to request the Fonts folder (represented by the selector kFontsFolderType) on volume -100, are you requesting the folder /System/Library/Fonts, /Library/Fonts, or ~/Fonts? On Mac OS X you should pass a disk or domain constant in this parameter.
folderType

Pass a four-character folder type, or a constant that represents the type, for the folder you want to find; see Folder Type Constants.
createFolder

A value of type Boolean, as defined in Create Folder Flags. Pass the constant kCreateFolder to create a directory if it does not already exist; otherwise, pass the constant kDontCreateFolder. Directories inside the System Folder are created only if the System Folder directory exists. The FindFolder function will not create a System Folder directory even if you specify the kCreateFolder constant in the createFolder parameter. Passing kCreateFolder will also not create a parent folder; if the parent of the target folder does not already exist, attempting to create the target will fail.
foundVRefNum

A pointer to a value of type short. On return, the value specifies the volume reference number for the volume containing the directory specified in the folderType parameter.
foundDirID

A pointer to a value of type long. On return, the value specifies the directory ID number for the directory specified in the folderType parameter. 
Return Value

A result code. See "Folder Manager Result Codes". The result code fnfErr indicates that the type has not been found in the 'fld#' resource, or the disk doesn’t have System Folder support, or the disk does not have desktop database support for Desktop Folder—in all cases, the folder has not been found. The result code dupFNErr indicates that a file has been found instead of a folder.
Discussion

As of Mac OS 8 and later, your application can add folders to the System Folder—or nest folders within other folders—and locate the folders via the FindFolder function. Prior to Mac OS 8, your application could only use FindFolder to find folders that were immediately inside of the System Folder, and a few other special folders such as the Trash folder and the System Folder itself. Now, once a folder (and any folders that it is nested within) is described in a folder descriptor—that is, registered using the function AddFolderDescriptor —your application can use FindFolder to find the folder no matter where it is located.

Those folders you’re most likely to want to access are Preferences and Trash. For example, you might wish to check for the existence of a user’s configuration file in Preferences or, if your application runs out of disk storage when trying to save a file, check how much disk storage is taken by items in the Trash directory and report this to the user.

The specified folder used for a given volume might be located on a different volume; therefore, do not assume the volume that you specify in vRefNum and the volume returned through foundVRefNum will be the same. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Folders.h*/
OSErr FindFolder (
   short vRefNum,
   OSType folderType,
   Boolean createFolder,
   short * foundVRefNum,
   long * foundDirID
){};

/*ReleaseFolder

Releases the Trash folder in preparation for unmounting a server volume. (Deprecated in Mac OS X v10.3. This function is not needed in Mac OS X.)

OSErr ReleaseFolder (
   short vRefNum,
   OSType folderType
);
Parameters
vRefNum

Pass the volume reference number of the server volume on which you want to release the Trash folder. 
folderType

Always pass the kTrashFolderType constant. Other folder types are currently ignored.
Return Value

A result code. See "Folder Manager Result Codes".
Discussion

When you call FindFolder with the kTrashFolderType constant, it opens a file on a server volume that ensures each server volume user gets a unique Trash folder. Because a server volume’s Trash folder may contain files or folders put there by the user, applications should delete the contents of the server volume’s Trash folder. To do this, before your application unmounts a server volume, your application should call ReleaseFolder, or the UnmountVol request could fail with a fBsyErr result code. ReleaseFolder closes the file FindFolder may have opened and releases the Trash folder on that volume.

Your application should not use this function unless you want to unmount one or more server volumes. Normally, applications should not unmount servers; they should let users use the Finder to unmount volumes. In particular, applications should have no need to release the Trash folder explicitly; rather, unmounting volumes should be left to users to do with the Finder or by restarting. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
Folders.h*/
OSErr ReleaseFolder (
   short vRefNum,
   OSType folderType
){};
