#include <CarbonCore/CarbonCore.h>


OSStatus  FSCopyURLForVolume(FSVolumeRefNum vRefNum, CFURLRef *url){
printf ("FSCopyURLForVolume",vRefNum,*url);
};


OSStatus  FSGetHFSUniStrFromString(CFStringRef theString, HFSUniStr255 *uniStr){
printf ("FSGetHFSUniStrFromString",theString,*uniStr);
};


OSStatus  FSCreateFileAndOpenForkUnicode(const FSRef *parentRef, UniCharCount nameLength, const UniChar *name, FSCatalogInfoBitmap whichInfo, const FSCatalogInfo *catalogInfo, UniCharCount forkNameLength, const UniChar *forkName, SInt8 permissions, SInt16 *forkRefNum, FSRef *newRef){
printf ("FSCreateFileAndOpenForkUnicode",*parentRef,nameLength,*name,whichInfo,*catalogInfo,forkNameLength,*forkName,permissions,*forkRefNum,*newRef);
};


FSFileSecurityRef  FSFileSecurityCreate(CFAllocatorRef alloc){
printf ("FSFileSecurityCreate",alloc);
};

OSStatus  FSFileSecuritySetMode(FSFileSecurityRef fileSec, UInt16 mode){
printf ("FSFileSecuritySetMode",fileSec,mode);
};

OSStatus  FSFileSecuritySetAccessControlList(FSFileSecurityRef fileSec, acl_t accessControlList){
printf ("FSFileSecuritySetAccessControlList",fileSec,accessControlList);
};


OSStatus  FSFileSecurityCopyAccessControlList(FSFileSecurityRef fileSec, acl_t *accessControlList){
printf ("FSFileSecurityCopyAccessControlList",fileSec,*accessControlList);
};

 QHdrPtr GetVCBQHdr(void) {
printf ("GetVCBQHdr");
};

/*File Operation Status Dictionary Keys

Keys used to determine the status of a file operation as reported in a status dictionary.

const CFStringRef kFSOperationTotalBytesKey;
const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
const CFStringRef kFSOperationObjectsCompleteKey;
const CFStringRef kFSOperationObjectsRemainingKey;
const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
const CFStringRef kFSOperationThroughputKey;
Constants
kFSOperationTotalBytesKey

The value for this key is a CFNumber that represents the total number of bytes that will be moved or copied by this file operation. This value is not available for a directory operation if the kFSFileOperationSkipPreflight option flag is specified.

Available in Mac OS X v10.4 and later.
kFSOperationBytesCompleteKey

The value for this key is a CFNumber that represents the total number of bytes that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationBytesRemainingKey

The value for this key is a CFNumber that represents the total number of bytes that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalObjectsKey

The value for this key is a CFNumber that represents the total number of objects that will be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalUserVisibleObjectsKey

The value for this key is a CFNumber that represents the total number of user-visible objects that will be moved or copied by this file operation. In general, an object is user-visible if it is displayed in a Finder window. For example, a package is counted as a single user-visible object even though it typically contains many other objects.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of user-visible objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of user-visible objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationThroughputKey

The value for this key is a CFNumber that represents the current throughput of this file operation in bytes per second.

Available in Mac OS X v10.4 and later.
Discussion

The status dictionary for a file operation is passed back to your status callback function. For more information, see “File Operation Callbacks”. You can also get the status dictionary for a file operation by calling a status accessor function such as FSFileOperationCopyStatus.*/
const CFStringRef kFSOperationTotalBytesKey;
 const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
const CFStringRef kFSOperationObjectsCompleteKey;
const CFStringRef kFSOperationObjectsRemainingKey;
const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
 const CFStringRef kFSOperationThroughputKey;


//work




/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
){};

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
){};

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
){};

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator
){};

/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum
){};

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
){};

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
){};

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
){};

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
){};

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
){};

/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
){};

/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
){};

/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
){};

/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
){};

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF
){};

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
){};

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum
){};

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
){};

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
){};

/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
){};

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
){};

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
){};

/*FSCreateFileUnicode

Creates a new file with a Unicode name.

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);
Parameters
parentRef

A pointer to an FSRef for the directory where the file is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the file's name. 
name

A pointer to the Unicode name for the new file. 
whichInfo

A bitmap specifying which catalog information fields to set for the new file. You specify the values for these fields in the catalogInfo parameter. If you do not wish to set catalog information for the new file, pass the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values of the new file’s catalog information. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new file.

newRef

On return, a pointer to the FSRef for the new file. If you do not want the FSRef returned, specify NULL.
newSpec

On return, a pointer to the FSSpec for the new file. If you do not want the FSSpec returned, specify NULL. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new file using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the file. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateFileUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBHCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode filenames, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
){};


/*FSSetCatalogInfo

Sets catalog information about a file or directory.

OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);
Parameters
ref

A pointer to an FSRef specifying the file or directory whose information is to be changed. See FSRef for a description of the FSRef data type.
whichInfo

A bitmap specifying which catalog information fields to set. Only some of the catalog information fields may be set. These fields are given by the constant kFSCatInfoSettableInfo; no other bits may be set in the whichInfo parameter. See Catalog Information Bitmap Constants for a description of the bits in this parameter.

To set the user ID (UID) and group ID (GID) on Mac OS X, specify the kFSCatInfoSetOwnership flag in this parameter. The File Manager attempts to set the user and group ID to the values specified in the permissions field of the catalog information structure. If FSSetCatalogInfo cannot set the user and group IDs, it returns an error.
catalogInfo

A pointer to the structure containing the new catalog information. Only some of the catalog information fields may be set. The fields which may be set are:
createDate
contentModDate
attributeModDate
accessDate
backupDate
permissions
finderInfo
extFinderInfo
textEncodingHint

On Mac OS 9, you may also set the kFSNodeLockedBit bit in the nodeFlags field if you are changing catalog information for a file.

Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
){};

/*FSDeleteObject

Deletes a file or an empty directory. 

OSErr FSDeleteObject (
   const FSRef * ref
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to be deleted. If the object to be deleted is a directory, it must be empty (it must contain no files or folders). See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”. On Mac OS 8 and 9, if you attempt to delete a folder for which there is an open catalog iterator, FSDeleteObject returns the error fBsyErr. On Mac OS X, a similar attempt to delete a folder while another process has an open iterator will succeed and FSDeleteObject returns noErr. Iteration, however, will continue to work until the iterator is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSDeleteObject (
   const FSRef * ref
){};

/*FSDisposeVolumeOperation

Releases the memory associated with a volume operation. 

OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);
Parameters
volumeOp

The FSVolumeOperation to release. 
Return Value

A result code. See “File Manager Result Codes”. This function will return paramErr if the FSVolumeOperation is in use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
){};

/*FSMountServerVolumeAsync

Mounts a server volume asynchronously.

OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);
Parameters
url

The server to mount. 
mountDir

The directory to mount the server to. If this parameter is NULL, the default location is used. 
user

A string to pass as the user for authentication. This parameter can be NULL. 
password

A string to pass as the password for authenticated log in. This parameter can be NULL. 
volumeOp

An FSVolumeOperation returned by the FSCreateVolumeOperation function. 
clientData

A pointer to client data associated with the operation. This parameter can be NULL.
flags

Options for future use.
callback

A function to call when the mount is complete. This parameter can be NULL. 
runloop

The runloop to run on. 
runloopMode

The mode for the runloop. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function will start the process to mount the server specified by the url parameter at the location specified by the mountDir parameter. If mountDir is NULL, the default location is used. An optional user and password can be passed in for authentication. If no user or password is provided then the underlying file system will handle authentication if required. If a callback function is provided, that function will be called when the mount operation is complete. Once this function returns noErr the status of the operation can be found using the FSGetAsyncMountStatus function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/


OSStatus FSMountServerVolumeAsync (
    CFURLRef url,
  CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
){};

/*NewFSVolumeMountUPP


FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the FSVolumeMountUPP data type.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
){};

/*FSCreateVolumeOperation

Returns an FSVolumeOperation which can be used for an asynchronous volume operation. 

OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);
Parameters
volumeOp

The new FSVolumeOperation. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

When the operation is completed the FSVolumeOperation should be disposed of to free the memory associated with the operation using FSDisposeVolumeOperation.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
){};

/*FSpMakeFSRef

Creates an FSRef for a file or directory, given an FSSpec.

OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);
Parameters
source

A pointer to the FSSpec for the file or directory. This parameter must point to a valid FSSpec for an existing file or directory; if it does not, the call will return fnfErr. See FSSpec for a description of the FSSpec data type.
newRef

On input, a pointer to an FSRef structure. On return, a pointer to the FSRef for the file or directory specified in the FSSpec pointed to in the source parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To obtain an FSSpec from an FSRef, use the FSGetCatalogInfo function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
){};

/*FSCompareFSRefs

Determines whether two FSRef structures refer to the same file or directory.

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);
Parameters
ref1

A pointer to the first FSRef to compare. For a description of the FSRef data type, see FSRef.
ref2

A pointer to the second FSRef to compare.
Return Value

A result code. See “File Manager Result Codes”. If the two FSRef structures refer to the same file or directory, then noErr is returned. If they refer to objects on different volumes, then diffVolErr is returned. If they refer to different files or directories on the same volume, then errFSRefsDifferent is returned. This function may return other errors, including nsvErr, fnfErr, dirNFErr, and volOffLinErr.
Discussion

You must use FSCompareFSRefs, or one of the corresponding parameter block functions, PBCompareFSRefsSync and PBCompareFSRefsAsync , to compare FSRef structures. It is not possible to compare the FSRef structures directly since some bytes may be uninitialized, case-insensitive text, or contain hint information.

Some volume formats may be able to tell that two FSRef structures would refer to two different files or directories, without having to actually find those objects. In this case, the volume format may return errFSRefsDifferent even if one or both objects no longer exist. Similarly, if the FSRef structures are for objects on different volumes, the File Manager will return diffVolErr even if one or both volumes are no longer mounted. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
){};

/*FSCreateDirectoryUnicode

Creates a new directory (folder) with a Unicode name. 

OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);
Parameters
parentRef

A pointer to an FSRef specifying the parent directory where the new directory is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the new directory's Unicode name. 
name

A pointer to the Unicode name of the new directory. 
whichInfo

A bitmap specifying which catalog information fields to set for the new directory. Specify the values for these fields in the catalogInfo parameter. 

If you do not wish to set catalog information for the new directory, specify the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values for the catalog information fields for the new directory. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new directory.

See FSCatalogInfo for a description of the FSCatalogInfo data type.
newRef

On return, a pointer to the FSRef for the new directory. This parameter is optional; specify NULL if you do not want the FSRef returned.
newSpec

On return, a pointer to the FSSpec for the new directory. This parameter is optional; specify NULL if you do not want the FSSpec returned. See FSSpec for a description of the FSSpec data type.
newDirID

On return, a pointer to the directory ID of the directory. This parameter is optional; specify NULL if you do not want the directory ID returned. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new directory using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the directory. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateDirectoryUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBDirCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode directory names, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
){};

/*FSWrite

Writes any number of bytes to an open file. (Deprecated in Mac OS X v10.4. Use FSWriteFork instead.)

OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);
Parameters
refNum

The file reference number of the open file to which to write. 
count

On input, a pointer to the number of bytes to write to the file. In Carbon on Mac OS 9 and X, passing 0 in this parameter will return a paramErr error.

On output, a pointer to the number of bytes actually written.

buffPtr

A pointer to the data buffer containing the data to write. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSWrite function takes the specified number of bytes from the data buffer and attempts to write them to the file. Because the write operation begins at the current mark, you might want to set the mark first by calling the SetFPos function.

If the write operation completes successfully, FSWrite moves the file mark to the byte following the last byte written and returns noErr. If you try to write past the logical end-of-file, FSWrite moves the logical end-of-file. If you try to write past the physical end-of-file, FSWrite adds one or more clumps to the file and moves the physical end-of-file accordingly.

The low-level functions PBWriteSync and PBWriteAsync let you set the mark without having to call SetFPos. For a description of the PBWriteSync and PBWriteAsync functions, see the Device Manager Reference .

If you wish to write to named forks other than the data or resource forks, or grow files larger than 2GB, you must use the FSWriteFork function, or one of its corresponding parameter block calls, PBWriteForkSync and PBWriteForkAsync. If you attempt to use FSWrite to write to a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/


OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
){};

/*FSpCreate

Creates a new file. (Deprecated in Mac OS X v10.4. Use FSCreateFileUnicode instead.)

OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to be created. See FSSpec for a description of the FSSpec data type.
creator

The creator of the new file. See the documentation for the Finder Interface for more information on file creators. 
fileType

The file type of the new file. See the documentation for the Finder Interface for more information on file types.
scriptTag

The code of the script system in which the filename is to be displayed. If you have established the name and location of the new file using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information about the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. See the Script Manager Reference for a description of the smSystemScript constant.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCreate function creates a new file (both data and resource forks) with the specified type, creator, and script code. The new file is unlocked and empty. The date and time of creation and last modification are set to the current date and time.

Files created using FSpCreate are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager functions HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpCreate is not available, you can use the function HCreate instead. To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
){};

/*FSpDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr FSpDelete (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to delete. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, FSpDelete returns the result code fBsyErr. FSpDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both forks of the file are deleted. The file ID reference, if any, is removed. A file must be closed before you can delete it. Similarly, a directory must be empty before you can delete it. 

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDelete is not available, you can use the function HDelete instead. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpDelete (
   const FSSpec * spec
){};

/*PBSetCatInfoSync

Modifies catalog information for a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBSetCatInfoSync function sets information about a file or directory. When used to set information about a file, it works much as PBHSetFInfoSync does, but lets you set some additional information.

If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFlFndrInfo 

On input, Finder information for the file. 
ioDirID 

On input, the parent directory ID of the file. 
ioFlCrDat 

On input, the date and time of the file’s creation. 
ioFlMdDat 

On input, the date and time of the file’s last modification. 
ioFlBkDat 

On input, the date and time of the file’s last backup. 
ioFlXFndrInfo 

On input, extended Finder information. 

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDrUsrWds 

On input, information used by the Finder. 
ioDrDirID 

On input, the directory ID. 
ioDrCrDat 

On input, the date and time of the directory’s creation. 
ioDrMdDat 

On input, the date and time of the directory’s last modification. 
ioDrBkDat 

On input, the date and time of the directory’s last backup. 
ioDrFndrInfo 

On input, additional information used by the Finder. 

To modify the catalog information for a named fork other than the data and resource fork, or to modify other catalog information maintained on HFS Plus volumes that is not modifiable through PBSetCatInfoSync, use one of the functions, FSSetCatalogInfo , PBSetCatalogInfoSync , or PBSetCatalogInfoAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
){};

/*SetFPos

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use FSSetForkPosition instead.)

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);
Parameters
refNum

The file reference number of an open file. 
posMode

A constant specifying how to position the file mark; this parameter must contain one of the values described in Position Mode Constants.
posOff

The offset from the base location specified by the posMode parameter for the new file mark position. If you specify fsFromLEOF in the posMode parameter, the value in the posOff parameter must be less than or equal to 0. If you specify fsAtMark, the value in the posOff parameter is ignored. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you may want to call SetFPos to reposition the file mark before reading from or writing to the file.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
){};

/*SetEOF

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSSetForkSize instead.)

OSErr SetEOF (
   short refNum,
   long logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

The new logical size (the logical end-of-file) of the given file. If you set the logEOF parameter to 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you attempt to set the logical end-of-file beyond the physical end-of-file, the physical end-of-file is set 1 byte beyond the end of the next free allocation block if there isn’t enough space on the volume, no change is made, and SetEOF returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr SetEOF (
   short refNum,
   long logEOF
){};

/*GetFPos

Returns the current position of the file mark. (Deprecated in Mac OS X v10.4. Use FSGetForkPosition instead.)

OSErr GetFPos (
   short refNum,
   long * filePos
);
Parameters
refNum

The file reference number of an open file. 
filePos

On return, a pointer to the current position of the mark. The position value is zero-based; that is, the value of filePos is 0 if the file mark is positioned at the beginning of the file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you should call GetFPos, or one of the parameter block functions, PBGetFPosSync and PBGetFPosAsync , to determine the current position of the file mark before reading from or writing to the file.

To determine the current position of a named fork, or of a fork larger than 2GB, use the FSGetForkPosition function, or one of the corresponding parameter block calls, PBGetForkPositionSync and PBGetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetFPos (
   short refNum,
   long * filePos
){};

/*FSpSetFInfo

Sets the Finder information about a file. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file for which to set the Finder information. See FSSpec for a description of the FSSpec data type.
fndrInfo

A pointer to the new Finder information. For a description of the FInfo data type, see the Finder Interface Reference.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpSetFInfo function changes the Finder information in the volume catalog entry for the specified file. FSpSetFInfo allows you to set only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
){};

/*PBSetFPosAsync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionAsync instead.)

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. 
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosAsync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosAsync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
){};

/*PBWriteForkAsync

Writes data to an open fork.

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned. 
forkRefNum 

On input, the reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching. 
positionOffset 

On input, the offset from the base location for the start of the write. 
requestCount 

On input, the number of bytes to write. 
buffer 

A pointer to a buffer containing the data to write. 
actualCount 

On output, the number of bytes actually written. The value in the actualCount field will be equal to the value in the requestCount field unless there was an error during the write operation. 

PBWriteForkAsync writes data starting at the position specified by the positionMode and positionOffset fields. The function attempts to write requestCount bytes from the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
){};

/*PBReadForkAsync

Reads data from an open fork.

void PBReadForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam data type.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned. 
forkRefNum 

On input, the reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read. 
positionOffset 

On input, the offset from the base location for the start of the read. 
requestCount 

On input, the number of bytes to read. The value that you pass in this field should be greater than zero. 
buffer 

A pointer to the buffer where the data will be returned. 
actualCount 

On output, the number of bytes actually read. The value in this field should be equal to the value in the requestCount field unless there was an error during the read operation. 

PBReadForkAsync reads data starting at the position specified by the positionMode and positionOffset fields. The function reads up to requestCount bytes into the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode field and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadForkAsync with a value of 0 in the requestCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadForkAsync returns a paramErr error if the value in the requestCount field is 0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBReadForkAsync (
   FSForkIOParam * paramBlock){};

/*NewIOCompletionUPP

Creates a new universal procedure pointer (UPP) to your completion function.

IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a completion callback function. See IOCompletionProcPtr for a description of the IOCompletionProcPtr data type.
Return Value

A universal procedure pointer to your completion function. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
){};

/*FSpGetFInfo

Obtains the Finder information for a file. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file. See FSSpec for a description of the FSSpec data type.
fndrInfo

On return, a pointer to information used by the Finder. The FSpGetFInfo function returns the Finder information from the volume catalog entry for the specified file. The function provides only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. For a description of the FInfo structure, see the Finder Interface Reference.
Return Value

A result code. If the specified object is a folder, this function returns fnfErr. For other possible return values, see “File Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
){};

/*PBHGetFInfoSync

Obtains information about a file. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a pathname. If the value of the ioFDirIndex field is negative or 0, PBHGetFInfoSync returns information about the file in the volume specified by the reference number in the ioVRefNum field and having the name given here.On output, a pointer to the name of the file, if the file is open. If you do not wish the name returned, pass NULL here. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file, or 0 for the default volume. 
ioFRefNum 

On output, the reference number of the first access path found, if the file is open and if the ioFDirIndex field is negative or 0; if the ioFDirIndex field is positive... 
ioFDirIndex 

On input, a directory index. If this value is positive, the function returns information about the file having the directory index specified here, on the volume specified in the ioVRefNum field and in the directory specified in the ioDirID field.If this value is negative or 0, the function returns information about the file on the specified volume, having the name pointed to in the ioNamePtr field. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for a description of the file attributes. 
ioFlFndrInfo 

On output, Finder information about the file. For a description of the FInfo data type, see the Finder Interface Reference . 
ioDirID 

On input, the parent directory ID of the file. On output, the file’s file ID. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 
ioFlStBlk 

On ouput, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the file’s data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the file’s data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 

You should call PBHGetFInfoSync just before PBHSetFInfoSync , so that the current information is present in the parameter block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
){};

/*PBCreateFileIDRefSync

Establishes a file ID reference for a file.

OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.PBCreateFileIDRefSync returns the result code fidExists if a file ID reference already exists for the file.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

Given a volume reference number, filename, and parent directory ID, the PBCreateFileIDRefSync function creates a structure to hold the name and parent directory ID of the specified file. The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the file’s name. 
ioVRefNum 

On input, a volume reference number for the volume containing the file. 
ioSrcDirID 

On input, the file’s parent directory ID. 
ioFileID 

On output, a file ID. If a file ID reference already exists for the file, PBCreateFileIDRefSync supplies the file ID but returns the result code fidExists. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*FSpRename

Renames a file or directory. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to rename. See FSSpec for a description of the FSSpec data type.
newName

The new name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If a file ID reference for the specified file exists, it remains with the renamed file.

If you want to change the name of a new copy of an existing file, you should use the FSpExchangeFiles function instead. To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
){};

/*HGetVol

Determines the current default volume and default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);
Parameters
volName

On return, a pointer to the name of the default volume. If you do not want the name of the default volume returned, set this parameter to NULL. 
vRefNum

On return, a pointer to the volume reference number of the default volume. 
dirID

On return, a pointer to the directory ID of the default directory. 
Return Value

A result code. See “File Manager Result Codes”.
Version Notes

When CarbonLib is not present, the HGetVol function returns a working directory reference number in the vRefNum parameter if the previous call to HSetVol (or one of the corresponding parameter block calls) passed in a working directory reference number.
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
){};

/*FSpOpenRF

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose resource fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s resource fork. For a description of the types of access you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open resource fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSpOpenRF will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenRF is not available, you can use the function HOpenRF instead. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenRF function, you will receive an error message. 
Special Considerations

Generally, your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The FSpOpenRF function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork. 

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
){};

/*FlushVol

Writes the contents of the volume buffer and update information about the volume.

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
);
Parameters
volName

The name of the mounted volume to flush. 
vRefNum

The volume reference number, drive number, or 0 for the default volume. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the specified volume, the FlushVol function writes the contents of the associated volume buffer and descriptive information about the volume. Information which has changed since the last time FlushVol was called is written to the volume. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
){};

/*PBGetVolMountInfoSize

Determines how much space to allocate for a volume mounting information structure.

OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to storage for the size information, which is of type Integer (2 bytes). If PBGetVolMountInfoSize returns noErr, that integer contains the size of the volume mounting information structure on output. 

You should call this function before you call PBGetVolMountInfo , to obtain the size of the volume mounting information for which you must allocate storage. Then call PBGetVolMountInfo to retrieve the actual volume mounting information. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
){};

/*PBGetVolMountInfo

Retrieves a record containing all the information needed to mount a volume, except for passwords.

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a buffer to hold the mounting information. The length of the buffer is specified by the value pointed to by the ioBuffer field in a previous call to PBGetVolMountInfoSize. On output, the mounting information for the specified volume. You can later pass this structure to the PBVolumeMount function to mount the volume.The mounting information for an AppleShare volume is stored as an AFP mounting record. The PBGetVolMountInfo function does not return the user password or volume password in the AFPVolMountInfo structure. Your application should solicit these passwords from the user and fill in the structure before attempting to mount the remote volume. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. This programmatic mounting function stores the mounting information in a structure called the AFPVolMountInfo structure. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
){};

/*FSCopyDiskIDForVolume

Returns a copy of the disk ID for a volume.

OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
);
Parameters
vRefNum

The volume reference number of the target volume. 
diskID

On return, a pointer to the disk ID string associated with the target volume. 
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
){};

/*FSRenameUnicode

Renames a file or folder.

OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef for the file or directory to rename. See FSRef for a description of the FSRef data type.
nameLength

The length of the new name in Unicode characters. 
name

A pointer to the new Unicode name of the file or directory. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, a pointer to the new FSRef for the file or directory. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because renaming an object may change its FSRef, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to access the object after the renaming, if you wish to continue to refer to the object. The FSRef passed in the ref parameter may or may not be usable after the object is renamed. The FSRef returned in the newRef parameter may point to the same storage as the FSRef passed in ref. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
){};

/*FSIterateForks

Determines the name and size of every named fork belonging to a file or directory.

OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to iterate. See FSRef for a description of the FSRef data type.
forkIterator

A pointer to a structure which maintains state between calls to FSIterateForks. Before the first call, set the initialize field of the structure to 0. The fork iterator will be updated after the call completes; the updated iterator should be passed into the next call. See CatPositionRec for a description of the CatPositionRec data type.
forkName

On return, a pointer to the Unicode name of the fork. This parameter is optional; if you do not wish the name returned, pass a NULL pointer. See HFSUniStr255 for a description of the HFSUniStr255 data type.
forkSize

On return, a pointer to the logical size of the fork, in bytes. This parameter is optional; if you do not wish to retrieve the logical fork size, pass a NULL pointer. 
forkPhysicalSize

On return, a pointer to the physical size of the fork (that is, to the amount of space allocated on disk), in bytes. This parameter is optional; if you do not wish to retrieve the physical fork size, pass a NULL pointer. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Since information is returned about one fork at a time, several calls may be required to iterate through all the forks. There is no guarantee about the order in which forks are returned; the order may vary between iterations. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
){};

/*PBHCopyFileSync

Duplicates a file and optionally renames it.

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the source file. 
ioVRefNum 

On input, the volume reference number or drive number for the volume containing the source file. Pass 0 for the default volume. 
ioDstVRefNum 

On input, the reference number or drive number of the destination volume. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the partial pathname for the destination directory. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 

This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it. 
Special Considerations

This is an optional call for AppleShare file servers. Your application should examine the information returned by the PBHGetVolParmsSync function to see if the volume supports PBHCopyFileSync. If the bHasCopyFile bit is set in the vMAttrib field of the GetVolParmsInfoBuffer structure, then the volume supports PBHCopyFileSync.

For AppleShare file servers, the source and destination pathnames must indicate the same file server; however, the parameter block may specify different source and destination volumes on that file server. A useful way to tell if two file server volumes are on the same file server is to call the PBHGetVolParmsSync function for each volume and compare the server addresses returned. The server opens source files with read/deny write enabled and destination files with write/deny read and write enabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
){};

/*PBHGetDirAccessSync

Returns the access control information for a directory or file.

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the directory or file. 
ioVRefNum 

On input, a volume specification for the volume containing the directory or file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On output, the user ID for the owner of the directory or file. 
ioACGroupID 

On output, the primary group ID of the directory or file. 
ioACAccess 

On output, the access rights for the directory or file. See File and Folder Access Privilege Constants for more information on these access rights.
ioDirID 

On input, the directory ID. 
Version Notes

On Mac OS 8 and 9, PBHGetDirAccessSync only returns access information for directories; you cannot use it to return information for files.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
){};

/*FSAllocateFork

Allocates space on a volume to an open fork.

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain a fork reference number with the FSOpenFork function, or with one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
flags

A constant indicating how the new space should be allocated. See Allocation Flags for a description of the constants which you can use in this parameter.
positionMode

A constant specifying the base location for the start of the allocation. See Position Mode Constants for more information on the constants which you can use to specify the base location. 
positionOffset

The offset from the base location of the start of the allocation. 
requestCount

The number of bytes to allocate. 
actualCount

On return, a pointer to the number of bytes actually allocated to the file. The value returned in here may be smaller than the number specified in the requestCount parameter if some of the space was already allocated. The value pointed to by the actualCount parameter does not reflect any additional bytes that may have been allocated because space is allocated in terms of fixed units such as allocation blocks, or the use of a clump size to reduce fragmentation. 

The actualCount output is optional if you don’t want the number of allocated bytes returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSAllocateFork function attempts to allocate requestCount bytes of physical storage starting at the offset specified by the positionMode and positionOffset parameters. For volume formats that support preallocated space, you can later write to this range of bytes (including extending the size of the fork) without requiring an implicit allocation.

Any extra space allocated but not used will be deallocated when the fork is closed, using FSCloseFork , PBCloseForkSync , or PBCloseForkAsync ; or when the fork is flushed, using FSFlushFork , PBFlushForkSync , or PBFlushForkAsync. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
){};

/*FSWriteFork

Writes data to an open fork.

OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching.
positionOffset

The offset from the base location for the start of the write. 
requestCount

The number of bytes to write. 
buffer

A pointer to a buffer containing the data to write. 
actualCount

On return, a pointer to the number of bytes actually written. The value pointed to by the actualCount parameter will be equal to the value in the requestCount parameter unless there was an error during the write operation.

This parameter is optional; if you don’t want this information, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned.
Discussion

FSWriteFork writes data starting at the position specified by the positionMode and positionOffset parameters. The function attempts to write requestCount bytes from the buffer pointed at by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
){};

/*FSCreateFork

Creates a named fork for a file or directory.

OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
);
Parameters
ref

A pointer to an FSRef specifying the file or directory. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the name of the new fork. 
forkName

A pointer to the Unicode name of the fork. 
Return Value

A result code. See “File Manager Result Codes”. If the named fork already exists, the function returns errFSForkExists. If the fork name is syntactically invalid or otherwise unsupported for the given volume, FSCreateFork returns errFSBadForkName or errFSNameTooLong.
Discussion

A newly created fork has zero length (that is, its logical end-of-file is zero). The data and resource forks of a file are automatically created and deleted as needed. This is done for compatibility with older APIs, and because data and resource forks are often handled specially. If a given fork always exists for a given volume format (such as data and resource forks for HFS and HFS Plus, or data forks for most other volume formats), an attempt to create that fork when a zero-length fork already exists should return noErr; if a non-empty fork already exists then errFSForkExists should be returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
){};

/*FSSetForkSize

Changes the size of an open fork.

OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant indicating the base location within the fork for the new size. See Position Mode Constants for more information about the constants you can use to specify the base location. 
positionOffset

The offset of the new size from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to extend the fork, then dskFulErr is returned and the fork’s size is unchanged.
Discussion

The FSSetForkSize function sets the logical end-of-file to the position indicated by the positionMode and positionOffset parameters. The fork’s new size may be less than, equal to, or greater than the fork’s current size. If the fork’s new size is greater than the fork’s current size, then the additional bytes, between the old and new size, will have an undetermined value.

If the fork’s current position is larger than the fork’s new size, then the current position will be set to the new fork size the current position will be equal to the logical end-of-file. 
Special Considerations

You do not need to check that the volume supports the FSSetForkSize function. If a volume does not support the FSSetForkSize function, but the FSSetForkSize function is present, the File Manager automatically calls the PBSetEOFSync function and translates between the calls appropriately. 

Note, however, that if the volume does not support the FSSetForkSize function, you can only access the data and resource forks, and you cannot grow the fork beyond 2GB. To check that the FSSetForkSize function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
){};

/*FSCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory.

OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};

/*FSMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory.

OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
source

A pointer to the source object to move. The object can be a file or a directory.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};

/*FSFileOperationCreate

Creates an object that represents an asynchronous file operation.

FSFileOperationRef FSFileOperationGetTypeID (
   CFAllocatorRef alloc
);
Parameters
alloc

The allocator to use. Pass NULL for the default allocator.
Return Value

A new FSFileOperation object, or NULL if the object could not be created. When you no longer need the object, you should release it by calling CFRelease.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
FSFileOperationRef FSFileOperationCreate (
   CFAllocatorRef alloc
){};

/*FSFileOperationScheduleWithRunLoop

Schedules an asynchronous file operation with the specified run loop and mode.

OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
fileOp

The file operation to schedule.
runLoop

The run loop in which to schedule the operation. For information about Core Foundation run loops, see Run Loops.
runLoopMode

The run loop mode in which to schedule the operation. In most cases, you may specify kCFRunLoopCommonModes.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To run, a file operation must be scheduled with at least one run loop. A file operation can be scheduled with multiple run loop and mode combinations.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
){};

/*FSPathMoveObjectSync

Moves a source object into a destination directory using paths.

OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should call it in a thread other than the main thread or use FSPathMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
){};

/*FSPathCopyObjectSync

Copies a source object into a destination directory using paths.

OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSPathCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
){};

/*FSPathFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation that uses paths.

OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory). You should free the path when you are finished using it.
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
){};

/*FSPathMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory using paths.

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};

/*FSPathCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory using paths.

OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
){};

/*FSMoveObjectSync

Moves a source object into a destination directory.

OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to move. The object can be a file or a directory. On output, the source object is no longer valid; if you want to refer to the moved object, you should use the FSRef variable passed back in the target parameter.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should either call it in a thread other than the main thread or use FSMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
){};

/*FSCopyObjectSync

Copies a source object into a destination directory.

OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
){};

/*FSFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation.

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to an FSRef variable. On output, the variable contains the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory).
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
){};

/*Accessing Information About Files and Directories
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoSync
   				(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBSetCatInfoSync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBHGetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRstFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRename		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRenameSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRenameAsync	(HParmBlkPtr paramBlock);*/
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async){};

/*Obtaining Volume Information
pascal OSErr PBHGetVInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfo		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBSetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfoAsync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVolParmsSync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParmsAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async){};

/*Searching a Catalog
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBCatSearchSync	(HParmBlkPtr paramBlock);
pascal OSErr PBCatSearchAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async){};

/*FSpExchangeFiles

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use FSExchangeObjects instead.)

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec for the first file to swap. The contents of this file and its file information are placed in the file specified in the dest parameter. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec for the second file to swap. The contents of this file and its file information are placed in the file specified in the source parameter.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpExchangeFiles function swaps the data in two files by changing the information in the volume’s catalog and, if either of the files are open, in the file control blocks. The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use FSpExchangeFiles when updating an existing file, so that the file ID remains valid in case the file is being tracked through its file ID. The FSpExchangeFiles function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The FSpExchangeFiles function works on both open and closed files. If either file is open, FSpExchangeFiles updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access permissions as opening both files for writing.

The files whose data is to be exchanged must both reside on the same volume. If they do not, FSpExchangeFiles returns the result code diffVolErr.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

The “compatibility code,” by which FSpExchangeFiles attempted to perform the file exchange itself if it suspected that the underlying filesystem did not have Exchange capability, has been removed in Carbon on Mac OS 9 and X. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling FSpExchangeFiles. Exclusive read/write access to both files will ensure that FSpExchangeFiles doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

FSpExchangeFiles does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling FSpExchangeFiles ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
){};

/*PBCatalogSearchAsync

Searches for objects traversed by a catalog iterator that match a given set of criteria.

void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
);
Parameters
paramBlock

A pointer to a catalog information parameter block. See FSCatalogBulkParam for a description of the FSCatalogBulkParam data type.
Discussion

The relevant fields of this parameter are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. When the entire volume has been searched, errFSNoMoreItems is returned. 
iterator 

On input, the iterator to use. Objects traversed by this iterator are matched against the criteria specified by the searchParams field. You can obtain a catalog iterator with the function FSOpenIterator , or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, this iterator must be created with the kFSIterateSubtree option and the container must be the root directory of a volume. See FSIterator for more information on the FSIterator data type. 
searchParams 

On input, a pointer to an FSSearchParams structure containing the search criteria. You can match against the object’s name in Unicode and by the fields in an FSCatalogInfo structure. You may use the same search bits as passed in the ioSearchBits field to the PBCatSearchSync and PBCatSearchAsync functions; they control the corresponding FSCatalogInfo fields. See Catalog Search Masks for a description of the search bits.There are a few new search criteria supported by PBCatalogSearchAsync but not by PBCatSearchSync and PBCatSearchAsync. These new search criteria are indicated by the constants described in Catalog Search Constants.If the searchTime field of this structure is non-zero, it is interpreted as a Time Manager duration; the search may terminate after this duration even if maximumItems objects have not been returned and the entire catalog has not been scanned. If searchTime is zero, there is no time limit for the search.If you are searching by any criteria other than name, you must set the searchInfo1 and searchInfo2 fields of the structure in this field to point to FSCatalogInfo structures containing the values to match against. 
maximumItems 

On input, the maximum number of items to return for this call. 
actualItems 

On output, the actual number of items returned for this call. 
containerChanged 

On output, a Boolean value indicating whether the container’s contents have changed. If true, the container’s contents changed since the previous PBCatalogSearchAsync call. Objects may still be returned even though the container changed. Note that if the container has changed, then the total set of items returned may be incorrect; some items may be returned multiple times, and some items may not be returned at all. 
whichInfo 

On input, a bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this field. See Catalog Information Bitmap Constants for a description of the bits in this field. 
catalogInfo 

On output, a pointer to an array of FSCatalogInfo structures; one for each found item. On input, the catalogInfo field should point to an array of maximumItems catalog information structures.This field is optional; if you do not wish any catalog information returned, pass NULL here. 
refs 

On output, a pointer to an array of FSRef structures; one for each returned item. On input, if you want an FSRef for each item found, pass a pointer to an array of maximumItems FSRef structures. Otherwise, pass NULL. 
names 

On output, a pointer to an array of filenames; one for each returned item. On input, if you want the Unicode filename for each item found, pass a pointer to an array of maximumItems HFSUniStr255 structures. Otherwise, pass NULL. 

A single search may span more than one call to PBCatalogSearchAsync. The call may complete with no error before scanning the entire volume. This typically happens because the time limit ( searchTime) has been reached or maximumItems items have been returned. If the search is not completed, you can continue the search by making another call to PBCatalogSearchAsync and passing the updated iterator returned by the previous call in the iterator field.

Before calling this function, you should determine that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
){};

/*DisposeIOCompletionUPP

Disposes of a universal procedure pointer (UPP) to your completion callback function.

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
);
Parameters
userUPP

The universal procedure pointer to dispose. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Discussion

See IOCompletionProcPtr for more information about completion functions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
){};

/*PBGetFCBInfoSync

Gets information about an open file from the file control block. (Deprecated in Mac OS X v10.4. Use PBGetForkCBInfoSync instead.)

OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a file control block parameter block. See FCBPBRec for a description of the FCBPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. You should pass a pointer to a Str31 value if you want the name of the file returned. If you pass NULL, no filename is returned. On output, if PBGetFCBInfoSync executes successfully, a pointer to the name of the specified open file. 
ioVRefNum 

On input, a volume specification. If you specify a valid index number in the ioFCBIndx field, the File Manager returns information on the file having that index in the FCB buffer on the volume specified in this field. This field may contain a drive number or volume reference number. If the value of ioVRefNum is 0, all open files are indexed; otherwise, only open files on the specified volume are indexed. 
ioRefNum 

On input, if the ioFCBIndx field is 0, the file reference number of the file to get information about. If the value of ioFCBIndx is positive, the ioRefNum field is ignored on input and contains the file reference number on output. 
ioFCBIndx 

On input, an index. If the value of ioFCBIndx is positive, the File Manager returns information about the file whose index in the FCB buffer is ioFCBIndx and that is located on the volume specified in the ioVRefNum field.If the value of ioFCBIndx is 0, the File Manager returns information about the file whose file reference number is specified by the ioRefNum field. 
ioFCBFlNm 

On output, the file ID. 
ioFCBFlags 

On output, file status flags. See FCB Flags for a description of the bits in this field. 
ioFCBStBlk 

On output, the first allocation block of the file. 
ioFCBEOF 

On output, the logical size (the logical end-of-file) of the file. 
ioFCBPLen 

On output, the physical size (the physical end-of-file) of the file. 
ioFCBCrPs 

On output, the current position of the file mark. 
ioFCBVRefNum 

On output, the volume reference number. 
ioFCBClpSiz 

On output, the file clump size. 
ioFCBParID 

On output, the directory ID of the file’s parent directory. 

To get information about a fork control block, use one of the functions, FSGetForkCBInfo , PBGetForkCBInfoSync , or PBGetForkCBInfoAsync. 
Special Considerations

On OS X, the value returned by PBGetFCBInfoSync in the ioFCBPLen field may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by PBGetFCBInfoSync changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
){};

/*PBHGetVInfoSync

Gets detailed information about a volume. (Deprecated in Mac OS X v10.4. Use PBGetVolumeInfoSync instead.)

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HVolumeParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.On output, a pointer to the volume’s name. You should pass a pointer to a Str31 value if you want the name returned. If you pass NULL, no volume name is returned. 
ioVRefNum 

On input, a volume reference number or drive number for the volume for which to return information; or 0 for the default volume. If the ioVolIndex field is negative, the File Manager uses the value in the ioNamePtr field, along with the value specified in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field. On output, the volume reference number. 
ioVolIndex 

On input, an index used for indexing through all mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s initialization. 
ioVLsMod 

On output, the date and time of the volume’s last modification. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of the volume attributes returned by this function. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block at which the search for the next new file allocation should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the size of the allocation blocks. 
ioVClpSiz 

On output, the default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of unused allocation blocks. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 

Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system handling this volume. 
ioVBkUp 

On output, the date and time of the volume’s last backup. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 

You can get information about all the online volumes by making repeated calls to PBHGetVInfoSync, starting with the value of the ioVolIndex field set to 1 and incrementing that value until PBHGetVInfoSync returns nsvErr.

If you need to obtain information about HFS Plus volumes, you should use the FSGetVolumeInfo function, or one of the corresponding parameter block calls, PBGetVolumeInfoSync and PBGetVolumeInfoAsync. The PBHGetVInfoSync function is still supported for HFS Plus volumes, but there is additional information returned by the FSGetVolumeInfo function (such as the date and time that the volume was last checked for consistency). 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBHGetVInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.

If the value of ioVolIndex is negative, the File Manager uses ioNamePtr and ioVRefNum in the standard way to determine the volume. However, because PBHGetVInfoSync returns the volume name in the buffer whose address you passed in ioNamePtr, your input pathname will be modified. If you don't want your input pathname modified, make a copy of it and pass the copy to PBHGetVInfoSync.

The volume name returned by PBHGetVInfoSync is not a full pathname to the volume because it does not contain a colon.

For compatibility with older programs, some values returned by PBHGetVInfoSync are not what is stored in the volume's Volume Control Block (VCB). Specifically:
ioVNmAlBlks and ioVFrBlk are pinned to values which, when multiplied by ioVAlBlkSiz, are always less than 2 Gigabytes.
ioVNmAlBlks may not include the allocation blocks used by the catalog and extents overflow files. 
$4244 is returned in ioVSigWord for both HFS and HFS Plus volumes. 

For unpinned total and free byte counts, and for the real ioVSigWord, use PBXGetVolInfoSync instead of PBHGetVInfoSync.
Version Notes

In non-Carbon applications, you may pass a working directory reference in the ioVRefNum field; if you pass a working directory reference in that field, the number of files and directories in the specified directory is returned in the ioVNmFls field.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
){};

/*FSGetResourceForkName

Returns a Unicode string constant for the name of the resource fork. 

OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
);
Parameters
resourceForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the resource fork. Currently, this is “RESOURCE_FORK”. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
){};

/*HRename

Renames a file, directory, or volume. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
oldName

An existing filename, directory name, or volume name. 
newName

The new filename, directory name, or volume name.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Given the name of a file or directory in the oldName parameter, HRename changes it to the name in the newName parameter. Given a volume name in the oldName parameter or a volume reference number in the vRefNum parameter, HRename changes the name of the volume to the name in newName. Access paths currently in use aren’t affected by this function.

If a file ID reference exists for a file you are renaming, the file ID remains with the renamed file.

To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Special Considerations

You cannot use HRename to change the directory in which a file resides. To move a file or directory, use the FSpCatMove, PBCatMoveSync, or PBCatMoveAsync functions. 

If you’re renaming a volume, make sure that both names end with a colon.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
){};

/*DirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
parentDirID

The directory ID of the parent directory. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is a volume other than the default volume, the new directory is placed in the root directory of the volume.To create a directory at the root of a volume, regardless of whether that volume is the current default volume, pass the constant fsRtDirID(2) in this parameter. 
directoryName

The name of the new directory. 
createdDirID

On return, a pointer to the directory ID of the new directory. Note that a directory ID, unlike a volume reference number, is a long integer.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The date and time of the new directory’s creation and last modification are set to the current date and time.

To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
){};

/*PBGetEOFSync

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBGetForkSizeSync instead.)

OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On output, a pointer to the logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you’ll need to coerce the value to a long integer to interpret the value correctly. 

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
){};

/*PBXGetVolInfoSync

Returns information about a volume, including size information for volumes up to 2 terabytes. (Deprecated in Mac OS X v10.4. Use FSGetVolumeInfo instead.)

OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
);
Parameters
paramBlock

A pointer to an extended volume parameter block. See XVolumeParam for a description of the XVolumeParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. You should pass a pointer to a Str31 value if you want the volume name returned; otherwise, pass NULL. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.the volume’s name. On output, a pointer to the volume’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. If the value in the ioVolIndex field is negative, the File Manager uses the name in the ioNamePtr field, along with the value in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field.On output, the volume reference number. 
ioXVersion 

On input, the version of the extended volume parameter block. Currently, this value is 0. 
ioVolIndex 

On input, an index used for indexing through all the mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s creation (initialization). 
ioVLsMod 

On output, the date and time that the volume was last modified. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of these attributes. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block where the next new file allocation search should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the allocation block size for the volume. 
ioVClpSiz 

On output, the volume’s default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of free (unused) allocation blocks on the volume. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system ID for the file system handling this volume. 
ioVBkUp 

On output, the date and time that the volume was last backed up. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 
ioVTotalBytes 

On output, the total number of bytes on the volume. 
ioVFreeBytes 

On output, the number of free bytes on the volume. 

The PBXGetVolInfoSync function is similar to the PBHGetVInfoSync function except that it returns additional volume space information in 64-bit integers and does not modify the information copied from the volume’s volume control block (VCB). Systems that support PBXGetVolInfoSync will have the gestaltFSSupports2TBVols bit set in the response returned by the gestaltFSAttr Gestalt selector. See Inside Mac OS X: Gestalt Manager Reference for a description of the gestaltFSAttr selector and of the bits that may be returned in the response. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBXGetVolInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
){};

/*Mounting and Unmounting Volumes
pascal OSErr PBMountVol		(ParmBlkPtr paramBlock);
pascal OSErr PBUnmountVol	(ParmBlkPtr paramBlock);
pascal OSErr PBEject		(ParmBlkPtr paramBlock);
pascal OSErr PBOffLine		(ParmBlkPtr paramBlock);*/
pascal OSErr PBEject		(ParmBlkPtr paramBlock){};

/*PBHOpenDenySync

Opens a file’s data fork using the access deny modes.

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenDenySync and PBHOpenRFDenySync functions (or their asynchronous counterparts, PBHOpenDenyAsync and PBHOpenRFDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s resource fork with access deny permissions, use the PBHOpenRFDenySync or PBHOpenRFDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
){};

/*PBGetUGEntrySync

Gets a user or group entry from the list of User and Group names and IDs on a local file server. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
){};

/*PBUnmountVol

Unmounts a volume. (Deprecated in Mac OS X v10.4. Use FSEjectVolumeSync instead.)

OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the VolumeParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to the name of the volume. 
ioVRefNum 

On input, the volume reference number of the volume to unmount, or 0 for the default volume. 

The PBUnmountVol function unmounts the specified volume. All user files on the volume must be closed. Then, PBUnmountVol calls PBFlushVolSync to flush the volume and releases the memory used for the volume.

The PBUnmountVol function always executes synchronously. 
Special Considerations

Don’t unmount the startup volume. Doing so will cause a system crash.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
){};

/*CatMove

Moves files or directories from one directory to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to move. 
oldName

The existing name of the file or directory to move. 
newDirID

If the newName parameter is empty, the directory ID of the destination directory; otherwise, the parent directory ID of the destination directory.
newName

The name of the destination directory. If a valid directory name is provided in this parameter, the destination directory’s parent directory is specified in the newDirID parameter. However, you can specify an empty name for newName, in which case newDirID should be set to the directory ID of the destination directory.

It is usually simplest to specify the destination directory by passing its directory ID in the newDirID parameter and by setting newName to an empty name. To specify an empty name, set newName to ':'.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

CatMove is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk.

The CatMove function cannot move a file or directory to another volume (that is, the vRefNum parameter is used in specifying both the source and the destination). Also, you cannot use it to rename files or directories; to rename a file or directory, use HRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Version Notes

On Mac OS 9, CatMove can change the location of locked files (files whose kHFSFileLockedBit bit is set). On Mac OS X, locked files cannot be moved, and CatMove returns permErr if called on a locked file.

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
){};

/*PBHSetFLockSync

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a name for the file or directory to lock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to lock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHSetFLockSync to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. Access paths currently in use aren’t affected. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
){};

/*HSetVol

Sets the default volume and the default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
);
Parameters
volName

The name of a mounted volume or the partial pathname of a directory. This parameter can be NULL. 
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The HSetVol function lets you specify the default directory by volume reference number or by directory ID.

Both the default volume and the default directory are used in calls made with no volume name, a volume reference number of 0, and a directory ID of 0. 
Special Considerations

Use of the HSetVol function is discouraged if your application may execute in system software versions prior to version 7.0. Because the specified directory might not itself be a working directory, HSetVol records the default volume and directory separately, using the volume reference number of the volume and the actual directory ID of the specified directory. Subsequent calls to GetVol (or PBGetVolSync or PBGetVolAsync) return only the volume reference number, which will cause that volume’s root directory (rather than the default directory, as expected) to be accessed. 
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
){};

/*PBSetFPosSync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionSync instead.)

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the file mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosSync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosSync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
){};

/*PBHOpenRFDenySync

Opens a file’s resource fork using the access deny modes.

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion function. 
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenRFDenySync and PBHOpenDenySync functions (or their asynchronous counterparts, PBHOpenRFDenyAsync and PBHOpenDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenRFDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s data fork with access deny permissions, use the PBHOpenDenySync or PBHOpenDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
){};

/*PBHDeleteSync

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use PBDeleteObjectSync instead.)

OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block.See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, PBHDeleteSync returns the result code fBsyErr. PBHDeleteSync also returns fBsyErr if you attempt to delete a directory that has an open working directory associated with it.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory to delete. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the file or directory to delete. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that file ID reference is also removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
){};

/*PBSetEOFSync

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBSetForkSizeSync instead.)

OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On input, the new logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you must coerce the desired value from a long integer to type Ptr. If the value of the ioMisc field is 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 

If you attempt to set the logical end-of-file beyond the current physical end-of-file, another allocation block is added to the file if there isn’t enough space on the volume, no change is made and PBSetEOFSync returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
){};

/*HRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to unlock. 
fileName

The name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use HRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file.

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};

/*PBHRstFLockSync

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to the name for the file or directory to unlock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to unlock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHRstFLockSync to unlock a directory. Otherwise, you can only use this function to unlock a file.

Access paths currently in use aren’t affected by this function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
){};

/*PBHOpenRFSync

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. On some file systems, PBHOpenRFSync will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open resource fork. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBOpenRFSync function, you will receive an error message. 
Special Considerations

Generally your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The PBHOpenRFSync function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork.

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenRFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
){};

/*PBHOpenDFSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. . If you attempt to open a locked file for writing, PBHOpenDFSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

You should use PBHOpenDFSync instead of the PBHOpenSync function; PBHOpenDFSync allows you to safely open a file whose name begins with a period (.).

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, the file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBHOpenDFSync function, you will receive an error message. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenDFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
){};

/*HDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The directory ID of the parent directory of the file or directory to delete. 
fileName

The name of the file or directory to delete. This can be a full or partial pathname. 
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, HDelete returns the result code fBsyErr. HDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that reference is removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
){};

/*PBHOpenSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to open a locked file for writing, PBHOpenSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If you use PBHOpenSync to try to open a file whose name begins with a period, you might mistakenly open a driver instead; subsequent attempts to write data might corrupt data on the target device. To avoid these problems, you should always use PBHOpenDFSync instead of PBHOpenSync. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
){};

/*PBDTOpenInform

Gets the reference number of the specified desktop database, reporting whether the desktop database was empty when it was opened. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTOpenInform (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTOpenInform fails, it sets this field to 0. 
ioTagInfo 

On output, the return flag (in the low bit of this field). If the desktop database was just created in response to PBDTOpenInform (and is therefore empty), PBDTOpenInform sets the low bit in this field to 0. If the desktop database had been created before you called PBDTOpenInform, PBDTOpenInform sets the low bit in this field to 1. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTOpenInform (
   DTPBPtr paramBlock
){};

/*PBGetForeignPrivsSync

Determines the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
){};

/*PBDTGetAPPLSync

Identifies the application that can open a file with a given creator. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On output, a pointer to the application’s name. 
ioDTRefNum 

On input, the desktop database reference number of the desktop database containing the specified application. 
ioIndex 

On input, an index into the application list. 
ioTagInfo 

On output, the application’s creation date. 
ioFileCreator 

On input, the signature of the application. 
ioAPPLParID 

On output, the application’s parent directory. 

A single call, with the ioIndex field set to 0, finds the application file with the most recent creation date. If you want to retrieve information about all copies of the application with the given signature, start with ioIndex set to 1 and increment this value by 1 with each call to PBDTGetAPPLSync until the result code afpItemNotFound is returned in the ioResult field; when called multiple times in this fashion, PBDTGetAPPLSync returns information about all the application’s copies, including the file with the most recent creation date, in arbitrary order. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
){};

/*FSpDirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
);
Parameters
spec

A pointer to an FSSpec structure specifying the directory to be created. 

Note that if the parent directory ID for the directory described by this FSSpec is 0 and the volume specified in this FSSpec is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the specified volume is a volume other than the default volume, the new directory is placed in the root directory of the volume. To create a directory at the root of a volume, regardless of whether that volume is the current default volume, set the parent directory ID to the constant fsRtDirID(2).

scriptTag

The code of the script system in which the directory name is to be displayed. If you have established the name and location of the new directory using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information on the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. For a description of the smSystemScript constant, see the Script Manager Reference.

createdDirID

On return, a pointer to the directory ID of the directory that was created. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpDirCreate function sets the date and time of creation and last modification to the current date and time.

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDirCreate is not available, you can use the function DirCreate instead. To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h */

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
){};

/*PBHSetDirAccessSync

Changes the access control information for a directory.

OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the directory. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On input, the owner ID. 
ioACGroupID 

On input, the group ID. 
ioACAccess 

On input, the directory’s access rights. You cannot set the owner or user rights bits of the ioACAccess field directly; if you try to do this, PBHSetDirAccessSync returns the result code paramErr. Only the blank access privileges can be set for a directory using this function. See File and Folder Access Privilege Constants for more information on directory access privileges. 
ioDirID 

On input, the directory ID. 

To change the owner or group, you should set the ioACOwnerID or ioACGroupID field to the appropriate ID. You must be the owner of the directory to change the owner or group ID. A guest on a server can manipulate the privileges of any directory owned by the guest. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
){};

/*FSpSetFLock

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to lock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync functions indicate that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpSetFLock to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. This function has no effect on existing access paths. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFLock (
   const FSSpec * spec
){};

/*PBHCreateSync

Creates a new file. (Deprecated in Mac OS X v10.4. Use PBCreateFileUnicodeSync instead.)

OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name for the new file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the new file. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

The PBHCreateSync function creates both the data and resource fork of the file the new file is unlocked and empty. The date and time of its creation and last modification are set to the current date and time. If the file created isn’t temporary (that is, if it will exist after the user quits the application), the application should call PBHSetFInfoSync after the call to PBHCreateSync to fill in the information needed by the Finder.

Files created using PBHCreateSync are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager procedures HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it (by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
){};

/*PBDTGetCommentSync

Retrieves the user comments for a file or directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you want to retrieve comments. 
ioDTRefNum 

On input, the desktop database reference number of the database in which the specified file or directory is found. 
ioDTBuffer 

On input, a pointer to a buffer allocated to hold the comment text. On output, a pointer to the comment text. Allocate a buffer at least 255 bytes in size. The PBDTGetCommentSync function places up to ioDTReqCount bytes of the comment into the buffer as a plain text string and places the actual length of the comment in the ioDTActCount field. 
ioDTReqCount 

On input, the size of the buffer allocated to hold the comment. 
ioDTActCount 

On output, the comment size. 
ioDirID 

On input, the parent directory of the file or directory. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
){};

/*PBDTGetPath

Gets the reference number of the specified desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetPath (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTGetPath fails, it sets this field to 0. 

If the desktop database is not already open, PBDTGetPath opens it and then returns the reference number. If the desktop database doesn’t exist, PBDTGetPath creates it . 
Special Considerations

PBDTGetPath allocates memory in the system heap; do not call it at interrupt time.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetPath (
   DTPBPtr paramBlock
){};

/*FSpRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpRstFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to unlock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file. 

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRstFLock (
   const FSSpec * spec
){};

/*PBExchangeFilesSync

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use PBExchangeObjectsSync instead.)

OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the first file to swap. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDestNamePtr 

On input, a pointer to the name of the second file to swap. 
ioDestDirID 

On input, the second file’s parent directory ID. 
ioSrcDirID 

On input, the first file’s parent directory ID. 

Typically, you use PBExchangeFilesSync after creating a new file during a safe save. The PBExchangeFilesSync function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The PBExchangeFilesSync function works on either open or closed files. PBExchangeFilesSync swaps the data in two files by changing some of the information in the volume catalog. If either file is open, PBExchangeFilesSync updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access privileges as opening both files for writing.

The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use PBExchangeFilesSync to preserve the file ID when updating an existing file, in case the file is being tracked through its file ID. The PBExchangeFilesSync function does not require that file ID references exist for the files being exchanged.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

Your application will have to swap any open reference numbers to the two files because the file's name and parent directory ID are exchanged in the file control blocks. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling PBExchangeFilesSync. Exclusive read/write access to both files will ensure that PBExchangeFilesSync doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

PBExchangeFilesSync does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling PBExchangeFilesSync ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
){};

/*PBUnshareSync

Makes a share point unavailable on the network. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
){};

/*PBLockRangeSync

Locks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXLockRangeSync or FSLockRange instead.)

OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBLockRangeSync on a file system that does not implement it—for example, SMB—PBLockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to lock. 
ioReqCount 

On input, the number of bytes in the range. Set ioReqCount to –1 to lock the maximum number of bytes from the position specified in the ioPosOffset field. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information about the constants you can use to specify the base location. 

You should not use the fsFromLEOF constant when locking a file range. PBLockRangeSync does not return the start of the locked range; thus, there is no way to determine what range was actually locked when you specify fsFromLEOF.
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBLockRangeSync function locks a portion of a file that was opened with shared read/write permission. The beginning of the range to be locked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be locked is determined by the beginning of the range and the ioReqCount field. For example, to lock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0.

The PBLockRangeSync function uses the same parameters as both PBReadSync and PBWriteSync; by calling it immediately before PBReadSync, you can use the information in the parameter block for the PBReadSync call. For more information about the PBReadSync and PBWriteSync functions, see the Device Manager Reference .

When you’re finished with the data (typically after a call to PBWriteSync), you can call PBUnlockRangeSync to free that portion of the file for subsequent read and write calls. Closing a file also releases all locked ranges in that file.
Special Considerations

The PBLockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a sharable local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set. 
Version Notes

In system software versions 6.0.7 and earlier, specifying ioPosMode as fsFromLEOF results in the wrong byte range being locked. System software version 7.0 fixes this bug.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible to have multiple writers for the same file. Locking a portion of a file with PBLockRangeSync does not guarantee exclusive access to that part of the file. If you call PBLockRangeSync to lock a portion of a file to which another process already has write access, the call will succeed without error. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
){};

/*PBDTSetCommentSync

Adds a user comment for a file or a directory to the desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory. 
ioDTRefNum 

On input, the desktop database reference number for the desktop database to which to add the user comment. 
ioDTBuffer 

On input, a pointer to the buffer containing the comment text. Put the comment in the buffer as a plain text string. 
ioDTReqCount 

On input, the length of the buffer containing the comment text, in bytes. The maximum length of a comment is 200 bytes; longer comments are truncated. Since the comment is a plain text string and not a Pascal string, the File Manager relies on the value in the ioDTReqCount field for determining the length of the buffer. 
ioDirID 

On input, the parent directory ID of the file or directory. 

If the specified object already has a comment in the database, the new comment replaces the old. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
){};

/*PBDTGetIconSync

Retrieves an icon definition. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBDTGetIconSync function returns the bitmap for an icon that represents a file of a given type and creator. For example, to get the icon for a file of file type 'SFWR' created by the application with a signature of 'WAVE', specify these two values in the ioFileType and ioFileCreator fields. 

The relevant fields of the parameter block for this function are:
ioDTRefNum 

On input, the desktop database reference number. 
ioTagInfo 

Reserved; on input, this field must be set to 0. 
ioDTBuffer 

On input, a pointer to a buffer to hold the icon’s data. On return, a pointer to the bitmap returned in the buffer. 
ioDTReqCount 

On input, the requested size of the icon’s bitmap. Pass the size in bytes of the buffer that you’ve allocated for the icon’s bitmap, pointed to by the ioDTBuffer field; this value depends on the icon type. Be sure to allocate enough storage for the icon data; 1024 bytes is the largest amount required for any icon in System 7. You can use the constants described in Icon Size Constants to indicate the amount of memory you have provided for the icon’s data. 
ioDTActCount 

On output, the actual size of the icon’s bitmap. If this value is larger than the value specified in the ioDTReqCount field, only the amount of data allowed by ioDTReqCount is valid. 
ioIconType 

On input, the icon type. For a description of the constants which you can use in this field, see Icon Type Constants. 
ioFileCreator 

On input, the icon’s file creator. 
ioFileType 

On input, the icon’s file type. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
){};

/*PBResolveFileIDRefSync

Retrieves the filename and parent directory ID of a file given its file ID.

OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an FIDParam variant of the HFS parameter block. See HParamBlockRec for more information on the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. A return code of fidNotFound means that the specified file ID reference has become invalid, either because the file was deleted or because the file ID reference was destroyed by PBDeleteFileIDRefSync or PBDeleteFileIDRefAsync.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. If the name string is NULL, PBResolveFileIDRefSync doe s not return the filename, but returns only the parent directory ID of the file in the ioSrcDirID field. If the name string is not NULL but is only a volume name, PBResolveFileIDRefSync ignores the value in the ioVRefNum field and uses the volume name instead. On output, a pointer to the filename of the file with the given file ID. 
ioVRefNum 

On input, a volume specification for the volume containing the file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioSrcDirID 

On output, the file’s parent directory ID. 
ioFileID 

On input, a file ID for the file to retrieve information about. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*PBShareSync

Establishes a local volume or directory as a share point. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBShareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBShareSync (
   HParmBlkPtr paramBlock
){};

/*PBDeleteFileIDRefSync

Deletes a file ID reference.

OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the file. 
ioFileID 

On input, the file ID reference to delete. After it has invalidated a file ID reference, the File Manager can no longer resolve that ID reference to a filename and parent directory ID. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
){};

/*FSpCatMove

Moves a file or directory from one location to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec structure specifying the name and location of the file or directory to move. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec structure specifying the name and location of the directory into which the source file or directory is to be moved. The directory ID specified in the parID field of this FSSpec is the directory ID of the parent of the directory into which you want to move the source file or directory. The name field of this FSSpec specifies the name of the directory into which you want to move the source file or directory.

If you don’t already know the parent directory ID of the destination directory, it might be easier to use the PBCatMoveSync or PBCatMoveAsync function, which allow you to specify only the directory ID of the destination directory.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCatMove function is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk. You cannot use FSpCatMove to move a file or directory to another volume (that is, the vRefNum field in both FSSpec structures in the source and dest parameters must be the same). Also, you cannot use FSpCatMove to rename files or directories; to rename a file or directory, use FSpRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
){};

/*PBHGetLogInInfoSync

Determines the login method used to log on to a particular shared volume. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
){};

/*PBFlushFileSync

Writes the contents of a file’s access path buffer to the disk. (Deprecated in Mac OS X v10.4. Use PBFlushForkSync instead.)

OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant field of the parameter block is:
ioRefNum 

On input, a file reference number for the file to flush. 

After writing the contents of the file to the volume, the PBFlushFileSync function updates the file’s entry in the volume catalog.

In the event of a system crash, all cached data not yet written to disk is lost. If you have made changes to space that alreday exists within a file (you are overwriting existing data before the file’s end-of-file), you must use PBFlushFileSync to ensure that everything written to the file will be written to disk. If you flush the fork’s cached blocks using PBFlushFileSync, the only possible data loss in a system crash will be the file’s modification date. 

You do not, however, need to use PBFlushFileSync to flush a file fork before it is closed; the file is automatically flushed when it is closed and all cache blocks associated with it are removed from the cache.

PBFlushFileSync flushes an open fork’s dirty cached blocks, but may not flush catalog information associated with the file. To flush catalog information, call FlushVol , or one of the related parameter block calls, PBFlushVolSync and PBFlushVolAsync. 

To update a file larger than 2GB, or a named fork other than the data and resource forks, you must use the FSFlushFork function, or one of the corresponding parameter block calls, PBFlushForkSync and PBFlushForkAsync. 
Special Considerations

Some information stored on the volume won’t be correct until PBFlushVolSync is called.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
){};

/*PBCatSearchSync

Searches a volume’s catalog file using a set of search criteria that you specify. (Deprecated in Mac OS X v10.4. Use PBCatalogSearchSync instead.)

OSErr PBCatSearchSync (
   CSParamPtr paramBlock
);
Parameters
paramBlock

A pointer to a CSParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. When PBCatSearchSync has searched the entire volume, it returns eofErr. If it exits because it either spends the maximum time allowed in the ioSearchTime field or finds the maximum number of matches allowed in the ioReqMatchCount field, it returns noErr.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the volume to search. 
ioVRefNum 

On input, a volume reference number or drive number for the volume to search; or 0 for the default volume. 
ioMatchPtr 

On input, a pointer to an array of FSSpec structure to hold the matches found by this function. On return, the FSSpec structures in this array identify the files and directories that match the criteria. 
ioReqMatchCount 

On input, the maximum number of matches to return. 
ioActMatchCount 

On output, the actual number of matches returned. 
ioSearchBits 

On input, a bitmap specifying the fields in the criteria structures to match against. See Catalog Search Masks for a description of the bits in this field. 
ioSearchInfo1 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in ioSearchInfo2, and set the matching value in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this structure. 
ioSearchInfo2 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching value in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this structure. 
ioSearchTime 

On input, the maximum allowed search time. If you pass 0 in this field, no time limit is set. 
ioCatPosition 

The current catalog position, specified as a CatPositionRec structure. You can use this field, along with the ioSearchTime field, to search a volume in segments. To search a volume in segments, set a time limit for the search in the ioSearchTime field and set the initialize field of the CatPositionRec structure to the location for the start of the search (0 if you wish to start searching at the beginning of the volume). On return, the catalog position will be updated. You can then pass this updated CatPositionRec structure to the next call to PBCatSearchSync to continue searching at the place where you left off. 
ioOptBuffer 

On input, a pointer to an optional read buffer. 
ioOptBufSize 

On input, the length of the optional read buffer. 

If the catalog file changes between two timed calls to PBCatSearchSync (that is, when you are using ioSearchTime and ioCatPosition to search a volume in segments and the catalog file changes between searches), PBCatSearchSync returns a result code of catChangedErr and no matches. Depending on what has changed on the volume, ioCatPosition might be invalid, most likely by a few entries in one direction or another. You can continue the search, but you risk either skipping some entries or reading some twice. 
Special Considerations

Not all volumes support the PBCatSearchSync function. Before you call PBCatSearchSync to search a particular volume, you should call the PBHGetVolParmsSync function to determine whether that volume supports PBCatSearchSync.If the bHasCatSearch bit is set in the vMAttrib field, then the volume supports PBCatSearchSync.

Even though AFP volumes support PBCatSearchSync, they do not support all of its features that are available on local volumes. These restrictions apply to AFP volumes:
AFP volumes do not use the ioSearchTime field. Current versions of the AppleShare server software search for 1 second or until 4 matches are found. The AppleShare workstation software keeps requesting the appropriate number of matches until the server returns either the number specified in the ioReqMatchCount field or an error.
AFP volumes do not support both logical and physical fork lengths. If you request a search using the length of a fork, the actual minimum length used is the smallest of the values in the logical and physical fields of the ioSearchInfo1 structure and the actual maximum length used is the largest of the values in the logical and physical fields of the ioSearchInfo2 structure.
The fsSBNegate bit of the ioSearchBits field is ignored during searches of remote volumes that support AFP version 2.1.
If the AFP server returns afpCatalogChanged, the catalog position structure returned to your application (in the ioCatPosition field) is the same one you passed to PBCatSearchSync. You should clear the initialize field of that structure to restart the search from the beginning.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBCatSearchSync (
   CSParamPtr paramBlock
){};

/*PBHMoveRenameSync

Moves a file or directory and optionally renames it. (Deprecated in Mac OS X v10.4. Use FSMoveObjectSync instead.)

OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBHMoveRenameSync function allows you to move (not copy) a file or directory. The source and destination pathnames must point to the same file server volume. This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the pathname for the source file or directory. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the source file or directory. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the destination pathname. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. If ioNewName is not NULL, the destination directory is the directory having the partial pathname pointed to by ioNewName in the directory having ID ioNewDirID on the specified volume. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
){};

/*PBUnlockRangeSync

Unlocks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXUnlockRangeSync or FSUnlockRange instead.)

OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBUnlockRangeSync on a file system that does not implement it—for example, SMB—PBUnlockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to unlock. 
ioReqCount 

On input, the number of bytes in the range. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information on the constants you can use to indicate the base location. 
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBUnlockRangeSync function unlocks a portion of a file that you locked with PBLockRangeSync or PBLockRangeAsync. The beginning of the range to be unlocked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be unlocked is determined by the beginning of the range and the ioReqCount field. For example, to unlock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0. The range of bytes to be unlocked must be the exact same range locked by a previous call to PBLockRangeSync or PBLockRangeAsync.

If for some reason you need to unlock a range whose beginning or length is unknown, you can simply close the file. When a file is closed, all locked ranges held by the user are unlocked. 
Special Considerations

The PBUnlockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
){};

/*PBVolumeMount

Mounts a volume.

OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioVRefNum 

On output, a volume reference number for the mounted volume. 
ioBuffer 

On input, a pointer to mounting information. You can use the volume mounting information returned by the PBGetVolMountInfo function or you can use a volume mounting information structure filled in by your application. If you’re mounting an AppleShare volume, place the volume’s AFP mounting information structure in the buffer pointed to by the ioBuffer field. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. 

The PBGetVolMountInfo function does not return the user and volume passwords they’re returned blank. Typically, your application asks the user for any necessary passwords and fills in those fields just before calling PBVolumeMount. If you want to mount a volume with guest status, pass an empty string as the user password.

If you have enough information about the volume, you can fill in the mounting structure yourself and call PBVolumeMount, even if you did not save the mounting information while the volume was mounted. To mount an AFP volume, you must fill in the structure with at least the zone name, server name, user name, user password, and volume password. You can lay out the fields in any order within the data field, as long as you specify the correct offsets.

In general, it is easier to mount remote volumes by creating and then resolving alias records that describe those volumes. The Alias Manager displays the standard user interface for user authentication when resolving alias records for remote volumes. As a result, this function is primarily of interest for applications that need to mount remote volumes with no user interface or with some custom user interface. 
Special Considerations

AFP volumes currently ignore the user authentication method passed in the uamType field of the volume mounting information structure whose address is passed in the ioBuffer field of the parameter block. The most secure available method is used by default, except when a user mounts the volume as Guest and uses the kNoUserAuthentication authentication method.

This function executes synchronously. You should not call it at interrupt time.
Version Notes

The File Sharing workstation software introduced in system software version 7.0 does not currently pass the volume password. The AppleShare 3.0 workstation software does, however, pass the volume password.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
){};

/*PBSetForeignPrivsSync

Changes the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
){};

/*PBHMapIDSync

Determines the name of a user or group given the user or group ID.

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 1 if you’re mapping a user ID to a user name or 2 if you’re mapping a group ID to a group name. See Mapping Code Constants for more information about the values you can use in this field. 
ioObjNamePtr 

On output, a pointer to the user or group name; the maximum size of the name is 31 characters (preceded by a length byte). 
ioObjID 

On input, the user or group ID to be mapped. AppleShare uses the value 0 to signify Any User. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might not need to specify a value in the ioObjType field.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
){};

/*IPBHMapNameSync

Determines the user ID or group ID from a user or group name.

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 3 if you’re mapping a user name to a user ID or 4 if you’re mapping a group name to a group ID. See Mapping Code Constants for more information on the values you can use in this field. 
ioObjNamePtr 

On input, a pointer to the user or group name. The maximum size of the name is 31 characters. If NULL is passed, the ID returned is always 0. 
ioObjID 

On output, the mapped user or group ID. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might need to set the ioObjType field to determine which database (user or group) to search first. If both a user and a group have the same name, this field determines which kind of ID you receive.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
){};

/*FSSetForkPosition

Sets the current position of an open fork. 

OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of a fork previously opened by the FSOpenFork, PBOpenForkSync, or PBOpenForkAsync function. 
positionMode

A constant specifying the base location within the fork for the new position. If this parameter is equal to fsAtMark, then the positionOffset parameter is ignored. See Position Mode Constants for a description of the constants you can use to specify the base location. 
positionOffset

The offset of the new position from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. On Mac OS X, FSSetForkPosition will return the result code posErr if you attempt to set the current position of the fork to an offset before the start of the file. On Mac OS 9, this same attempt will return the result code eofErr.
Special Considerations

To determine if the FSSetForkPosition function is present, call the Gestalt function with the gestaltFSAttr selector. If the FSSetForkPosition function is present, but the volume does not directly support it, the File Manager will automatically call the PBSetFPosSync function. However, if the volume does not directly support the FSSetForkPosition function, you can only set the file position for the data and resource forks, and you cannot grow these files beyond 2GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
){};

/*FSGetForkCBInfo

Returns information about a specified open fork, or about all open forks.

OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
);
Parameters
desiredRefNum

If you want information on a specific fork, set this parameter to that fork’s reference number, and pass NULL in the iterator parameter. If you pass a non-zero value in this parameter, the function attempts to get information on the fork specified by that reference number. 

Pass zero in this parameter to iterate over all open forks. You can limit this iteration to a specific volume with the volume parameter.
volume

The volume to search, when iterating over multiple forks. To iterate over all open forks on a single volume, specify the volume reference number in this parameter. To iterate over all open forks on all volumes, set this parameter to the constant kFSInvalidVolumeRefNum.

This parameter is ignored if you specify a fork reference number in the desiredRefNum parameter. Set desiredRefNum to zero if you wish to iterate over multiple forks.

See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
iterator

A pointer to an iterator. If the desiredRefNum parameter is 0, the iterator maintains state between calls to FSGetForkCBInfo. Set the iterator parameter to 0 before you begin iterating, on the first call to FSGetForkCBInfo. On return, the iterator will be updated; pass this updated iterator in the iterator parameter of the next call to FSIterateForks to continue iterating.
actualRefNum

On return, a pointer to the reference number of the open fork. This parameter is optional if you do not wish to retrieve the fork’s reference number, pass NULL.
forkInfo

On return, a pointer to an FSForkInfo structure containing information about the open fork. This parameter is optional; if you do not wish this information returned, set forkInfo to NULL. See FSForkInfo for a description of the FSForkInfo data type.

On OS X, the value returned by FSGetForkCBInfo in the physicalEOF field of the FSForkInfo structure may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by FSGetForkCBInfo changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
ref

On return, a pointer to the FSRef for the file or directory that contains the fork. This parameter is optional; if you do not wish to retrieve the FSRef, set ref to NULL. See FSRef for a description of the FSRef data type.
outForkName

On return, a pointer to the name of the fork. This parameter is optional; if you do not wish the name returned, set outForkName to NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”. If you are iterating over multiple forks, the function returns errFSNoMoreItems if there are no more open forks to return.
Discussion

Carbon applications are no longer guaranteed access to the FCB table. Instead, applications should use FSGetForkCBInfo, or one of the related parameter block functions, PBGetForkCBInfoSync and PBGetForkCBInfoAsync , to access information about a fork control block. 
Special Considerations

Returning the fork information in the forkInfo parameter generally does not require a disk access; returning the information in the ref or forkName parameters may cause disk access for some volume formats.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
){};

/*FSExchangeObjects

Swaps the contents of two files.

OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
);
Parameters
ref

A pointer to an FSRef for the first file. See FSRef for a description of the FSRef data type.
destRef

A pointer to an FSRef for the second file.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSExchangeObjects function allows programs to implement a “safe save” operation by creating and writing a complete new file and swapping the contents. An alias, FSSpec, or FSRef that refers to the old file will now access the new data. The corresponding information in in-memory data structures are also exchanged.

Either or both files may have open access paths. After the exchange, the access path will refer to the opposite file’s data (that is, to the same data it originally referred, which is now part of the other file). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
){};

/*PBMakeFSRefUnicodeSync

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ref 

On input, a pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type. 
nameLength 

On input, the length of the file or directory name. 
name 

On input, a pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to PBMakeFSRefUnicodeSync. 
textEncodingHint 

On input, the suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef 

On output, if the function returns a result of noErr, a pointer to the new FSRef 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
){};

/*FSMoveObject

Moves a file or directory into a different directory.

OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to move. See FSRef for a description of the FSRef data type.
destDirectory

A pointer to an FSRef specifying the directory into which the file or directory indicated by the ref parameter will be moved.
newRef

On return, a pointer to the new FSRef for the file or directory in its new location. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”. If the destDirectory parameter specifies a non-existent object, dirNFErr is returned; if it refers to a file, errFSNotAFolder is returned. If the directory specified in the destDirectory parameter is on a different volume than the file or directory indicated in the ref parameter, diffVolErr is returned.
Discussion

Moving an object may change its FSRef. If you want to continue to refer to the object, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to refer to the object after the move. The original FSRef passed in the ref parameter may or may not be usable after the move. The newRef parameter may point to the same storage as the destDirectory or ref parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
){};

/*FNNotify

Broadcasts notification of changes to the specified directory.

OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
);
Parameters
ref

A file system reference describing the directory for which to broadcast the notification. 
message

An indication of what happened to the target directory.
flags

Options regarding the delivery of the notification. Specify kNilOptions for the default behaviour.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
){};

/*Maintaining Working Directories
pascal OSErr OpenWD	(short vRefNum, long dirID, long procID, 
			short *wdRefNum);
pascal OSErr CloseWD	(short wdRefNum);
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID);*/
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID){};

/*Manipulating the Default Volume
pascal OSErr GetVol 		(StringPtr volName, short *vRefNum);
pascal OSErr SetVol		(StringPtr volName, short vRefNum);
pascal OSErr HGetVol		(StringPtr volName, short *vRefNum, 
				long *dirID);
pascal OSErr HSetVol		(StringPtr volName, short vRefNum, long dirID);*/
pascal OSErr SetVol		(StringPtr volName, short vRefNum){};

/*GetVRefNum

Gets a volume reference number from a file reference number. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr GetVRefNum (
   short fileRefNum,
   short * vRefNum
);
Parameters
fileRefNum

The file reference number of an open file. 
vRefNum

On return, a pointer to the volume reference number of the volume containing the file specified in the refNum parameter.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you also want to determine the directory ID of the specified file’s parent directory, call the PBGetFCBInfoSync or PBGetFCBInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetVRefNum (
   short fileRefNum,
   short * vRefNum
){};

/*Adding a Drive
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl);*/
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl){};

 OSErr  FSOpen(
  ConstStr255Param   fileName,
  short              vRefNum,
  short *            refNum){};

OSErr 
FSDelete(
  ConstStr255Param   fileName,
  short              vRefNum){};

OSErr 
Create(
  ConstStr255Param   fileName,
  short              vRefNum,
  OSType             creator,
  OSType             fileType){};


/*Adding a Drive
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl);*/
pascal void AddDrive	(short drvrRefNum, short drvNum, DrvQElPtr qEl);

/*Maintaining Working Directories
pascal OSErr PBOpenWD		(WDPBPtr paramBlock, Boolean async);
pascal OSErr PBOpenWDSync	(WDPBPtr paramBlock);
pascal OSErr PBOpenWDAsync	(WDPBPtr paramBlock);
pascal OSErr PBCloseWD		(WDPBPtr paramBlock, Boolean async);
pascal OSErr PBCloseWDSync	(WDPBPtr paramBlock);
pascal OSErr PBCloseWDAsync	(WDPBPtr paramBlock);
pascal OSErr PBGetWDInfo	(WDPBPtr paramBlock, Boolean async);
pascal OSErr PBGetWDInfoSync	(WDPBPtr paramBlock);
pascal OSErr PBGetWDInfoAsync
   				(WDPBPtr paramBlock);*/
pascal OSErr PBOpenWD		(WDPBPtr paramBlock, Boolean async){};
pascal OSErr PBGetWDInfo	(WDPBPtr paramBlock, Boolean async){};

/*Creating and Deleting Files and Directories
pascal OSErr PBHCreate		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHCreateSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHCreateAsync	(HParmBlkPtr paramBlock);
pascal OSErr PBDirCreate	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBDirCreateSync	(HParmBlkPtr paramBlock);
pascal OSErr PBDirCreateAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHDelete		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHDeleteSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHDeleteAsync	(HParmBlkPtr paramBlock);*/
pascal OSErr PBDirCreate	(HParmBlkPtr paramBlock, Boolean async){};





