#include <CFNetwork/CFNetwork.h>


/*CFNetDiagnosticCreateWithURL

Creates a CFNetDiagnosticRef from a CFURLRef.

CFNetDiagnosticRef CFNetDiagnosticCreateWithURL (
    CFAllocatorRef alloc,
    CFURLRef url
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
url

CFURLRef that refers to the failed connection.
Return Value

CFNetDiagnosticRef that you can pass to CFNetDiagnosticDiagnoseProblemInteractively or CFNetDiagnosticCopyNetworkStatusPassively. Ownership follows the Create Rule.
Discussion

This function uses a URL to create a reference to an instance of a CFNetDiagnostic object. You can pass the reference to CFNetDiagnosticDiagnoseProblemInteractively to open a Network Diagnostics window or to CFNetDiagnosticCopyNetworkStatusPassively to get a description of the connection referenced by readStream and writeStream.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/

CFNetDiagnosticRef CFNetDiagnosticCreateWithURL (
    CFAllocatorRef alloc,
    CFURLRef url
){
printf ("CFNetDiagnosticCreateWithURL",alloc,url);
};

/*CFNetDiagnosticCreateWithStreams

Creates a network diagnostic object from a pair of CFStreams.

CFNetDiagnosticRef CFNetDiagnosticCreateWithStreams (
    CFAllocatorRef alloc,
    CFReadStreamRef readStream,
    CFWriteStreamRef writeStream
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
readStream

Reference to a read stream whose connection has failed, or NULL if you do not want the CFNetDiagnosticRef to have a read stream.
writeStream

Reference to a write stream whose connection has failed, or NULL if you do not want the CFNetDiagnosticRef to have a write stream.
function result

CFNetDiagnosticRef that you can pass to CFNetDiagnosticDiagnoseProblemInteractively or CFNetDiagnosticCopyNetworkStatusPassively. Ownership follows the Create Rule.
Discussion

This function uses references to a read steam and a write stream (or just a read stream or just a write stream) to create a reference to an instance of a CFNetDiagnostic object. You can pass the reference to CFNetDiagnosticDiagnoseProblemInteractively to open a Network Diagnostics window or to CFNetDiagnosticCopyNetworkStatusPassively to get a description of the connection referenced by readStream and writeStream.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/
CFNetDiagnosticRef CFNetDiagnosticCreateWithStreams (
    CFAllocatorRef alloc,
    CFReadStreamRef readStream,
    CFWriteStreamRef writeStream
){
printf ("CFNetDiagnosticCreateWithStreams",alloc,readStream,writeStream);
};

/*CFNetDiagnosticDiagnoseProblemInteractively

Opens a Network Diagnostics window.

CFNetDiagnosticStatus CFNetDiagnosticDiagnoseProblemInteractively (
    CFNetDiagnosticRef details
);
Parameters
details

A network diagnostics object, created by CFNetDiagnosticCreateWithStreams or CFNetDiagnosticCreateWithURL, for which the window is to be opened.
Return Value

CFNetDiagnosticNoErr if no error occurred, or CFNetDiagnosticErr if an error occurred that prevented this call from completing successfully.
Discussion

This function opens the Network Diagnostics window and returns immediately once the window is open.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFNetDiagnosticRef at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFNetDiagnostics.h*/
CFNetDiagnosticStatus CFNetDiagnosticDiagnoseProblemInteractively (
    CFNetDiagnosticRef details
){
printf ("CFNetDiagnosticDiagnoseProblemInteractively",details);
};

