#include <AppKit/NSWindow.h>



@implementation NSWindow (hys)



/*attachedSheet

Returns the sheet attached to the receiver.

- (NSWindow *)attachedSheet
Return Value

The sheet attached to the receiver.
Discussion

If the receiver does not have a sheet attached, this method returns nil.
Availability
Available in Mac OS X v10.1 and later.*/
- (NSWindow *)attachedSheet{
printf ("attachedSheet");
}


/*disableScreenUpdatesUntilFlush

Disables the receiver’s screen updates until the window is flushed.

- (void)disableScreenUpdatesUntilFlush
Discussion

This method can be invoked to synchronize hardware surface flushes with the window’s flushes. The receiver immediately disables screen updates using the function NSDisableScreenUpdates and re-enables screen updates when the window flushes. Sending this message multiple times during a window update cycle has no effect.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)disableScreenUpdatesUntilFlush{
printf ("disableScreenUpdatesUntilFlush");
}

/*setMovableByWindowBackground:

Sets whether the receiver is movable by clicking and dragging anywhere in its background.

- (void)setMovableByWindowBackground:(BOOL)movableByWindowBackground
Parameters
movableByWindowBackground

YES to specify that the window is movable by background, NO to specify that the window is not movable by background.
Availability
Available in Mac OS X v10.2 and later.
See Also
– isMovableByWindowBackground*/
- (void)setMovableByWindowBackground:(BOOL)movableByWindowBackground{
printf ("setMovableByWindowBackground",movableByWindowBackground);
}


/*removeChildWindow:

Detaches childWin from the receiver.

- (void)removeChildWindow:(NSWindow *)childWin
Availability
Available in Mac OS X v10.2 and later.
See Also
– addChildWindow:ordered:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)removeChildWindow:(NSWindow *)childWin{
printf ("removeChildWindow",childWin);
}
/*frameRectForContentRect:

Returns the receiver’s frame rectangle with a given content rectangle.

- (NSRect)frameRectForContentRect:(NSRect)windowContent
Parameters
windowContent

Content rectangle for the window expressed in screen coordinates.
Return Value

The receiver’s frame rectangle, expressed in screen coordinates, with windowContent.
Discussion

The receiver uses its current style mask in computing the frame rectangle. See “Constants” for a list of style mask values. The major advantage of this instance-method counterpart to frameRectForContentRect:styleMask: is that it allows you to take toolbars into account when converting between content and frame rectangles. (The toolbar is included in the frame rectangle but not the content rectangle.)
Availability
Available in Mac OS X v10.3 and later.
See Also
– contentRectForFrameRect:
+ frameRectForContentRect:styleMask:*/
- (NSRect)frameRectForContentRect:(NSRect)windowContent{
printf ("frameRectForContentRect",windowContent);
}


@end