#import <AppKit/NSSegmentedCell.h>

@implementation NSSegmentedCell : NSActionCell

/*tagForSegment:

Returns the tag of the specified segment.

- (int)tagForSegment:(int)segment
Parameters
segment

The index of the segment whose tool tag you want to get. This method raises an NSRangeException if the index is out of bounds.
Return Value

The tag of the segment.
Availability
Available in Mac OS X v10.3 and later.
See Also
– setTag:forSegment:*/
- (int)tagForSegment:(int)segment{}

/*setEnabled:forSegment:

Sets the enabled state of the specified segment 

- (void)setEnabled:(BOOL)flag forSegment:(int)segment
Parameters
flag

YES to enable the segment; otherwise, NO to disable it.
segment

The index of the segment you want to enable or disable. This method raises an NSRangeException if the index is out of bounds.
Availability
Available in Mac OS X v10.3 and later.
See Also
– isEnabledForSegment:*/
- (void)setEnabled:(BOOL)flag forSegment:(int)segment{}

@end

