#include <AddressBook/ABAddressBookC.h>

/*ABRecordSetValue

Sets the value of a given property for a record.

bool ABRecordSetValue(
ABRecordRef record,
CFStringRef property,
CFTypeRef value
);
Parameters
record

The record you wish to modify. 
property

The property whose value you wish to set. May be a pre-defined or program-defined property. See Common Properties for a list of properties all records have, and specific ABRecord derived opaque types for any additional properties. If NULL, this function raises an exception.
value

The new value for property in record. If NULL or not the correct type, this function raises an exception.
Return Value

If property is a multi-value list property, this method checks to see if the values in the multi-value list are the same type. If the multi-value list contains mixed types, this method returns false. Returns true if successful, false otherwise. 
Availability
Available in Mac OS X v10.2 and later.*/

bool ABRecordSetValue(
ABRecordRef record,
CFStringRef property,
CFTypeRef value
){
printf ("ABRecordSetValue",record,property,value);
};


/*ABMultiValueCreateMutable

Returns a newly created mutable multi-value list object.

ABMutableMultiValueRef ABMultiValueCreateMutable (void);
Return Value

A newly created ABMutableMultiValue object. You are responsible for releasing this object.
Availability
Available in Mac OS X v10.2 and later.*/
ABMutableMultiValueRef ABMultiValueCreateMutable (void){};

/*ABMultiValueCopyLabelAtIndex

Returns the label for the given index.

CFStringRef ABMultiValueCopyLabelAtIndex (
   ABMultiValueRef multiValue,
   int index
);
Parameters
multiValue

The multi-value list that you wish to access.
index

The index of the identifier you wish to obtain. If this parameter is out of bounds, this function raises an exception.
Return Value

The label at index in multiValue. You are responsible for releasing this object.
Discussion

Each value in a multi-value list must be the same type, and has an associated pre-defined or user-defined label, and unique identifier. Use the ABMultiValueCopyIdentifierAtIndex function to get a identifier, and the ABMultiValueCopyValueAtIndexfunction to get a value.
Availability
Available in Mac OS X v10.2 and later.*/
CFStringRef ABMultiValueCopyLabelAtIndex (
   ABMultiValueRef multiValue,
   int index
){};



/*ABMultiValueAdd

Adds a value and its label to a multi-value list.

bool ABMultiValueAdd (
   ABMutableMultiValueRef multiValue,
   CFTypeRef value,
   CFStringRef label,
   CFStringRef *outIdentifier
);

Parameters
multiValue

The multi-value list you wish to modify.
value

An object representing a value in a multi-value list--it must be of the correct type. For example, if multiValue is the value for a property of type kABMultiStringProperty, then value needs to be a CFString object. See Property Types for a list of supported types in a multi-value list (see descriptions of the kABMulti... constants). If value is NULL, this function raises an exception.
label

The label for value—it need not be unique. If label is NULL, this function raises an exception.
outIdentifier

If value is added successfully, this parameter returns the new identifier.
Return Value

true if successfully, false otherwise.
Discussion

This function performs no type checking and will let you add a value whose type does not match the types of the other values in the list. However, if you try to use a multi-value list whose values are not all of the same type, functions, such as the ABRecord ABRecordSetValue function, will returns NULL or kABErrorInProperty. 
Availability
Available in Mac OS X v10.2 and later.*/
bool ABMultiValueAdd (
   ABMutableMultiValueRef multiValue,
   CFTypeRef value,
   CFStringRef label,
   CFStringRef *outIdentifier
){};


/*ABMultiValueCount

Returns the number of entries in a multi-value list.

unsigned ABMultiValueCount (
   ABMultiValueRef multiValue
);

Parameters
multiValue

The multi-value list that you wish to access.
Return Value

The number of entries in multiValue.
Availability
Available in Mac OS X v10.2 and later.*/
unsigned ABMultiValueCount (
   ABMultiValueRef multiValue
){};

/*ABAddRecord

Adds a record of the specified type to the Address Book database.

bool ABAddRecord (
   ABAddressBookRef addressBook,
   ABRecordRef record
);
Parameters
addressBook

The address book for the logged-in user. 
record

The record to add to the Address Book database. If this parameter is NULL, the function raises an exception.
Return Value

true if the record was added successfully, false otherwise.
Availability
Available in Mac OS X v10.2 and later.*/
bool ABAddRecord (
   ABAddressBookRef addressBook,
   ABRecordRef record
){};


/*ABSave

Saves all the changes made since the last save.

bool ABSave (
   ABAddressBookRef addressBook
);
Parameters
addressBook

The address book for the logged-in user. 
Return Value

true if this function is successful or if there were no changes, false otherwise. 
Availability
Available in Mac OS X v10.2 and later.*/
bool ABSave (
   ABAddressBookRef addressBook
){};
/*ABMultiValueCopyValueAtIndex

Returns the value for the given index.

CFTypeRef ABMultiValueCopyValueAtIndex (
   ABMultiValueRef multiValue,
   int index
);
Parameters
multiValue

The multi-value list that you wish to access.
index

The index of the identifier you wish to obtain. If this parameter is out of bounds, this function raises an exception.
Return Value

The value at index in multiValue. You are responsible for releasing this object.
Discussion

Each value in a multi-value list must be the same type, and has an associated pre-defined or user-defined label, and unique identifier. Use the ABMultiValueCopyIdentifierAtIndex function to get a identifier, and the ABMultiValueCopyLabelAtIndexfunction to get a label.
Availability
Available in Mac OS X v10.2 and later.*/
CFTypeRef ABMultiValueCopyValueAtIndex (
   ABMultiValueRef multiValue,
   int index
){};


/*ABGetSharedAddressBook

Returns the unique shared ABAddressBook object. 

ABAddressBookRef ABGetSharedAddressBook (void);
Return Value

The address book for the logged-in user. You are responsible for retaining and releasing this object as needed.
Discussion

Every application shares the address book for the logged-in user and this function returns it. If you call this function more than once or try to create a new address book, you get a pointer to the same shared address book.
Availability
Available in Mac OS X v10.2 and later.*/
ABAddressBookRef ABGetSharedAddressBook (void){};

/*ABRecordCopyValue

Returns the value of the given property. 

CFTypeRef ABRecordCopyValue(
ABRecordRef record,
CFStringRef property
);

Parameters
record

The record whose value you wish to obtain. 
property

The property name in record whose value you wish to obtain. May be a pre-defined or program-defined property. See Common Properties for a list of properties all records have, and specific ABRecord derived opaque types for any additional properties.
Return Value

The value for property in record. The type of the returned value depends on the property type (see Property Types for a list of possible property types). You are responsible for releasing this object.
Availability
Available in Mac OS X v10.2 and later.*/
CFTypeRef ABRecordCopyValue(
ABRecordRef record,
CFStringRef property
){};


/*ABCopyArrayOfMatchingRecords

Returns an array of records that match the given search element, or an empty array if no records match the search element.

CFArrayRef ABCopyArrayOfMatchingRecords(
ABAddressBookRef addressBook,
ABSearchElementRef search
);

Parameters
addressBook

The address book for the logged-in user.
search

The search element that specifies the query. If search is NULL, this function raises an exception. Create an ABSearchElement object using the record specific functions: ABGroupCreateSearchElement or ABPersonCreateSearchElement. See ABSearchElement for more functions that create compound queries.
Return Value

A new array containing ABRecord objects representing all the records that match search. If no records match search, this function returns an empty array. You are responsible for releasing this object.
Availability
Available in Mac OS X v10.2 and later.*/
CFArrayRef ABCopyArrayOfMatchingRecords(
ABAddressBookRef addressBook,
ABSearchElementRef search
){};

/*ABPersonCreate

Returns a newly created person object.

ABPersonRef ABPersonCreate (void);
Return Value

A newly created person object. You are responsible for releasing this object.
Availability
Available in Mac OS X v10.2 and later.*/
ABPersonRef ABPersonCreate (void){};

/*ABPersonCreateSearchElement

Returns a search element object that specifies a query for records of this type.

ABSearchElementRef ABPersonCreateSearchElement (
   CFStringRef property,
   CFStringRef label,
   CFStringRef key,
   CFTypeRef value,
   ABSearchComparison comparison
);

Parameters
property

The name of the property to search on. It cannot be NULL. For a full list of the properties, see Person Properties and Common Properties in ABRecord.
label

The label name for a multi-value list. If property does not have multiple values, pass NULL. If property does have multiple values, pass NULL to search all the values.
key

The key name for a dictionary. If property is not a dictionary, pass NULL. If property is a dictionary, pass NULL to search all keys.
value

The value you are searching for. It cannot be NULL 
comparison

Specifies the type of comparison to perform, such as kABEqual or kABPrefixMatchCaseInsensitive. For a full list, see ABSearchComparison.
Return Value

A search element object that specifies a query according to the above parameters. You are responsible for releasing this object.
Discussion

Use the ABAddressBook ABCopyArrayOfMatchingRecords function to actually perform the query. Also, see ABSearchElement for more functions that create compound queries.
Availability
Available in Mac OS X v10.2 and later.*/
ABSearchElementRef ABPersonCreateSearchElement (
   CFStringRef property,
   CFStringRef label,
   CFStringRef key,
   CFTypeRef value,
   ABSearchComparison comparison
){};






