#include <AE/AE.h>

/*AEGetEventHandler

Gets an event handler from an Apple event dispatch table.

OSErr AEGetEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP * handler,
   long * handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the desired handler. See AEEventClass.
theAEEventID

The event ID for the desired handler. See AEEventID.
handler

A universal procedure pointer. On return, a pointer to the specified handler, if a dispatch table entry exists that exactly matches the values supplied in the parameters theAEEventClass and theAEEventID.

If you use the typeWildCard constant for either or both of these parameters, AEGetEventHandler will return an error unless an entry exists that specifies typeWildCard in exactly the same way. For example, if you specify typeWildCard in both the theAEEventClass parameter and the theAEEventID parameter, the Apple Event Manager will not return the first handler for any event class and event ID in the dispatch table; instead, it will only return a handler if an entry exists that specifies type typeWildCard for both the event class and the event ID.

For an explanation of wildcard values, see the Discussion section for AEInstallEventHandler.

See AEEventHandlerUPP.
handlerRefcon

A pointer to a reference constant. On return, the reference constant from the dispatch table entry for the specified handler. The reference constant may have a value of 0.
isSysHandler

Specifies the Apple event dispatch table to get the handler from. Pass TRUE to get the handler from the system dispatch table or FALSE to get the handler from your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.

In Mac OS 7.1 through 9.x and Mac OS X version v10.2 and later, AEGetEventHandler returns errAEHandlerNotInstalled when there’s not an exact match, even if a wildcard handler is installed that could handle the event. Mac OS X version v10.0.x and v10.1.x will return the wildcard handler.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AEGetEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP * handler,
   long * handlerRefcon,
   Boolean isSysHandler
){
printf ("AEGetEventHandler",theAEEventClass,theAEEventClass,*handler,*handlerRefcon,isSysHandler);
};



/*AERemoveEventHandler

Removes an event handler entry from an Apple event dispatch table.

OSErr AERemoveEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the handler to remove. See AEEventClass.
theAEEventID

The event ID for the handler to remove. See AEEventID.
handler

A universal procedure pointer to the handler to remove. Although the parameters theAEEventClass and theAEEventID are sufficient to identify the handler, you can identify the handler explicitly as a safeguard. If you pass NULL for this parameter, the Apple Event Manager relies solely on the event class and event ID to identify the handler.

If you use the typeWildCard constant for either or both of the event class and event ID parameters, AERemoveEventHandler will return an error unless an entry exists that specifies typeWildCard in exactly the same way. For example, if you specify typeWildCard in both the theAEEventClass parameter and the theAEEventID parameter, AERemoveEventHandler will not remove the first handler for any event class and event ID in the dispatch table; instead, it will only remove a handler if an entry exists that specifies type typeWildCard for both the event class and the event ID.

For an explanation of wildcard values, see the Discussion section for AEInstallEventHandler.

See AEEventHandlerUPP.
isSysHandler

Specifies the Apple event dispatch table to remove the handler from. Pass TRUE to remove the handler from the system dispatch table or FALSE to remove the handler from your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AERemoveEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   Boolean isSysHandler
){
printf ("AERemoveEventHandler",theAEEventClass,theAEEventID,handler,isSysHandler);
};

/*AEInstallEventHandler

Adds an entry for an event handler to an Apple event dispatch table.

OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventID parameter. See AEEventClass.
theAEEventID

The event ID for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventClass parameter. See AEEventID.
handler

A universal procedure pointer to the Apple event handler function to install. See AEEventHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
isSysHandler

Specifies the Apple event dispatch table to add the handler to. Pass TRUE to add the handler to the system dispatch table or FALSE to add the handler to your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The parameters theAEEventClass and theAEEventID specify the event class and event ID of the Apple events handled by the handler for this dispatch table entry. If there is already an entry in the specified dispatch table for the same event class and event ID, it is replaced. For these parameters, you must provide one of the following combinations:
the event class and event ID of a single Apple event to dispatch to the handler (for example, an event class of kAECoreSuite and an event ID of kAEDelete so that a specific kind of delete event is dispatched to the handler) 
the typeWildCard constant for theAEEventClass and an event ID for theAEEventID, which indicates that Apple events from all event classes whose event IDs match theAEEventID should be dispatched to the handler (for example, an event class of typeWildCard and an event ID of kAEDelete so that for all event classes, the delete event is dispatched to the handler) 
an event class for theAEEventClass and the typeWildCard constant for theAEEventID, which indicates that all events from the specified event class should be dispatched to the handler (for example, an event class of kAECoreSuite and an event ID of typeWildCard so that all events for the core suite are dispatched to the handler) 
the typeWildCard constant for both the theAEEventClass and theAEEventID parameters, which indicates that all Apple events should be dispatched to the handler

If you use the typeWildCard constant for either the theAEEventClass or the theAEEventID parameter (or for both parameters), the corresponding handler must return the error errAEEventNotHandled if it does not handle a particular event.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that is identical except that it specifies a wildcard value for either the event class or the event ID, the Apple Event Manager dispatches the more specific entry. For example, if an Apple event dispatch table includes one entry that specifies the event class as kAECoreSuite and the event ID as kAEDelete, and another entry that specifies the event class as kAECoreSuite and the event ID as typeWildCard, the Apple Event Manager dispatches the Apple event handler associated with the entry that specifies the event ID as kAEDelete.

In addition to the Apple event handler dispatch tables, applications can add entries to special handler dispatch tables, as described in “Managing Special Handler Dispatch Tables”. 
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler){
printf ("AEInstallEventHandler",theAEEventClass,theAEEventID,handler,handlerRefcon,isSysHandler);
};


