#include <AE/AE.h>

/*CreateObjSpecifier

Assembles an object specifier that identifies one or more Apple event objects, from other descriptors.

OSErr CreateObjSpecifier (
   DescType desiredClass,
   AEDesc * theContainer,
   DescType keyForm,
   AEDesc * keyData,
   Boolean disposeInputs,
   AEDesc * objSpecifier
);
Parameters
desiredClass

The object class of the desired Apple event objects. See DescType.
theContainer

A pointer to a descriptor that describes the container for the requested object, usually in the form of another object specifier. See AEDesc.
keyForm

The key form for the object specifier.
keyData

A pointer to a descriptor that supplies the key data for the object specifier.
disposeInputs

A Boolean value. Pass (TRUE) if the function should dispose of the descriptors for the theContainer and keyData parameters or (FALSE) if your application will. A value of FALSE may be more efficient for some applications because it allows them to reuse descriptors.
objSpecifier

On successful return, a pointer to the object specifier created by the CreateObjSpecifier function. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of this descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEPackObject.h*/
OSErr CreateObjSpecifier (
   DescType desiredClass,
   AEDesc * theContainer,
   DescType keyForm,
   AEDesc * keyData,
   Boolean disposeInputs,
   AEDesc * objSpecifier){
printf ("CreateObjSpecifier",desiredClass,*theContainer,keyForm,*keyData,disposeInputs,*objSpecifier);
};



