#include <AE/AE.h>


/*AEObjectInit

Initializes the Object Support Library.

OSErr AEObjectInit ();
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You must call this function before calling any of the Apple Event Manager functions that describe or manipulate Apple event objects.

You should call the AEObjectInit function to initialize the Apple Event Manager functions that handle object specifiers and Apple event objects. 
Version Notes

To make these functions available to your application with version 1.01 and earlier versions of the Apple Event Manager, you must also link the Apple Event Object Support Library with your application when you build it. For more information, see the Version Notes section for the AppleScript Gestalt Selector described in Inside Mac OS X: Gestalt Manager Reference and the function AERemoveSpecialHandler.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEObjectInit (){
printf ("AEObjectInit");
};


/*AEGetObjectAccessor

Gets an object accessor function from an object accessor dispatch table. 

OSErr AEGetObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP * accessor,
   long * accessorRefcon,
   Boolean isSysHandler
);
Parameters
desiredClass

The object class of the Apple event objects located by the object accessor function to get. Pass the value typeWildCard to get an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the object class. Pass the value cProperty to get an object accessor function whose entry in an object accessor dispatch table specifies cProperty (a constant used to specify a property of any object class). Some other possible values are defined in “Object Class ID Constants”. See DescType.
containerType

The descriptor type of the token that identifies the container for the objects located by the requested accessor function. (Token is defined in AEDisposeToken.) Pass the value typeWildCard to get an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the descriptor type of the token used to specify the container type. See DescType.
accessor

A universal procedure pointer. On return, a pointer to the requested object accessor function, if an object accessor dispatch table entry exists that exactly matches the values supplied in the parameters desiredClass and containerType. See OSLAccessorUPP.
accessorRefcon

A pointer to a reference constant. On return, points to the reference constant from the object accessor dispatch table entry for the specified object accessor function. The reference constant may have a value of 0.
isSysHandler

Specifies the object accessor dispatch table to get the object accessor function from. Pass TRUE to get the object accessor function from the system object accessor dispatch table or FALSE to get the object accessor function from your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended. 
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Calling AEGetObjectAccessor does not remove the object accessor function from an object accessor dispatch table. 
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEGetObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP * accessor,
   long * accessorRefcon,
   Boolean isSysHandler
){
printf ("AEGetObjectAccessor",desiredClass,containerType,*accessor,*accessorRefcon,isSysHandler);
};

/*AERemoveObjectAccessor

Removes an object accessor function from an object accessor dispatch table. 

OSErr AERemoveObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   Boolean isSysHandler
);
Parameters
desiredClass

The object class of the Apple event objects located by the object accessor function to remove. Pass the value typeWildCard to remove an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the object class. Pass the value cProperty to remove an object accessor function whose entry in an object accessor dispatch table specifies cProperty (a constant used to specify a property of any object class). Some other possible values are defined in “Object Class ID Constants”. See DescType.
containerType

The descriptor type of the token that identifies the container for the objects located by the object accessor function to remove. (Token is defined in AEDisposeToken.) Pass the value typeWildCard to remove an object accessor function whose entry in an object accessor dispatch table specifies typeWildCard as the descriptor type of the token used to specify the container type. See DescType.
theAccessor

A universal procedure pointer to the special handler to remove. Although the functionClass parameter is sufficient to identify the handler to remove, you can identify the handler explicitly as a safeguard. If you pass NULL for this parameter, the Apple Event Manager relies solely on the function class to identify the handler.A universal procedure pointer (UPP) to the object accessor function to remove. Although the parameters desiredClass and containerType are sufficient to identify the function to remove, you can identify the function explicitly by providing a UPP in this parameter. If you pass NULL for this parameter, the Apple Event Manager relies solely on the desired class and container type. See OSLAccessorUPP.
isSysHandler

Specifies the object accessor dispatch table to remove the object accessor function from. Pass TRUE to remove the object accessor function from the system object accessor dispatch table or FALSE to remove the object accessor function from your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AERemoveObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   Boolean isSysHandler
){
printf ("AERemoveObjectAccessor",desiredClass,containerType,theAccessor,isSysHandler);
};


/*AEInstallObjectAccessor

Adds or replaces an entry for an object accessor function to an object accessor dispatch table.

OSErr AEInstallObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   long accessorRefcon,
   Boolean isSysHandler
);
Parameters
desiredClass

The object type of the Apple event objects located by this accessor. See DescType.
containerType

The type of the token whose objects are accessed by this accessor. (Token is defined in AEDisposeToken.) The accessor function finds objects in containers specified by tokens of this type. See DescType.
theAccessor

A universal procedure pointer to the object accessor function to install. See OSLAccessorUPP.
accessorRefcon

A reference constant the Apple Event Manager passes to the object accessor function whenever it calls the function. If your object accessor function doesn’t require a reference constant, pass 0 for this parameter. To change the value of the reference constant, you must call AEInstallObjectAccessor again.
isSysHandler

Specifies the object accessor dispatch table to add the entry to. Pass TRUE to add the entry to the system object accessor dispatch table or FALSE to add the entry to your application’s object accessor dispatch table. Use of the system object accessor dispatch table is not recommended. 
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEInstallObjectAccessor function adds or replaces an entry to either the application or system object accessor dispatch table. 
Version Notes

In Mac OS X, your application can not make an object callback function available to other applications by installing it in a system object accessor dispatch table.

If your Carbon application running in Mac OS 8 or OS 9 installs a system object accessor function in its application heap, rather than in the system heap, you must call AERemoveObjectAccessor to remove the function before your application terminates.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSErr AEInstallObjectAccessor (
   DescType desiredClass,
   DescType containerType,
   OSLAccessorUPP theAccessor,
   long accessorRefcon,
   Boolean isSysHandler
){
printf ("AEInstallObjectAccessorr",desiredClass,containerType,theAccessor,accessorRefcon,isSysHandler);
};

/*NewOSLAccessorUPP

Creates a new universal procedure pointer to an object accessor function.

OSLAccessorUPP NewOSLAccessorUPP (
   OSLAccessorProcPtr userRoutine
);
Return Value

See OSLAccessorUPP.
Discussion

See the OSLAccessorProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/
OSLAccessorUPP NewOSLAccessorUPP (
   OSLAccessorProcPtr userRoutine
){
printf ("NewOSLAccessorUPP",userRoutine);
};


/*InvokeOSLAccessorUPP

Calls an object accessor universal procedure pointer.

OSErr InvokeOSLAccessorUPP (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon,
   OSLAccessorUPP userUPP
);
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

See the OSLAccessorProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEObjects.h*/

OSErr InvokeOSLAccessorUPP (
   DescType desiredClass,
   const AEDesc * container,
   DescType containerClass,
   DescType form,
   const AEDesc * selectionData,
   AEDesc * value,
   long accessorRefcon,
   OSLAccessorUPP userUPP
){
printf ("InvokeOSLAccessorUPP",desiredClass,*container,containerClass,form,*selectionData,*value,accessorRefcon,userUPP);
};



