#ifndef SYS_KERN_EVENT_H
#define SYS_KERN_EVENT_H

#include <sys/appleapiopts.h>
#include <sys/ioccom.h>
#include <sys/sys_domain.h>

/*kev_d_vectors

struct kev_d_vectors { 
    u_long data_length; // Length of the event data //
    void /data_ptr; // Pointer to event data //
};  
Fields
data_length
The length of data.
data_ptr
A pointer to data.
Discussion 

This structure is used to append some data to a kernel event.*/
struct kev_d_vectors { 
    u_long data_length; /* Length of the event data */
    void *data_ptr; /* Pointer to event data */
};  
typedef struct kev_d_vectors kev_d_vectors;

/*kev_msg

struct kev_msg { 
    u_long vendor_code; // For non-Apple extensibility //
    u_long kev_class; // Layer of event source //
    u_long kev_subclass; // Component within layer //
    u_long event_code; // The event code //
    struct kev_d_vectors dv[5  ]; // Up to n data vectors //
};  
Fields
vendor_code
The vendor code assigned by kev_vendor_code_find.
kev_class
The event's class.
kev_class
The event's subclass.
kev_class
The event's code.
dv
An array of vectors describing additional data to be appended to the kernel event.
Discussion 

This structure is used when posting a kernel event.*/
struct kev_msg { 
    u_long vendor_code; /* For non-Apple extensibility */
    u_long kev_class; /* Layer of event source */
    u_long kev_subclass; /* Component within layer */
    u_long event_code; /* The event code */
    struct kev_d_vectors dv[5  ]; /* Up to n data vectors */
};  
typedef  struct kev_msg kev_msg;

#endif 
