#ifndef _OBJC_RUNTIME_H_
#define _OBJC_RUNTIME_H_

#import <stdarg.h>
#import <AvailabilityMacros.h>
#import <objc/objc.h>
#import <objc/objc-class.h>
//#include <HYS/objc/objc-runtime.h>

/*objc_msgSend

Sends a message with a simple return value to an instance of a class.

id objc_msgSend(id theReceiver, SEL theSelector, ...)
Parameters
theReceiver

A pointer that points to the instance of the class that is to receive the message.
theSelector

The selector of the method that handles the message.
...

A variable argument list containing the arguments to the method.
Return Value

The return value of the method.
Discussion

When it encounters a method call, the compiler generates a call to one of the functions objc_msgSend, objc_msgSend_stret, objc_msgSendSuper, or objc_msgSendSuper_stret. Messages sent to an object’s superclass (using the super keyword) are sent using objc_msgSendSuper; other messages are sent using objc_msgSend. Methods that have data structures as return values are sent using objc_msgSendSuper_stret and objc_msgSend_stret.*/
id objc_msgSend(id theReceiver, SEL theSelector, ...);


#endif
