#ifndef _WINDEF_
#define _WINDEF_


#ifdef __cplusplus
extern "C" {
#endif
#include <Wine/winnt.h>

#if defined(__i386__) && !defined(_X86_)
# define _X86_
#endif

#if defined(_X86_) && !defined(__i386__)
# define __i386__
#endif

#if defined(__x86_64__) && !defined(_WIN64)
#define _WIN64
#endif


#ifdef WINE_NO_UNICODE_MACROS
# define WINELIB_NAME_AW(func) \
    func##_must_be_suffixed_with_W_or_A_in_this_context \
    func##_must_be_suffixed_with_W_or_A_in_this_context
#else  /* WINE_NO_UNICODE_MACROS */
# ifdef UNICODE
#  define WINELIB_NAME_AW(func) func##W
# else
#  define WINELIB_NAME_AW(func) func##A
# endif
#endif  /* WINE_NO_UNICODE_MACROS */

#ifndef __cdecl
# if defined(__i386__) && defined(__GNUC__)
#  ifdef __APPLE__ /* Mac OS X uses 16-byte aligned stack and not a 4-byte one */
#   define __cdecl __attribute__((__cdecl__)) __attribute__((__force_align_arg_pointer__))
#  else
#   define __cdecl __attribute__((__cdecl__))
#  endif
# elif !defined(_MSC_VER)
#  define __cdecl
# endif
#endif /* __cdecl */

#ifndef __stdcall
# ifdef __i386__
#  ifdef __GNUC__
#   ifdef __APPLE__ /* Mac OS X uses a 16-byte aligned stack and not a 4-byte one */
#    define __stdcall __attribute__((__stdcall__)) __attribute__((__force_align_arg_pointer__))
#   else
#    define __stdcall __attribute__((__stdcall__))
#   endif
#  elif defined(_MSC_VER)
    /* Nothing needs to be done. __stdcall already exists */
#  else
#   error You need to define __stdcall for your compiler
#  endif
# else  /* __i386__ */
#  define __stdcall
# endif  /* __i386__ */
#endif /* __stdcall */

#define CALLBACK    __stdcall
#define WINAPI      __stdcall
#define DECLARE_HANDLE(name) typedef void *name

#ifdef WINE_NO_UNICODE_MACROS
# define DECL_WINELIB_TYPE_AW(type)  /* nothing */
#else
# define DECL_WINELIB_TYPE_AW(type)  typedef WINELIB_NAME_AW(type) type;
#endif

#ifdef MAX_PATH /* Work-around for Mingw */ 
#undef MAX_PATH
#endif /* MAX_PATH */

#define MAX_PATH        260

#define WINAPIV     __cdecl

#define LOWORD(l)              ((WORD)((DWORD_PTR)(l) & 0xFFFF))
#define HIWORD(l)              ((WORD)((DWORD_PTR)(l) >> 16))

#undef NULL
#ifdef __cplusplus
#define NULL  0
#else
#define NULL  ((void*)0)
#endif


//#include <Wine/wtypes.h>//hys

DECLARE_HANDLE(HBRUSH);
DECLARE_HANDLE(HDC);
DECLARE_HANDLE(HINSTANCE);
DECLARE_HANDLE(HWND);
DECLARE_HANDLE(HBITMAP);
DECLARE_HANDLE(HICON);
DECLARE_HANDLE(HMENU);
DECLARE_HANDLE(HACCEL);

typedef const void                             *LPCVOID;
typedef int             INT,        *PINT,     *LPINT;
typedef int             BOOL,       *PBOOL,    *LPBOOL;
typedef unsigned char   BYTE,       *PBYTE,    *LPBYTE;
typedef unsigned short  WORD,       *PWORD,    *LPWORD;
typedef unsigned int    UINT,       *PUINT;
typedef UINT_PTR        WPARAM;
typedef void                                   *LPVOID;

#ifdef _MSC_VER
typedef long                                   *LPLONG;
typedef unsigned long   DWORD,      *PDWORD,   *LPDWORD;
#ifndef __COREFOUNDATION_CFPLUGINCOM__
typedef unsigned long   ULONG;
#endif
typedef ULONG  *PULONG;
#else
typedef int                                    *LPLONG;
typedef unsigned int    DWORD,      *PDWORD,   *LPDWORD;
typedef unsigned int    ULONG,      *PULONG;
#endif

typedef LONG_PTR        LPARAM;
typedef HANDLE HGLOBAL;
typedef HANDLE HLOCAL;
typedef HANDLE HGDIOBJ;

typedef DWORD           COLORREF, *LPCOLORREF;

typedef struct _POINTL
{
    LONG x;
    LONG y;
} POINTL, *PPOINT;

typedef struct tagRECT
{
    LONG left;
    LONG top;
    LONG right;
    LONG bottom;
} RECT, *PRECT, *LPRECT;

typedef LONG_PTR        LRESULT;

typedef struct tagPOINT
{
    LONG  x;
    LONG  y;
} POINT;

typedef HICON HCURSOR;
typedef HINSTANCE HMODULE;
typedef WORD            ATOM;

#ifdef __cplusplus
}
#endif

#endif /* _WINDEF_ */
