#ifndef  SECKEYCHAIN_H
#define SECKEYCHAIN_H

#include <Security/SecBase.h>
#include <Security/cssmapple.h>
#include <CoreFoundation/CFArray.h>

#include <APPLE/Security/SecKeychain.h>
#if defined(__cplusplus)
extern "C" {
#endif

/*Keychain Protocol Type Constants

Defines the protocol type associated with an AppleShare or Internet password.

typedef FourCharCode SecProtocolType;
enum
{
   kSecProtocolTypeFTP         = 'ftp ',
   kSecProtocolTypeFTPAccount  = 'ftpa',
   kSecProtocolTypeHTTP        = 'http',
   kSecProtocolTypeIRC         = 'irc ',
   kSecProtocolTypeNNTP        = 'nntp',
   kSecProtocolTypePOP3        = 'pop3',
   kSecProtocolTypeSMTP        = 'smtp',
   kSecProtocolTypeSOCKS       = 'sox ',
   kSecProtocolTypeIMAP        = 'imap',
   kSecProtocolTypeLDAP        = 'ldap',
   kSecProtocolTypeAppleTalk   = 'atlk',
   kSecProtocolTypeAFP         = 'afp ',
   kSecProtocolTypeTelnet      = 'teln',
   kSecProtocolTypeSSH         = 'ssh ',
   kSecProtocolTypeFTPS        = 'ftps',
   kSecProtocolTypeHTTPS       = 'htps',
   kSecProtocolTypeHTTPProxy   = 'htpx',
   kSecProtocolTypeHTTPSProx   = 'htsx',
   kSecProtocolTypeFTPProxy    = 'ftpx',
   kSecProtocolTypeSMB         = 'smb ',
   kSecProtocolTypeRTSP        = 'rtsp',
   kSecProtocolTypeRTSPProxy   = 'rtsx',
   kSecProtocolTypeDAAP        = 'daap',
   kSecProtocolTypeEPPC        = 'eppc',
   kSecProtocolTypeIPP         = 'ipp ',
   kSecProtocolTypeNNTPS       = 'ntps',
   kSecProtocolTypeLDAPS       = 'ldps',
   kSecProtocolTypeTelnetS     = 'tels',
   kSecProtocolTypeIMAPS       = 'imps',
   kSecProtocolTypeIRCS        = 'ircs',
   kSecProtocolTypePOP3S       = 'pops'
};
Constants
kSecProtocolTypeFTP

Indicates FTP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeFTPAccount

Indicates a client side FTP account. The usage of this constant is deprecated as of Mac OS X v10.3.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeHTTP

Indicates HTTP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeIRC

Indicates IRC.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeNNTP

Indicates NNTP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypePOP3

Indicates POP3.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeSMTP

Indicates SMTP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeSOCKS

Indicates SOCKS.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeIMAP

Indicates IMAP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeLDAP

Indicates LDAP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeAppleTalk

Indicates AFP over AppleTalk.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeAFP

Indicates AFP over TCP.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeTelnet

Indicates Telnet.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeSSH

Indicates SSH.

Available in Mac OS X v10.2 and later.
kSecProtocolTypeFTPS

Indicates FTP over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeHTTPS

Indicates HTTP over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeHTTPProxy

Indicates HTTP proxy. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeHTTPSProxy

Indicates HTTPS proxy. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeFTPProxy

Indicates FTP proxy. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeSMB

Indicates SMB. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeRTSP

Indicates RTSP. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeRTSPProxy

Indicates RTSP proxy. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeDAAP

Indicates DAAP. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeEPPC

Indicates Remote Apple Events. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeIPP

Indicates IPP. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeNNTPS

Indicates NNTP over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeLDAPS

Indicates LDAP over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeTelnetS

Indicates Telnet over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeIMAPS

Indicates IMAP4 over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypeIRCS

Indicates IRC over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecProtocolTypePOP3S

Indicates POP3 over TLS/SSL. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.*/
typedef FourCharCode SecProtocolType;
enum
{
   kSecProtocolTypeFTP         = 'ftp ',
   kSecProtocolTypeFTPAccount  = 'ftpa',
   kSecProtocolTypeHTTP        = 'http',
   kSecProtocolTypeIRC         = 'irc ',
   kSecProtocolTypeNNTP        = 'nntp',
   kSecProtocolTypePOP3        = 'pop3',
   kSecProtocolTypeSMTP        = 'smtp',
   kSecProtocolTypeSOCKS       = 'sox ',
   kSecProtocolTypeIMAP        = 'imap',
   kSecProtocolTypeLDAP        = 'ldap',
   kSecProtocolTypeAppleTalk   = 'atlk',
   kSecProtocolTypeAFP         = 'afp ',
   kSecProtocolTypeTelnet      = 'teln',
   kSecProtocolTypeSSH         = 'ssh ',
   kSecProtocolTypeFTPS        = 'ftps',
   kSecProtocolTypeHTTPS       = 'htps',
   kSecProtocolTypeHTTPProxy   = 'htpx',
   kSecProtocolTypeHTTPSProxy   = 'htsx',
   kSecProtocolTypeFTPProxy    = 'ftpx',
   kSecProtocolTypeSMB         = 'smb ',
   kSecProtocolTypeRTSP        = 'rtsp',
   kSecProtocolTypeRTSPProxy   = 'rtsx',
   kSecProtocolTypeDAAP        = 'daap',
   kSecProtocolTypeEPPC        = 'eppc',
   kSecProtocolTypeIPP         = 'ipp ',
   kSecProtocolTypeNNTPS       = 'ntps',
   kSecProtocolTypeLDAPS       = 'ldps',
   kSecProtocolTypeTelnetS     = 'tels',
   kSecProtocolTypeIMAPS       = 'imps',
   kSecProtocolTypeIRCS        = 'ircs',
   kSecProtocolTypePOP3S       = 'pops'
};

/*Keychain Authentication Type Constants

Defines constants you can use to identify the type of authentication to use for an Internet password.

typedef FourCharCode SecAuthenticationType;
enum
{
   kSecAuthenticationTypeNTLM             = AUTH_TYPE_FIX_ ('ntlm'),
   kSecAuthenticationTypeMSN              = AUTH_TYPE_FIX_ ('msna'),
   kSecAuthenticationTypeDPA              = AUTH_TYPE_FIX_ ('dpaa'),
   kSecAuthenticationTypeRPA              = AUTH_TYPE_FIX_ ('rpaa'),
   kSecAuthenticationTypeHTTPBasic        = AUTH_TYPE_FIX_ ('http'),
   kSecAuthenticationTypeHTTPDigest       = AUTH_TYPE_FIX_ ('httd'),
   kSecAuthenticationTypeHTMLForm         = AUTH_TYPE_FIX_ ('form'),
   kSecAuthenticationTypeDefault          = AUTH_TYPE_FIX_ ('dflt')
};
Constants
kSecAuthenticationTypeNTLM

Specifies Windows NT LAN Manager authentication.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeMSN

Specifies Microsoft Network default authentication.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeDPA

Specifies Distributed Password authentication.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeRPA

Specifies Remote Password authentication.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeHTTPBasic

Specifies HTTP Basic authentication. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecAuthenticationTypeHTTPDigest

Specifies HTTP Digest Access authentication.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeHTMLForm

Specifies HTML form based authentication. This constant is available in Mac OS X v10.3 and later.

Available in Mac OS X v10.3 and later.
kSecAuthenticationTypeDefault

Specifies the default authentication type.

Available in Mac OS X v10.2 and later.*/
typedef FourCharCode SecAuthenticationType;
enum
{
   kSecAuthenticationTypeNTLM             = AUTH_TYPE_FIX_ ('ntlm'),
   kSecAuthenticationTypeMSN              = AUTH_TYPE_FIX_ ('msna'),
   kSecAuthenticationTypeDPA              = AUTH_TYPE_FIX_ ('dpaa'),
   kSecAuthenticationTypeRPA              = AUTH_TYPE_FIX_ ('rpaa'),
   kSecAuthenticationTypeHTTPBasic        = AUTH_TYPE_FIX_ ('http'),
   kSecAuthenticationTypeHTTPDigest       = AUTH_TYPE_FIX_ ('httd'),
   kSecAuthenticationTypeHTMLForm         = AUTH_TYPE_FIX_ ('form'),
   kSecAuthenticationTypeDefault          = AUTH_TYPE_FIX_ ('dflt')
};


//function

/*SecKeychainFindInternetPassword

Finds the first Internet password based on the attributes passed.

OSStatus SecKeychainFindInternetPassword (
   CFTypeRef keychainOrArray,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 *passwordLength,
   void **passwordData,
   SecKeychainItemRef *itemRef
);
Parameters
keychainOrArray

A reference to an array of keychains to search, a single keychain or NULL to search the user’s default keychain search list.
serverNameLength

The length of the serverName character string.
serverName

A UTF-8 encoded character string representing the server name.
securityDomainLength

The length of the securityDomain character string.
securityDomain

A UTF-8 encoded character string representing the security domain. This parameter is optional, as not all protocols require it. Pass NULL if it is not required.
accountNameLength

The length of the accountName character string.
accountName

A UTF-8 encoded character string representing the account name.
pathLength

The length of the path character string.
path

A UTF-8 encoded character string representing the path.
port

The TCP/IP port number. Pass 0 to ignore the port number.
protocol

The protocol associated with this password. See “Keychain Protocol Type Constants” for a description of possible values.
authenticationType

The authentication scheme used. See “Keychain Authentication Type Constants” for a description of possible values. Pass the constant kSecAuthenticationTypeDefault, to specify the default authentication scheme.
passwordLength

On return, the length of the buffer pointed to by passwordData.
passwordData

On return, a pointer to a buffer containing the password data. Pass NULL if you want to obtain the item object but not the password data. In this case, you must also pass NULL in the passwordLength parameter. You should use the SecKeychainItemFreeContent function to free the memory pointed to by this parameter.
itemRef

On return, a pointer to the item object of the Internet password. Pass NULL if you don’t want to obtain this object.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

This function finds the first Internet password item that matches the attributes you provide. This function optionally returns a reference to the found item.

This function decrypts the password before returning it to you. If the calling application is not in the list of trusted applications, the user is prompted before access is allowed. If the access controls for this item do not allow decryption, the function returns the errSecAuthFailed result code.

This function automatically calls the function SecKeychainUnlock to display the Unlock Keychain dialog box if the keychain is currently locked.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/

OSStatus SecKeychainFindInternetPassword (
   CFTypeRef keychainOrArray,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 *passwordLength,
   void **passwordData,
   SecKeychainItemRef *itemRef
);

/*SecKeychainAddInternetPassword

Adds a new Internet password to a keychain.

OSStatus SecKeychainAddInternetPassword (
   SecKeychainRef keychain,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 passwordLength,
   const void *passwordData,
   SecKeychainItemRef *itemRef
);
Parameters
keychain

A reference to the keychain in which to store an Internet password. Pass NULL to specify the user’s default keychain.
serverNameLength

The length of the serverName character string.
serverName

A UTF-8 encoded character string representing the server name.
securityDomainLength

The length of the securityDomain character string.
securityDomain

A UTF-8 encoded character string representing the security domain. This parameter is optional. Pass NULL if the protocol does not require it.
accountNameLength

The length of the accountName character string.
accountName

A UTF-8 encoded character string representing the account name.
pathLength

The length of the path character string.
path

A UTF-8 encoded character string representing the path.
port

The TCP/IP port number. If no specific port number is associated with this password, pass 0.
protocol

The protocol associated with this password. See “Keychain Protocol Type Constants” for a description of possible values.
authenticationType

The authentication scheme used. See “Keychain Authentication Type Constants” for a description of possible values. Pass the constant kSecAuthenticationTypeDefault, to specify the default authentication scheme.
passwordLength

The length of the passwordData buffer.
passwordData

A pointer to a buffer containing the password data to be stored in the keychain.
itemRef

On return, a pointer to a reference to the new keychain item. Pass NULL if you don’t want to obtain this object. You must allocate the memory for this pointer. The memory that this pointer occupies must be released by calling the CFRelease function when finished with it.
Return Value

A result code. See “Keychain Services Result Codes”. The result code errSecNoDefaultKeychain indicates that no default keychain could be found. The result code errSecDuplicateItem indicates that you tried to add a password that already exists in the keychain. The result code errSecDataTooLarge indicates that you tried to add more data than is allowed for a structure of this type.
Discussion

This function adds a new Internet server password to the specified keychain. Required parameters to identify the password are serverName and accountName (you cannot pass NULL for both parameters). In addition, some protocols may require an optional securityDomain when authentication is requested. This function optionally returns a reference to the newly added item.

This function sets the initial access rights for the new keychain item so that the application creating the item is given trusted access. 

This function automatically calls the function SecKeychainUnlock to display the Unlock Keychain dialog box if the keychain is currently locked.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/
OSStatus SecKeychainAddInternetPassword (
   SecKeychainRef keychain,
   UInt32 serverNameLength,
   const char *serverName,
   UInt32 securityDomainLength,
   const char *securityDomain,
   UInt32 accountNameLength,
   const char *accountName,
   UInt32 pathLength,
   const char *path,
   UInt16 port,
   SecProtocolType protocol,
   SecAuthenticationType authenticationType,
   UInt32 passwordLength,
   const void *passwordData,
   SecKeychainItemRef *itemRef
);

/*SecKeychainCopyDefault

Retrieves a pointer to the default keychain.

OSStatus SecKeychainCopyDefault (
   SecKeychainRef *keychain
);
Parameters
keychain

On return, a pointer to the default keychain object. The memory that this pointer occupies must be released by calling the CFRelease function when finished with it.
Return Value

A result code. See “Keychain Services Result Codes”. The result code errSecNoDefaultKeychain indicates that there is no default keychain.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/
OSStatus SecKeychainCopyDefault (
   SecKeychainRef *keychain
);

/*SecKeychainGetPath

Determines the path of a keychain.

OSStatus SecKeychainGetPath (
   SecKeychainRef keychain,
   UInt32 *ioPathLength,
   char *pathName
);
Parameters
keychain

A reference to a keychain whose path you wish to obtain.
ioPathLength

On input, a pointer to the size of the character string pathName. On return, the size of pathName without the zero termination.
pathName

On input, a pointer to a buffer that you have allocated. On output, the buffer contains the POSIX path of the keychain as a UTF-8 encoded string. The function returns errSecBufferTooSmall if the provided buffer is too small.
Return Value

A result code. See “Keychain Services Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/

OSStatus SecKeychainGetPath (
   SecKeychainRef keychain,
   UInt32 *ioPathLength,
   char *pathName
);

/*SecKeychainOpen

Opens a keychain.

OSStatus SecKeychainOpen (
   const char *pathName,
   SecKeychainRef *keychain
);
Parameters
pathName

A constant character string representing the POSIX path to the keychain to open.
keychain

On return, a pointer to the keychain object. The memory that this pointer occupies must be released by calling the CFRelease function when finished with it.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

You may use this function to retrieve a pointer to a keychain object given the path of the keychain. You do not need to close the keychain, but you should release the memory that the pointer occupies when you are finished with it.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychain.h*/
OSStatus SecKeychainOpen (
   const char *pathName,
   SecKeychainRef *keychain
);

#if defined(__cplusplus)
}
#endif

#endif 
