
#ifndef SECIDENTITYSEARCH_H
#define SECIDENTITYSEARCH_H

#include <Security/SecBase.h>
#include <Security/cssmtype.h>
#include <CoreFoundation/CFArray.h>


#if defined(__cplusplus)
extern "C" {
#endif

/*SecIdentitySearchRef

Contains information about an identity search.

typedef struct OpaqueSecIdentitySearchRef *SecIdentitySearchRef;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct OpaqueSecIdentitySearchRef *SecIdentitySearchRef;

//function

/*SecIdentitySearchCreate

Creates a search object for finding identities.

OSStatus SecIdentitySearchCreate (
   CFTypeRef keychainOrArray,
   CSSM_KEYUSE keyUsage,
   SecIdentitySearchRef *searchRef
);
Parameters
keychainOrArray

A keychain object for a single keychain to search, an array of keychain objects for a set of keychains to search, or NULL to search the user’s default keychain search list.
keyUsage

ACSSM key use value as defined in cssmtype.h. (Note that, because key recovery is not implemented, the SIGN_RECOVER and VERIFY_RECOVER constants are not supported.) Use this parameter to filter the search by specifying the key use for the identity. Pass in 0 if you want all identities returned by this search. Pass in CSSM_KEYUSE_ANY to limit the identities returned to those that can be used for every operation.
searchRef

On return, points to the identity search object. Call the CFRelease function to release this object when you are done with it.
Return Value

A result code. See “Certificate, Key, and Trust Services Result Codes”.
Discussion

You can OR CSSM_KEYUSE values together to set more than one value for key use. Use the returned search object in calls to the SecIdentitySearchCopyNext function to obtain identities that match the search criteria. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecIdentitySearch.h*/
OSStatus SecIdentitySearchCreate (
   CFTypeRef keychainOrArray,
   CSSM_KEYUSE keyUsage,
   SecIdentitySearchRef *searchRef
);

/*SecIdentitySearchCopyNext

Finds the next identity matching specified search criteria

OSStatus SecIdentitySearchCopyNext (
   SecIdentitySearchRef searchRef,
   SecIdentityRef *identity
);
Parameters
searchRef

An identity search object specifying the search criteria for this search. You create the identity search object by calling the SecIdentitySearchCreate function.
identity

On return, points to the identity object of the next matching identity (if any). Call the CFRelease function to release this object when finished with it.
Return Value

A result code. When there are no more identities that match the parameters specified to SecIdentitySearchCreate, errSecItemNotFound is returned. See “Certificate, Key, and Trust Services Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecIdentitySearch.h*/
OSStatus SecIdentitySearchCopyNext (
   SecIdentitySearchRef searchRef,
   SecIdentityRef *identity
);

#if defined(__cplusplus)
}
#endif

#endif 
