
#ifndef SECCERTIFICATE_H
#define SECCERTIFICATE_H

#include <Security/SecBase.h>
#include <Security/cssmtype.h>
#include <Security/x509defs.h>


#if defined(__cplusplus)
extern "C" {
#endif

/*SecCertificateGetData

Retrieves the data for a certificate.

OSStatus SecCertificateGetData (
   SecCertificateRef certificate,
   CSSM_DATA_PTR data
);
Parameters
certificate

A certificate object for the certificate from which to retrieve the data.
data

On return, points to the data for the certificate specified. You must allocate the space for a CSSM_DATA structure before calling this function. This data pointer is only guaranteed to remain valid as long as the certificate remains unchanged and valid.
Return Value

A result code. See “Certificate, Key, and Trust Services Result Codes”.
Discussion

This function requires a certificate object, which can, for example, be created with the SecCertificateCreateFromData function, obtained from an identity with the SecIdentityCopyCertificate function, or obtained over a network (see Secure Transport Reference).
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecCertificate.h*/
OSStatus SecCertificateGetData (
   SecCertificateRef certificate,
   CSSM_DATA_PTR data
);

#if defined(__cplusplus)
}
#endif

#endif 
